/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.mapboxgl = factory());
    })(this, (function () { 'use strict';
    
    /* eslint-disable */
    
    var shared, worker, mapboxgl;
    // define gets called three times: one for each chunk. we rely on the order
    // they're imported to know which is which
    function define(_, chunk) {
    if (!shared) {
        shared = chunk;
    } else if (!worker) {
        worker = chunk;
    } else {
        var workerBundleString = "self.onerror = function() { console.error('An error occurred while parsing the WebWorker bundle. This is most likely due to improper transpilation by Babel; please see https://docs.mapbox.com/mapbox-gl-js/guides/install/#transpiling'); }; var sharedChunk = {}; (" + shared + ")(sharedChunk); (" + worker + ")(sharedChunk); self.onerror = null;"
    
        var sharedChunk = {};
        shared(sharedChunk);
        mapboxgl = chunk(sharedChunk);
        if (typeof window !== 'undefined' && window && window.URL && window.URL.createObjectURL) {
            mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
        }
    }
    }
    
    
    define(["exports"],(function(t){"use strict";var e="undefined"!=typeof self?self:{},r="2.14.1";let n;const i={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==n){const t=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{n=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):t;}catch(e){n=t;}}return n},get API_TILEJSON_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return /^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return /^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!i.API_URL)return null;try{const t=new URL(i.API_URL);return "api.mapbox.cn"===t.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===t.hostname?"https://events.mapbox.com/events/v2":null}catch(t){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,MAX_PARALLEL_IMAGE_REQUESTS:16},s={supported:!1,testSupport:function(t){!l&&o&&(u?c(t):a=t);}};let a,o,l=!1,u=!1;function c(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,o),t.isContextLost())return;s.supported=!0;}catch(t){}t.deleteTexture(e),l=!0;}e.document&&(o=e.document.createElement("img"),o.onload=function(){a&&c(a),a=null,u=!0;},o.onerror=function(){l=!0,a=null;},o.src="data:image/webp;base64,UklGRh5AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const h="01";var p=f;function f(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}f.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var d=y;function y(t,e){this.x=t,this.y=e;}y.prototype={clone:function(){return new y(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},y.convert=function(t){return t instanceof y?t:Array.isArray(t)?new y(t[0],t[1]):t};const m=Math.PI/180,g=180/Math.PI;function x(t){return t*m}function v(t){return t*g}const b=[[0,0],[1,0],[1,1],[0,1]];function w(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function _(t,e,r,n){const i=new p(t,e,r,n);return function(t){return i.solve(t)}}const A=_(.25,.1,.25,1);function S(t,e,r){return Math.min(r,Math.max(e,t))}function k(t,e,r){return (r=S((r-t)/(e-t),0,1))*r*(3-2*r)}function I(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function M(t,e,r){if(!t.length)return r(null,[]);let n=t.length;const i=new Array(t.length);let s=null;t.forEach(((t,a)=>{e(t,((t,e)=>{t&&(s=t),i[a]=e,0==--n&&r(s,i);}));}));}function T(t){const e=[];for(const r in t)e.push(t[r]);return e}function z(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let B=1;function E(){return B++}function C(){return function t(e){return e?(e^Math.random()*(16>>e/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()}function P(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function D(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)}function V(t,e){t.forEach((t=>{e[t]&&(e[t]=e[t].bind(e));}));}function L(t,e){return -1!==t.indexOf(e,t.length-e.length)}function F(t,e,r){const n={};for(const i in t)n[i]=e.call(r||this,t[i],i,t);return n}function R(t,e,r){const n={};for(const i in t)e.call(r||this,t[i],i,t)&&(n[i]=t[i]);return n}function j(t){return Array.isArray(t)?t.map(j):"object"==typeof t&&t?F(t,j):t}const $={};function U(t){$[t]||("undefined"!=typeof console&&console.warn(t),$[t]=!0);}function O(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function q(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function N(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function G(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let Z=null;function X(t){if(null==Z){const e=t.navigator?t.navigator.userAgent:null;Z=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return Z}function K(t){try{const r=e[t];return r.setItem("_mapbox_test_",1),r.removeItem("_mapbox_test_"),!0}catch(t){return !1}}function Y(t,e){return [t[4*e],t[4*e+1],t[4*e+2],t[4*e+3]]}const H="mapbox-tiles";let W,J,Q=500,tt=50;function et(){try{return e.caches}catch(t){}}function rt(){et()&&!W&&(W=e.caches.open(H));}function nt(t){const e=t.indexOf("?");if(e<0)return t;const r=function(t){const e=t.indexOf("?");return e>0?t.slice(e+1).split("&"):[]}(t),n=r.filter((t=>{const e=t.split("=");return "language"===e[0]||"worldview"===e[0]}));return n.length?`${t.slice(0,e)}?${n.join("&")}`:t.slice(0,e)}let it=1/0;const st={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image"};"function"==typeof Object.freeze&&Object.freeze(st);class at extends Error{constructor(t,e,r){401===e&&gt(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const ot=N()?()=>self.worker&&self.worker.referrer:()=>("blob:"===e.location.protocol?e.parent:e).location.href;const lt=function(t,r){if(!(/^file:/.test(n=t.url)||/^file:/.test(ot())&&!/^\w+:/.test(n))){if(e.fetch&&e.Request&&e.AbortController&&e.Request.prototype.hasOwnProperty("signal"))return function(t,r){const n=new e.AbortController,i=new e.Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:ot(),referrerPolicy:t.referrerPolicy,signal:n.signal});let s=!1,a=!1;const o=(l=i.url).indexOf("sku=")>0&&gt(l);var l;"json"===t.type&&i.headers.set("Accept","application/json");const u=(n,s,l)=>{if(a)return;if(n&&"SecurityError"!==n.message&&U(n),s&&l)return c(s);const u=Date.now();e.fetch(i).then((e=>{if(e.ok){const t=o?e.clone():null;return c(e,t,u)}return r(new at(e.statusText,e.status,t.url))})).catch((e=>{"AbortError"!==e.name&&r(new Error(`${e.message} ${t.url}`));}));},c=(n,o,l)=>{("arrayBuffer"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text()).then((t=>{a||(o&&l&&function(t,r,n){if(rt(),!W)return;const i={status:r.status,statusText:r.statusText,headers:new e.Headers};r.headers.forEach(((t,e)=>i.headers.set(e,t)));const s=G(r.headers.get("Cache-Control")||"");if(s["no-store"])return;s["max-age"]&&i.headers.set("Expires",new Date(n+1e3*s["max-age"]).toUTCString());const a=i.headers.get("Expires");a&&(new Date(a).getTime()-n<42e4||function(t,e){if(void 0===J)try{new Response(new ReadableStream),J=!0;}catch(t){J=!1;}J?e(t.body):t.blob().then(e);}(r,(r=>{const n=new e.Response(r,i);rt(),W&&W.then((e=>e.put(nt(t.url),n))).catch((t=>U(t.message)));})));}(i,o,l),s=!0,r(null,t,n.headers.get("Cache-Control"),n.headers.get("Expires")));})).catch((t=>{a||r(new Error(t.message));}));};return o?function(t,e){if(rt(),!W)return e(null);const r=nt(t.url);W.then((t=>{t.match(r).then((n=>{const i=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=G(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(n);t.delete(r),i&&t.put(r,n.clone()),e(null,n,i);})).catch(e);})).catch(e);}(i,u):u(null,null),{cancel:()=>{a=!0,s||n.abort();}}}(t,r);if(N()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,r,void 0,!0)}var n;return function(t,r){const n=new e.XMLHttpRequest;n.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(n.responseType="arraybuffer");for(const e in t.headers)n.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(n.responseType="text",n.setRequestHeader("Accept","application/json")),n.withCredentials="include"===t.credentials,n.onerror=()=>{r(new Error(n.statusText));},n.onload=()=>{if((n.status>=200&&n.status<300||0===n.status)&&null!==n.response){let e=n.response;if("json"===t.type)try{e=JSON.parse(n.response);}catch(t){return r(t)}r(null,e,n.getResponseHeader("Cache-Control"),n.getResponseHeader("Expires"));}else r(new at(n.statusText,n.status,t.url));},n.send(t.body),{cancel:()=>n.abort()}}(t,r)},ut=function(t,e){return lt(z(t,{type:"arrayBuffer"}),e)};function ct(t){const r=e.document.createElement("a");return r.href=t,r.protocol===e.document.location.protocol&&r.host===e.document.location.host}const ht="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let pt,ft;pt=[],ft=0;const dt=function(t,r){if(s.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),ft>=i.MAX_PARALLEL_IMAGE_REQUESTS){const e={requestParameters:t,callback:r,cancelled:!1,cancel(){this.cancelled=!0;}};return pt.push(e),e}ft++;let n=!1;const a=()=>{if(!n)for(n=!0,ft--;pt.length&&ft<i.MAX_PARALLEL_IMAGE_REQUESTS;){const t=pt.shift(),{requestParameters:e,callback:r,cancelled:n}=t;n||(t.cancel=dt(e,r).cancel);}},o=ut(t,((t,n,i,s)=>{a(),t?r(t):n&&(e.createImageBitmap?function(t,r){const n=new e.Blob([new Uint8Array(t)],{type:"image/png"});e.createImageBitmap(n).then((t=>{r(null,t);})).catch((t=>{r(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));}));}(n,((t,e)=>r(t,e,i,s))):function(t,r){const n=new e.Image,i=e.URL;n.onload=()=>{r(null,n),i.revokeObjectURL(n.src),n.onload=null,e.requestAnimationFrame((()=>{n.src=ht;}));},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const s=new e.Blob([new Uint8Array(t)],{type:"image/png"});n.src=t.byteLength?i.createObjectURL(s):ht;}(n,((t,e)=>r(t,e,i,s))));}));return {cancel:()=>{o.cancel(),a();}}},yt="NO_ACCESS_TOKEN";function mt(t){return 0===t.indexOf("mapbox:")}function gt(t){return i.API_URL_REGEX.test(t)}function xt(t){return i.API_CDN_URL_REGEX.test(t)}function vt(t){return i.API_STYLE_REGEX.test(t)&&!bt(t)}function bt(t){return i.API_SPRITE_REGEX.test(t)}const wt=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function _t(t){const e=t.match(wt);if(!e)throw new Error("Unable to parse URL object");return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}function At(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}function St(t){if(!t)return null;const r=t.split(".");if(!r||3!==r.length)return null;try{return JSON.parse(decodeURIComponent(e.atob(r[1]).split("").map((t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2))).join("")))}catch(t){return null}}class kt{constructor(t){this.type=t,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const r=St(i.ACCESS_TOKEN);let n="";return n=r&&r.u?e.btoa(encodeURIComponent(r.u).replace(/%([0-9A-F]{2})/g,((t,e)=>String.fromCharCode(Number("0x"+e))))):i.ACCESS_TOKEN||"",t?`mapbox.eventData.${t}:${n}`:`mapbox.eventData:${n}`}fetchEventData(){const t=K("localStorage"),r=this.getStorageKey(),n=this.getStorageKey("uuid");if(t)try{const t=e.localStorage.getItem(r);t&&(this.eventData=JSON.parse(t));const i=e.localStorage.getItem(n);i&&(this.anonId=i);}catch(t){U("Unable to read from LocalStorage");}}saveEventData(){const t=K("localStorage"),r=this.getStorageKey(),n=this.getStorageKey("uuid");if(t)try{e.localStorage.setItem(n,this.anonId),Object.keys(this.eventData).length>=1&&e.localStorage.setItem(r,JSON.stringify(this.eventData));}catch(t){U("Unable to write to LocalStorage");}}processRequests(t){}postEvent(t,e,r,n){if(!i.EVENTS_URL)return;const s=_t(i.EVENTS_URL);s.params.push(`access_token=${n||i.ACCESS_TOKEN||""}`);const a={event:this.type,created:new Date(t).toISOString()},o=e?z(a,e):a,l={url:At(s),headers:{"Content-Type":"text/plain"},body:JSON.stringify([o])};this.pendingRequest=function(t,e){return lt(z(t,{method:"POST"}),e)}(l,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(n);}));}queueRequest(t,e){this.queue.push(t),this.processRequests(e);}}const It=new class extends kt{constructor(t){super("appUserTurnstile"),this._customAccessToken=t;}postTurnstileEvent(t,e){i.EVENTS_URL&&i.ACCESS_TOKEN&&Array.isArray(t)&&t.some((t=>mt(t)||gt(t)))&&this.queueRequest(Date.now(),e);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const e=St(i.ACCESS_TOKEN),n=e?e.u:i.ACCESS_TOKEN;let s=n!==this.eventData.tokenU;D(this.anonId)||(this.anonId=C(),s=!0);const a=this.queue.shift();if(this.eventData.lastSuccess){const t=new Date(this.eventData.lastSuccess),e=new Date(a),r=(a-this.eventData.lastSuccess)/864e5;s=s||r>=1||r<-1||t.getDate()!==e.getDate();}else s=!0;s?this.postEvent(a,{sdkIdentifier:"mapbox-gl-js",sdkVersion:r,skuId:h,"enabled.telemetry":!1,userId:this.anonId},(t=>{t||(this.eventData.lastSuccess=a,this.eventData.tokenU=n);}),t):this.processRequests();}},Mt=It.postTurnstileEvent.bind(It),Tt=new class extends kt{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,e,r,n){this.skuToken=e,this.errorCb=n,i.EVENTS_URL&&(r||i.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(yt)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:n}=this.queue.shift();e&&this.success[e]||(this.anonId||this.fetchEventData(),D(this.anonId)||(this.anonId=C()),this.postEvent(n,{sdkIdentifier:"mapbox-gl-js",sdkVersion:r,skuId:h,skuToken:this.skuToken,userId:this.anonId},(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t));}},zt=Tt.postMapLoadEvent.bind(Tt),Bt=new class extends kt{constructor(){super("gljs.performance");}postPerformanceEvent(t,e){i.EVENTS_URL&&(t||i.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:e},t);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:n,performanceData:i}=this.queue.shift(),s=function(t){const n=e.performance.getEntriesByType("resource"),i=e.performance.getEntriesByType("mark"),s=function(t){const e={};if(t)for(const r in t)if("other"!==r)for(const n of t[r]){const t=`${r}ResolveRangeMin`,i=`${r}ResolveRangeMax`,s=`${r}RequestCount`,a=`${r}RequestCachedCount`;e[t]=Math.min(e[t]||1/0,n.startTime),e[i]=Math.max(e[i]||-1/0,n.responseEnd);const o=t=>{void 0===e[t]&&(e[t]=0),++e[t];};void 0!==n.transferSize&&0===n.transferSize&&o(a),o(s);}return e}(function(t,e){const r={};if(t)for(const n of t){const t=e(n);void 0===r[t]&&(r[t]=[]),r[t].push(n);}return r}(n,Ft)),a=e.devicePixelRatio,o=e.navigator.connection||e.navigator.mozConnection||e.navigator.webkitConnection,l={counters:[],metadata:[],attributes:[]},u=(t,e,r)=>{null!=r&&t.push({name:e,value:r.toString()});};for(const t in s)u(l.counters,t,s[t]);if(t.interactionRange[0]!==1/0&&t.interactionRange[1]!==-1/0&&(u(l.counters,"interactionRangeMin",t.interactionRange[0]),u(l.counters,"interactionRangeMax",t.interactionRange[1])),i)for(const t of Object.keys(Vt)){const e=Vt[t],r=i.find((t=>t.name===e));r&&u(l.counters,e,r.startTime);}return u(l.counters,"visibilityHidden",t.visibilityHidden),u(l.attributes,"style",function(t){if(t)for(const e of t){const t=e.name.split("?")[0];if(vt(t)){const e=t.split("/").slice(-2);if(2===e.length)return `mapbox://styles/${e[0]}/${e[1]}`}}}(n)),u(l.attributes,"terrainEnabled",t.terrainEnabled?"true":"false"),u(l.attributes,"fogEnabled",t.fogEnabled?"true":"false"),u(l.attributes,"projection",t.projection),u(l.attributes,"zoom",t.zoom),u(l.metadata,"devicePixelRatio",a),u(l.metadata,"connectionEffectiveType",o?o.effectiveType:void 0),u(l.metadata,"navigatorUserAgent",e.navigator.userAgent),u(l.metadata,"screenWidth",e.screen.width),u(l.metadata,"screenHeight",e.screen.height),u(l.metadata,"windowWidth",e.innerWidth),u(l.metadata,"windowHeight",e.innerHeight),u(l.metadata,"mapWidth",t.width/a),u(l.metadata,"mapHeight",t.height/a),u(l.metadata,"webglRenderer",t.renderer),u(l.metadata,"webglVendor",t.vendor),u(l.metadata,"sdkVersion",r),u(l.metadata,"sdkIdentifier","mapbox-gl-js"),l}(i);for(const t of s.metadata);for(const t of s.counters);for(const t of s.attributes);this.postEvent(n,s,(()=>{}),t);}},Et=Bt.postPerformanceEvent.bind(Bt),Ct=new class extends kt{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,e,r,n){if(!i.API_URL||!i.SESSION_PATH)return;const s=_t(i.API_URL+i.SESSION_PATH);s.params.push(`sku=${e||""}`),s.params.push(`access_token=${n||i.ACCESS_TOKEN||""}`);const a={url:At(s),headers:{"Content-Type":"text/plain"}};this.pendingRequest=function(t,e){return lt(z(t,{method:"GET"}),e)}(a,(t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(n);}));}getSessionAPI(t,e,r,n){this.skuToken=e,this.errorCb=n,i.SESSION_PATH&&i.API_URL&&(r||i.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error(yt)));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||this.getSession(r,this.skuToken,(t=>{t?this.errorCb(t):e&&(this.success[e]=!0);}),t);}},Pt=Ct.getSessionAPI.bind(Ct),Dt=new Set,Vt={create:"create",load:"load",fullLoad:"fullLoad"},Lt={mark(t){e.performance.mark(t);},measure(t,r,n){e.performance.measure(t,r,n);}};function Ft(t){const e=t.name.split("?")[0];return xt(e)&&e.includes("mapbox-gl.js")?"javascript":xt(e)&&e.includes("mapbox-gl.css")?"css":function(t){return i.API_FONTS_REGEX.test(t)}(e)?"fontRange":bt(e)?"sprite":vt(e)?"style":function(t){return i.API_TILEJSON_REGEX.test(t)}(e)?"tilejson":"other"}const Rt=e.performance;function jt(t){const e=t?t.url.toString():void 0;return Rt.getEntriesByName(e)}let $t,Ut,Ot,qt;const Nt={now:()=>void 0!==Ot?Ot:e.performance.now(),setNow(t){Ot=t;},restoreNow(){Ot=void 0;},frame(t){const r=e.requestAnimationFrame(t);return {cancel:()=>e.cancelAnimationFrame(r)}},getImageData(t,r=0){const{width:n,height:i}=t;qt||(qt=e.document.createElement("canvas"));const s=qt.getContext("2d",{willReadFrequently:!0});if(!s)throw new Error("failed to create canvas 2d context");return (n>qt.width||i>qt.height)&&(qt.width=n,qt.height=i),s.clearRect(-r,-r,n+2*r,i+2*r),s.drawImage(t,0,0,n,i),s.getImageData(-r,-r,n+2*r,i+2*r)},resolveURL:t=>($t||($t=e.document.createElement("a")),$t.href=t,$t.href),get devicePixelRatio(){return e.devicePixelRatio},get prefersReducedMotion(){return !!e.matchMedia&&(null==Ut&&(Ut=e.matchMedia("(prefers-reduced-motion: reduce)")),Ut.matches)}};function Gt(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function Zt(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class Xt{constructor(t,e={}){z(this,e),this.type=t;}}class Kt extends Xt{constructor(t,e={}){super("error",z({error:t},e));}}class Yt{on(t,e){return this._listeners=this._listeners||{},Gt(t,e,this._listeners),this}off(t,e){return Zt(t,e,this._listeners),Zt(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},Gt(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new Xt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)Zt(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(z(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof Kt&&console.error(t.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var Ht=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360,"units":"degrees"},"pitch":{"type":"number","default":0,"units":"degrees"},"light":{"type":"light"},"terrain":{"type":"terrain"},"fog":{"type":"fog"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":{},"tms":{}},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512,"units":"pixels"},"scheme":{"type":"enum","values":{"xyz":{},"tms":{}},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512,"units":"pixels"},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":{},"mapbox":{}},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":{}}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":{}}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":{}}},"url":{"required":true,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"hillshade":{},"background":{},"sky":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky"],"layout_background":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","private":true,"default":0,"minimum":0,"maximum":1,"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":{},"round":{},"square":{}},"default":"butt","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":{},"round":{},"miter":{}},"default":"miter","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"requires":[{"line-join":"miter"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"requires":[{"line-join":"round"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":{},"line":{},"line-center":{}},"default":"point","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"units":"pixels","requires":[{"symbol-placement":"line"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":{},"viewport-y":{},"source":{}},"default":"auto","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"requires":["icon-image","text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"units":"factor of the original icon size","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{"type":"enum","values":{"none":{},"width":{},"height":{},"both":{}},"default":"none","requires":["icon-image","text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"units":"pixels","requires":["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"units":"degrees","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"requires":["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"default":"center","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{"type":"number","default":10,"minimum":0,"units":"ems","requires":["text-field",{"symbol-placement":["point"]}],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"units":"ems","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"units":"ems","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":{},"left":{},"center":{},"right":{}},"default":"center","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","units":"ems","default":0,"requires":["text-field"],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"requires":["text-field",{"symbol-placement":["point"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"default":"center","requires":["text-field",{"!":"text-variable-anchor"}],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"units":"degrees","requires":["text-field",{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":{},"vertical":{}},"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"units":"degrees","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"requires":["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":{},"uppercase":{},"lowercase":{}},"default":"none","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","units":"ems","length":2,"default":[0,0],"requires":["text-field",{"!":"text-radial-offset"}],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"requires":["text-field","icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},"in":{},"!in":{},"all":{},"any":{},"none":{},"has":{},"!has":{},"within":{}}},"geometry_type":{"type":"enum","values":{"Point":{},"LineString":{},"Polygon":{}}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":{},"exponential":{},"interval":{},"categorical":{}},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":{},"lab":{},"hcl":{}},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":{},"viewport":{}},"property-type":"data-constant","transition":false,"expression":{"interpolated":false,"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":{},"equalEarth":{},"equirectangular":{},"lambertConformalConic":{},"mercator":{},"naturalEarth":{},"winkelTripel":{},"globe":{}},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90],"transition":false,"requires":[{"name":["albers","lambertConformalConic"]}]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90],"transition":false,"requires":[{"name":["albers","lambertConformalConic"]}]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true,"requires":["source"]}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"fill-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"requires":[{"!":"fill-pattern"},{"fill-antialias":true}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["fill-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"fill-extrusion-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["fill-extrusion-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"units":"meters","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"units":"meters","transition":true,"requires":["fill-extrusion-height"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","private":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true,"requires":["fill-extrusion-edge-radius"]}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"line-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["line-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"transition":false,"units":"line widths","requires":[{"!":"line-pattern"}],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","transition":false,"requires":[{"!":"line-pattern"},{"source":"geojson","has":{"lineMetrics":true}}],"expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"transition":false,"requires":[{"source":"geojson","has":{"lineMetrics":true}}],"property-type":"constant"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["circle-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{}},"default":"viewport","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"transition":false,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"transition":false,"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["icon-image","icon-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["text-field","text-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"units":"degrees","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":{},"nearest":{}},"default":"linear","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"transition":false,"units":"milliseconds","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"transition":false,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"viewport","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_background":{"background-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"background-pattern"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":{},"atmosphere":{}},"default":"atmosphere","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"units":"degrees","minimum":[0,0],"maximum":[360,180],"transition":false,"requires":[{"sky-type":"atmosphere"}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","requires":[{"sky-type":"atmosphere"}],"default":10,"minimum":0,"maximum":100,"transition":false,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","requires":[{"sky-type":"gradient"}],"value":"number","default":[0,0],"length":2,"units":"degrees","minimum":[0,0],"maximum":[360,180],"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","requires":[{"sky-type":"gradient"}],"default":90,"minimum":0,"maximum":180,"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"transition":false,"requires":[{"sky-type":"gradient"}],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","transition":false,"requires":[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","transition":false,"requires":[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"transition":{"duration":{"type":"number","default":300,"minimum":0,"units":"milliseconds"},"delay":{"type":"number","default":0,"minimum":0,"units":"milliseconds"}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"string"}}}');function Wt(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function Jt(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Qt(t){if(Array.isArray(t))return t.map(Qt);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=Qt(t[r]);return e}return Jt(t)}class te extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}var ee=te;class re{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new re(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}var ne=re;const ie={kind:"null"},se={kind:"number"},ae={kind:"string"},oe={kind:"boolean"},le={kind:"color"},ue={kind:"object"},ce={kind:"value"},he={kind:"collator"},pe={kind:"formatted"},fe={kind:"resolvedImage"};function de(t,e){return {kind:"array",itemType:t,N:e}}function ye(t){if("array"===t.kind){const e=ye(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const me=[ie,se,ae,oe,le,pe,ue,de(ce),fe];function ge(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!ge(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of me)if(!ge(t,e))return null}return `Expected ${ye(t)} but found ${ye(e)} instead.`}function xe(t,e){return e.some((e=>e.kind===t.kind))}function ve(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}var be,we={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function _e(t){return (t=Math.round(t))<0?0:t>255?255:t}function Ae(t){return _e("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function Se(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function ke(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{be={}.parseCSSColor=function(t){var e,r=t.replace(/ /g,"").toLowerCase();if(r in we)return we[r].slice();if("#"===r[0])return 4===r.length?(e=parseInt(r.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===r.length&&(e=parseInt(r.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var n=r.indexOf("("),i=r.indexOf(")");if(-1!==n&&i+1===r.length){var s=r.substr(0,n),a=r.substr(n+1,i-(n+1)).split(","),o=1;switch(s){case"rgba":if(4!==a.length)return null;o=Se(a.pop());case"rgb":return 3!==a.length?null:[Ae(a[0]),Ae(a[1]),Ae(a[2]),o];case"hsla":if(4!==a.length)return null;o=Se(a.pop());case"hsl":if(3!==a.length)return null;var l=(parseFloat(a[0])%360+360)%360/360,u=Se(a[1]),c=Se(a[2]),h=c<=.5?c*(u+1):c+u-c*u,p=2*c-h;return [_e(255*ke(p,h,l+1/3)),_e(255*ke(p,h,l)),_e(255*ke(p,h,l-1/3)),o];default:return null}}return null};}catch(t){}class Ie{constructor(t,e,r,n=1){this.r=t,this.g=e,this.b=r,this.a=n;}static parse(t){if(!t)return;if(t instanceof Ie)return t;if("string"!=typeof t)return;const e=be(t);return e?new Ie(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toString(){const[t,e,r,n]=this.toArray();return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${n})`}toArray(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[255*t/n,255*e/n,255*r/n,n]}toArray01(){const{r:t,g:e,b:r,a:n}=this;return 0===n?[0,0,0,0]:[t/n,e/n,r/n,n]}toArray01PremultipliedAlpha(){const{r:t,g:e,b:r,a:n}=this;return [t,e,r,n]}}Ie.black=new Ie(0,0,0,1),Ie.white=new Ie(1,1,1,1),Ie.transparent=new Ie(0,0,0,0),Ie.red=new Ie(1,0,0,1),Ie.blue=new Ie(0,0,1,1);var Me=Ie;class Te{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class ze{constructor(t,e,r,n,i){this.text=t.normalize?t.normalize():t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Be{constructor(t){this.sections=t;}static fromString(t){return new Be([new ze(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Be?t:Be.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.name]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toArray())),t.push(r);}return t}}class Ee{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new Ee({name:t,available:!1}):null}serialize(){return ["image",this.name]}}function Ce(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Pe(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof Me)return !0;if(t instanceof Te)return !0;if(t instanceof Be)return !0;if(t instanceof Ee)return !0;if(Array.isArray(t)){for(const e of t)if(!Pe(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Pe(t[e]))return !1;return !0}return !1}function De(t){if(null===t)return ie;if("string"==typeof t)return ae;if("boolean"==typeof t)return oe;if("number"==typeof t)return se;if(t instanceof Me)return le;if(t instanceof Te)return he;if(t instanceof Be)return pe;if(t instanceof Ee)return fe;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=De(e);if(r){if(r===t)continue;r=ce;break}r=t;}return de(r||ce,e)}return ue}function Ve(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Me||t instanceof Be||t instanceof Ee?t.toString():JSON.stringify(t)}class Le{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Pe(t[1]))return e.error("invalid value");const r=t[1];let n=De(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Le(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof Me?["rgba"].concat(this.value.toArray()):this.value instanceof Be?this.value.serialize():this.value}}var Fe=Le,Re=class{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}};const je={string:ae,number:se,boolean:oe,object:ue};class $e{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in je)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=je[r],n++;}else i=ce;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=de(i,s);}else r=je[i];const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,ce);if(!r)return null;s.push(r);}return new $e(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!ge(this.type,De(r)))return r;if(e===this.args.length-1)throw new Re(`Expected value to be of type ${ye(this.type)}, but found ${ye(De(r))} instead.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const n=t.N;("number"==typeof n||this.args.length>1)&&e.push(n);}}return e.concat(this.args.map((t=>t.serialize())))}}var Ue=$e;class Oe{constructor(t){this.type=pe,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,se),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,de(ae)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,le),!a))return null;const o=n[n.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,ce);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new Oe(n)}evaluate(t){return new Be(this.sections.map((e=>{const r=e.content.evaluate(t);return De(r)===fe?new ze("",r,null,null,null):new ze(Ve(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class qe{constructor(t){this.type=fe,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,ae);return r?new qe(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Ee.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){return ["image",this.input.serialize()]}}const Ne={"to-boolean":oe,"to-color":le,"to-number":se,"to-string":ae};class Ge{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Ne[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,ce);if(!n)return null;i.push(n);}return new Ge(n,i)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Me)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Ce(e[0],e[1],e[2],e[3]),!r))return new Me(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Re(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new Re(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?Be.fromString(Ve(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?Ee.fromString(Ve(this.args[0].evaluate(t))):Ve(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new Oe([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new qe(this.args[0]).serialize();const t=[`to-${this.type.kind}`];return this.eachChild((e=>{t.push(e.serialize());})),t}}var Ze=Ge;const Xe=["Unknown","Point","LineString","Polygon"];var Ke=class{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null;}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Xe[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const t=this.featureDistanceData.center,e=this.featureDistanceData.scale,{x:r,y:n}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(r*e-t[0])+this.featureDistanceData.bearing[1]*(n*e-t[1])}return 0}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=Me.parse(t)),e}};class Ye{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map((t=>t.serialize())))}static parse(t,e){const r=t[0],n=Ye.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new _r(e.registry,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Ye(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(ye).join(", ")})`:`(${ye(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(ye(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){Ye.definitions=e;for(const r in e)t[r]=Ye;}}var He=Ye;class We{constructor(t,e,r){this.type=he,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,oe);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,oe);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,ae),!s)?null:new We(n,i,s)}evaluate(t){return new Te(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}const Je=8192;function Qe(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function tr(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function er(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*Je),Math.round(n*i*Je)]}function rr(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function nr(t,e){let r=!1;for(let a=0,o=e.length;a<o;a++){const o=e[a];for(let e=0,a=o.length;e<a-1;e++){if(rr(t,o[e],o[e+1]))return !1;(i=o[e])[1]>(n=t)[1]!=(s=o[e+1])[1]>n[1]&&n[0]<(s[0]-i[0])*(n[1]-i[1])/(s[1]-i[1])+i[0]&&(r=!r);}}var n,i,s;return r}function ir(t,e){for(let r=0;r<e.length;r++)if(nr(t,e[r]))return !0;return !1}function sr(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function ar(t,e,r){for(const u of r)for(let r=0;r<u.length-1;++r)if(0!=(o=[(a=u[r+1])[0]-(s=u[r])[0],a[1]-s[1]])[0]*(l=[(i=e)[0]-(n=t)[0],i[1]-n[1]])[1]-o[1]*l[0]&&sr(n,i,s,a)&&sr(s,a,n,i))return !0;var n,i,s,a,o,l;return !1}function or(t,e){for(let r=0;r<t.length;++r)if(!nr(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(ar(t[r],t[r+1],e))return !1;return !0}function lr(t,e){for(let r=0;r<e.length;r++)if(or(t,e[r]))return !0;return !1}function ur(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=er(t[i][n],r);Qe(e,a),s.push(a);}n.push(s);}return n}function cr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=ur(t[i],e,r);n.push(s);}return n}function hr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}Qe(e,t);}function pr(t,e,r,n){const i=Math.pow(2,n.z)*Je,s=[n.x*Je,n.y*Je],a=[];if(!t)return a;for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];hr(n,e,r,i),a.push(n);}return a}function fr(t,e,r,n){const i=Math.pow(2,n.z)*Je,s=[n.x*Je,n.y*Je],a=[];if(!t)return a;for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Qe(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)hr(n,e,r,i);}var o;return a}class dr{constructor(t,e){this.type=oe,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Pe(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new dr(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new dr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new dr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=ur(e.coordinates,n,i),a=pr(t.geometry(),r,n,i);if(!tr(r,n))return !1;for(const t of a)if(!nr(t,s))return !1}if("MultiPolygon"===e.type){const s=cr(e.coordinates,n,i),a=pr(t.geometry(),r,n,i);if(!tr(r,n))return !1;for(const t of a)if(!ir(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if(!i)return !1;if("Polygon"===e.type){const s=ur(e.coordinates,n,i),a=fr(t.geometry(),r,n,i);if(!tr(r,n))return !1;for(const t of a)if(!or(t,s))return !1}if("MultiPolygon"===e.type){const s=cr(e.coordinates,n,i),a=fr(t.geometry(),r,n,i);if(!tr(r,n))return !1;for(const t of a)if(!lr(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}var yr=dr;function mr(t){if(t instanceof He){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof yr)return !1;let e=!0;return t.eachChild((t=>{e&&!mr(t)&&(e=!1);})),e}function gr(t){if(t instanceof He&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!gr(t)&&(e=!1);})),e}function xr(t,e){if(t instanceof He&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!xr(t,e)&&(r=!1);})),r}class vr{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new vr(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}var br=vr;class wr{constructor(t,e=[],r,n=new ne,i=[]){this.registry=t,this.path=e,this.key=e.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=i,this.expectedType=r;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new Ue(e,[t]):"coerce"===r?new Ze(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==i.kind&&"string"!==i.kind){if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof Fe)&&"resolvedImage"!==n.type.kind&&Ar(n)){const t=new Ke;try{n=new Fe(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new wr(this.registry,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new ee(r,t));}checkSubtype(t,e){const r=ge(t,e);return r&&this.error(r),r}}var _r=wr;function Ar(t){if(t instanceof br)return Ar(t.boundExpression);if(t instanceof He&&"error"===t.name)return !1;if(t instanceof We)return !1;if(t instanceof yr)return !1;const e=t instanceof Ze||t instanceof Ue;let r=!0;return t.eachChild((t=>{r=e?r&&Ar(t):r&&t instanceof Fe;})),!!r&&mr(t)&&xr(t,["zoom","heatmap-density","line-progress","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center"])}function Sr(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new Re("Input is not a number.");a=o-1;}return 0}class kr{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,se);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new kr(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Sr(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}var Ir=kr;function Mr(t,e,r){return t*(1-r)+e*r}var Tr=Object.freeze({__proto__:null,number:Mr,color:function(t,e,r){return new Me(Mr(t.r,e.r,r),Mr(t.g,e.g,r),Mr(t.b,e.b,r),Mr(t.a,e.a,r))},array:function(t,e,r){return t.map(((t,n)=>Mr(t,e[n],r)))}});const zr=.95047,Br=1.08883,Er=4/29,Cr=6/29,Pr=3*Cr*Cr,Dr=Math.PI/180,Vr=180/Math.PI;function Lr(t){return t>.008856451679035631?Math.pow(t,1/3):t/Pr+Er}function Fr(t){return t>Cr?t*t*t:Pr*(t-Er)}function Rr(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function jr(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function $r(t){const e=jr(t.r),r=jr(t.g),n=jr(t.b),i=Lr((.4124564*e+.3575761*r+.1804375*n)/zr),s=Lr((.2126729*e+.7151522*r+.072175*n)/1);return {l:116*s-16,a:500*(i-s),b:200*(s-Lr((.0193339*e+.119192*r+.9503041*n)/Br)),alpha:t.a}}function Ur(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,n=isNaN(t.b)?e:e-t.b/200;return e=1*Fr(e),r=zr*Fr(r),n=Br*Fr(n),new Me(Rr(3.2404542*r-1.5371385*e-.4985314*n),Rr(-.969266*r+1.8760108*e+.041556*n),Rr(.0556434*r-.2040259*e+1.0572252*n),t.alpha)}function Or(t,e,r){const n=e-t;return t+r*(n>180||n<-180?n-360*Math.round(n/360):n)}const qr={forward:$r,reverse:Ur,interpolate:function(t,e,r){return {l:Mr(t.l,e.l,r),a:Mr(t.a,e.a,r),b:Mr(t.b,e.b,r),alpha:Mr(t.alpha,e.alpha,r)}}},Nr={forward:function(t){const{l:e,a:r,b:n}=$r(t),i=Math.atan2(n,r)*Vr;return {h:i<0?i+360:i,c:Math.sqrt(r*r+n*n),l:e,alpha:t.a}},reverse:function(t){const e=t.h*Dr,r=t.c;return Ur({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:Or(t.h,e.h,r),c:Mr(t.c,e.c,r),l:Mr(t.l,e.l,r),alpha:Mr(t.alpha,e.alpha,r)}}};var Gr=Object.freeze({__proto__:null,lab:qr,hcl:Nr});class Zr{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=Xr(e,t.base,r,n);else if("linear"===t.name)i=Xr(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new p(s[0],s[1],s[2],s[3]).solve(Xr(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,se),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=le:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new Zr(o,r,n,i,a):e.error(`Type ${ye(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=Sr(e,n),a=Zr.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?Tr[this.type.kind.toLowerCase()](o,l,a):"interpolate-hcl"===this.operator?Nr.reverse(Nr.interpolate(Nr.forward(o),Nr.forward(l),a)):qr.reverse(qr.interpolate(qr.forward(o),qr.forward(l),a))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function Xr(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}var Kr=Zr;class Yr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}const s=n&&i.some((t=>ge(n,t.type)));return new Yr(s?ce:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args){if(n++,r=i.evaluate(t),r&&r instanceof Ee&&!r.available&&(e||(e=r),r=null,n===this.args.length))return e;if(null!==r)break}return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}serialize(){const t=["coalesce"];return this.eachChild((e=>{t.push(e.serialize());})),t}}var Hr=Yr;class Wr{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Wr(r,n):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}var Jr=Wr;class Qr{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,se),n=e.parse(t[2],2,de(e.expectedType||ce));return r&&n?new Qr(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new Re(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new Re(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new Re(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}var tn=Qr;class en{constructor(t,e){this.type=oe,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ce),n=e.parse(t[2],2,ce);return r&&n?xe(r.type,[oe,ae,se,ie,ce])?new en(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ye(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(null==r)return !1;if(!ve(e,["boolean","string","number","null"]))throw new Re(`Expected first argument to be of type boolean, string, number or null, but found ${ye(De(e))} instead.`);if(!ve(r,["string","array"]))throw new Re(`Expected second argument to be of type array or string, but found ${ye(De(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}var rn=en;class nn{constructor(t,e,r){this.type=se,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ce),n=e.parse(t[2],2,ce);if(!r||!n)return null;if(!xe(r.type,[oe,ae,se,ie,ce]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ye(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,se);return i?new nn(r,n,i):null}return new nn(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!ve(e,["boolean","string","number","null"]))throw new Re(`Expected first argument to be of type boolean, string, number or null, but found ${ye(De(e))} instead.`);if(!ve(r,["string","array"]))throw new Re(`Expected second argument to be of type array or string, but found ${ye(De(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}var sn=nn;class an{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,De(t)))return null}else r=De(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,ce);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new an(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (De(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],n={};for(const t of e){const e=n[this.cases[t]];void 0===e?(n[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const i=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,n]of r)t.push(1===n.length?i(n[0]):n.map(i)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}var on=an;class ln{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,oe);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);return i?new ln(r,n,i):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild((e=>{t.push(e.serialize());})),t}}var un=ln;class cn{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ce),n=e.parse(t[2],2,se);if(!r||!n)return null;if(!xe(r.type,[de(ce),ae,ce]))return e.error(`Expected first argument to be of type array or string, but found ${ye(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,se);return i?new cn(r.type,r,n,i):null}return new cn(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!ve(e,["string","array"]))throw new Re(`Expected first argument to be of type array or string, but found ${ye(De(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}var hn=cn;function pn(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function fn(t,e,r,n){return 0===n.compare(e,r)}function dn(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=oe,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,ce);if(!s)return null;if(!pn(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${ye(s.type)}'.`);let a=e.parse(t[2],2,ce);if(!a)return null;if(!pn(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${ye(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${ye(s.type)}' and '${ye(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new Ue(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new Ue(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,he),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=De(s),r=De(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new Re(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=De(s),r=De(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild((t=>{e.push(t.serialize());})),e}}}const yn=dn("==",(function(t,e,r){return e===r}),fn),mn=dn("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !fn(0,e,r,n)})),gn=dn("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),xn=dn(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),vn=dn("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),bn=dn(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class wn{constructor(t,e,r,n,i,s){this.type=ae,this.number=t,this.locale=e,this.currency=r,this.unit=n,this.minFractionDigits=i,this.maxFractionDigits=s;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,se);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,ae),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,ae),!s))return null;let a=null;if(n.unit&&(a=e.parse(n.unit,1,ae),!a))return null;let o=null;if(n["min-fraction-digits"]&&(o=e.parse(n["min-fraction-digits"],1,se),!o))return null;let l=null;return n["max-fraction-digits"]&&(l=e.parse(n["max-fraction-digits"],1,se),!l)?null:new wn(r,i,s,a,o,l)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(t):void 0,unit:this.unit?this.unit.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.unit&&t(this.unit),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.unit&&(t.unit=this.unit.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class _n{constructor(t){this.type=se,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${ye(r.type)} instead.`):new _n(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new Re(`Expected value to be of type string or array, but found ${ye(De(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild((e=>{t.push(e.serialize());})),t}}const An={"==":yn,"!=":mn,">":xn,"<":gn,">=":bn,"<=":vn,array:Ue,at:tn,boolean:Ue,case:un,coalesce:Hr,collator:We,format:Oe,image:qe,in:rn,"index-of":sn,interpolate:Kr,"interpolate-hcl":Kr,"interpolate-lab":Kr,length:_n,let:Jr,literal:Fe,match:on,number:Ue,"number-format":wn,object:Ue,slice:hn,step:Ir,string:Ue,"to-boolean":Ze,"to-color":Ze,"to-number":Ze,"to-string":Ze,var:br,within:yr};function Sn(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=Ce(e,r,n,s);if(a)throw new Re(a);return new Me(e/255*s,r/255*s,n/255*s,s)}function kn(t,e){return t in e}function In(t,e){const r=e[t];return void 0===r?null:r}function Mn(t){return {type:t}}He.register(An,{error:[{kind:"error"},[ae],(t,[e])=>{throw new Re(e.evaluate(t))}],typeof:[ae,[ce],(t,[e])=>ye(De(e.evaluate(t)))],"to-rgba":[de(se,4),[le],(t,[e])=>e.evaluate(t).toArray()],rgb:[le,[se,se,se],Sn],rgba:[le,[se,se,se,se],Sn],has:{type:oe,overloads:[[[ae],(t,[e])=>kn(e.evaluate(t),t.properties())],[[ae,ue],(t,[e,r])=>kn(e.evaluate(t),r.evaluate(t))]]},get:{type:ce,overloads:[[[ae],(t,[e])=>In(e.evaluate(t),t.properties())],[[ae,ue],(t,[e,r])=>In(e.evaluate(t),r.evaluate(t))]]},"feature-state":[ce,[ae],(t,[e])=>In(e.evaluate(t),t.featureState||{})],properties:[ue,[],t=>t.properties()],"geometry-type":[ae,[],t=>t.geometryType()],id:[ce,[],t=>t.id()],zoom:[se,[],t=>t.globals.zoom],pitch:[se,[],t=>t.globals.pitch||0],"distance-from-center":[se,[],t=>t.distanceFromCenter()],"heatmap-density":[se,[],t=>t.globals.heatmapDensity||0],"line-progress":[se,[],t=>t.globals.lineProgress||0],"sky-radial-progress":[se,[],t=>t.globals.skyRadialProgress||0],accumulated:[ce,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[se,Mn(se),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[se,Mn(se),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:se,overloads:[[[se,se],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[se],(t,[e])=>-e.evaluate(t)]]},"/":[se,[se,se],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[se,[se,se],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[se,[],()=>Math.LN2],pi:[se,[],()=>Math.PI],e:[se,[],()=>Math.E],"^":[se,[se,se],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[se,[se],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[se,[se],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[se,[se],(t,[e])=>Math.log(e.evaluate(t))],log2:[se,[se],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[se,[se],(t,[e])=>Math.sin(e.evaluate(t))],cos:[se,[se],(t,[e])=>Math.cos(e.evaluate(t))],tan:[se,[se],(t,[e])=>Math.tan(e.evaluate(t))],asin:[se,[se],(t,[e])=>Math.asin(e.evaluate(t))],acos:[se,[se],(t,[e])=>Math.acos(e.evaluate(t))],atan:[se,[se],(t,[e])=>Math.atan(e.evaluate(t))],min:[se,Mn(se),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[se,Mn(se),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[se,[se],(t,[e])=>Math.abs(e.evaluate(t))],round:[se,[se],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[se,[se],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[se,[se],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[oe,[ae,ce],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[oe,[ce],(t,[e])=>t.id()===e.value],"filter-type-==":[oe,[ae],(t,[e])=>t.geometryType()===e.value],"filter-<":[oe,[ae,ce],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[oe,[ce],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[oe,[ae,ce],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[oe,[ce],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[oe,[ae,ce],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[oe,[ce],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[oe,[ae,ce],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[oe,[ce],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[oe,[ce],(t,[e])=>e.value in t.properties()],"filter-has-id":[oe,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[oe,[de(ae)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[oe,[de(ce)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[oe,[ae,de(ce)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[oe,[ae,de(ce)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:oe,overloads:[[[oe,oe],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Mn(oe),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:oe,overloads:[[[oe,oe],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Mn(oe),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[oe,[oe],(t,[e])=>!e.evaluate(t)],"is-supported-script":[oe,[ae],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[ae,[ae],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[ae,[ae],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[ae,Mn(ce),(t,e)=>e.map((e=>Ve(e.evaluate(t)))).join("")],"resolved-locale":[ae,[he],(t,[e])=>e.evaluate(t).resolvedLocale()]});var Tn=An;function zn(t){return {result:"success",value:t}}function Bn(t){return {result:"error",value:t}}function En(t){return "data-driven"===t["property-type"]}function Cn(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Pn(t){return !!t.expression&&t.expression.interpolated}function Dn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Vn(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Ln(t){return t}function Fn(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(Pn(e)?"exponential":"interval");if(r&&((t=Wt({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],Me.parse(t[1])]))),t.default=Me.parse(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==t.colorSpace&&!Gr[t.colorSpace])throw new Error(`Unknown color space: ${t.colorSpace}`);let a,o,l;if("exponential"===s)a=Un;else if("interval"===s)a=$n;else if("categorical"===s){a=jn,o=Object.create(null);for(const e of t.stops)o[e[0]]=e[1];l=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);a=On;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Fn(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:Kr.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Un({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:Kr.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>a(t,e,r,o,l)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Rn(t.default,e.default):a(t,e,i,o,l)}}}function Rn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function jn(t,e,r,n,i){return Rn(typeof r===i?n[r]:void 0,t.default,e.default)}function $n(t,e,r){if("number"!==Dn(r))return Rn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Sr(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Un(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Dn(r))return Rn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=Sr(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1];let u=Tr[e.type]||Ln;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=Gr[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),a));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,a)}}:u(o,l,a)}function On(t,e,r){return "color"===e.type?r=Me.parse(r):"formatted"===e.type?r=Be.fromString(r.toString()):"resolvedImage"===e.type?r=Ee.fromString(r.toString()):Dn(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),Rn(r,t.default,e.default)}class qn{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new Ke,this._defaultValue=e?function(t){return "color"===t.type&&(Vn(t.default)||Array.isArray(t.default))?new Me(0,0,0,0):"color"===t.type?Me.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s,a,o){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s,a,o){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n||null,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=o||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Re(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Nn(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Tn}function Gn(t,e){const r=new _r(Tn,[],e?function(t){const e={color:le,string:ae,number:se,enum:ae,boolean:oe,formatted:pe,resolvedImage:fe};return "array"===t.type?de(e[t.value]||ce,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?zn(new qn(n,e)):Bn(r.errors)}class Zn{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!gr(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class Xn{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!gr(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?Kr.interpolationFactor(this.interpolationType,t,e,r):0}}function Kn(t,e){if("error"===(t=Gn(t,e)).result)return t;const r=t.value.expression,n=mr(r);if(!n&&!En(e))return Bn([new ee("","data expressions not supported")]);const i=xr(r,["zoom","pitch","distance-from-center"]);if(!i&&!Cn(e))return Bn([new ee("","zoom expressions not supported")]);const s=Hn(r);return s||i?s instanceof ee?Bn([s]):s instanceof Kr&&!Pn(e)?Bn([new ee("",'"interpolate" expressions cannot be used with this property')]):zn(s?new Xn(n?"camera":"composite",t.value,s.labels,s instanceof Kr?s.interpolation:void 0):new Zn(n?"constant":"source",t.value)):Bn([new ee("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class Yn{constructor(t,e){this._parameters=t,this._specification=e,Wt(this,Fn(this._parameters,this._specification));}static deserialize(t){return new Yn(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function Hn(t){let e=null;if(t instanceof Jr)e=Hn(t.result);else if(t instanceof Hr){for(const r of t.args)if(e=Hn(r),e)break}else (t instanceof Ir||t instanceof Kr)&&t.input instanceof He&&"zoom"===t.input.name&&(e=t);return e instanceof ee||t.eachChild((t=>{const r=Hn(t);r instanceof ee?e=r:!e&&r?e=new ee("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new ee("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}class Wn{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function Jn(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec;let o=[];const l=Dn(r);if("object"!==l)return [new Wn(e,r,`object expected, ${l} found`)];for(const t in r){const l=t.split(".")[0],u=n[l]||n["*"];let c;i[l]?c=i[l]:n[l]?c=Ci:i["*"]?c=i["*"]:n["*"]&&(c=Ci),c?o=o.concat(c({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:u,style:s,styleSpec:a,object:r,objectKey:t},r)):o.push(new Wn(e,r[t],`unknown property "${t}"`));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&o.push(new Wn(e,r,`missing required property "${t}"`));return o}function Qn(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||Ci;if("array"!==Dn(e))return [new Wn(s,e,`array expected, ${Dn(e)} found`)];if(r.length&&e.length!==r.length)return [new Wn(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new Wn(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values,minimum:r.minimum,maximum:r.maximum,function:void 0};i.$version<7&&(o.function=r.function),"object"===Dn(r.value)&&(o=r.value);let l=[];for(let t=0;t<e.length;t++)l=l.concat(a({array:e,arrayIndex:t,value:e[t],valueSpec:o,style:n,styleSpec:i,key:`${s}[${t}]`}));return l}function ti(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Dn(r);if("number"===i&&r!=r&&(i="NaN"),"number"!==i)return [new Wn(e,r,`number expected, ${i} found`)];if("minimum"in n){let i=n.minimum;if("array"===Dn(n.minimum)&&(i=n.minimum[t.arrayIndex]),r<i)return [new Wn(e,r,`${r} is less than the minimum value ${i}`)]}if("maximum"in n){let i=n.maximum;if("array"===Dn(n.maximum)&&(i=n.maximum[t.arrayIndex]),r>i)return [new Wn(e,r,`${r} is greater than the maximum value ${i}`)]}return []}function ei(t){const e=t.valueSpec,r=Jt(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Dn(t.value.stops)&&"array"===Dn(t.value.stops[0])&&"object"===Dn(t.value.stops[0][0]),c=Jn({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new Wn(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(Qn({key:t.key,value:n,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Dn(n)&&0===n.length&&e.push(new Wn(t.key,n,"array must have at least one stop")),e},default:function(t){return Ci({key:t.key,value:t.value,valueSpec:e,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new Wn(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new Wn(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!Pn(t.valueSpec)&&c.push(new Wn(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!En(t.valueSpec)?c.push(new Wn(t.key,t.value,"property functions not supported")):o&&!Cn(t.valueSpec)&&c.push(new Wn(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new Wn(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Dn(n))return [new Wn(o,n,`array expected, ${Dn(n)} found`)];if(2!==n.length)return [new Wn(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Dn(n[0]))return [new Wn(o,n,`object expected, ${Dn(n[0])} found`)];if(void 0===n[0].zoom)return [new Wn(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new Wn(o,n,"object stop key must have value")];const e=Jt(n[0].zoom);if("number"!=typeof e)return [new Wn(o,n[0].zoom,"stop zoom values must be numbers")];if(s&&s>e)return [new Wn(o,n[0].zoom,"stop zoom values must appear in ascending order")];e!==s&&(s=e,i=void 0,a={}),r=r.concat(Jn({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:ti,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},n));return Nn(Qt(n[1]))?r.concat([new Wn(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(Ci({key:`${o}[1]`,value:n[1],valueSpec:e,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=Dn(t.value),l=Jt(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new Wn(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o&&"number"!=typeof l&&"string"!=typeof l&&"boolean"!=typeof l)return [new Wn(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return En(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Wn(t.key,u,n)]}return "categorical"!==r||"number"!==o||"number"==typeof l&&isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&"number"==typeof l&&"number"==typeof i&&void 0!==i&&l<i?[new Wn(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new Wn(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new Wn(t.key,u,`integer expected, found ${String(l)}`)]}}function ri(t){const e=("property"===t.expressionContext?Kn:Gn)(Qt(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Wn(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new Wn(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!gr(r))return [new Wn(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext)return ni(r,t);if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!xr(r,["zoom","feature-state"]))return [new Wn(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!mr(r))return [new Wn(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function ni(t,e){const r=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(e.valueSpec&&e.valueSpec.expression)for(const t of e.valueSpec.expression.parameters)r.delete(t);if(0===r.size)return [];const n=[];return t instanceof He&&r.has(t.name)?[new Wn(e.key,e.value,`["${t.name}"] expression is not supported in a filter for a ${e.object.type} layer with id: ${e.object.id}`)]:(t.eachChild((t=>{n.push(...ni(t,e));})),n)}function ii(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(Jt(r))&&i.push(new Wn(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(Jt(r))&&i.push(new Wn(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function si(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!si(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}function ai(t,e="fill"){if(null==t)return {filter:()=>!0,needGeometry:!1,needFeature:!1};si(t)||(t=fi(t));const r=t;let n=!0;try{n=function(t){if(!ui(t))return t;let e=Qt(t);return li(e),e=oi(e),e}(r);}catch(t){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(r,null,2)}\n        `);}const i=Ht[`filter_${e}`],s=Gn(n,i);let a=null;if("error"===s.result)throw new Error(s.value.map((t=>`${t.key}: ${t.message}`)).join(", "));a=(t,e,r)=>s.value.evaluate(t,e,{},r);let o=null,l=null;if(n!==r){const t=Gn(r,i);if("error"===t.result)throw new Error(t.value.map((t=>`${t.key}: ${t.message}`)).join(", "));o=(e,r,n,i,s)=>t.value.evaluate(e,r,{},n,void 0,void 0,i,s),l=!mr(t.value.expression);}return {filter:a,dynamicFilter:o||void 0,needGeometry:pi(n),needFeature:!!l}}function oi(t){if(!Array.isArray(t))return t;const e=function(t){if(ci.has(t[0]))for(let e=1;e<t.length;e++)if(ui(t[e]))return !0;return t}(t);return !0===e?e:e.map((t=>oi(t)))}function li(t){let e=!1;const r=[];if("case"===t[0]){for(let n=1;n<t.length-1;n+=2)e=e||ui(t[n]),r.push(t[n+1]);r.push(t[t.length-1]);}else if("match"===t[0]){e=e||ui(t[1]);for(let e=2;e<t.length-1;e+=2)r.push(t[e+1]);r.push(t[t.length-1]);}else if("step"===t[0]){e=e||ui(t[1]);for(let e=1;e<t.length-1;e+=2)r.push(t[e+1]);}e&&(t.length=0,t.push("any",...r));for(let e=1;e<t.length;e++)li(t[e]);}function ui(t){if(!Array.isArray(t))return !1;if("pitch"===(e=t[0])||"distance-from-center"===e)return !0;var e;for(let e=1;e<t.length;e++)if(ui(t[e]))return !0;return !1}const ci=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function hi(t,e){return t<e?-1:t>e?1:0}function pi(t){if(!Array.isArray(t))return !1;if("within"===t[0])return !0;for(let e=1;e<t.length;e++)if(pi(t[e]))return !0;return !1}function fi(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?di(t[1],t[2],"=="):"!="===e?gi(di(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?di(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(fi))):"all"===e?["all"].concat(t.slice(1).map(fi)):"none"===e?["all"].concat(t.slice(1).map(fi).map(gi)):"in"===e?yi(t[1],t.slice(2)):"!in"===e?gi(yi(t[1],t.slice(2))):"has"===e?mi(t[1]):"!has"===e?gi(mi(t[1])):"within"!==e||t;var r;}function di(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function yi(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(hi)]]:["filter-in-small",t,["literal",e]]}}function mi(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function gi(t){return ["!",t]}function xi(t){return si(Qt(t.value))?ri(Wt({},t,{expressionContext:"filter",valueSpec:t.styleSpec[`filter_${t.layerType||"fill"}`]})):vi(t)}function vi(t){const e=t.value,r=t.key;if("array"!==Dn(e))return [new Wn(r,e,`array expected, ${Dn(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new Wn(r,e,"filter array must have at least 1 element")];switch(s=s.concat(ii({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),Jt(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===Jt(e[1])&&s.push(new Wn(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new Wn(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=Dn(e[1]),"string"!==i&&s.push(new Wn(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=Dn(e[a]),"$type"===Jt(e[1])?s=s.concat(ii({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new Wn(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(vi({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=Dn(e[1]),2!==e.length?s.push(new Wn(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new Wn(`${r}[1]`,e[1],`string expected, ${i} found`));break;case"within":i=Dn(e[1]),2!==e.length?s.push(new Wn(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"object"!==i&&s.push(new Wn(`${r}[1]`,e[1],`object expected, ${i} found`));}return s}function bi(t,e){const r=t.key,n=t.style,i=t.styleSpec,s=t.value,a=t.objectKey,o=i[`${e}_${t.layerType}`];if(!o)return [];const l=a.match(/^(.*)-transition$/);if("paint"===e&&l&&o[l[1]]&&o[l[1]].transition)return Ci({key:r,value:s,valueSpec:i.transition,style:n,styleSpec:i});const u=t.valueSpec||o[a];if(!u)return [new Wn(r,s,`unknown property "${a}"`)];let c;if("string"===Dn(s)&&En(u)&&!u.tokens&&(c=/^{([^}]+)}$/.exec(s))){const t=`\`{ "type": "identity", "property": ${c?JSON.stringify(c[1]):'"_"'} }\``;return [new Wn(r,s,`"${a}" does not support interpolation syntax\nUse an identity property function instead: ${t}.`)]}const h=[];return "symbol"===t.layerType&&("text-field"===a&&n&&!n.glyphs&&h.push(new Wn(r,s,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&Vn(Qt(s))&&"identity"===Jt(s.type)&&h.push(new Wn(r,s,'"text-font" does not support identity functions'))),h.concat(Ci({key:t.key,value:s,valueSpec:u,style:n,styleSpec:i,expressionContext:"property",propertyType:e,propertyKey:a}))}function wi(t){return bi(t,"paint")}function _i(t){return bi(t,"layout")}function Ai(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;r.type||r.ref||e.push(new Wn(n,r,'either "type" or "ref" is required'));let a=Jt(r.type);const o=Jt(r.ref);if(r.id){const s=Jt(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];Jt(t.id)===s&&e.push(new Wn(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new Wn(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{Jt(e.id)===o&&(t=e);})),t?t.ref?e.push(new Wn(n,r.ref,"ref cannot reference another ref layer")):a=Jt(t.type):"string"==typeof o&&e.push(new Wn(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a&&"sky"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&Jt(t.type);t?"vector"===s&&"raster"===a?e.push(new Wn(n,r.source,`layer "${r.id}" requires a raster source`)):"raster"===s&&"raster"!==a?e.push(new Wn(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new Wn(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]&&!r.paint["line-trim-offset"]||"geojson"===s&&t.lineMetrics||e.push(new Wn(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Wn(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new Wn(n,r.source,`source "${r.source}" not found`));}else e.push(new Wn(n,r,'missing required property "source"'));return e=e.concat(Jn({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>Ci({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,object:r,objectKey:"type"}),filter:t=>xi(Wt({layerType:a},t)),layout:t=>Jn({layer:r,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>_i(Wt({layerType:a},t))}}),paint:t=>Jn({layer:r,key:t.key,value:t.value,valueSpec:{},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>wi(Wt({layerType:a},t))}})}})),e}function Si(t){const e=t.value,r=t.key,n=Dn(e);return "string"!==n?[new Wn(r,e,`string expected, ${n} found`)]:[]}const ki={promoteId:function({key:t,value:e}){if("string"===Dn(e))return Si({key:t,value:e});{const r=[];for(const n in e)r.push(...Si({key:`${t}.${n}`,value:e[n]}));return r}}};function Ii(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style;if(!e.type)return [new Wn(r,e,'"type" is required')];const s=Jt(e.type);let a;switch(s){case"vector":case"raster":case"raster-dem":return a=Jn({key:r,value:e,valueSpec:n[`source_${s.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:ki}),a;case"geojson":if(a=Jn({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,objectElementValidators:ki}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],s="string"==typeof n?[n,["accumulated"],["get",t]]:n;a.push(...ri({key:`${r}.${t}.map`,value:i,expressionContext:"cluster-map"})),a.push(...ri({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return a;case"video":return Jn({key:r,value:e,valueSpec:n.source_video,style:i,styleSpec:n});case"image":return Jn({key:r,value:e,valueSpec:n.source_image,style:i,styleSpec:n});case"canvas":return [new Wn(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return ii({key:`${r}.type`,value:e.type,valueSpec:{values:Mi(n)},style:i,styleSpec:n})}}function Mi(t){return t.source.reduce(((e,r)=>{const n=t[r];return "enum"===n.type.type&&(e=e.concat(Object.keys(n.type.values))),e}),[])}function Ti(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=Dn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Wn("light",e,`object expected, ${a} found`)]),s;for(const t in e){const a=t.match(/^(.*)-transition$/);s=s.concat(a&&n[a[1]]&&n[a[1]].transition?Ci({key:t,value:e[t],valueSpec:r.transition,style:i,styleSpec:r}):n[t]?Ci({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}):[new Wn(t,e[t],`unknown property "${t}"`)]);}return s}function zi(t){const e=t.value,r=t.key,n=t.style,i=t.styleSpec,s=i.terrain;let a=[];const o=Dn(e);if(void 0===e)return a;if("object"!==o)return a=a.concat([new Wn("terrain",e,`object expected, ${o} found`)]),a;for(const t in e){const r=t.match(/^(.*)-transition$/);a=a.concat(r&&s[r[1]]&&s[r[1]].transition?Ci({key:t,value:e[t],valueSpec:i.transition,style:n,styleSpec:i}):s[t]?Ci({key:t,value:e[t],valueSpec:s[t],style:n,styleSpec:i}):[new Wn(t,e[t],`unknown property "${t}"`)]);}if(e.source){const t=n.sources&&n.sources[e.source],i=t&&Jt(t.type);t?"raster-dem"!==i&&a.push(new Wn(r,e.source,`terrain cannot be used with a source of type ${String(i)}, it only be used with a "raster-dem" source type`)):a.push(new Wn(r,e.source,`source "${e.source}" not found`));}else a.push(new Wn(r,e,'terrain is missing required property "source"'));return a}function Bi(t){const e=t.value,r=t.style,n=t.styleSpec,i=n.fog;let s=[];const a=Dn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Wn("fog",e,`object expected, ${a} found`)]),s;for(const t in e){const a=t.match(/^(.*)-transition$/);s=s.concat(a&&i[a[1]]&&i[a[1]].transition?Ci({key:t,value:e[t],valueSpec:n.transition,style:r,styleSpec:n}):i[t]?Ci({key:t,value:e[t],valueSpec:i[t],style:r,styleSpec:n}):[new Wn(t,e[t],`unknown property "${t}"`)]);}return s}const Ei={"*":()=>[],array:Qn,boolean:function(t){const e=t.value,r=t.key,n=Dn(e);return "boolean"!==n?[new Wn(r,e,`boolean expected, ${n} found`)]:[]},number:ti,color:function(t){const e=t.key,r=t.value,n=Dn(r);return "string"!==n?[new Wn(e,r,`color expected, ${n} found`)]:null===be(r)?[new Wn(e,r,`color expected, "${r}" found`)]:[]},enum:ii,filter:xi,function:ei,layer:Ai,object:Jn,source:Ii,light:Ti,terrain:zi,fog:Bi,string:Si,formatted:function(t){return 0===Si(t).length?[]:ri(t)},resolvedImage:function(t){return 0===Si(t).length?[]:ri(t)},projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style;let s=[];const a=Dn(e);if("object"===a)for(const t in e)s=s.concat(Ci({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}));else "string"!==a&&(s=s.concat([new Wn("projection",e,`object or string expected, ${a} found`)]));return s}};function Ci(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return r.expression&&Vn(Jt(e))?ei(t):r.expression&&Nn(Qt(e))?ri(t):r.type&&Ei[r.type]?Ei[r.type](t):Jn(Wt({},t,{valueSpec:r.type?n[r.type]:r}))}function Pi(t){const e=t.value,r=t.key,n=Si(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new Wn(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new Wn(r,e,'"glyphs" url must include a "{range}" token'))),n}function Di(t,e=Ht){return Fi(Ci({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,objectElementValidators:{glyphs:Pi,"*":()=>[]}}))}const Vi=t=>Fi(wi(t)),Li=t=>Fi(_i(t));function Fi(t){return t.slice().sort(((t,e)=>t.line&&e.line?t.line-e.line:0))}function Ri(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new Kt(new Error(n.message))),r=!0;return r}var ji=$i;function $i(t,e,r){var n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;var i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(var s=0;s<this.d*this.d;s++){var a=i[3+s],o=i[3+s+1];n.push(a===o?null:i.subarray(a,o));}var l=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],l),this.bboxes=i.subarray(l),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(var u=0;u<this.d*this.d;u++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;var c=r/e*t;this.min=-c,this.max=t+c;}$i.prototype.insert=function(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);},$i.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},$i.prototype._insertCell=function(t,e,r,n,i,s){this.cells[i].push(s);},$i.prototype.query=function(t,e,r,n,i){var s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,n,this._queryCell,o,{},i),o},$i.prototype._queryCell=function(t,e,r,n,i,s,a,o){var l=this.cells[i];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===a[p]){var f=4*p;(o?o(c[f+0],c[f+1],c[f+2],c[f+3]):t<=c[f+2]&&e<=c[f+3]&&r>=c[f+0]&&n>=c[f+1])?(a[p]=!0,s.push(u[p])):a[p]=!1;}}},$i.prototype._forEachCell=function(t,e,r,n,i,s,a,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n),p=l;p<=c;p++)for(var f=u;f<=h;f++){var d=this.d*f+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(f),this._convertFromCellCoord(p+1),this._convertFromCellCoord(f+1)))&&i.call(this,t,e,r,n,d,s,a,o))return}},$i.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},$i.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},$i.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var t=this.cells,e=3+this.cells.length+1+1,r=0,n=0;n<this.cells.length;n++)r+=this.cells[n].length;var i=new Int32Array(e+r+this.keys.length+this.bboxes.length);i[0]=this.extent,i[1]=this.n,i[2]=this.padding;for(var s=e,a=0;a<t.length;a++){var o=t[a];i[3+a]=s,i.set(o,s),s+=o.length;}return i[3+t.length]=s,i.set(this.keys,s),i[3+t.length+1]=s+=this.keys.length,i.set(this.bboxes,s),s+=this.bboxes.length,i.buffer};const Ui={};function Oi(t,e,r={}){Object.defineProperty(t,"_classRegistryKey",{value:e,writeable:!1}),Ui[e]={klass:t,omit:r.omit||[]};}Oi(Object,"Object"),ji.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}},ji.deserialize=function(t){return new ji(t.buffer)},Object.defineProperty(ji,"name",{value:"Grid"}),Oi(ji,"Grid"),Oi(Me,"Color"),Oi(Error,"Error"),Oi(at,"AJAXError"),Oi(Ee,"ResolvedImage"),Oi(Yn,"StylePropertyFunction"),Oi(qn,"StyleExpression",{omit:["_evaluator"]}),Oi(Xn,"ZoomDependentExpression"),Oi(Zn,"ZoomConstantExpression"),Oi(He,"CompoundExpression",{omit:["_evaluate"]});for(const t in Tn)Ui[Tn[t]._classRegistryKey]||Oi(Tn[t],`Expression${t}`);function qi(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Ni(t){return e.ImageBitmap&&t instanceof e.ImageBitmap}function Gi(t,r){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(qi(t)||Ni(t))return r&&r.push(t),t;if(ArrayBuffer.isView(t)){const e=t;return r&&r.push(e.buffer),e}if(t instanceof e.ImageData)return r&&r.push(t.data.buffer),t;if(Array.isArray(t)){const e=[];for(const n of t)e.push(Gi(n,r));return e}if("object"==typeof t){const e=t.constructor,n=e._classRegistryKey;if(!n)throw new Error(`can't serialize object of unregistered class ${n}`);const i=e.serialize?e.serialize(t,r):{};if(!e.serialize){for(const e in t)t.hasOwnProperty(e)&&(Ui[n].omit.indexOf(e)>=0||(i[e]=Gi(t[e],r)));t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function Zi(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||qi(t)||Ni(t)||ArrayBuffer.isView(t)||t instanceof e.ImageData)return t;if(Array.isArray(t))return t.map(Zi);if("object"==typeof t){const e=t.$name||"Object",{klass:r}=Ui[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const e of Object.keys(t))"$name"!==e&&(n[e]=Zi(t[e]));return n}throw new Error("can't deserialize object of type "+typeof t)}const Xi=t=>t>=1536&&t<=1791,Ki=t=>t>=1872&&t<=1919,Yi=t=>t>=2208&&t<=2303,Hi=t=>t>=11904&&t<=12031,Wi=t=>t>=12032&&t<=12255,Ji=t=>t>=12272&&t<=12287,Qi=t=>t>=12288&&t<=12351,ts=t=>t>=12352&&t<=12447,es=t=>t>=12448&&t<=12543,rs=t=>t>=12544&&t<=12591,ns=t=>t>=12704&&t<=12735,is=t=>t>=12736&&t<=12783,ss=t=>t>=12784&&t<=12799,as=t=>t>=12800&&t<=13055,os=t=>t>=13056&&t<=13311,ls=t=>t>=13312&&t<=19903,us=t=>t>=19968&&t<=40959,cs=t=>t>=40960&&t<=42127,hs=t=>t>=42128&&t<=42191,ps=t=>t>=44032&&t<=55215,fs=t=>t>=63744&&t<=64255,ds=t=>t>=64336&&t<=65023,ys=t=>t>=65040&&t<=65055,ms=t=>t>=65072&&t<=65103,gs=t=>t>=65104&&t<=65135,xs=t=>t>=65136&&t<=65279,vs=t=>t>=65280&&t<=65519;function bs(t){for(const e of t)if(As(e.charCodeAt(0)))return !0;return !1}function ws(t){for(const e of t)if(!_s(e.charCodeAt(0)))return !1;return !0}function _s(t){return !(Xi(t)||Ki(t)||Yi(t)||ds(t)||xs(t))}function As(t){return !(746!==t&&747!==t&&(t<4352||!(ns(t)||rs(t)||ms(t)&&!(t>=65097&&t<=65103)||fs(t)||os(t)||Hi(t)||is(t)||!(!Qi(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||ls(t)||us(t)||as(t)||(t=>t>=12592&&t<=12687)(t)||(t=>t>=43360&&t<=43391)(t)||(t=>t>=55216&&t<=55295)(t)||(t=>t>=4352&&t<=4607)(t)||ps(t)||ts(t)||Ji(t)||(t=>t>=12688&&t<=12703)(t)||Wi(t)||ss(t)||es(t)&&12540!==t||!(!vs(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!gs(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||(t=>t>=5120&&t<=5759)(t)||(t=>t>=6320&&t<=6399)(t)||ys(t)||(t=>t>=19904&&t<=19967)(t)||cs(t)||hs(t))))}function Ss(t){return !(As(t)||function(t){return !!((t=>t>=128&&t<=255)(t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||(t=>t>=8192&&t<=8303)(t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||(t=>t>=8448&&t<=8527)(t)||(t=>t>=8528&&t<=8591)(t)||(t=>t>=8960&&t<=9215)(t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||(t=>t>=9216&&t<=9279)(t)&&9251!==t||(t=>t>=9280&&t<=9311)(t)||(t=>t>=9312&&t<=9471)(t)||(t=>t>=9632&&t<=9727)(t)||(t=>t>=9728&&t<=9983)(t)&&!(t>=9754&&t<=9759)||(t=>t>=11008&&t<=11263)(t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Qi(t)||es(t)||(t=>t>=57344&&t<=63743)(t)||ms(t)||gs(t)||vs(t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function ks(t){return t>=1424&&t<=2303||ds(t)||xs(t)}function Is(t,e){return !(!e&&ks(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Ms(t){for(const e of t)if(ks(e.charCodeAt(0)))return !0;return !1}const Ts="deferred",zs="loading",Bs="loaded";let Es=null,Cs="unavailable",Ps=null;const Ds=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(Cs="error"),Es&&Es(t);};function Vs(){Ls.fire(new Xt("pluginStateChange",{pluginStatus:Cs,pluginURL:Ps}));}const Ls=new Yt,Fs=function(){return Cs},Rs=function(){if(Cs!==Ts||!Ps)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Cs=zs,Vs(),Ps&&ut({url:Ps},(t=>{t?Ds(t):(Cs=Bs,Vs());}));},js={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>Cs===Bs||null!=js.applyArabicShaping,isLoading:()=>Cs===zs,setState(t){Cs=t.pluginStatus,Ps=t.pluginURL;},isParsed:()=>null!=js.applyArabicShaping&&null!=js.processBidirectionalText&&null!=js.processStyledBidirectionalText,getPluginURL:()=>Ps};class $s{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.transition=e.transition,this.pitch=e.pitch):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0);}isSupportedScript(t){return function(t,e){for(const r of t)if(!Is(r.charCodeAt(0),e))return !1;return !0}(t,js.isLoaded())}}class Us{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Vn(t))return new Yn(t,e);if(Nn(t)){const r=Kn(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=Me.parse(t)),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class Os{constructor(t){this.property=t,this.value=new Us(t,void 0);}transitioned(t,e){return new Ns(this.property,this.value,e,z({},t.transition,this.transition),t.now)}untransitioned(){return new Ns(this.property,this.value,null,{},0)}}class qs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return j(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Os(this._values[t].property)),this._values[t].value=new Us(this._values[t].property,null===e?void 0:j(e));}getTransition(t){return j(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new Os(this._values[t].property)),this._values[t].transition=j(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new Gs(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new Gs(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Ns{constructor(t,e,r,n,i){const s=n.delay||0,a=n.duration||0;i=i||0,this.property=t,this.value=e,this.begin=i+s,this.end=this.begin+a,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,w(a))}}return i}}class Gs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new Ks(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Zs{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}getValue(t){return j(this._values[t].value)}setValue(t,e){this._values[t]=new Us(this._values[t].property,null===e?void 0:j(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new Ks(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class Xs{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class Ks{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class Ys{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const n=Tr[this.specification.type];return n?n(t,e,r):t}}class Hs{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new Xs(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Xs(this,{kind:"constant",value:void 0},t.parameters);const n=Tr[this.specification.type];return n?new Xs(this,{kind:"constant",value:n(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class Ws{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class Js{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const e=new $s(0,{});for(const r in t){const n=t[r];n.specification.overridable&&this.overridableProperties.push(r);const i=this.defaultPropertyValues[r]=new Us(n,void 0),s=this.defaultTransitionablePropertyValues[r]=new Os(n);this.defaultTransitioningPropertyValues[r]=s.untransitioned(),this.defaultPossiblyEvaluatedValues[r]=i.possiblyEvaluate(e);}}}function Qs(t,e){return 256*(t=S(Math.floor(t),0,255))+S(Math.floor(e),0,255)}Oi(Hs,"DataDrivenProperty"),Oi(Ys,"DataConstantProperty"),Oi(Ws,"ColorRampProperty");const ta={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ea{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class ra{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null;}}function na(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=ta[t.type].BYTES_PER_ELEMENT,s=r=ia(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:ia(r,Math.max(n,e)),alignment:e}}function ia(t,e){return Math.ceil(t/e)*e}class sa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}sa.prototype.bytesPerElement=4,Oi(sa,"StructArrayLayout2i4");class aa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}aa.prototype.bytesPerElement=6,Oi(aa,"StructArrayLayout3i6");class oa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}oa.prototype.bytesPerElement=8,Oi(oa,"StructArrayLayout4i8");class la extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=n,this.uint8[u+5]=i,this.uint8[u+6]=s,this.uint8[u+7]=a,this.float32[c+2]=o,t}}la.prototype.bytesPerElement=12,Oi(la,"StructArrayLayout2i4ub1f12");class ua extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}ua.prototype.bytesPerElement=16,Oi(ua,"StructArrayLayout4f16");class ca extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=6*t,o=3*t;return this.uint16[a+0]=e,this.uint16[a+1]=r,this.uint16[a+2]=n,this.uint16[a+3]=i,this.float32[o+2]=s,t}}ca.prototype.bytesPerElement=12,Oi(ca,"StructArrayLayout4ui1f12");class ha extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.uint16[s+0]=e,this.uint16[s+1]=r,this.uint16[s+2]=n,this.uint16[s+3]=i,t}}ha.prototype.bytesPerElement=8,Oi(ha,"StructArrayLayout4ui8");class pa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}pa.prototype.bytesPerElement=12,Oi(pa,"StructArrayLayout6i12");class fa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}fa.prototype.bytesPerElement=24,Oi(fa,"StructArrayLayout4i4ui4i24");class da extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=10*t,l=5*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.float32[l+2]=i,this.float32[l+3]=s,this.float32[l+4]=a,t}}da.prototype.bytesPerElement=20,Oi(da,"StructArrayLayout3i3f20");class ya extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ya.prototype.bytesPerElement=4,Oi(ya,"StructArrayLayout1ul4");class ma extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=this.length;return this.resize(f+1),this.emplace(f,t,e,r,n,i,s,a,o,l,u,c,h,p)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f){const d=20*t,y=10*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=n,this.int16[d+3]=i,this.int16[d+4]=s,this.float32[y+3]=a,this.float32[y+4]=o,this.float32[y+5]=l,this.float32[y+6]=u,this.int16[d+14]=c,this.uint32[y+8]=h,this.uint16[d+18]=p,this.uint16[d+19]=f,t}}ma.prototype.bytesPerElement=40,Oi(ma,"StructArrayLayout5i4f1i1ul2ui40");class ga extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,n,i,s,a)}emplace(t,e,r,n,i,s,a,o){const l=8*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.int16[l+2]=n,this.int16[l+4]=i,this.int16[l+5]=s,this.int16[l+6]=a,this.int16[l+7]=o,t}}ga.prototype.bytesPerElement=16,Oi(ga,"StructArrayLayout3i2i2i16");class xa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}xa.prototype.bytesPerElement=16,Oi(xa,"StructArrayLayout2f1f2i16");class va extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=12*t,a=3*t;return this.uint8[s+0]=e,this.uint8[s+1]=r,this.float32[a+1]=n,this.float32[a+2]=i,t}}va.prototype.bytesPerElement=12,Oi(va,"StructArrayLayout2ub2f12");class ba extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}ba.prototype.bytesPerElement=12,Oi(ba,"StructArrayLayout3f12");class wa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}wa.prototype.bytesPerElement=6,Oi(wa,"StructArrayLayout3ui6");class _a extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b){const w=this.length;return this.resize(w+1),this.emplace(w,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w){const _=30*t,A=15*t,S=60*t;return this.int16[_+0]=e,this.int16[_+1]=r,this.int16[_+2]=n,this.float32[A+2]=i,this.float32[A+3]=s,this.uint16[_+8]=a,this.uint16[_+9]=o,this.uint32[A+5]=l,this.uint32[A+6]=u,this.uint32[A+7]=c,this.uint16[_+16]=h,this.uint16[_+17]=p,this.uint16[_+18]=f,this.float32[A+10]=d,this.float32[A+11]=y,this.uint8[S+48]=m,this.uint8[S+49]=g,this.uint8[S+50]=x,this.uint32[A+13]=v,this.int16[_+28]=b,this.uint8[S+58]=w,t}}_a.prototype.bytesPerElement=60,Oi(_a,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class Aa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,I,M,T,z){const B=this.length;return this.resize(B+1),this.emplace(B,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,I,M,T,z)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,I,M,T,z,B){const E=38*t,C=19*t;return this.int16[E+0]=e,this.int16[E+1]=r,this.int16[E+2]=n,this.float32[C+2]=i,this.float32[C+3]=s,this.int16[E+8]=a,this.int16[E+9]=o,this.int16[E+10]=l,this.int16[E+11]=u,this.int16[E+12]=c,this.int16[E+13]=h,this.uint16[E+14]=p,this.uint16[E+15]=f,this.uint16[E+16]=d,this.uint16[E+17]=y,this.uint16[E+18]=m,this.uint16[E+19]=g,this.uint16[E+20]=x,this.uint16[E+21]=v,this.uint16[E+22]=b,this.uint16[E+23]=w,this.uint16[E+24]=_,this.uint16[E+25]=A,this.uint16[E+26]=S,this.uint16[E+27]=k,this.uint16[E+28]=I,this.uint32[C+15]=M,this.float32[C+16]=T,this.float32[C+17]=z,this.float32[C+18]=B,t}}Aa.prototype.bytesPerElement=76,Oi(Aa,"StructArrayLayout3i2f6i15ui1ul3f76");class Sa extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Sa.prototype.bytesPerElement=4,Oi(Sa,"StructArrayLayout1f4");class ka extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=5*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.float32[a+3]=i,this.float32[a+4]=s,t}}ka.prototype.bytesPerElement=20,Oi(ka,"StructArrayLayout5f20");class Ia extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=n,this.uint16[s+4]=i,t}}Ia.prototype.bytesPerElement=12,Oi(Ia,"StructArrayLayout1ul3ui12");class Ma extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ma.prototype.bytesPerElement=4,Oi(Ma,"StructArrayLayout2ui4");class Ta extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Ta.prototype.bytesPerElement=2,Oi(Ta,"StructArrayLayout1ui2");class za extends ra{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}za.prototype.bytesPerElement=8,Oi(za,"StructArrayLayout2f8");class Ba extends ea{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}Ba.prototype.size=40;class Ea extends ma{get(t){return new Ba(this,t)}}Oi(Ea,"CollisionBoxArray");class Ca extends ea{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(t){this._structArray.uint8[this._pos1+49]=t;}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(t){this._structArray.uint8[this._pos1+50]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(t){this._structArray.uint32[this._pos4+13]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(t){this._structArray.uint8[this._pos1+58]=t;}}Ca.prototype.size=60;class Pa extends _a{get(t){return new Ca(this,t)}}Oi(Pa,"PlacedSymbolArray");class Da extends ea{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+11]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+13]}get key(){return this._structArray.uint16[this._pos2+14]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+17]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+19]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+21]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+22]}get featureIndex(){return this._structArray.uint16[this._pos2+23]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+25]}get numIconVertices(){return this._structArray.uint16[this._pos2+26]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+27]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+28]}get crossTileID(){return this._structArray.uint32[this._pos4+15]}set crossTileID(t){this._structArray.uint32[this._pos4+15]=t;}get textOffset0(){return this._structArray.float32[this._pos4+16]}get textOffset1(){return this._structArray.float32[this._pos4+17]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+18]}}Da.prototype.size=76;class Va extends Aa{get(t){return new Da(this,t)}}Oi(Va,"SymbolInstanceArray");class La extends Sa{getoffsetX(t){return this.float32[1*t+0]}}Oi(La,"GlyphOffsetArray");class Fa extends sa{getx(t){return this.int16[2*t+0]}gety(t){return this.int16[2*t+1]}}Oi(Fa,"SymbolLineVertexArray");class Ra extends ea{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}Ra.prototype.size=12;class ja extends Ia{get(t){return new Ra(this,t)}}Oi(ja,"FeatureIndexArray");class $a extends Ma{geta_centroid_pos0(t){return this.uint16[2*t+0]}geta_centroid_pos1(t){return this.uint16[2*t+1]}}Oi($a,"FillExtrusionCentroidArray");const Ua=na([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),Oa=na([{name:"a_dash",components:4,type:"Uint16"}]);var qa={},Na={get exports(){return qa},set exports(t){qa=t;}},Ga={};({get exports(){return Ga},set exports(t){Ga=t;}}).exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0};var Za={};({get exports(){return Za},set exports(t){Za=t;}}).exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0};var Xa=Ga,Ka=Za;Na.exports=Xa,qa.murmur3=Xa,qa.murmur2=Ka;class Ya{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(Ha(t)),this.positions.push(e,r,n);}getPositions(t){const e=Ha(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return Wa(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new Ya;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function Ha(t){const e=+t;return !isNaN(e)&&Number.MIN_SAFE_INTEGER<=e&&e<=Number.MAX_SAFE_INTEGER?e:qa(String(t))}function Wa(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;Ja(t,s,a),Ja(e,3*s,3*a),Ja(e,3*s+1,3*a+1),Ja(e,3*s+2,3*a+2);}a-r<n-a?(Wa(t,e,r,a),r=a+1):(Wa(t,e,a+1,n),n=a);}}function Ja(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}Oi(Ya,"FeaturePositionMap");class Qa{constructor(t){this.gl=t.gl,this.initialized=!1;}fetchUniformLocation(t,e){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(t,e),this.initialized=!0),!!this.location}}class to extends Qa{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1f(this.location,r));}}class eo extends Qa{constructor(t){super(t),this.current=[0,0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]&&r[3]===this.current[3]||(this.current=r,this.gl.uniform4f(this.location,r[0],r[1],r[2],r[3])));}}class ro extends Qa{constructor(t){super(t),this.current=Me.transparent;}set(t,e,r){this.fetchUniformLocation(t,e)&&(r.r===this.current.r&&r.g===this.current.g&&r.b===this.current.b&&r.a===this.current.a||(this.current=r,this.gl.uniform4f(this.location,r.r,r.g,r.b,r.a)));}}const no=new Float32Array(16),io=new Float32Array(9),so=new Float32Array(4);function ao(t){return [Qs(255*t.r,255*t.g),Qs(255*t.b,255*t.a)]}class oo{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r,n,i){e.set(t,i,n.constantOr(this.value));}getBinding(t,e){return "color"===this.type?new ro(t):new to(t)}}class lo{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.pattern=null,this.pixelRatio=1;}setConstantPatternPositions(t){this.pixelRatio=t.pixelRatio||1,this.pattern=t.tl.concat(t.br);}setUniform(t,e,r,n,i){const s="u_pattern"===i||"u_dash"===i?this.pattern:"u_pixel_ratio"===i?this.pixelRatio:null;s&&e.set(t,i,s);}getBinding(t,e){return "u_pattern"===e||"u_dash"===e?new eo(t):new to(t)}}class uo{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i,s){const a=this.paintVertexArray.length,o=this.expression.evaluate(new $s(0),e,{},i,n,s);this.paintVertexArray.resize(t),this._setPaintValue(a,t,o);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate({zoom:0},r,n,void 0,i);this._setPaintValue(t,e,s);}_setPaintValue(t,e,r){if("color"===this.type){const n=ao(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class co{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i,s){const a=this.expression.evaluate(new $s(this.zoom),e,{},i,n,s),o=this.expression.evaluate(new $s(this.zoom+1),e,{},i,n,s),l=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(l,t,a,o);}updatePaintArray(t,e,r,n,i){const s=this.expression.evaluate({zoom:this.zoom},r,n,void 0,i),a=this.expression.evaluate({zoom:this.zoom+1},r,n,void 0,i);this._setPaintValue(t,e,s,a);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=ao(r),s=ao(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e,r,n,i){const s=this.useIntegerZoom?Math.floor(r.zoom):r.zoom,a=S(this.expression.interpolationFactor(s,this.zoom,this.zoom+1),0,1);e.set(t,i,a);}getBinding(t,e){return new to(t)}}class ho{constructor(t,e,r,n,i){this.expression=t,this.layerId=i,this.paintVertexAttributes=("array"===r?Oa:Ua).members;for(let t=0;t<e.length;++t);this.paintVertexArray=new n;}populatePaintArray(t,e,r){const n=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i,s){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],s);}_setPaintValues(t,e,r,n){if(!n||!r)return;const i=n[r];if(!i)return;const{tl:s,br:a,pixelRatio:o}=i;for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,s[0],s[1],a[0],a[1],o);}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class po{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof Xs&&En(s.property.specification)))continue;const a=mo(i,t.type),o=s.value,l=s.property.specification.type,u=!!s.property.useIntegerZoom,c="line-dasharray"===i||i.endsWith("pattern"),h="line-dasharray"===i&&"constant"!==t.layout.get("line-cap").value.kind;if("constant"!==o.kind||h)if("source"===o.kind||h||c){const e=vo(i,l,"source");this.binders[i]=c?new ho(o,a,l,e,t.id):new uo(o,a,l,e),n.push(`/a_${i}`);}else {const t=vo(i,l,"composite");this.binders[i]=new co(o,a,l,u,e,t),n.push(`/z_${i}`);}else this.binders[i]=c?new lo(o.value,a):new oo(o.value,a,l),n.push(`/u_${i}`);}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof uo||e instanceof co?e.maxValue:0}populatePaintArrays(t,e,r,n,i,s){for(const a in this.binders){const o=this.binders[a];(o instanceof uo||o instanceof co||o instanceof ho)&&o.populatePaintArray(t,e,r,n,i,s);}}setConstantPatternPositions(t){for(const e in this.binders){const r=this.binders[e];r instanceof lo&&r.setConstantPatternPositions(t);}}updatePaintArrays(t,e,r,n,i,s){let a=!1;for(const o in t){const l=e.getPositions(o);for(const e of l){const l=r.feature(e.index);for(const r in this.binders){const u=this.binders[r];if((u instanceof uo||u instanceof co||u instanceof ho)&&!0===u.expression.isStateDependent){const c=n.paint.get(r);u.expression=c.value,u.updatePaintArray(e.start,e.end,l,t[o],i,s),a=!0;}}}}return a}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof oo||r instanceof lo)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof uo||r instanceof co||r instanceof ho)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof oo||r instanceof lo||r instanceof co)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t){const e=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof oo||n instanceof lo||n instanceof co)for(const i of n.uniformNames)e.push({name:i,property:r,binding:n.getBinding(t,i)});}return e}setUniforms(t,e,r,n,i){for(const{name:e,property:s,binding:a}of r)this.binders[s].setUniform(t,a,i,n.get(s),e);}updatePaintBuffers(){this._buffers=[];for(const t in this.binders){const e=this.binders[t];(e instanceof uo||e instanceof co||e instanceof ho)&&e.paintVertexBuffer&&this._buffers.push(e.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof uo||r instanceof co||r instanceof ho)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof uo||e instanceof co||e instanceof ho)&&e.destroy();}}}class fo{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new po(n,e,r);this.needsUpload=!1,this._featureMap=new Ya,this._bufferOffset=0;}populatePaintArrays(t,e,r,n,i,s,a){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s,a);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n,i){for(const s of r)this.needsUpload=this.programConfigurations[s.id].updatePaintArrays(t,this._featureMap,e,s,n,i)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}const yo={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio"],"fill-pattern":["pattern","pixel_ratio"],"fill-extrusion-pattern":["pattern","pixel_ratio"],"line-dasharray":["dash"]};function mo(t,e){return yo[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}const go={"line-pattern":{source:ca,composite:ca},"fill-pattern":{source:ca,composite:ca},"fill-extrusion-pattern":{source:ca,composite:ca},"line-dasharray":{source:ha,composite:ha}},xo={color:{source:za,composite:ua},number:{source:Sa,composite:za}};function vo(t,e,r){const n=go[t];return n&&n[r]||xo[e][r]}Oi(oo,"ConstantBinder"),Oi(lo,"PatternConstantBinder"),Oi(uo,"SourceExpressionBinder"),Oi(ho,"PatternCompositeBinder"),Oi(co,"CompositeExpressionBinder"),Oi(po,"ProgramConfiguration",{omit:["_buffers"]}),Oi(fo,"ProgramConfigurationSet");const bo="-transition";class wo extends Yt{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&"sky"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new Zs(e.layout)),e.paint)){this._transitionablePaint=new qs(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Ks(e.paint);}}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Li,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return L(t,bo)?this._transitionablePaint.getTransition(t.slice(0,-bo.length)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Vi,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(L(t,bo))return this._transitionablePaint.setTransition(t.slice(0,-bo.length),e||void 0),!1;{const r=this._transitionablePaint._values[t],n=r.value.isDataDriven(),i=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const s=this._transitionablePaint._values[t].value,a=s.isDataDriven(),o=L(t,"pattern")||"line-dasharray"===t;return a||n||o||this._handleOverridablePaintPropertyUpdate(t,i,s)}}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getProgramConfiguration(t){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),R(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&Ri(this,t.call(Di,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:Ht,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Xs&&En(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}compileFilter(){this._filterCompiled||(this._featureFilter=ai(this.filter),this._filterCompiled=!0);}invalidateCompiledFilter(){this._filterCompiled=!1;}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}}const _o=na([{name:"a_pos",components:2,type:"Int16"}],4),Ao=na([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class So{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>So.MAX_VERTEX_ARRAY_LENGTH&&U(`Max vertices per segment is ${So.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>So.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new So([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}So.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Oi(So,"SegmentVector");var ko=8192;class Io{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof ru?new ru(t.lng,t.lat):ru.convert(t),this}setSouthWest(t){return this._sw=t instanceof ru?new ru(t.lng,t.lat):ru.convert(t),this}extend(t){const e=this._sw,r=this._ne;let n,i;if(t instanceof ru)n=t,i=t;else {if(!(t instanceof Io))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(Io.convert(t)):this.extend(ru.convert(t)):"object"==typeof t&&null!==t&&t.hasOwnProperty("lat")&&(t.hasOwnProperty("lon")||t.hasOwnProperty("lng"))?this.extend(ru.convert(t)):this;if(n=t._sw,i=t._ne,!n||!i)return this}return e||r?(e.lng=Math.min(n.lng,e.lng),e.lat=Math.min(n.lat,e.lat),r.lng=Math.max(i.lng,r.lng),r.lat=Math.max(i.lat,r.lat)):(this._sw=new ru(n.lng,n.lat),this._ne=new ru(i.lng,i.lat)),this}getCenter(){return new ru((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new ru(this.getWest(),this.getNorth())}getSouthEast(){return new ru(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=ru.convert(t);let n=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(n=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&n}static convert(t){return !t||t instanceof Io?t:new Io(t)}}var Mo=1e-6,To="undefined"!=typeof Float32Array?Float32Array:Array;function zo(){var t=new To(9);return To!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function Bo(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=r[0],f=r[1],d=r[2],y=r[3],m=r[4],g=r[5],x=r[6],v=r[7],b=r[8];return t[0]=p*n+f*a+d*u,t[1]=p*i+f*o+d*c,t[2]=p*s+f*l+d*h,t[3]=y*n+m*a+g*u,t[4]=y*i+m*o+g*c,t[5]=y*s+m*l+g*h,t[6]=x*n+v*a+b*u,t[7]=x*i+v*o+b*c,t[8]=x*s+v*l+b*h,t}function Eo(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function Co(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,A=i*u-s*l,S=c*y-h*d,k=c*m-p*d,I=c*g-f*d,M=h*m-p*y,T=h*g-f*y,z=p*g-f*m,B=x*z-v*T+b*M+w*I-_*k+A*S;return B?(t[0]=(o*z-l*T+u*M)*(B=1/B),t[1]=(i*T-n*z-s*M)*B,t[2]=(y*A-m*_+g*w)*B,t[3]=(p*_-h*A-f*w)*B,t[4]=(l*I-a*z-u*k)*B,t[5]=(r*z-i*I+s*k)*B,t[6]=(m*b-d*A-g*v)*B,t[7]=(c*A-p*b+f*v)*B,t[8]=(a*T-o*I+u*S)*B,t[9]=(n*I-r*T-s*S)*B,t[10]=(d*_-y*b+g*x)*B,t[11]=(h*b-c*_-f*x)*B,t[12]=(o*k-a*M-l*S)*B,t[13]=(r*M-n*k+i*S)*B,t[14]=(y*v-d*w-m*x)*B,t[15]=(c*w-h*v+p*x)*B,t):null}function Po(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*f+_*g,t[3]=v*a+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*f+_*g,t[7]=v*a+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*f+_*g,t[11]=v*a+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*f+_*g,t[15]=v*a+b*c+w*d+_*x,t}function Do(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+f*g+e[14],t[15]=a*y+c*m+d*g+e[15]),t}function Vo(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function Lo(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t}function Fo(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t}function Ro(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function jo(t,e,r){var n,i,s,a=r[0],o=r[1],l=r[2],u=Math.hypot(a,o,l);return u<Mo?null:(a*=u=1/u,o*=u,l*=u,n=Math.sin(e),i=Math.cos(e),t[0]=a*a*(s=1-i)+i,t[1]=o*a*s+l*n,t[2]=l*a*s-o*n,t[3]=0,t[4]=a*o*s-l*n,t[5]=o*o*s+i,t[6]=l*o*s+a*n,t[7]=0,t[8]=a*l*s+o*n,t[9]=o*l*s-a*n,t[10]=l*l*s+i,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var $o=Po;function Uo(){var t=new To(3);return To!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function Oo(t){var e=new To(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function qo(t){return Math.hypot(t[0],t[1],t[2])}function No(t,e,r){var n=new To(3);return n[0]=t,n[1]=e,n[2]=r,n}function Go(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function Zo(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function Xo(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t}function Ko(t,e,r){return t[0]=Math.min(e[0],r[0]),t[1]=Math.min(e[1],r[1]),t[2]=Math.min(e[2],r[2]),t}function Yo(t,e,r){return t[0]=Math.max(e[0],r[0]),t[1]=Math.max(e[1],r[1]),t[2]=Math.max(e[2],r[2]),t}function Ho(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function Wo(t,e,r,n){return t[0]=e[0]+r[0]*n,t[1]=e[1]+r[1]*n,t[2]=e[2]+r[2]*n,t}function Jo(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function Qo(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function tl(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t}function el(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t}function rl(t,e,r){var n=r[0],i=r[1],s=r[2],a=e[0],o=e[1],l=e[2],u=i*l-s*o,c=s*a-n*l,h=n*o-i*a,p=i*h-s*c,f=s*u-n*h,d=n*c-i*u,y=2*r[3];return c*=y,h*=y,f*=2,d*=2,t[0]=a+(u*=y)+(p*=2),t[1]=o+c+f,t[2]=l+h+d,t}var nl,il=Zo,sl=Xo,al=qo;function ol(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t}function ll(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r*r+n*n+i*i+s*s;return a>0&&(a=1/Math.sqrt(a)),t[0]=r*a,t[1]=n*a,t[2]=i*a,t[3]=s*a,t}function ul(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}function cl(){var t=new To(4);return To!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function hl(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t}function pl(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+a*o,t[1]=i*l+s*o,t[2]=s*l-i*o,t[3]=a*l-n*o,t}function fl(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l-s*o,t[1]=i*l+a*o,t[2]=s*l+n*o,t[3]=a*l-i*o,t}Uo(),nl=new To(4),To!=Float32Array&&(nl[0]=0,nl[1]=0,nl[2]=0,nl[3]=0);var dl=ll;Uo(),No(1,0,0),No(0,1,0),cl(),cl(),zo();const yl=na([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:ml}=yl,gl=na([{name:"a_pos_3",components:3,type:"Int16"}]);var xl=na([{name:"a_pos",type:"Int16",components:2}]);class vl{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const n=Qo(e,this.dir);if(Math.abs(n)<1e-6)return !1;const i=((t[0]-this.pos[0])*e[0]+(t[1]-this.pos[1])*e[1]+(t[2]-this.pos[2])*e[2])/n;return r[0]=this.pos[0]+this.dir[0]*i,r[1]=this.pos[1]+this.dir[1]*i,r[2]=this.pos[2]+this.dir[2]*i,!0}closestPointOnSphere(t,e,r){if(function(t,e){var r=t[0],n=t[1],i=t[2],s=e[0],a=e[1],o=e[2];return Math.abs(r-s)<=Mo*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-a)<=Mo*Math.max(1,Math.abs(n),Math.abs(a))&&Math.abs(i-o)<=Mo*Math.max(1,Math.abs(i),Math.abs(o))}(this.pos,t)||0===e)return r[0]=r[1]=r[2]=0,!1;const[n,i,s]=this.dir,a=this.pos[0]-t[0],o=this.pos[1]-t[1],l=this.pos[2]-t[2],u=n*n+i*i+s*s,c=2*(a*n+o*i+l*s),h=c*c-4*u*(a*a+o*o+l*l-e*e);if(h<0){const t=Math.max(-c/2,0),u=a+n*t,h=o+i*t,p=l+s*t,f=Math.hypot(u,h,p);return r[0]=u*e/f,r[1]=h*e/f,r[2]=p*e/f,!1}{const t=(-c-Math.sqrt(h))/(2*u);if(t<0){const t=Math.hypot(a,o,l);return r[0]=a*e/t,r[1]=o*e/t,r[2]=l*e/t,!1}return r[0]=a+n*t,r[1]=o+i*t,r[2]=l+s*t,!0}}}class bl{constructor(t,e,r,n,i){this.TL=t,this.TR=e,this.BR=r,this.BL=n,this.horizon=i;}static fromInvProjectionMatrix(t,e,r){const n=[-1,1,1],i=[1,1,1],s=[1,-1,1],a=[-1,-1,1],o=el(n,n,t),l=el(i,i,t),u=el(s,s,t),c=el(a,a,t);return new bl(o,l,u,c,e/r)}}class wl{constructor(t,e){this.points=t,this.planes=e;}static fromInvProjectionMatrix(t,e,r,n){const i=Math.pow(2,r),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((r=>{const s=ul([],r,t),a=1/s[3]/e*i;return function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}(s,s,[a,a,n?1/s[3]:a,a])})),a=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=Jo([],tl([],il([],s[t[0]],s[t[1]]),il([],s[t[2]],s[t[1]]))),r=-Qo(e,s[t[1]]);return e.concat(r)}));return new wl(s,a)}}class _l{static fromPoints(t){const e=[1/0,1/0,1/0],r=[-1/0,-1/0,-1/0];for(const n of t)Ko(e,e,n),Yo(r,r,n);return new _l(e,r)}static applyTransform(t,e){const r=t.getCorners();for(let t=0;t<r.length;++t)el(r[t],r[t],e);return _l.fromPoints(r)}constructor(t,e){this.min=t,this.max=e,this.center=Ho([],Go([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=Oo(this.min),n=Oo(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],n[t]=e[t]?this.center[t]:this.max[t];return n[2]=this.max[2],new _l(r,n)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}getCorners(){const t=this.min,e=this.max;return [[t[0],t[1],t[2]],[e[0],t[1],t[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],e[2]],[t[0],e[1],e[2]]]}intersects(t){const e=this.getCorners();let r=!0;for(let n=0;n<t.planes.length;n++){const i=t.planes[n];let s=0;for(let t=0;t<e.length;t++)s+=Qo(i,e[t])+i[3]>=0;if(0===s)return 0;s!==e.length&&(r=!1);}if(r)return 2;for(let e=0;e<3;e++){let r=Number.MAX_VALUE,n=-Number.MAX_VALUE;for(let i=0;i<t.points.length;i++){const s=t.points[i][e]-this.min[e];r=Math.min(r,s),n=Math.max(n,s);}if(n<0||r>this.max[e]-this.min[e])return 0}return 1}}const Al=ko/Math.PI/2,Sl=64,kl=[Sl,32,16],Il=-Al,Ml=Al,Tl=[new _l([Il,Il,Il],[Ml,Ml,Ml]),new _l([Il,Il,Il],[0,0,Ml]),new _l([0,Il,Il],[Ml,0,Ml]),new _l([Il,0,Il],[0,Ml,Ml]),new _l([0,0,Il],[Ml,Ml,Ml])];function zl(t){return t*Al/tu}function Bl(t,e,r,n=!0){const i=Ho([],t._camera.position,t.worldSize),s=[e,r,1,1];ul(s,s,t.pixelMatrixInverse),ol(s,s,1/s[3]);const a=Jo([],il([],s,i)),o=t.globeMatrix,l=[o[12],o[13],o[14]],u=il([],l,i),c=qo(u),h=Jo([],u),p=t.worldSize/(2*Math.PI),f=Qo(h,a),d=Math.asin(p/c);if(d<Math.acos(f)){if(!n)return null;const t=[],e=[];Ho(t,a,c/f),Jo(e,il(e,t,u)),Jo(a,Go(a,u,Ho(a,e,Math.tan(d)*c)));}const y=[];new vl(i,a).closestPointOnSphere(l,p,y);const m=Jo([],Y(o,0)),g=Jo([],Y(o,1)),x=Jo([],Y(o,2)),b=Qo(m,y),w=Qo(g,y),_=Qo(x,y),A=v(Math.asin(-w/p));let k=v(Math.atan2(b,_));k=t.center.lng+function(t,e){const r=(e-t+180)%360-180;return r<-180?r+360:r}(t.center.lng,k);const I=iu(k),M=S(su(A),0,1);return new pu(I,M)}class El{constructor(t,e,r){this.a=il([],t,r),this.b=il([],e,r),this.center=r;const n=Jo([],this.a),i=Jo([],this.b);this.angle=Math.acos(Qo(n,i));}}function Cl(t,e){if(0===t.angle)return null;let r;return r=0===t.a[e]?1/t.angle*.5*Math.PI:1/t.angle*Math.atan(t.b[e]/t.a[e]/Math.sin(t.angle)-1/Math.tan(t.angle)),r<0||r>1?null:function(t,e,r,n){const i=Math.sin(r);return t*(Math.sin((1-n)*r)/i)+e*(Math.sin(n*r)/i)}(t.a[e],t.b[e],t.angle,S(r,0,1))+t.center[e]}function Pl(t){if(t.z<=1)return Tl[t.z+2*t.y+t.x];const e=jl(Rl(t));return _l.fromPoints(e)}function Dl(t,e,r){return Ho(t,t,1-r),Wo(t,t,e,r)}function Vl(t,e){const r=Kl(e.zoom);if(0===r)return Pl(t);const n=Rl(t),i=jl(n),s=iu(n.getWest())*e.worldSize,a=iu(n.getEast())*e.worldSize,o=su(n.getNorth())*e.worldSize,l=su(n.getSouth())*e.worldSize,u=[s,o,0],c=[a,o,0],h=[s,l,0],p=[a,l,0],f=Co([],e.globeMatrix);return el(u,u,f),el(c,c,f),el(h,h,f),el(p,p,f),i[0]=Dl(i[0],h,r),i[1]=Dl(i[1],p,r),i[2]=Dl(i[2],c,r),i[3]=Dl(i[3],u,r),_l.fromPoints(i)}function Ll(t,e,r){for(const n of t)el(n,n,e),Ho(n,n,r);}function Fl(t,e,r){const n=e/t.worldSize,i=t.globeMatrix;if(r.z<=1){const t=Pl(r).getCorners();return Ll(t,i,n),_l.fromPoints(t)}const s=Rl(r),a=jl(s);Ll(a,i,n);const o=Number.MAX_VALUE,l=[-o,-o,-o],u=[o,o,o];if(s.contains(t.center)){for(const t of a)Ko(u,u,t),Yo(l,l,t);l[2]=0;const e=t.point,r=[e.x*n,e.y*n,0];return Ko(u,u,r),Yo(l,l,r),new _l(u,l)}const c=[i[12]*n,i[13]*n,i[14]*n],h=s.getCenter(),p=S(t.center.lat,-cu,cu),f=S(h.lat,-cu,cu),d=iu(t.center.lng),y=su(p);let m=d-iu(h.lng);const g=y-su(f);m>.5?m-=1:m<-.5&&(m+=1);let v=0;Math.abs(m)>Math.abs(g)?v=m>=0?1:3:(v=g>=0?0:2,Wo(c,c,[i[4]*n,i[5]*n,i[6]*n],-Math.sin(x(g>=0?s.getSouth():s.getNorth()))*Al));const b=a[v],w=a[(v+1)%4],_=new El(b,w,c),A=[Cl(_,0)||b[0],Cl(_,1)||b[1],Cl(_,2)||b[2]],k=Kl(t.zoom);if(k>0){const n=function({x:t,y:e,z:r},n,i,s,a){const o=1/(1<<r);let l=t*o,u=l+o,c=e*o,h=c+o,p=0;const f=(l+u)/2-s;return f>.5?p=-1:f<-.5&&(p=1),l=((l+p)*n-(s*=n))*i+s,u=((u+p)*n-s)*i+s,c=(c*n-(a*=n))*i+a,h=(h*n-a)*i+a,[[l,h,0],[u,h,0],[u,c,0],[l,c,0]]}(r,e,t._pixelsPerMercatorPixel,d,y);for(let t=0;t<a.length;t++)Dl(a[t],n[t],k);const i=Go([],n[v],n[(v+1)%4]);Ho(i,i,.5),Dl(A,i,k);}for(const t of a)Ko(u,u,t),Yo(l,l,t);return u[2]=Math.min(b[2],w[2]),Ko(u,u,A),Yo(l,l,A),new _l(u,l)}function Rl({x:t,y:e,z:r}){const n=1/(1<<r),i=new ru(ou(t*n),lu((e+1)*n)),s=new ru(ou((t+1)*n),lu(e*n));return new Io(i,s)}function jl(t){const e=x(t.getNorth()),r=x(t.getSouth()),n=Math.cos(e),i=Math.cos(r),s=Math.sin(e),a=Math.sin(r),o=t.getWest(),l=t.getEast();return [$l(i,a,o),$l(i,a,l),$l(n,s,l),$l(n,s,o)]}function $l(t,e,r,n=Al){return r=x(r),[t*Math.sin(r)*n,-e*n,t*Math.cos(r)*n]}function Ul(t,e,r){return $l(Math.cos(x(t)),Math.sin(x(t)),e,r)}function Ol(t,e,r,n){const i=1<<r.z,s=(t/ko+r.x)/i;return Ul(lu((e/ko+r.y)/i),ou(s),n)}function ql({min:t,max:e}){return 16383/Math.max(e[0]-t[0],e[1]-t[1],e[2]-t[2])}const Nl=new Float64Array(16);function Gl(t){const e=ql(t),r=Ro(Nl,[e,e,e]);return Do(r,r,((n=[])[0]=-(i=t.min)[0],n[1]=-i[1],n[2]=-i[2],n));var n,i;}function Zl(t){const e=(n=t.min,(r=Nl)[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=1,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=1,r[11]=0,r[12]=n[0],r[13]=n[1],r[14]=n[2],r[15]=1,r);var r,n;const i=1/ql(t);return Vo(e,e,[i,i,i])}function Xl(t,e,r,n,i){const s=function(t){const e=ko/(2*Math.PI);return t/(2*Math.PI)/e}(r),a=[t,e,-r/(2*Math.PI)],o=Eo(new Float64Array(16));return Do(o,o,a),Vo(o,o,[s,s,s]),Lo(o,o,x(-i)),Fo(o,o,x(-n)),o}function Kl(t){return k(5,6,t)}function Yl(t,e){const r=Ul(e.lat,e.lng),n=function(t){const e=Ul(t._center.lat,t._center.lng);let r=tl([],No(0,1,0),e);const n=jo([],-t.angle,e);r=el(r,r,n),jo(n,-t._pitch,r);const i=Jo([],e);return Ho(i,i,zl(t.cameraToCenterDistance/t.pixelsPerMeter)),el(i,i,n),Go([],e,i)}(t);return a=(i=Zo([],n,r))[0],o=i[1],l=i[2],u=(s=r)[0],c=s[1],h=s[2],f=(p=Math.sqrt(a*a+o*o+l*l)*Math.sqrt(u*u+c*c+h*h))&&Qo(i,s)/p,Math.acos(Math.min(Math.max(f,-1),1));var i,s,a,o,l,u,c,h,p,f;}function Hl(t,e){return Yl(t,e)>Math.PI/2*1.01}const Wl=x(85),Jl=Math.cos(Wl),Ql=Math.sin(Wl),tu=6371008.8,eu=2*Math.PI*tu;class ru{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new ru(I(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return tu*Math.acos(Math.min(i,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new Io(new ru(this.lng-r,this.lat-e),new ru(this.lng+r,this.lat+e))}toEcef(t){const e=zl(t);return Ul(this.lat,this.lng,Al+e)}static convert(t){if(t instanceof ru)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new ru(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new ru(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}function nu(t){return eu*Math.cos(t*Math.PI/180)}function iu(t){return (180+t)/360}function su(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function au(t,e){return t/nu(e)}function ou(t){return 360*t-180}function lu(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function uu(t,e){return t*nu(lu(e))}const cu=85.051129;function hu(t){return 1/Math.cos(t*Math.PI/180)}class pu{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=ru.convert(t);return new pu(iu(r.lng),su(r.lat),au(e,r.lat))}toLngLat(){return new ru(ou(this.x),lu(this.y))}toAltitude(){return uu(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/eu*hu(lu(this.y))}}function fu(t,e,r,n,i,s,a,o,l){const u=(e+n)/2,c=(r+i)/2,h=new d(u,c);o(h),function(t,e,r,n,i,s){const a=r-i,o=n-s;return Math.abs((n-e)*a-(r-t)*o)/Math.hypot(a,o)}(h.x,h.y,s.x,s.y,a.x,a.y)>=l?(fu(t,e,r,u,c,s,h,o,l),fu(t,u,c,n,i,h,a,o,l)):t.push(a);}function du(t,e,r){let n=t[0],i=n.x,s=n.y;e(n);const a=[n];for(let o=1;o<t.length;o++){const l=t[o],{x:u,y:c}=l;e(l),fu(a,i,s,u,c,n,l,e,r),i=u,s=c,n=l;}return a}function yu(t,e,r,n){if(n(e,r)){const i=e.add(r)._mult(.5);yu(t,e,i,n),yu(t,i,r,n);}else t.push(r);}function mu(t,e){let r=t[0];const n=[r];for(let i=1;i<t.length;i++){const s=t[i];yu(n,r,s,e),r=s;}return n}const gu=Math.pow(2,14)-1,xu=-gu-1;function vu(t,e){const r=Math.round(t.x*e),n=Math.round(t.y*e);return t.x=S(r,xu,gu),t.y=S(n,xu,gu),(r<t.x||r>t.x+1||n<t.y||n>t.y+1)&&U("Geometry exceeds allowed extent, reduce your vector tile buffer size"),t}function bu(t,e,r){const n=t.loadGeometry(),i=t.extent,s=ko/i;if(e&&r&&r.projection.isReprojectedInTileSpace){const s=1<<e.z,{scale:a,x:o,y:l,projection:u}=r,c=t=>{const r=ou((e.x+t.x/i)/s),n=lu((e.y+t.y/i)/s),c=u.project(r,n);t.x=(c.x*a-o)*i,t.y=(c.y*a-l)*i;};for(let e=0;e<n.length;e++)if(1!==t.type)n[e]=du(n[e],c,1);else {const t=[];for(const r of n[e])r.x<0||r.x>=i||r.y<0||r.y>=i||(c(r),t.push(r));n[e]=t;}}for(const t of n)for(const e of t)vu(e,s);return n}function wu(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?bu(t):[]}}function _u(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}function Au(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class Su{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.projection=t.projection,this.layoutVertexArray=new sa,this.indexArray=new wa,this.segments=new So,this.programConfigurations=new fo(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r,n){const i=this.layers[0],s=[];let a=null;"circle"===i.type&&(a=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=wu(e,t);if(!this.layers[0]._featureFilter.filter(new $s(this.zoom),u,r))continue;const c=a?a.evaluate(u,{},r):void 0,h={id:i,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:bu(e,r,n),patterns:{},sortKey:c};s.push(h);}a&&s.sort(((t,e)=>t.sortKey-e.sortKey));let o=null;"globe"===n.projection.name&&(this.globeExtVertexArray=new pa,o=n.projection);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n,l=t[s].feature;this.addFeature(n,i,s,e.availableImages,r,o),e.featureIndex.insert(l,i,s,a,this.index);}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,_o.members),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,Ao.members))),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy());}addFeature(t,e,r,n,i,s){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=ko||n<0||n>=ko)continue;if(s){const t=s.projectTilePoint(r,n,i),e=s.upVector(i,r,n),a=this.globeExtVertexArray;Au(a,t,e),Au(a,t,e),Au(a,t,e),Au(a,t,e);}const a=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),o=a.vertexLength;_u(this.layoutVertexArray,r,n,-1,-1),_u(this.layoutVertexArray,r,n,1,-1),_u(this.layoutVertexArray,r,n,1,1),_u(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(o,o+1,o+2),this.indexArray.emplaceBack(o,o+2,o+3),a.vertexLength+=4,a.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n,i);}}function ku(t,e){for(let r=0;r<t.length;r++)if(Du(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Du(t,e[r]))return !0;return !!zu(t,e)}function Iu(t,e,r){return !!Du(t,e)||!!Eu(e,t,r)}function Mu(t,e){if(1===t.length)return Pu(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(Du(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(Pu(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(zu(t,e[r]))return !0;return !1}function Tu(t,e,r){if(t.length>1){if(zu(t,e))return !0;for(let n=0;n<e.length;n++)if(Eu(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(Eu(t[n],e,r))return !0;return !1}function zu(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(Bu(n,i,e[t],e[t+1]))return !0}return !1}function Bu(t,e,r,n){return O(t,r,n)!==O(e,r,n)&&O(t,e,r)!==O(t,e,n)}function Eu(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(Cu(t,e[r-1],e[r])<n)return !0;return !1}function Cu(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function Pu(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function Du(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function Vu(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const s=[new d(e,r),new d(e,i),new d(n,i),new d(n,r)];if(t.length>2)for(const e of s)if(Du(t,e))return !0;for(let e=0;e<t.length-1;e++)if(Lu(t[e],t[e+1],s))return !0;return !1}function Lu(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=O(t,e,r[0]);return s!==O(t,e,r[1])||s!==O(t,e,r[2])||s!==O(t,e,r[3])}function Fu(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function Ru(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function ju(t,e,r,n,i){if(!e[0]&&!e[1])return t;const s=d.convert(e)._mult(i);"viewport"===r&&s._rotate(-n);const a=[];for(let e=0;e<t.length;e++)a.push(t[e].sub(s));return a}function $u(t,e,r,n){const i=d.convert(t)._mult(n);return "viewport"===e&&i._rotate(-r),i}Oi(Su,"CircleBucket",{omit:["layers"]});const Uu=new Js({"circle-sort-key":new Hs(Ht.layout_circle["circle-sort-key"])});var Ou={paint:new Js({"circle-radius":new Hs(Ht.paint_circle["circle-radius"]),"circle-color":new Hs(Ht.paint_circle["circle-color"]),"circle-blur":new Hs(Ht.paint_circle["circle-blur"]),"circle-opacity":new Hs(Ht.paint_circle["circle-opacity"]),"circle-translate":new Ys(Ht.paint_circle["circle-translate"]),"circle-translate-anchor":new Ys(Ht.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Ys(Ht.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Ys(Ht.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Hs(Ht.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Hs(Ht.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Hs(Ht.paint_circle["circle-stroke-opacity"])}),layout:Uu};function qu(t,e,r,n,i,s,a,o,l){if(s&&t.queryGeometry.isAboveHorizon)return !1;s&&(l*=t.pixelToTileUnitsFactor);const u=t.tileID.canonical,c=r.projection.upVectorScale(u,r.center.lat,r.worldSize).metersToTile;for(const h of e)for(const e of h){const h=e.add(o),p=i&&r.elevation?r.elevation.exaggeration()*i.getElevationAt(h.x,h.y,!0):0,f=r.projection.projectTilePoint(h.x,h.y,u);if(p>0){const t=r.projection.upVector(u,h.x,h.y);f.x+=t[0]*c*p,f.y+=t[1]*c*p,f.z+=t[2]*c*p;}const d=s?h:Nu(f.x,f.y,f.z,n),y=s?t.tilespaceRays.map((t=>Xu(t,p))):t.queryGeometry.screenGeometry,m=ul([],[f.x,f.y,f.z,1],n);if(!a&&s?l*=m[3]/r.cameraToCenterDistance:a&&!s&&(l*=r.cameraToCenterDistance/m[3]),s){const t=lu((e.y/ko+u.y)/(1<<u.z));l/=r.projection.pixelsPerMeter(t,1)/au(1,t);}if(Iu(y,d,l))return !0}return !1}function Nu(t,e,r,n){const i=ul([],[t,e,r,1],n);return new d(i[0]/i[3],i[1]/i[3])}const Gu=No(0,0,0),Zu=No(0,0,1);function Xu(t,e){const r=Uo();return Gu[2]=e,t.intersectsPlane(Gu,Zu,r),new d(r[0],r[1])}class Ku extends Su{}function Yu(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError("mismatched image size")}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function Hu(t,e,r){const{width:n,height:i}=e;n===t.width&&i===t.height||(Wu(t,e,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,n),height:Math.min(t.height,i)},r),t.width=n,t.height=i,t.data=e.data);}function Wu(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}Oi(Ku,"HeatmapBucket",{omit:["layers"]});class Ju{constructor(t,e){Yu(this,t,1,e);}resize(t){Hu(this,new Ju(t),1);}clone(){return new Ju({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Wu(t,e,r,n,i,1);}}class Qu{constructor(t,e){Yu(this,t,4,e);}resize(t){Hu(this,new Qu(t),4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Qu({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Wu(t,e,r,n,i,4);}}Oi(Ju,"AlphaImage"),Oi(Qu,"RGBAImage");var tc={paint:new Js({"heatmap-radius":new Hs(Ht.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Hs(Ht.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Ys(Ht.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Ws(Ht.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Ys(Ht.paint_heatmap["heatmap-opacity"])})};function ec(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Qu({width:r,height:n}),s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}var rc={paint:new Js({"hillshade-illumination-direction":new Ys(Ht.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new Ys(Ht.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Ys(Ht.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Ys(Ht.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Ys(Ht.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Ys(Ht.paint_hillshade["hillshade-accent-color"])})};const nc=na([{name:"a_pos",components:2,type:"Int16"}],4),{members:ic}=nc;var sc={};function ac(t,e,r){r=r||2;var n,i,s,a,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=oc(t,0,h,r,!0),f=[];if(!p||p.next===p.prev)return f;if(c&&(p=function(t,e,r,n){var i,s,a,o=[];for(i=0,s=e.length;i<s;i++)(a=oc(t,e[i]*n,i<s-1?e[i+1]*n:t.length,n,!1))===a.next&&(a.steiner=!0),o.push(xc(a));for(o.sort(dc),i=0;i<o.length;i++)r=yc(o[i],r);return r}(t,e,p,r)),t.length>80*r){n=s=t[0],i=a=t[1];for(var d=r;d<h;d+=r)(o=t[d])<n&&(n=o),(l=t[d+1])<i&&(i=l),o>s&&(s=o),l>a&&(a=l);u=0!==(u=Math.max(s-n,a-i))?32767/u:0;}return uc(p,f,r,n,i,u,0),f}function oc(t,e,r,n,i){var s,a;if(i===Ec(t,e,r,n)>0)for(s=e;s<r;s+=n)a=Tc(s,t[s],t[s+1],a);else for(s=r-n;s>=e;s-=n)a=Tc(s,t[s],t[s+1],a);return a&&_c(a,a.next)&&(zc(a),a=a.next),a}function lc(t,e){if(!t)return t;e||(e=t);var r,n=t;do{if(r=!1,n.steiner||!_c(n,n.next)&&0!==wc(n.prev,n,n.next))n=n.next;else {if(zc(n),(n=e=n.prev)===n.next)break;r=!0;}}while(r||n!==e);return e}function uc(t,e,r,n,i,s,a){if(t){!a&&s&&function(t,e,r,n){var i=t;do{0===i.z&&(i.z=gc(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,r,n,i,s,a,o,l,u=1;do{for(r=t,t=null,s=null,a=0;r;){for(a++,n=r,o=0,e=0;e<u&&(o++,n=n.nextZ);e++);for(l=u;o>0||l>0&&n;)0!==o&&(0===l||!n||r.z<=n.z)?(i=r,r=r.nextZ,o--):(i=n,n=n.nextZ,l--),s?s.nextZ=i:t=i,i.prevZ=s,s=i;r=n;}s.nextZ=null,u*=2;}while(a>1)}(i);}(t,n,i,s);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev,l=t.next,s?hc(t,n,i,s):cc(t))e.push(o.i/r|0),e.push(t.i/r|0),e.push(l.i/r|0),zc(t),t=l.next,u=l.next;else if((t=l)===u){a?1===a?uc(t=pc(lc(t),e,r),e,r,n,i,s,2):2===a&&fc(t,e,r,n,i,s):uc(lc(t),e,r,n,i,s,1);break}}}function cc(t){var e=t.prev,r=t,n=t.next;if(wc(e,r,n)>=0)return !1;for(var i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=i<s?i<a?i:a:s<a?s:a,h=o<l?o<u?o:u:l<u?l:u,p=i>s?i>a?i:a:s>a?s:a,f=o>l?o>u?o:u:l>u?l:u,d=n.next;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&vc(i,o,s,l,a,u,d.x,d.y)&&wc(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function hc(t,e,r,n){var i=t.prev,s=t,a=t.next;if(wc(i,s,a)>=0)return !1;for(var o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,y=o>l?o>u?o:u:l>u?l:u,m=c>h?c>p?c:p:h>p?h:p,g=gc(f,d,e,r,n),x=gc(y,m,e,r,n),v=t.prevZ,b=t.nextZ;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&vc(o,c,l,h,u,p,v.x,v.y)&&wc(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&vc(o,c,l,h,u,p,b.x,b.y)&&wc(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&vc(o,c,l,h,u,p,v.x,v.y)&&wc(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&vc(o,c,l,h,u,p,b.x,b.y)&&wc(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function pc(t,e,r){var n=t;do{var i=n.prev,s=n.next.next;!_c(i,s)&&Ac(i,n,n.next,s)&&Ic(i,s)&&Ic(s,i)&&(e.push(i.i/r|0),e.push(n.i/r|0),e.push(s.i/r|0),zc(n),zc(n.next),n=t=s),n=n.next;}while(n!==t);return lc(n)}function fc(t,e,r,n,i,s){var a=t;do{for(var o=a.next.next;o!==a.prev;){if(a.i!==o.i&&bc(a,o)){var l=Mc(a,o);return a=lc(a,a.next),l=lc(l,l.next),uc(a,e,r,n,i,s,0),void uc(l,e,r,n,i,s,0)}o=o.next;}a=a.next;}while(a!==t)}function dc(t,e){return t.x-e.x}function yc(t,e){var r=function(t,e){var r,n=e,i=t.x,s=t.y,a=-1/0;do{if(s<=n.y&&s>=n.next.y&&n.next.y!==n.y){var o=n.x+(s-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(o<=i&&o>a&&(a=o,r=n.x<n.next.x?n:n.next,o===i))return r}n=n.next;}while(n!==e);if(!r)return null;var l,u=r,c=r.x,h=r.y,p=1/0;n=r;do{i>=n.x&&n.x>=c&&i!==n.x&&vc(s<h?i:a,s,c,h,s<h?a:i,s,n.x,n.y)&&(l=Math.abs(s-n.y)/(i-n.x),Ic(n,t)&&(l<p||l===p&&(n.x>r.x||n.x===r.x&&mc(r,n)))&&(r=n,p=l)),n=n.next;}while(n!==u);return r}(t,e);if(!r)return e;var n=Mc(r,t);return lc(n,n.next),lc(r,r.next)}function mc(t,e){return wc(t.prev,t,e.prev)<0&&wc(e.next,t,t.next)<0}function gc(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function xc(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function vc(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function bc(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Ac(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Ic(t,e)&&Ic(e,t)&&function(t,e){var r=t,n=!1,i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(wc(t.prev,t,e.prev)||wc(t,e.prev,e))||_c(t,e)&&wc(t.prev,t,t.next)>0&&wc(e.prev,e,e.next)>0)}function wc(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function _c(t,e){return t.x===e.x&&t.y===e.y}function Ac(t,e,r,n){var i=kc(wc(t,e,r)),s=kc(wc(t,e,n)),a=kc(wc(r,n,t)),o=kc(wc(r,n,e));return i!==s&&a!==o||!(0!==i||!Sc(t,r,e))||!(0!==s||!Sc(t,n,e))||!(0!==a||!Sc(r,t,n))||!(0!==o||!Sc(r,e,n))}function Sc(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function kc(t){return t>0?1:t<0?-1:0}function Ic(t,e){return wc(t.prev,t,t.next)<0?wc(t,e,t.next)>=0&&wc(t,t.prev,e)>=0:wc(t,e,t.prev)<0||wc(t,t.next,e)<0}function Mc(t,e){var r=new Bc(t.i,t.x,t.y),n=new Bc(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function Tc(t,e,r,n){var i=new Bc(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function zc(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function Bc(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=0,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function Ec(t,e,r,n){for(var i=0,s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}function Cc(t,e,r,n,i){Pc(t,e,r||0,n||t.length-1,i||Vc);}function Pc(t,e,r,n,i){for(;n>r;){if(n-r>600){var s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);Pc(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}var c=t[e],h=r,p=n;for(Dc(t,r,e),i(t[n],c)>0&&Dc(t,r,n);h<p;){for(Dc(t,h,p),h++,p--;i(t[h],c)<0;)h++;for(;i(t[p],c)>0;)p--;}0===i(t[r],c)?Dc(t,r,p):Dc(t,++p,n),p<=e&&(r=p+1),e<=p&&(n=p-1);}}function Dc(t,e,r){var n=t[e];t[e]=t[r],t[r]=n;}function Vc(t,e){return t<e?-1:t>e?1:0}function Lc(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=q(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(Cc(n[t],e,1,n[t].length-1,Fc),n[t]=n[t].slice(0,e));return n}function Fc(t,e){return e.area-t.area}function Rc(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s]=!0);}return i}function jc(t,e,r,n,i){const s=i.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n},r,{},i.availableImages);t=t&&t.name?t.name:t,s[t]=!0,r.patterns[a.id]=t;}}return r}({get exports(){return sc},set exports(t){sc=t;}}).exports=ac,sc.default=ac,ac.deviation=function(t,e,r,n){var i=e&&e.length,s=Math.abs(Ec(t,0,i?e[0]*r:t.length,r));if(i)for(var a=0,o=e.length;a<o;a++)s-=Math.abs(Ec(t,e[a]*r,a<o-1?e[a+1]*r:t.length,r));var l=0;for(a=0;a<n.length;a+=3){var u=n[a]*r,c=n[a+1]*r,h=n[a+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===s&&0===l?0:Math.abs((l-s)/s)},ac.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},n=0,i=0;i<t.length;i++){for(var s=0;s<t[i].length;s++)for(var a=0;a<e;a++)r.vertices.push(t[i][s][a]);i>0&&r.holes.push(n+=t[i-1].length);}return r};class $c{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new sa,this.indexArray=new wa,this.indexArray2=new Ma,this.programConfigurations=new fo(t.layers,t.zoom),this.segments=new So,this.segments2=new So,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.projection=t.projection;}populate(t,e,r,n){this.hasPattern=Rc("fill",this.layers,e);const i=this.layers[0].layout.get("fill-sort-key"),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=wu(a,t);if(!this.layers[0]._featureFilter.filter(new $s(this.zoom),c,r))continue;const h=i?i.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:bu(a,r,n),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=jc("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.availableImages);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}addFeatures(t,e,r,n,i){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ic),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,s=[]){for(const t of Lc(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=sc(i,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(n+a[t],n+a[t+1],n+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n);}}Oi($c,"FillBucket",{omit:["layers","patternFeatures"]});const Uc=new Js({"fill-sort-key":new Hs(Ht.layout_fill["fill-sort-key"])});var Oc={paint:new Js({"fill-antialias":new Ys(Ht.paint_fill["fill-antialias"]),"fill-opacity":new Hs(Ht.paint_fill["fill-opacity"]),"fill-color":new Hs(Ht.paint_fill["fill-color"]),"fill-outline-color":new Hs(Ht.paint_fill["fill-outline-color"]),"fill-translate":new Ys(Ht.paint_fill["fill-translate"]),"fill-translate-anchor":new Ys(Ht.paint_fill["fill-translate-anchor"]),"fill-pattern":new Hs(Ht.paint_fill["fill-pattern"])}),layout:Uc};const qc=na([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),Nc=na([{name:"a_centroid_pos",components:2,type:"Uint16"}]),Gc=na([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:Zc}=qc;var Xc={},Kc=d,Yc=Hc;function Hc(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(Wc,this,e);}function Wc(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function Jc(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}Hc.types=["Unknown","Point","LineString","Polygon"],Hc.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,i=0,s=0,a=0,o=[];t.pos<r;){if(i<=0){var l=t.readVarint();n=7&l,i=l>>3;}if(i--,1===n||2===n)s+=t.readSVarint(),a+=t.readSVarint(),1===n&&(e&&o.push(e),e=[]),e.push(new Kc(s,a));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&o.push(e),o},Hc.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},Hc.prototype.toGeoJSON=function(t,e,r){var n,i,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=Hc.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],s=0;s<e;s++){var a=Jc(t[s]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(r&&i.push(r),r=[t[s]]):r.push(t[s]));}return r&&i.push(r),i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var Qc=Yc,th=eh;function eh(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(rh,this,e),this.length=this._features.length;}function rh(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}eh.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new Qc(this._pbf,e,this.extent,this._keys,this._values)};var nh=th;function ih(t,e,r){if(3===t){var n=new nh(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}var sh=Xc.VectorTile=function(t,e){this.layers=t.readFields(ih,{},e);},ah=Xc.VectorTileFeature=Yc;function oh(t,e,r,n){const i=[],s=0===n?(t,e,r,n,i,s)=>{t.push(new d(s,r+(s-e)/(n-e)*(i-r)));}:(t,e,r,n,i,s)=>{t.push(new d(e+(s-r)/(i-r)*(n-e),s));};for(const a of t){const t=[];for(const i of a){if(i.length<=2)continue;const a=[];for(let t=0;t<i.length-1;t++){const o=i[t].x,l=i[t].y,u=i[t+1].x,c=i[t+1].y,h=0===n?o:l,p=0===n?u:c;h<e?p>e&&s(a,o,l,u,c,e):h>r?p<r&&s(a,o,l,u,c,r):a.push(i[t]),p<e&&h>=e&&s(a,o,l,u,c,e),p>r&&h<=r&&s(a,o,l,u,c,r);}let o=i[i.length-1];const l=0===n?o.x:o.y;l>=e&&l<=r&&a.push(o),a.length&&(o=a[a.length-1],a[0].x===o.x&&a[0].y===o.y||a.push(a[0]),t.push(a));}t.length&&i.push(t);}return i}Xc.VectorTileLayer=th;const lh=ah.types,uh=Math.pow(2,13);function ch(t,e,r,n,i,s,a,o){t.emplaceBack((e<<1)+a,(r<<1)+s,(Math.floor(n*uh)<<1)+i,Math.round(o));}function hh(t,e,r){const n=16384;t.emplaceBack(e.x,e.y,e.z,r[0]*n,r[1]*n,r[2]*n);}class ph{constructor(){this.acc=new d(0,0),this.polyCount=[];}startRing(t){this.currentPolyCount={edges:0,top:0},this.polyCount.push(this.currentPolyCount),this.min||(this.min=new d(t.x,t.y),this.max=new d(t.x,t.y));}append(t,e){this.currentPolyCount.edges++,this.acc._add(t);const r=this.min,n=this.max;t.x<r.x?r.x=t.x:t.x>n.x&&(n.x=t.x),t.y<r.y?r.y=t.y:t.y>n.y&&(n.y=t.y),((0===t.x||t.x===ko)&&t.x===e.x)!=((0===t.y||t.y===ko)&&t.y===e.y)&&this.processBorderOverlap(t,e),e.x<0!=t.x<0&&this.addBorderIntersection(0,Mr(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>ko!=t.x>ko&&this.addBorderIntersection(1,Mr(e.y,t.y,(ko-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,Mr(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>ko!=t.y>ko&&this.addBorderIntersection(3,Mr(e.x,t.x,(ko-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){const t=this.polyCount.reduce(((t,e)=>t+e.edges),0);return 0!==t?this.acc.div(t)._round():new d(0,0)}span(){return new d(this.max.x-this.min.x,this.max.y-this.min.y)}intersectsCount(){return this.borders.reduce(((t,e)=>t+ +(e[0]!==Number.MAX_VALUE)),0)}}class fh{constructor(t){this.zoom=t.zoom,this.canonical=t.canonical,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=t.projection,this.layoutVertexArray=new oa,this.centroidVertexArray=new $a,this.indexArray=new wa,this.programConfigurations=new fo(t.layers,t.zoom),this.segments=new So,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.enableTerrain=t.enableTerrain;}populate(t,e,r,n){this.features=[],this.hasPattern=Rc("fill-extrusion",this.layers,e),this.featuresOnBorder=[],this.borders=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.tileToMeter=function(t){const e=Math.exp(Math.PI*(1-t.y/(1<<t.z)*2));return 80150034*e/(e*e+1)/ko/(1<<t.z)}(r),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter;for(const{feature:i,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=wu(i,t);if(!this.layers[0]._featureFilter.filter(new $s(this.zoom),l,r))continue;const u={id:s,sourceLayerIndex:o,index:a,geometry:t?l.geometry:bu(i,r,n),properties:i.properties,type:i.type,patterns:{}},c=this.layoutVertexArray.length;this.hasPattern?this.features.push(jc("fill-extrusion",this.layers,u,this.zoom,e)):this.addFeature(u,u.geometry,a,r,{},e.availableImages,n),e.featureIndex.insert(i,u.geometry,a,o,this.index,c);}this.sortBorders();}addFeatures(t,e,r,n,i){for(const t of this.features){const{geometry:s}=t;this.addFeature(t,s,t.index,e,r,n,i);}this.sortBorders();}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Zc),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=t.createVertexBuffer(this.layoutVertexExtArray,Gc.members,!0))),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){0!==this.centroidVertexArray.length&&(this.centroidVertexBuffer?this.needsCentroidUpdate&&this.centroidVertexBuffer.updateData(this.centroidVertexArray):this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Nc.members,!0),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i,s,a){const o=[new d(0,0),new d(ko,ko)],l=a.projection,u="globe"===l.name,c=this.enableTerrain&&!u?new ph:null,h="Polygon"===lh[t.type];u&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new pa);const p=Lc(e,500);for(let t=p.length-1;t>=0;t--){const e=p[t];(0===e.length||(f=e[0]).every((t=>t.x<=0))||f.every((t=>t.x>=ko))||f.every((t=>t.y<=0))||f.every((t=>t.y>=ko)))&&p.splice(t,1);}var f;let y;if(u)y=wh(p,o,n);else {y=[];for(const t of p)y.push({polygon:t,bounds:o});}const m=h?this.edgeRadius:0;for(const{polygon:t,bounds:e}of y){let r=0,i=0;for(const e of t)h&&!e[0].equals(e[e.length-1])&&e.push(e[0]),i+=h?e.length-1:e.length;const s=this.segments.prepareSegment((h?5:4)*i,this.layoutVertexArray,this.indexArray);if(h){const e=[],i=[];r=s.vertexLength;for(const r of t){let a,o;r.length&&r!==t[0]&&i.push(e.length/2),a=r[1].sub(r[0])._perp()._unit();for(let t=1;t<r.length;t++){const i=r[t],c=r[t===r.length-1?1:t+1];let{x:h,y:p}=i;if(m){o=c.sub(i)._perp()._unit();const t=a.add(o)._unit(),e=m*Math.min(4,1/(a.x*t.x+a.y*t.y));h+=e*t.x,p+=e*t.y,a=o;}ch(this.layoutVertexArray,h,p,0,0,1,1,0),s.vertexLength++,e.push(i.x,i.y),u&&hh(this.layoutVertexExtArray,l.projectTilePoint(h,p,n),l.upVector(n,h,p));}}const a=sc(e,i);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(r+a[t],r+a[t+2],r+a[t+1]),s.primitiveLength++;}for(const i of t){c&&i.length&&c.startRing(i[0]);let t,a,o,p=i.length>4&&xh(i[i.length-2],i[0],i[1]),f=m?yh(i[i.length-2],i[0],i[1],m):0;a=i[1].sub(i[0])._perp()._unit();let d=!0;for(let y=1,g=0;y<i.length;y++){let x=i[y-1],v=i[y];const b=i[y===i.length-1?1:y+1];if(c&&h&&c.currentPolyCount.top++,gh(v,x,e)){m&&(a=b.sub(v)._perp()._unit(),d=!d);continue}c&&c.append(v,x);const w=v.sub(x)._perp(),_=w.x/(Math.abs(w.x)+Math.abs(w.y)),A=w.y>0?1:0,S=x.dist(v);if(g+S>32768&&(g=0),m){o=b.sub(v)._perp()._unit();let t=mh(x,v,b,dh(a,o),m);isNaN(t)&&(t=0);const e=v.sub(x)._unit();x=x.add(e.mult(f))._round(),v=v.add(e.mult(-t))._round(),f=t,a=o;}const k=s.vertexLength,I=i.length>4&&xh(x,v,b);let M=vh(g,p,d);if(ch(this.layoutVertexArray,x.x,x.y,_,A,0,0,M),ch(this.layoutVertexArray,x.x,x.y,_,A,0,1,M),g+=S,M=vh(g,I,!d),p=I,ch(this.layoutVertexArray,v.x,v.y,_,A,0,0,M),ch(this.layoutVertexArray,v.x,v.y,_,A,0,1,M),s.vertexLength+=4,this.indexArray.emplaceBack(k+0,k+1,k+2),this.indexArray.emplaceBack(k+1,k+3,k+2),s.primitiveLength+=2,m){const n=r+(1===y?i.length-2:y-2),a=1===y?r:n+1;if(this.indexArray.emplaceBack(k+1,n,k+3),this.indexArray.emplaceBack(n,a,k+3),s.primitiveLength+=2,void 0===t&&(t=k),!gh(b,i[y],e)){const e=y===i.length-1?t:s.vertexLength;this.indexArray.emplaceBack(k+2,k+3,e),this.indexArray.emplaceBack(k+3,e+1,e),this.indexArray.emplaceBack(k+3,a,e+1),s.primitiveLength+=3;}d=!d;}if(u){const t=this.layoutVertexExtArray,e=l.projectTilePoint(x.x,x.y,n),r=l.projectTilePoint(v.x,v.y,n),i=l.upVector(n,x.x,x.y),s=l.upVector(n,v.x,v.y);hh(t,e,i),hh(t,e,i),hh(t,r,s),hh(t,r,s);}}h&&(r+=i.length-1);}}if(c&&c.polyCount.length>0){if(c.borders){c.vertexArrayOffset=this.centroidVertexArray.length;const t=c.borders,e=this.featuresOnBorder.push(c)-1;for(let r=0;r<4;r++)t[r][0]!==Number.MAX_VALUE&&this.borders[r].push(e);}this.encodeCentroid(c.borders?void 0:c.centroid(),c);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n);}sortBorders(){for(let t=0;t<4;t++)this.borders[t].sort(((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]));}encodeCentroid(t,e,r=!0){let n,i;if(t)if(0!==t.y){const r=e.span()._mult(this.tileToMeter);n=(Math.max(t.x,1)<<3)+Math.min(7,Math.round(r.x/10)),i=(Math.max(t.y,1)<<3)+Math.min(7,Math.round(r.y/10));}else n=Math.ceil(7*(t.x+450)),i=0;else n=0,i=+r;let s=r?this.centroidVertexArray.length:e.vertexArrayOffset;for(const t of e.polyCount){r&&this.centroidVertexArray.resize(this.centroidVertexArray.length+4*t.edges+t.top);for(let e=0;e<t.top;e++)this.centroidVertexArray.emplace(s++,n,i);for(let e=0;e<2*t.edges;e++)this.centroidVertexArray.emplace(s++,0,i),this.centroidVertexArray.emplace(s++,n,i);}}}function dh(t,e){const r=t.add(e)._unit();return t.x*r.x+t.y*r.y}function yh(t,e,r,n){const i=e.sub(t)._perp()._unit(),s=r.sub(e)._perp()._unit();return mh(t,e,r,dh(i,s),n)}function mh(t,e,r,n,i){const s=Math.sqrt(1-n*n);return Math.min(t.dist(e)/3,e.dist(r)/3,i*s/n)}function gh(t,e,r){return t.x<r[0].x&&e.x<r[0].x||t.x>r[1].x&&e.x>r[1].x||t.y<r[0].y&&e.y<r[0].y||t.y>r[1].y&&e.y>r[1].y}function xh(t,e,r){if(t.x<0||t.x>=ko||e.x<0||e.x>=ko||r.x<0||r.x>=ko)return !1;const n=r.sub(e),i=n.perp(),s=t.sub(e);return (n.x*s.x+n.y*s.y)/Math.sqrt((n.x*n.x+n.y*n.y)*(s.x*s.x+s.y*s.y))>-.866&&i.x*s.x+i.y*s.y<0}function vh(t,e,r){const n=e?2|t:-3&t;return r?1|n:-2&n}function bh(){const t=Math.PI/32,e=Math.tan(t),r=tu;return r*Math.sqrt(1+2*e*e)-r}function wh(t,e,r){const n=1<<r.z,i=ou(r.x/n),s=ou((r.x+1)/n),a=lu(r.y/n),o=lu((r.y+1)/n);return function(t,e,r,n,i=0,s){const a=[];if(!t.length||!r||!n)return a;const o=(t,e)=>{for(const r of t)a.push({polygon:r,bounds:e});},l=Math.ceil(Math.log2(r)),u=Math.ceil(Math.log2(n)),c=l-u,h=[];for(let t=0;t<Math.abs(c);t++)h.push(c>0?0:1);for(let t=0;t<Math.min(l,u);t++)h.push(0),h.push(1);let p=t;if(p=oh(p,e[0].y-i,e[1].y+i,1),p=oh(p,e[0].x-i,e[1].x+i,0),!p.length)return a;const f=[];for(h.length?f.push({polygons:p,bounds:e,depth:0}):o(p,e);f.length;){const t=f.pop(),e=t.depth,r=h[e],n=t.bounds[0],a=t.bounds[1],l=0===r?n.x:n.y,u=0===r?a.x:a.y,c=s?s(r,l,u):.5*(l+u),p=oh(t.polygons,l-i,c+i,r),y=oh(t.polygons,c-i,u+i,r);if(p.length){const t=[n,new d(0===r?c:a.x,1===r?c:a.y)];h.length>e+1?f.push({polygons:p,bounds:t,depth:e+1}):o(p,t);}if(y.length){const t=[new d(0===r?c:n.x,1===r?c:n.y),a];h.length>e+1?f.push({polygons:y,bounds:t,depth:e+1}):o(y,t);}}return a}(t,e,Math.ceil((s-i)/11.25),Math.ceil((a-o)/11.25),1,((t,e,i)=>{if(0===t)return .5*(e+i);{const t=lu((r.y+e/ko)/n);return (su(.5*(lu((r.y+i/ko)/n)+t))*n-r.y)*ko}}))}Oi(fh,"FillExtrusionBucket",{omit:["layers","features"]}),Oi(ph,"PartMetadata");const _h=new Js({"fill-extrusion-edge-radius":new Ys(Ht["layout_fill-extrusion"]["fill-extrusion-edge-radius"])});var Ah={paint:new Js({"fill-extrusion-opacity":new Ys(Ht["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Hs(Ht["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Ys(Ht["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Ys(Ht["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Hs(Ht["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Hs(Ht["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Hs(Ht["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Ys(Ht["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new Ys(Ht["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new Ys(Ht["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"])}),layout:_h};function Sh(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class kh{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=Th(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=function(t,e,r){var n=Sh(256*t,256*(e=Math.pow(2,r)-e-1),r),i=Sh(256*(t+1),256*(e+1),r);return n[0]+","+n[1]+","+i[0]+","+i[1]}(this.x,this.y,this.z),n=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",n).replace("{bbox-epsg-3857}",r)}toString(){return `${this.z}/${this.x}/${this.y}`}}class Ih{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Th(t,e.z,e.z,e.x,e.y);}}class Mh{constructor(t,e,r,n,i){this.overscaledZ=t,this.wrap=e,this.canonical=new kh(r,+n,+i),this.key=0===e&&t===r?this.canonical.key:Th(e,t,r,n,i);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new Mh(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Mh(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return Th(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return Th(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new Mh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new Mh(e,this.wrap,e,r,n),new Mh(e,this.wrap,e,r+1,n),new Mh(e,this.wrap,e,r,n+1),new Mh(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new Mh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new Mh(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Ih(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function Th(t,e,r,n,i){const s=1<<Math.min(r,22);let a=s*(i%s)+n%s;return t&&r<22&&(a+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*a+r)+(e-r)}Oi(kh,"CanonicalTileID"),Oi(Mh,"OverscaledTileID",{omit:["projMatrix"]});class zh extends d{constructor(t,e,r){super(t,e),this.z=r;}}function Bh(t,e){return t.x*e.x+t.y*e.y}function Eh(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=Bh(o,o),h=Bh(o,l),p=Bh(l,l),f=Bh(u,o),d=Bh(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Ch(t,e,r,n,i,s,a,o){const l=a*i.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?a*(s[0]/7-450):a*function(t,e,r){const n=Math.floor(e[0]/8),i=Math.floor(e[1]/8),s=10*(e[0]-8*n),a=10*(e[1]-8*i),o=t.getElevationAt(n,i,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(a*l-1)),h=t.tileCoordToPixel(n,i),p=2*u+1,f=2*c+1,d=function(t,e,r,n,i){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+i,r,!0),t.getElevationAtPixel(e,r+i,!0),t.getElevationAtPixel(e+n,r+i,!0)]}(t,h.x-u,h.y-c,p,f),y=Math.abs(d[0]-d[1]),m=Math.abs(d[2]-d[3]),g=Math.abs(d[0]-d[2])+Math.abs(d[1]-d[3]),x=Math.min(.25,.5*l*(y+m)/p),v=Math.min(.25,.5*l*g/f);return o+Math.max(x*s,v*a)}(i,s,o):l;return {base:l+(0===r)?-1:r,top:u?Math.max(c+n,l+r+2):l+n}}const Ph=na([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:Dh}=Ph,Vh=na([{name:"a_packed",components:4,type:"Float32"}]),{members:Lh}=Vh,Fh=ah.types,Rh=Math.cos(Math.PI/180*37.5);class jh{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.projection=t.projection,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new la,this.layoutVertexArray2=new ua,this.indexArray=new wa,this.programConfigurations=new fo(t.layers,t.zoom),this.segments=new So,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r,n){this.hasPattern=Rc("line",this.layers,e);const i=this.layers[0].layout.get("line-sort-key"),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=wu(e,t);if(!this.layers[0]._featureFilter.filter(new $s(this.zoom),u,r))continue;const c=i?i.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:bu(e,r,n),patterns:{},sortKey:c};s.push(h);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));const{lineAtlas:a,featureIndex:o}=e,l=this.addConstantDashes(a);for(const n of s){const{geometry:i,index:s,sourceLayerIndex:u}=n;if(l&&this.addFeatureDashes(n,a),this.hasPattern){const t=jc("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,a.positions,e.availableImages);o.insert(t[s].feature,i,s,u,this.index);}}addConstantDashes(t){let e=!1;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,i=r.layout.get("line-cap").value;if("constant"!==n.kind||"constant"!==i.kind)e=!0;else {const e=i.value,r=n.value;if(!r)continue;t.addDash(r,e);}}return e}addFeatureDashes(t,e){const r=this.zoom;for(const n of this.layers){const i=n.paint.get("line-dasharray").value,s=n.layout.get("line-cap").value;if("constant"===i.kind&&"constant"===s.kind)continue;let a,o;if("constant"===i.kind){if(a=i.value,!a)continue}else a=i.evaluate({zoom:r},t);o="constant"===s.kind?s.value:s.evaluate({zoom:r},t),e.addDash(a,o),t.patterns[n.id]=e.getKey(a,o);}}update(t,e,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r,n);}addFeatures(t,e,r,n,i){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r,n);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Lh)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Dh),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s){const a=this.layers[0].layout,o=a.get("line-join").evaluate(t,{}),l=a.get("line-cap").evaluate(t,{}),u=a.get("line-miter-limit"),c=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,o,l,u,c);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,s,n);}addLine(t,e,r,n,i,s){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const a="Polygon"===Fh[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===r&&(i=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p,f,d,y;this.e1=this.e2=-1,a&&(h=t[o-2],y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(f=e===o-1?a?t[l+1]:void 0:t[e+1],f&&t[e].equals(f))continue;y&&(d=y),h&&(p=h),h=t[e],y=f?f.sub(h)._unit()._perp():d,d=d||y;let m=d.add(y);0===m.x&&0===m.y||m._unit();const g=d.x*y.x+d.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Rh&&p&&f,_=d.x*y.y-d.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,d,0,0,c),p=e;}}const A=p&&f;let S=A?r:a?"butt":n;if(A&&"round"===S&&(v<s?S="miter":v<=2&&(S="fakeround")),"miter"===S&&v>i&&(S="bevel"),"bevel"===S&&(v>2&&(S="flipbevel"),v<i&&(S="miter")),p&&this.updateDistance(p,h),"miter"===S)m._mult(v),this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===S){if(v>100)m=y.mult(-1);else {const t=v*d.add(y).mag()/d.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c),this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===S||"fakeround"===S){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,d,e,r,c),"fakeround"===S){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const n=y.sub(d)._mult(r)._add(d)._unit()._mult(_?-1:1);this.addHalfVertex(h,n.x,n.y,!1,_,0,c);}}f&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===S)this.addCurrentVertex(h,m,0,0,c);else if("square"===S){const t=p?1:-1;p||this.addCurrentVertex(h,m,t,t,c),this.addCurrentVertex(h,m,0,0,c),p&&this.addCurrentVertex(h,m,t,t,c);}else "round"===S&&(p&&(this.addCurrentVertex(h,d,0,0,c),this.addCurrentVertex(h,d,1,1,c,!0)),f&&(this.addCurrentVertex(h,y,-1,-1,c,!0),this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(f);if(t>2*u){const e=h.add(f.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,y,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i);}addHalfVertex({x:t,y:e},r,n,i,s,a,o){this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,this.lineClips.start,this.lineClips.end);const l=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),o.primitiveLength++),s?this.e2=l:this.e1=l;}updateScaledDistance(){if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t*this.lineClips.start+this.distance;}else this.lineSoFar=this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}Oi(jh,"LineBucket",{omit:["layers","patternFeatures"]});const $h=new Js({"line-cap":new Hs(Ht.layout_line["line-cap"]),"line-join":new Hs(Ht.layout_line["line-join"]),"line-miter-limit":new Ys(Ht.layout_line["line-miter-limit"]),"line-round-limit":new Ys(Ht.layout_line["line-round-limit"]),"line-sort-key":new Hs(Ht.layout_line["line-sort-key"])});var Uh={paint:new Js({"line-opacity":new Hs(Ht.paint_line["line-opacity"]),"line-color":new Hs(Ht.paint_line["line-color"]),"line-translate":new Ys(Ht.paint_line["line-translate"]),"line-translate-anchor":new Ys(Ht.paint_line["line-translate-anchor"]),"line-width":new Hs(Ht.paint_line["line-width"]),"line-gap-width":new Hs(Ht.paint_line["line-gap-width"]),"line-offset":new Hs(Ht.paint_line["line-offset"]),"line-blur":new Hs(Ht.paint_line["line-blur"]),"line-dasharray":new Hs(Ht.paint_line["line-dasharray"]),"line-pattern":new Hs(Ht.paint_line["line-pattern"]),"line-gradient":new Ws(Ht.paint_line["line-gradient"]),"line-trim-offset":new Ys(Ht.paint_line["line-trim-offset"])}),layout:$h};const Oh=new class extends Hs{possiblyEvaluate(t,e){return e=new $s(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=z({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}(Uh.paint.properties["line-width"].specification);function qh(t,e){return e>0?e+2*t:t}Oh.useIntegerZoom=!0;const Nh=na([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Gh=na([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),Zh=na([{name:"a_projected_pos",components:4,type:"Float32"}],4);na([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const Xh=na([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]),Kh=na([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"}]);na([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Yh=na([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),Hh=na([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);na([{name:"triangle",components:3,type:"Uint16"}]),na([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),na([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"}]),na([{type:"Float32",name:"offsetX"}]),na([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);var Wh=24;const Jh=128;function Qh(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new $s(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new $s(a)),maxSize:r.evaluate(new $s(o)),interpolationType:n}}}function tp(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/Jh:"composite"===t.kind?Mr(n/Jh,i/Jh,r):e}function ep(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?S(Kr.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=Mr(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}}var rp=Object.freeze({__proto__:null,getSizeData:Qh,evaluateSizeForFeature:tp,evaluateSizeForZoom:ep,SIZE_PACK_FACTOR:Jh});function np(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),js.applyArabicShaping&&(t=js.applyArabicShaping(t)),t}(t.text,e,r);})),t}const ip={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};function sp(t){return "︶"===t||"﹈"===t||"︸"===t||"﹄"===t||"﹂"===t||"︾"===t||"︼"===t||"︺"===t||"︘"===t||"﹀"===t||"︐"===t||"︓"===t||"︔"===t||"｀"===t||"￣"===t||"︑"===t||"︒"===t}function ap(t){return "︵"===t||"﹇"===t||"︷"===t||"﹃"===t||"﹁"===t||"︽"===t||"︻"===t||"︹"===t||"︗"===t||"︿"===t}var op=cp,lp=function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(f?-1:1);a+=Math.pow(2,n),s-=u;}return (f?-1:1)*a*Math.pow(2,s-n)},up=function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+f]=255&a,f+=d,a/=256,u-=8);t[r+f-d]|=128*y;};
    /*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */function cp(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}cp.Varint=0,cp.Fixed64=1,cp.Bytes=2,cp.Fixed32=5;var hp=4294967296,pp=1/hp,fp="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function dp(t){return t.type===cp.Bytes?t.readVarint()+t.pos:t.pos+1}function yp(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function mp(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function gp(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function xp(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function vp(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function bp(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function wp(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function _p(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Ap(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function Sp(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function kp(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Ip(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Mp(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function Tp(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}function zp(t,e,r){e.glyphs=[],1===t&&r.readMessage(Bp,e);}function Bp(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Ep,{});e.glyphs.push({id:t,bitmap:new Ju({width:i+6,height:s+6},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}else 4===t?e.ascender=r.readSVarint():5===t&&(e.descender=r.readSVarint());}function Ep(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function Cp(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}cp.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Ip(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=Tp(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Ip(this.buf,this.pos)+Ip(this.buf,this.pos+4)*hp;return this.pos+=8,t},readSFixed64:function(){var t=Ip(this.buf,this.pos)+Tp(this.buf,this.pos+4)*hp;return this.pos+=8,t},readFloat:function(){var t=lp(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=lp(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return yp(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return yp(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return yp(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return yp(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return yp(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return yp(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&fp?function(t,e,r){return fp.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==cp.Bytes)return t.push(this.readVarint(e));var r=dp(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==cp.Bytes)return t.push(this.readSVarint());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==cp.Bytes)return t.push(this.readBoolean());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==cp.Bytes)return t.push(this.readFloat());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==cp.Bytes)return t.push(this.readDouble());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==cp.Bytes)return t.push(this.readFixed32());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==cp.Bytes)return t.push(this.readSFixed32());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==cp.Bytes)return t.push(this.readFixed64());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==cp.Bytes)return t.push(this.readSFixed64());var e=dp(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===cp.Varint)for(;this.buf[this.pos++]>127;);else if(e===cp.Bytes)this.pos=this.readVarint()+this.pos;else if(e===cp.Fixed32)this.pos+=4;else {if(e!==cp.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),Mp(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),Mp(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),Mp(this.buf,-1&t,this.pos),Mp(this.buf,Math.floor(t*pp),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),Mp(this.buf,-1&t,this.pos),Mp(this.buf,Math.floor(t*pp),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&mp(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),up(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),up(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&mp(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,cp.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,gp,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,xp,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,wp,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,vp,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,bp,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,_p,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,Ap,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,Sp,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,kp,e);},writeBytesField:function(t,e){this.writeTag(t,cp.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,cp.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,cp.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,cp.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,cp.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,cp.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,cp.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,cp.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,cp.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,cp.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};class Pp{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Dp{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=Cp(i),o=new Qu({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Qu.copy(n.data,o,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+1,a=i.y+1,l=r.data.width,u=r.data.height;Qu.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Qu.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Qu.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Qu.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Qu.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),e[n]=new Pp(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((e=>t.hasImage(e))),t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}Oi(Pp,"ImagePosition"),Oi(Dp,"ImageAtlas");const Vp={horizontal:1,vertical:2,horizontalOnly:3};class Lp{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new Lp;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new Lp;return e.imageName=t,e}}class Fp{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new Fp;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSections(){return this.sections}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(t){this.text=function(t,e){let r="";for(let n=0;n<t.length;n++){const i=t.charCodeAt(n+1)||null,s=t.charCodeAt(n-1)||null;r+=!e&&(i&&Ss(i)&&!ip[t[n+1]]||s&&Ss(s)&&!ip[t[n-1]])||!ip[t[n]]?t[n]:ip[t[n]];}return r}(this.text,t);}trim(){let t=0;for(let e=0;e<this.text.length&&jp[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&jp[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Fp;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(Lp.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void U("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Lp.forImage(e)),this.sectionIndex.push(this.sections.length-1)):U("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Rp(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d){const y=Fp.fromFeature(t,i);h===Vp.vertical&&y.verticalizePunctuation(p);let m=[];const g=function(t,e,r,n,i,s){if(!t)return [];const a=[],o=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=Up(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCharCode(r);if(jp[p]||(u+=Up(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904||!(ns(c)||rs(c)||ms(c)||fs(c)||os(c)||Hi(c)||is(c)||Qi(c)||ls(c)||us(c)||as(c)||vs(c)||ts(c)||Ji(c)||Wi(c)||ss(c)||es(c)||ys(c)||hs(c)||cs(c)));($p[p]||e||h.imageName)&&a.push(Np(r+1,u,o,a,qp(p,t.getCharCode(r+1),e&&l),!1));}}var c;return Gp(Np(t.length(),u,o,a,0,!0))}(y,u,s,e,n,f),{processBidirectionalText:x,processStyledBidirectionalText:v}=js;if(x&&1===y.sections.length){const t=x(y.toString(),g);for(const e of t){const t=new Fp;t.text=e,t.sections=y.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);m.push(t);}}else if(v){const t=v(y.text,y.sectionIndex,g);for(const e of t){const t=new Fp;t.text=e[0],t.sectionIndex=e[1],t.sections=y.sections,m.push(t);}}else m=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(y,g);const b=[],w={positionedLines:b,text:y.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1,hasBaseline:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,f=0,d=0;const y="right"===o?1:"left"===o?0:.5;let m=!1;for(const t of i){const r=t.getSections();for(const t of r){if(t.imageName)continue;const r=e[t.fontStack];if(r&&(m=void 0!==r.ascender&&void 0!==r.descender,!m))break}if(!m)break}let g=0;for(const a of i){a.trim();const i=a.getMaxScale(),o=(i-1)*Wh,v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let w=0;if(!a.length()){f+=s,++g;continue}let _=0,A=0;for(let s=0;s<a.length();s++){const o=a.getSection(s),d=a.getSectionIndex(s),y=a.getCharCode(s);let g=o.scale,v=null,S=null,k=null,I=Wh,M=0;const T=!(l===Vp.horizontal||!c&&!As(y)||c&&(jp[y]||(x=y,Xi(x)||Ki(x)||Yi(x)||ds(x)||xs(x))));if(o.imageName){const e=n[o.imageName];if(!e)continue;k=o.imageName,t.iconsInText=t.iconsInText||!0,S=e.paddedRect;const r=e.displaySize;g=g*Wh/h,v={width:r[0],height:r[1],left:1,top:-3,advance:T?r[1]:r[0],localGlyph:!1},M=m?-v.height*g:i*Wh-17-r[1]*g,I=v.advance;const s=(T?r[0]:r[1])*g-Wh*i;s>0&&s>w&&(w=s);}else {const t=r[o.fontStack];if(!t)continue;t[y]&&(S=t[y]);const n=e[o.fontStack];if(!n)continue;const s=n.glyphs[y];if(!s)continue;if(v=s.metrics,I=8203!==y?Wh:0,m){const t=void 0!==n.ascender?Math.abs(n.ascender):0,e=void 0!==n.descender?Math.abs(n.descender):0,r=(t+e)*g;_<r&&(_=r,A=(t-e)/2*g),M=-t*g;}else M=(i-g)*Wh-17;}T?(t.verticalizable=!0,b.push({glyph:y,imageName:k,x:p,y:f+M,vertical:T,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:S}),p+=I*g+u):(b.push({glyph:y,imageName:k,x:p,y:f+M,vertical:T,scale:g,localGlyph:v.localGlyph,fontStack:o.fontStack,sectionIndex:d,metrics:v,rect:S}),p+=v.advance*g+u);}0!==b.length&&(d=Math.max(p-u,d),m?Xp(b,y,w,A,s*i/2):Xp(b,y,w,0,s/2)),p=0;const S=s*i+w;v.lineOffset=Math.max(w,o),f+=S,++g;}var x;const v=f,{horizontalAlign:b,verticalAlign:w}=Zp(a);((function(t,e,r,n,i,s){const a=(e-r)*i,o=-s*n;for(const e of t)for(const t of e.positionedGlyphs)t.x+=a,t.y+=o;}))(t.positionedLines,y,b,w,d,v),t.top+=-w*v,t.bottom=t.top+v,t.left+=-b*d,t.right=t.left+d,t.hasBaseline=m;}(w,e,r,n,m,a,o,l,h,u,p,d),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const jp={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},$p={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Up(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*Wh/s+i:0}{const n=r[e.fontStack],s=n&&n.glyphs[t];return s?s.metrics.advance*e.scale+i:0}}function Op(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function qp(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function Np(t,e,r,n,i,s){let a=null,o=Op(e,r,i,s);for(const t of n){const n=Op(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function Gp(t){return t?Gp(t.priorBreak).concat(t.index):[]}function Zp(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function Xp(t,e,r,n,i){if(!(e||r||n||i))return;const s=t.length-1,a=t[s],o=(a.x+a.metrics.advance*a.scale)*e;for(let e=0;e<=s;e++)t[e].x-=o,t[e].y+=r+n+i;}function Kp(t,e,r){const{horizontalAlign:n,verticalAlign:i}=Zp(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function Yp(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:f,collisionPadding:o}}class Hp extends d{constructor(t,e,r,n,i){super(t,e),this.angle=n,this.z=r,void 0!==i&&(this.segment=i);}clone(){return new Hp(this.x,this.y,this.z,this.angle,this.segment)}}function Wp(t,e,r,n,i){if(void 0===e.segment)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function Jp(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Qp(t,e,r){return t?.6*e*r:0}function tf(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function ef(t,e,r,n,i,s){const a=Qp(r,i,s),o=tf(r,n)*s;let l=0;const u=Jp(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=Mr(n.x,i.x,c),p=Mr(n.y,i.y,c),f=new Hp(h,p,0,i.angleTo(n),r);return !a||Wp(t,f,o,a,e)?f:void 0}l+=s;}}function rf(t,e,r,n,i,s,a,o,l){const u=Qp(n,s,a),c=tf(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),nf(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function nf(t,e,r,n,i,s,a,o,l){const u=s/2,c=Jp(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),y=o.angleTo(a);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=Mr(a.x,o.x,m),x=Mr(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Hp(g,x,0,y,e);r._round(),n&&!Wp(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=nf(t,h/2,r,n,i,s,a,!0,l)),f}function sf(t,e,r,n,i){const s=[];for(let a=0;a<t.length;a++){const o=t[a];let l;for(let t=0;t<o.length-1;t++){let a=o[t],u=o[t+1];a.x<e&&u.x<e||(a.x<e?a=new d(e,a.y+(e-a.x)/(u.x-a.x)*(u.y-a.y))._round():u.x<e&&(u=new d(e,a.y+(e-a.x)/(u.x-a.x)*(u.y-a.y))._round()),a.y<r&&u.y<r||(a.y<r?a=new d(a.x+(r-a.y)/(u.y-a.y)*(u.x-a.x),r)._round():u.y<r&&(u=new d(a.x+(r-a.y)/(u.y-a.y)*(u.x-a.x),r)._round()),a.x>=n&&u.x>=n||(a.x>=n?a=new d(n,a.y+(n-a.x)/(u.x-a.x)*(u.y-a.y))._round():u.x>=n&&(u=new d(n,a.y+(n-a.x)/(u.x-a.x)*(u.y-a.y))._round()),a.y>=i&&u.y>=i||(a.y>=i?a=new d(a.x+(i-a.y)/(u.y-a.y)*(u.x-a.x),i)._round():u.y>=i&&(u=new d(a.x+(i-a.y)/(u.y-a.y)*(u.x-a.x),i)._round()),l&&a.equals(l[l.length-1])||(l=[a],s.push(l)),l.push(u)))));}}return s}Oi(Hp,"Anchor");const af=1e20;function of(t,e,r,n,i,s,a,o,l){for(let u=e;u<e+n;u++)lf(t,r*s+u,s,i,a,o,l);for(let u=r;u<r+i;u++)lf(t,u*s+e,1,n,a,o,l);}function lf(t,e,r,n,i,s,a){s[0]=0,a[0]=-af,a[1]=af,i[0]=t[e];for(let o=1,l=0,u=0;o<n;o++){i[o]=t[e+o*r];const n=o*o;do{const t=s[l];u=(i[o]-i[t]+n-t*t)/(o-t)/2;}while(u<=a[l]&&--l>-1);l++,s[l]=o,a[l]=u,a[l+1]=af;}for(let o=0,l=0;o<n;o++){for(;a[l+1]<o;)l++;const n=s[l],u=o-n;t[e+o*r]=i[n]+u*u;}}const uf={none:0,ideographs:1,all:2};class cf{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t){this.url=t;}getGlyphs(t,e){const r=[];for(const e in t)for(const n of t[e])r.push({stack:e,id:n});M(r,(({stack:t,id:e},r)=>{let n=this.entries[t];n||(n=this.entries[t]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let i=n.glyphs[e];if(void 0!==i)return void r(null,{stack:t,id:e,glyph:i});if(i=this._tinySDF(n,t,e),i)return n.glyphs[e]=i,void r(null,{stack:t,id:e,glyph:i});const s=Math.floor(e/256);if(256*s>65535)return void r(new Error("glyphs > 65535 not supported"));if(n.ranges[s])return void r(null,{stack:t,id:e,glyph:i});let a=n.requests[s];a||(a=n.requests[s]=[],cf.loadGlyphRange(t,s,this.url,this.requestManager,((t,e)=>{if(e){n.ascender=e.ascender,n.descender=e.descender;for(const t in e.glyphs)this._doesCharSupportLocalGlyph(+t)||(n.glyphs[+t]=e.glyphs[+t]);n.ranges[s]=!0;}for(const r of a)r(t,e);delete n.requests[s];}))),a.push(((n,i)=>{n?r(n):i&&r(null,{stack:t,id:e,glyph:i.glyphs[e]||null});}));}),((t,r)=>{if(t)e(t);else if(r){const t={};for(const{stack:e,id:n,glyph:i}of r)void 0===t[e]&&(t[e]={}),void 0===t[e].glyphs&&(t[e].glyphs={}),t[e].glyphs[n]=i&&{id:i.id,bitmap:i.bitmap.clone(),metrics:i.metrics},t[e].ascender=this.entries[e].ascender,t[e].descender=this.entries[e].descender;e(null,t);}}));}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==uf.none&&(this.localGlyphMode===uf.all?!!this.localFontFamily:!!this.localFontFamily&&(us(t)||ps(t)||ts(t)||es(t)||Qi(t)))}_tinySDF(t,e,r){const n=this.localFontFamily;if(!n||!this._doesCharSupportLocalGlyph(r))return;let i=t.tinySDF;if(!i){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),i=t.tinySDF=new cf.TinySDF({fontFamily:n,fontWeight:r,fontSize:48,buffer:6,radius:16}),i.fontWeight=r;}if(this.localGlyphs[i.fontWeight][r])return this.localGlyphs[i.fontWeight][r];const s=String.fromCharCode(r),{data:a,width:o,height:l,glyphWidth:u,glyphHeight:c,glyphLeft:h,glyphTop:p,glyphAdvance:f}=i.draw(s);return this.localGlyphs[i.fontWeight][r]={id:r,bitmap:new Ju({width:o,height:l},a),metrics:{width:u/2,height:c/2,left:h/2,top:p/2-27,advance:f/2,localGlyph:!0}}}}function hf(t,e,r,n){const i=[],s=t.image,a=s.pixelRatio,o=s.paddedRect.w-2,l=s.paddedRect.h-2,u=t.right-t.left,c=t.bottom-t.top,h=s.stretchX||[[0,o]],p=s.stretchY||[[0,l]],f=(t,e)=>t+e[1]-e[0],y=h.reduce(f,0),m=p.reduce(f,0),g=o-y,x=l-m;let v=0,b=y,w=0,_=m,A=0,S=g,k=0,I=x;if(s.content&&n){const t=s.content;v=pf(h,0,t[0]),w=pf(p,0,t[1]),b=pf(h,t[0],t[2]),_=pf(p,t[1],t[3]),A=t[0]-v,k=t[1]-w,S=t[2]-t[0]-b,I=t[3]-t[1]-_;}const M=(n,i,o,l)=>{const h=df(n.stretch-v,b,u,t.left),p=yf(n.fixed-A,S,n.stretch,y),f=df(i.stretch-w,_,c,t.top),g=yf(i.fixed-k,I,i.stretch,m),x=df(o.stretch-v,b,u,t.left),M=yf(o.fixed-A,S,o.stretch,y),T=df(l.stretch-w,_,c,t.top),z=yf(l.fixed-k,I,l.stretch,m),B=new d(h,f),E=new d(x,f),C=new d(x,T),P=new d(h,T),D=new d(p/a,g/a),V=new d(M/a,z/a),L=e*Math.PI/180;if(L){const t=Math.sin(L),e=Math.cos(L),r=[e,-t,t,e];B._matMult(r),E._matMult(r),P._matMult(r),C._matMult(r);}const F=n.stretch+n.fixed,R=i.stretch+i.fixed;return {tl:B,tr:E,bl:P,br:C,tex:{x:s.paddedRect.x+1+F,y:s.paddedRect.y+1+R,w:o.stretch+o.fixed-F,h:l.stretch+l.fixed-R},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:D,pixelOffsetBR:V,minFontScaleX:S/a/u,minFontScaleY:I/a/c,isSDF:r}};if(n&&(s.stretchX||s.stretchY)){const t=ff(h,g,y),e=ff(p,x,m);for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1];for(let t=0;t<e.length-1;t++)i.push(M(n,e[t],s,e[t+1]));}}else i.push(M({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:o+1},{fixed:0,stretch:l+1}));return i}function pf(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function ff(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+1,stretch:r}),n}function df(t,e,r,n){return t/e*r+n}function yf(t,e,r,n){return t-e*r/n}function mf(t,e,r,n){const i=e+t.positionedLines[n].lineOffset;return 0===n?r+i/2:r+(i+(e+t.positionedLines[n-1].lineOffset))/2}cf.loadGlyphRange=function(t,e,r,n,i){const s=256*e,a=s+255,o=n.transformRequest(n.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${a}`),st.Glyphs);ut(o,((t,e)=>{if(t)i(t);else if(e){const t={},r=function(t){return new op(t).readFields(zp,{})}(e);for(const e of r.glyphs)t[e.id]=e;i(null,{glyphs:t,ascender:r.ascender,descender:r.descender});}}));},cf.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:r=8,cutoff:n=.25,fontFamily:i="sans-serif",fontWeight:s="normal",fontStyle:a="normal"}={}){this.buffer=e,this.cutoff=n,this.radius=r;const o=this.size=t+4*e,l=this._createCanvas(o),u=this.ctx=l.getContext("2d",{willReadFrequently:!0});u.font=`${a} ${s} ${t}px ${i}`,u.textBaseline="alphabetic",u.textAlign="left",u.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:r,actualBoundingBoxDescent:n,actualBoundingBoxLeft:i,actualBoundingBoxRight:s}=this.ctx.measureText(t),a=Math.ceil(r),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-i))),l=Math.min(this.size-this.buffer,a+Math.ceil(n)),u=o+2*this.buffer,c=l+2*this.buffer,h=Math.max(u*c,0),p=new Uint8ClampedArray(h),f={data:p,width:u,height:c,glyphWidth:o,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return f;const{ctx:d,buffer:y,gridInner:m,gridOuter:g}=this;d.clearRect(y,y,o,l),d.fillText(t,y,y+a);const x=d.getImageData(y,y,o,l);g.fill(af,0,h),m.fill(0,0,h);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const r=x.data[4*(t*o+e)+3]/255;if(0===r)continue;const n=(t+y)*u+e+y;if(1===r)g[n]=0,m[n]=af;else {const t=.5-r;g[n]=t>0?t*t:0,m[n]=t<0?t*t:0;}}of(g,0,0,u,c,u,this.f,this.v,this.z),of(m,y,y,o,l,u,this.f,this.v,this.z);for(let t=0;t<h;t++){const e=Math.sqrt(g[t])-Math.sqrt(m[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return f}};class gf{constructor(t=[],e=xf){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this.length++,this._up(this.length-1);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1),s=e[n];const a=n+1;if(a<this.length&&r(e[a],s)<0&&(n=a,s=e[a]),r(s,i)>=0)break;e[t]=s,t=n;}e[t]=i;}}function xf(t,e){return t<e?-1:t>e?1:0}function vf(t,e=1,r=!1){let n=1/0,i=1/0,s=-1/0,a=-1/0;const o=t[0];for(let t=0;t<o.length;t++){const e=o[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>s)&&(s=e.x),(!t||e.y>a)&&(a=e.y);}const l=Math.min(s-n,a-i);let u=l/2;const c=new gf([],bf);if(0===l)return new d(n,i);for(let e=n;e<s;e+=l)for(let r=i;r<a;r+=l)c.push(new wf(e+u,r+u,u,t));let h=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new wf(r/e,n/e,0,t)}(t),p=c.length;for(;c.length;){const n=c.pop();(n.d>h.d||!h.d)&&(h=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,p)),n.max-h.d<=e||(u=n.h/2,c.push(new wf(n.p.x-u,n.p.y-u,u,t)),c.push(new wf(n.p.x+u,n.p.y-u,u,t)),c.push(new wf(n.p.x-u,n.p.y+u,u,t)),c.push(new wf(n.p.x+u,n.p.y+u,u,t)),p+=4);}return r&&(console.log(`num probes: ${p}`),console.log(`best distance: ${h.d}`)),h.p}function bf(t,e){return e.max-t.max}class wf{constructor(t,e,r,n){this.p=new d(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,Cu(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}}const _f=Number.POSITIVE_INFINITY,Af=Math.sqrt(2);function Sf(t,[e,r]){let n=0,i=0;if(r===_f){e<0&&(e=0);const r=e/Af;switch(t){case"top-right":case"top-left":i=r-7;break;case"bottom-right":case"bottom-left":i=7-r;break;case"bottom":i=7-e;break;case"top":i=e-7;}switch(t){case"top-right":case"bottom-right":n=-r;break;case"top-left":case"bottom-left":n=r;break;case"left":n=e;break;case"right":n=-e;}}else {switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-7;break;case"bottom-right":case"bottom-left":case"bottom":i=7-r;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}}return [n,i]}function kf(t,e,r,n,i,s,a,o,l,u){t.createArrays(),t.tilePixelRatio=ko/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const c=t.layers[0].layout,h=t.layers[0]._unevaluatedLayout._values,p={};if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;p.compositeTextSizes=[h["text-size"].possiblyEvaluate(new $s(e),o),h["text-size"].possiblyEvaluate(new $s(r),o)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;p.compositeIconSizes=[h["icon-size"].possiblyEvaluate(new $s(e),o),h["icon-size"].possiblyEvaluate(new $s(r),o)];}p.layoutTextSize=h["text-size"].possiblyEvaluate(new $s(l+1),o),p.layoutIconSize=h["icon-size"].possiblyEvaluate(new $s(l+1),o),p.textMaxSize=h["text-size"].possiblyEvaluate(new $s(18),o);const f="map"===c.get("text-rotation-alignment")&&"point"!==c.get("symbol-placement"),d=c.get("text-size");for(const s of t.features){const l=c.get("text-font").evaluate(s,{},o).join(","),h=d.evaluate(s,{},o),y=p.layoutTextSize.evaluate(s,{},o),m=(p.layoutIconSize.evaluate(s,{},o),{horizontal:{},vertical:void 0}),g=s.text;let x,v=[0,0];if(g){const n=g.toString(),a=c.get("text-letter-spacing").evaluate(s,{},o)*Wh,u=c.get("text-line-height").evaluate(s,{},o)*Wh,p=ws(n)?a:0,d=c.get("text-anchor").evaluate(s,{},o),x=c.get("text-variable-anchor");if(!x){const t=c.get("text-radial-offset").evaluate(s,{},o);v=t?Sf(d,[t*Wh,_f]):c.get("text-offset").evaluate(s,{},o).map((t=>t*Wh));}let b=f?"center":c.get("text-justify").evaluate(s,{},o);const w="point"===c.get("symbol-placement"),_=w?c.get("text-max-width").evaluate(s,{},o)*Wh:1/0,A=s=>{t.allowVerticalPlacement&&bs(n)&&(m.vertical=Rp(g,e,r,i,l,_,u,d,s,p,v,Vp.vertical,!0,y,h));};if(!f&&x){const t="auto"===b?x.map((t=>If(t))):[b];let n=!1;for(let s=0;s<t.length;s++){const a=t[s];if(!m.horizontal[a])if(n)m.horizontal[a]=m.horizontal[0];else {const t=Rp(g,e,r,i,l,_,u,"center",a,p,v,Vp.horizontal,!1,y,h);t&&(m.horizontal[a]=t,n=1===t.positionedLines.length);}}A("left");}else {if("auto"===b&&(b=If(d)),w||c.get("text-writing-mode").indexOf("horizontal")>=0||!bs(n)){const t=Rp(g,e,r,i,l,_,u,d,b,p,v,Vp.horizontal,!1,y,h);t&&(m.horizontal[b]=t);}A(w?"left":b);}}let b=!1;if(s.icon&&s.icon.name){const e=n[s.icon.name];e&&(x=Kp(i[s.icon.name],c.get("icon-offset").evaluate(s,{},o),c.get("icon-anchor").evaluate(s,{},o)),b=e.sdf,void 0===t.sdfIcons?t.sdfIcons=e.sdf:t.sdfIcons!==e.sdf&&U("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.pixelRatio||0!==c.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const w=Bf(m.horizontal)||m.vertical;t.iconsInText||(t.iconsInText=!!w&&w.iconsInText),(w||x)&&Mf(t,s,m,x,n,p,y,0,v,b,a,o,u);}s&&t.generateCollisionDebugBuffers(l,t.collisionBoxArray);}function If(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Mf(t,e,r,n,i,s,a,o,l,u,c,h,p){let f=s.textMaxSize.evaluate(e,{},h);void 0===f&&(f=a);const d=t.layers[0].layout,y=d.get("icon-offset").evaluate(e,{},h),m=Bf(r.horizontal)||r.vertical,g="globe"===p.name,v=a/24,b=t.tilePixelRatio*f/24,w=(z=t.overscaling,t.zoom>18&&z>2&&(z>>=1),Math.max(ko/(512*z),1)*d.get("symbol-spacing")),_=d.get("text-padding")*t.tilePixelRatio,A=d.get("icon-padding")*t.tilePixelRatio,S=x(d.get("text-max-angle")),k="map"===d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),I="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),M=d.get("symbol-placement"),T=w/2;var z;const B=d.get("icon-text-fit");let E;n&&"none"!==B&&(t.allowVerticalPlacement&&r.vertical&&(E=Yp(n,r.vertical,B,d.get("icon-text-fit-padding"),y,v)),m&&(n=Yp(n,m,B,d.get("icon-text-fit-padding"),y,v)));const C=(a,o,f)=>{if(o.x<0||o.x>=ko||o.y<0||o.y>=ko)return;let d=null;if(g){const{x:t,y:e,z:r}=p.projectTilePoint(o.x,o.y,f);d={anchor:new Hp(t,e,r,0,void 0),up:p.upVector(f,o.x,o.y)};}!function(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S){const k=t.addToLineVertexArray(e,n);let I,M,T,z,B,E,C,P=0,D=0,V=0,L=0,F=-1,R=-1;const j={};let $=qa("");const O=r?r.anchor:e;let q=0,N=0;if(void 0===l._unevaluatedLayout.getValue("text-radial-offset")?[q,N]=l.layout.get("text-offset").evaluate(b,{},S).map((t=>t*Wh)):(q=l.layout.get("text-radial-offset").evaluate(b,{},S)*Wh,N=_f),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(d)E=Cf(t),o&&(C=Cf(o));else {const r=l.layout.get("text-rotate").evaluate(b,{},S)+90;T=Ef(u,O,e,c,h,p,t,f,r,y),o&&(z=Ef(u,O,e,c,h,p,o,g,r));}}if(s){const n=l.layout.get("icon-rotate").evaluate(b,{},S),i="none"!==l.layout.get("icon-text-fit"),a=hf(s,n,_,i),f=o?hf(o,n,_,i):void 0;M=Ef(u,O,e,c,h,p,s,g,n),P=4*a.length;const d=t.iconSizeData;let y=null;"source"===d.kind?(y=[Jh*l.layout.get("icon-size").evaluate(b,{},S)],y[0]>Tf&&U(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[Jh*w.compositeIconSizes[0].evaluate(b,{},S),Jh*w.compositeIconSizes[1].evaluate(b,{},S)],(y[0]>Tf||y[1]>Tf)&&U(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,a,y,v,x,b,!1,r,e,k.lineStartIndex,k.lineLength,-1,A,S),F=t.icon.placedSymbolArray.length-1,f&&(D=4*f.length,t.addSymbols(t.icon,f,y,v,x,b,Vp.vertical,r,e,k.lineStartIndex,k.lineLength,-1,A,S),R=t.icon.placedSymbolArray.length-1);}for(const n in i.horizontal){const s=i.horizontal[n];I||($=qa(s.text),d?B=Cf(s):I=Ef(u,O,e,c,h,p,s,f,l.layout.get("text-rotate").evaluate(b,{},S),y));const o=1===s.positionedLines.length;if(V+=zf(t,r,e,s,a,l,d,b,y,k,i.vertical?Vp.horizontal:Vp.horizontalOnly,o?Object.keys(i.horizontal):[n],j,F,w,A,S),o)break}i.vertical&&(L+=zf(t,r,e,i.vertical,a,l,d,b,y,k,Vp.vertical,["vertical"],j,R,w,A,S));let G=-1;const Z=(t,e)=>t?Math.max(t,e):e;G=Z(B,G),G=Z(E,G),G=Z(C,G);const X=G>-1?1:0;t.glyphOffsetArray.length>=hd.MAX_GLYPHS&&U("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(O.x,O.y,O.z,e.x,e.y,j.right>=0?j.right:-1,j.center>=0?j.center:-1,j.left>=0?j.left:-1,j.vertical>=0?j.vertical:-1,F,R,$,void 0!==I?I:t.collisionBoxArray.length,void 0!==I?I+1:t.collisionBoxArray.length,void 0!==T?T:t.collisionBoxArray.length,void 0!==T?T+1:t.collisionBoxArray.length,void 0!==M?M:t.collisionBoxArray.length,void 0!==M?M+1:t.collisionBoxArray.length,z||t.collisionBoxArray.length,z?z+1:t.collisionBoxArray.length,c,V,L,P,D,X,0,q,N,G);}(t,o,d,a,r,n,i,E,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,_,k,l,0,A,I,y,e,s,u,c,h);};if("line"===M)for(const i of sf(e.geometry,0,0,ko,ko)){const e=rf(i,w,S,r.vertical||m,n,24,b,t.overscaling,ko);for(const r of e){const e=m;e&&Pf(t,e.text,T,r)||C(i,r,h);}}else if("line-center"===M){for(const t of e.geometry)if(t.length>1){const e=ef(t,S,r.vertical||m,n,24,b);e&&C(t,e,h);}}else if("Polygon"===e.type)for(const t of Lc(e.geometry,0)){const e=vf(t,16);C(t[0],new Hp(e.x,e.y,0,0,void 0),h);}else if("LineString"===e.type)for(const t of e.geometry)C(t,new Hp(t[0].x,t[0].y,0,0,void 0),h);else if("Point"===e.type)for(const t of e.geometry)for(const e of t)C([e],new Hp(e.x,e.y,0,0,void 0),h);}const Tf=32640;function zf(t,e,r,n,i,s,a,o,l,u,c,h,p,f,y,m,g){const x=function(t,e,r,n,i,s,a,o){const l=[];if(0===e.positionedLines.length)return l;const u=n.layout.get("text-rotate").evaluate(s,{})*Math.PI/180,c=function(t){const e=t[0],r=t[1],n=e*r;return n>0?[e,-r]:n<0?[-e,r]:0===e?[r,e]:[r,-e]}(r);let h=Math.abs(e.top-e.bottom);for(const t of e.positionedLines)h-=t.lineOffset;const p=e.positionedLines.length,f=h/p;let y=e.top-r[1];for(let t=0;t<p;++t){const n=e.positionedLines[t];y=mf(e,f,y,t);for(const t of n.positionedGlyphs){if(!t.rect)continue;const n=t.rect||{};let s=4,h=!0,p=1,f=0;if(t.imageName){const e=a[t.imageName];if(!e)continue;if(e.sdf){U("SDF images are not supported in formatted text and will be ignored.");continue}h=!1,p=e.pixelRatio,s=1/p;}const m=(i||o)&&t.vertical,g=t.metrics.advance*t.scale/2,x=t.metrics,v=t.rect;if(null===v)continue;o&&e.verticalizable&&(f=t.imageName?g-t.metrics.width*t.scale/2:0);const b=i?[t.x+g,t.y]:[0,0];let w=[0,0],_=[0,0],A=!1;i||(m?(_=[t.x+g+c[0],t.y+c[1]-f],A=!0):w=[t.x+g+r[0],t.y+r[1]-f]);const S=v.w*t.scale/(p*(t.localGlyph?2:1)),k=v.h*t.scale/(p*(t.localGlyph?2:1));let I,M,T,z;if(m){const e=t.y-y,r=new d(-g,g-e),n=-Math.PI/2,i=new d(..._);I=new d(-g+w[0],w[1]),I._rotateAround(n,r)._add(i),I.x+=-e+g,I.y-=(x.left-s)*t.scale;const a=t.imageName?x.advance*t.scale:Wh*t.scale,o=String.fromCharCode(t.glyph);sp(o)?I.x+=(1-s)*t.scale:ap(o)?I.x+=a-x.height*t.scale+(-s-1)*t.scale:I.x+=t.imageName||x.width+2*s===v.w&&x.height+2*s===v.h?(a-k)/2:(a-(x.height+2*s)*t.scale)/2,M=new d(I.x,I.y-S),T=new d(I.x+k,I.y),z=new d(I.x+k,I.y-S);}else {const e=(x.left-s)*t.scale-g+w[0],r=(-x.top-s)*t.scale+w[1],n=e+S,i=r+k;I=new d(e,r),M=new d(n,r),T=new d(e,i),z=new d(n,i);}if(u){let t;t=i?new d(0,0):A?new d(c[0],c[1]):new d(r[0],r[1]),I._rotateAround(u,t),M._rotateAround(u,t),T._rotateAround(u,t),z._rotateAround(u,t);}const B=new d(0,0),E=new d(0,0);l.push({tl:I,tr:M,bl:T,br:z,tex:n,writingMode:e.writingMode,glyphOffset:b,sectionIndex:t.sectionIndex,isSDF:h,pixelOffsetTL:B,pixelOffsetBR:E,minFontScaleX:0,minFontScaleY:0});}}return l}(0,n,l,s,a,o,i,t.allowVerticalPlacement),v=t.textSizeData;let b=null;"source"===v.kind?(b=[Jh*s.layout.get("text-size").evaluate(o,{},g)],b[0]>Tf&&U(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===v.kind&&(b=[Jh*y.compositeTextSizes[0].evaluate(o,{},g),Jh*y.compositeTextSizes[1].evaluate(o,{},g)],(b[0]>Tf||b[1]>Tf)&&U(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,x,b,l,a,o,c,e,r,u.lineStartIndex,u.lineLength,f,m,g);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*x.length}function Bf(t){for(const e in t)return t[e];return null}function Ef(t,e,r,n,i,s,a,o,l,u){let c=a.top,h=a.bottom,p=a.left,f=a.right;const y=a.collisionPadding;if(y&&(p-=y[0],c-=y[1],f+=y[2],h+=y[3]),l){const t=new d(p,c),e=new d(f,c),r=new d(p,h),n=new d(f,h),i=x(l);let s=new d(0,0);u&&(s=new d(u[0],u[1])),t._rotateAround(i,s),e._rotateAround(i,s),r._rotateAround(i,s),n._rotateAround(i,s),p=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),c=Math.min(t.y,e.y,r.y,n.y),h=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,e.z,r.x,r.y,p,c,f,h,o,n,i,s),t.length-1}function Cf(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function Pf(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}function Df(t,e){const r=t.fovAboveCenter,n=t.elevation?t.elevation.getMinElevationBelowMSL()*e:0,i=(t._camera.position[2]*t.worldSize-n)/Math.cos(t._pitch),s=Math.sin(r)*i/Math.sin(Math.max(Math.PI/2-t._pitch-r,.01)),a=Math.sin(t._pitch)*s+i;return Math.min(1.01*a,i*(1/t._horizonShift))}function Vf(t,e){if(!e.isReprojectedInTileSpace)return {scale:1<<t.z,x:t.x,y:t.y,x2:t.x+1,y2:t.y+1,projection:e};const r=Math.pow(2,-t.z),n=t.x*r,i=(t.x+1)*r,s=t.y*r,a=(t.y+1)*r,o=ou(n),l=ou(i),u=lu(s),c=lu(a),h=e.project(o,u),p=e.project(l,u),f=e.project(l,c),d=e.project(o,c);let y=Math.min(h.x,p.x,f.x,d.x),m=Math.min(h.y,p.y,f.y,d.y),g=Math.max(h.x,p.x,f.x,d.x),x=Math.max(h.y,p.y,f.y,d.y);const v=r/16;function b(t,r,n,i,s,a){const o=(n+s)/2,l=(i+a)/2,u=e.project(ou(o),lu(l)),c=Math.max(0,y-u.x,m-u.y,u.x-g,u.y-x);y=Math.min(y,u.x),g=Math.max(g,u.x),m=Math.min(m,u.y),x=Math.max(x,u.y),c>v&&(b(t,u,n,i,o,l),b(u,r,o,l,s,a));}b(h,p,n,s,i,s),b(p,f,i,s,i,a),b(f,d,i,a,n,a),b(d,h,n,a,n,s),y-=v,m-=v,g+=v,x+=v;const w=1/Math.max(g-y,x-m);return {scale:w,x:y*w,y:m*w,x2:g*w,y2:x*w,projection:e}}const Lf=Eo(new Float32Array(16));class Ff{constructor(t){this.spec=t,this.name=t.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7];}project(t,e){return {x:0,y:0,z:0}}unproject(t,e){return new ru(0,0)}projectTilePoint(t,e,r){return {x:t,y:e,z:0}}locationPoint(t,e,r=!0){return t._coordinatePoint(t.locationCoordinate(e),r)}pixelsPerMeter(t,e){return au(1,t)*e}pixelSpaceConversion(t,e,r){return 1}farthestPixelDistance(t){return Df(t,t.pixelsPerMeter)}pointCoordinate(t,e,r,n){const i=t.horizonLineFromTop(!1),s=new d(e,Math.max(i,r));return t.rayIntersectionCoordinate(t.pointRayIntersection(s,n))}pointCoordinate3D(t,e,r){const n=new d(e,r);if(t.elevation)return t.elevation.pointCoordinate(n);{const e=this.pointCoordinate(t,n.x,n.y,0);return [e.x,e.y,e.z]}}isPointAboveHorizon(t,e){if(t.elevation)return !this.pointCoordinate3D(t,e.x,e.y);const r=t.horizonLineFromTop();return e.y<r}createInversionMatrix(t,e){return Lf}createTileMatrix(t,e,r){let n,i,s;const a=r.canonical,o=Eo(new Float64Array(16));if(this.isReprojectedInTileSpace){const l=Vf(a,this);n=1,i=l.x+r.wrap*l.scale,s=l.y,Vo(o,o,[n/l.scale,n/l.scale,t.pixelsPerMeter/e]);}else n=e/t.zoomScale(a.z),i=(a.x+Math.pow(2,a.z)*r.wrap)*n,s=a.y*n;return Do(o,o,[i,s,0]),Vo(o,o,[n/ko,n/ko,1]),o}upVector(t,e,r){return [0,0,1]}upVectorScale(t,e,r){return {metersToTile:1}}}class Rf extends Ff{constructor(t){super(t),this.range=[4,7],this.center=t.center||[-96,37.5];const[e,r]=this.parallels=t.parallels||[29.5,45.5],n=Math.sin(x(e));this.n=(n+Math.sin(x(r)))/2,this.c=1+n*(2*this.n-n),this.r0=Math.sqrt(this.c)/this.n;}project(t,e){const{n:r,c:n,r0:i}=this,s=x(t-this.center[0]),a=x(e),o=Math.sqrt(n-2*r*Math.sin(a))/r;return {x:o*Math.sin(s*r),y:o*Math.cos(s*r)-i,z:0}}unproject(t,e){const{n:r,c:n,r0:i}=this,s=i+e;let a=Math.atan2(t,Math.abs(s))*Math.sign(s);s*r<0&&(a-=Math.PI*Math.sign(t)*Math.sign(s));const o=x(this.center[0])*r;a=I(a,-Math.PI-o,Math.PI-o);const l=S(v(a/r)+this.center[0],-180,180),u=Math.asin(S((n-(t*t+s*s)*r*r)/(2*r),-1,1)),c=S(v(u),-cu,cu);return new ru(l,c)}}const jf=1.340264,$f=-.081106,Uf=893e-6,Of=.003796,qf=Math.sqrt(3)/2;class Nf extends Ff{project(t,e){e=e/180*Math.PI,t=t/180*Math.PI;const r=Math.asin(qf*Math.sin(e)),n=r*r,i=n*n*n;return {x:.5*(t*Math.cos(r)/(qf*(jf+3*$f*n+i*(7*Uf+9*Of*n)))/Math.PI+.5),y:1-.5*(r*(jf+$f*n+i*(Uf+Of*n))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=r*r,i=n*n*n;for(let t,s,a,o=0;o<12&&(s=r*(jf+$f*n+i*(Uf+Of*n))-e,a=jf+3*$f*n+i*(7*Uf+9*Of*n),t=s/a,r=S(r-t,-Math.PI/3,Math.PI/3),n=r*r,i=n*n*n,!(Math.abs(t)<1e-12));++o);const s=qf*t*(jf+3*$f*n+i*(7*Uf+9*Of*n))/Math.cos(r),a=Math.asin(Math.sin(r)/qf),o=S(180*s/Math.PI,-180,180),l=S(180*a/Math.PI,-cu,cu);return new ru(o,l)}}class Gf extends Ff{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){return {x:.5+t/360,y:.5-e/360,z:0}}unproject(t,e){const r=360*(t-.5),n=S(360*(.5-e),-cu,cu);return new ru(r,n)}}const Zf=Math.PI/2;function Xf(t){return Math.tan((Zf+t)/2)}class Kf extends Ff{constructor(t){super(t),this.center=t.center||[0,30];const[e,r]=this.parallels=t.parallels||[30,30];let n=x(e),i=x(r);this.southernCenter=n+i<0,this.southernCenter&&(n=-n,i=-i);const s=Math.cos(n),a=Xf(n);this.n=n===i?Math.sin(n):Math.log(s/Math.cos(i))/Math.log(Xf(i)/a),this.f=s*Math.pow(Xf(n),this.n)/this.n;}project(t,e){e=x(e),this.southernCenter&&(e=-e),t=x(t-this.center[0]);const r=1e-6,{n:n,f:i}=this;i>0?e<-Zf+r&&(e=-Zf+r):e>Zf-r&&(e=Zf-r);const s=i/Math.pow(Xf(e),n);let a=s*Math.sin(n*t),o=i-s*Math.cos(n*t);return a=.5*(a/Math.PI+.5),o=.5*(o/Math.PI+.5),{x:a,y:this.southernCenter?o:1-o,z:0}}unproject(t,e){t=(2*t-.5)*Math.PI,this.southernCenter&&(e=1-e),e=(2*(1-e)-.5)*Math.PI;const{n:r,f:n}=this,i=n-e,s=Math.sign(i),a=Math.sign(r)*Math.sqrt(t*t+i*i);let o=Math.atan2(t,Math.abs(i))*s;i*r<0&&(o-=Math.PI*Math.sign(t)*s);const l=S(v(o/r)+this.center[0],-180,180),u=S(v(2*Math.atan(Math.pow(n/a,1/r))-Zf),-cu,cu);return new ru(l,this.southernCenter?-u:u)}}class Yf extends Ff{constructor(t){super(t),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null;}project(t,e){return {x:iu(t),y:su(e),z:0}}unproject(t,e){const r=ou(t),n=lu(e);return new ru(r,n)}}const Hf=x(cu);class Wf extends Ff{project(t,e){const r=(e=x(e))*e,n=r*r;return {x:.5*((t=x(t))*(.8707-.131979*r+n*(n*(.003971*r-.001529*n)-.013791))/Math.PI+.5),y:1-.5*(e*(1.007226+r*(.015085+n*(.028874*r-.044475-.005916*n)))/Math.PI+1),z:0}}unproject(t,e){t=(2*t-.5)*Math.PI;let r=e=(2*(1-e)-1)*Math.PI,n=25,i=0,s=r*r;do{s=r*r;const t=s*s;i=(r*(1.007226+s*(.015085+t*(.028874*s-.044475-.005916*t)))-e)/(1.007226+s*(.045255+t*(.259866*s-.311325-.005916*11*t))),r=S(r-i,-Hf,Hf);}while(Math.abs(i)>1e-6&&--n>0);s=r*r;const a=S(v(t/(.8707+s*(s*(s*s*s*(.003971-.001529*s)-.013791)-.131979))),-180,180),o=v(r);return new ru(a,o)}}const Jf=x(cu);class Qf extends Ff{project(t,e){e=x(e),t=x(t);const r=Math.cos(e),n=2/Math.PI,i=Math.acos(r*Math.cos(t/2)),s=Math.sin(i)/i,a=.5*(t*n+2*r*Math.sin(t/2)/s)||0,o=.5*(e+Math.sin(e)/s)||0;return {x:.5*(a/Math.PI+.5),y:1-.5*(o/Math.PI+1),z:0}}unproject(t,e){let r=t=(2*t-.5)*Math.PI,n=e=(2*(1-e)-1)*Math.PI,i=25;const s=1e-6;let a=0,o=0;do{const i=Math.cos(n),s=Math.sin(n),l=2*s*i,u=s*s,c=i*i,h=Math.cos(r/2),p=Math.sin(r/2),f=2*h*p,d=p*p,y=1-c*h*h,m=y?1/y:0,g=y?Math.acos(i*h)*Math.sqrt(1/y):0,x=.5*(2*g*i*p+2*r/Math.PI)-t,v=.5*(g*s+n)-e,b=.5*m*(c*d+g*i*h*u)+1/Math.PI,w=m*(f*l/4-g*s*p),_=.125*m*(l*p-g*s*c*f),A=.5*m*(u*h+g*d*i)+.5,k=w*_-A*b;a=(v*w-x*A)/k,o=(x*_-v*b)/k,r=S(r-a,-Math.PI,Math.PI),n=S(n-o,-Jf,Jf);}while((Math.abs(a)>s||Math.abs(o)>s)&&--i>0);return new ru(v(r),v(n))}}class td extends Ff{constructor(t){super(t),this.center=t.center||[0,0],this.parallels=t.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(x(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0;}project(t,e){const{scale:r,cosPhi:n}=this;return {x:x(t)*n*r+.5,y:-Math.sin(x(e))/n*r+.5,z:0}}unproject(t,e){const{scale:r,cosPhi:n}=this,i=-(e-.5)/r,s=S(v((t-.5)/r)/n,-180,180),a=Math.asin(S(i*n,-1,1)),o=S(v(a),-cu,cu);return new ru(s,o)}}class ed extends Yf{constructor(t){super(t),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5];}projectTilePoint(t,e,r){const n=Ol(t,e,r);return el(n,n,Gl(Pl(r))),{x:n[0],y:n[1],z:n[2]}}locationPoint(t,e){const r=Ul(e.lat,e.lng),n=Jo([],r),i=t.elevation?t.elevation.getAtPointOrZero(t.locationCoordinate(e),t._centerAltitude):t._centerAltitude;Wo(r,r,n,au(1,0)*ko*i);const s=Eo(new Float64Array(16));return Po(s,t.pixelMatrix,t.globeMatrix),el(r,r,s),new d(r[0],r[1])}pixelsPerMeter(t,e){return au(1,0)*e}pixelSpaceConversion(t,e,r){const n=au(1,t)*e,i=Mr(au(1,45)*e,n,r);return this.pixelsPerMeter(t,e)/i}createTileMatrix(t,e,r){const n=Zl(Pl(r.canonical));return Po(new Float64Array(16),t.globeMatrix,n)}createInversionMatrix(t,e){const{center:r}=t,n=Gl(Pl(e));return Fo(n,n,x(r.lng)),Lo(n,n,x(r.lat)),Vo(n,n,[t._pixelsPerMercatorPixel,t._pixelsPerMercatorPixel,1]),Float32Array.from(n)}pointCoordinate(t,e,r,n){return Bl(t,e,r,!0)||new pu(0,0)}pointCoordinate3D(t,e,r){const n=this.pointCoordinate(t,e,r,0);return [n.x,n.y,n.z]}isPointAboveHorizon(t,e){return !Bl(t,e.x,e.y,!1)}farthestPixelDistance(t){const e=function(t,e){const r=t.cameraToCenterDistance,n=t._centerAltitude*e,i=t._camera,s=t._camera.forward(),a=Go([],Ho([],s,-r),[0,0,n]),o=t.worldSize/(2*Math.PI),l=[0,0,-o],u=t.width/t.height,c=Math.tan(t.fovAboveCenter),h=Ho([],i.up(),c),p=Ho([],i.right(),c*u),f=Jo([],Go([],Go([],s,h),p)),d=[];let y;if(new vl(a,f).closestPointOnSphere(l,o,d)){const e=Go([],d,l),r=il([],e,a);y=Math.cos(t.fovAboveCenter)*qo(r);}else {const t=il([],a,l),e=il([],l,a);Jo(e,e);const r=qo(t)-o;y=Math.sqrt(r*(r+2*o));const n=Math.acos(y/(o+r))-Math.acos(Qo(s,e));y*=Math.cos(n);}return 1.01*y}(t,this.pixelsPerMeter(t.center.lat,t.worldSize)),r=Kl(t.zoom);if(r>0){const n=Df(t,au(1,t.center.lat)*t.worldSize),i=t.worldSize/(2*Math.PI),s=Math.max(t.width,t.height)/t.worldSize*Math.PI;return Mr(e,n+i*(1-Math.cos(s)),Math.pow(r,10))}return e}upVector(t,e,r){return Ol(e,r,t,1)}upVectorScale(t){return {metersToTile:zl(ql(Pl(t)))}}}function rd(t){const e=t.parallels,r=!!e&&Math.abs(e[0]+e[1])<.01;switch(t.name){case"mercator":return new Yf(t);case"equirectangular":return new Gf(t);case"naturalEarth":return new Wf(t);case"equalEarth":return new Nf(t);case"winkelTripel":return new Qf(t);case"albers":return r?new td(t):new Rf(t);case"lambertConformalConic":return r?new td(t):new Kf(t);case"globe":return new ed(t)}throw new Error(`Invalid projection name: ${t.name}`)}const nd=ah.types,id=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function sd(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(Tf,Math.round(o[0])):0,d=o?Math.min(Tf,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function ad(t,e,r,n,i,s,a){t.emplaceBack(e,r,n,i,s,a);}function od(t,e,r,n,i){t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i),t.emplaceBack(e,r,n,i);}function ld(t){for(const e of t.sections)if(Ms(e.text))return !0;return !1}class ud{constructor(t){this.layoutVertexArray=new fa,this.indexArray=new wa,this.programConfigurations=t,this.segments=new So,this.dynamicLayoutVertexArray=new ua,this.opacityVertexArray=new ya,this.placedSymbolArray=new Pa,this.globeExtVertexArray=new da;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Nh.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Zh.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,id,!0),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=t.createVertexBuffer(this.globeExtVertexArray,Gh.members,!0)),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy());}}Oi(ud,"SymbolBuffers");class cd{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new So,this.collisionVertexArray=new va,this.collisionVertexArrayExt=new ba;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,Xh.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,Kh.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}Oi(cd,"CollisionBuffers");class hd{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=Eo([]),this.placementViewportMatrix=Eo([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Qh(this.zoom,e["text-size"]),this.iconSizeData=Qh(this.zoom,e["icon-size"]);const r=this.layers[0].layout,n=r.get("symbol-sort-key"),i=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==i&&void 0!==n.constantOr(1),this.sortFeaturesByY=("viewport-y"===i||"auto"===i&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=r.get("text-writing-mode").map((t=>Vp[t])),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID,this.projection=t.projection;}createArrays(){this.text=new ud(new fo(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new ud(new fo(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new La,this.lineVertexArray=new Fa,this.symbolInstances=new Va;}calculateGlyphDependencies(t,e,r,n,i){for(let r=0;r<t.length;r++)if(e[t.charCodeAt(r)]=!0,n&&i){const n=ip[t.charAt(r)];n&&(e[n.charCodeAt(0)]=!0);}}populate(t,e,r,n){const i=this.layers[0],s=i.layout,a="globe"===this.projection.name,o=s.get("text-font"),l=s.get("text-field"),u=s.get("icon-image"),c=("constant"!==l.value.kind||l.value.value instanceof Be&&!l.value.value.isEmpty()||l.value.value.toString().length>0)&&("constant"!==o.value.kind||o.value.value.length>0),h="constant"!==u.value.kind||!!u.value.value||Object.keys(u.parameters).length>0,p=s.get("symbol-sort-key");if(this.features=[],!c&&!h)return;const f=e.iconDependencies,d=e.glyphDependencies,y=e.availableImages,m=new $s(this.zoom);for(const{feature:e,id:l,index:u,sourceLayerIndex:g}of t){const t=i._featureFilter.needGeometry,x=wu(e,t);if(!i._featureFilter.filter(m,x,r))continue;if(t||(x.geometry=bu(e,r,n)),a&&1!==e.type&&r.z<=5){const t=x.geometry,e=.98078528056,n=(t,n)=>Qo(Ol(t.x,t.y,r,1),Ol(n.x,n.y,r,1))<e;for(let e=0;e<t.length;e++)t[e]=mu(t[e],n);}let v,b;if(c){const t=i.getValueAndResolveTokens("text-field",x,r,y),e=Be.factory(t);ld(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===Fs()||this.hasRTLText&&js.isParsed())&&(v=np(e,i,x));}if(h){const t=i.getValueAndResolveTokens("icon-image",x,r,y);b=t instanceof Ee?t:Ee.fromString(t);}if(!v&&!b)continue;const w=this.sortFeaturesByKey?p.evaluate(x,{},r):void 0;if(this.features.push({id:l,text:v,icon:b,index:u,sourceLayerIndex:g,geometry:x.geometry,properties:e.properties,type:nd[e.type],sortKey:w}),b&&(f[b.name]=!0),v){const t=o.evaluate(x,{},r).join(","),e="map"===s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Vp.vertical)>=0;for(const r of v.sections)if(r.image)f[r.image.name]=!0;else {const n=bs(v.toString()),i=r.fontStack||t,s=d[i]=d[i]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r,n){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r,n),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r,n));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}getProjection(){return this.projectionInstance||(this.projectionInstance=rd(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment)for(const{x:t,y:r}of e)this.lineVertexArray.emplaceBack(t,r);return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,n,i,s,a,o,l,u,c,h,p,f){const d=t.indexArray,y=t.layoutVertexArray,m=t.globeExtVertexArray,g=t.segments.prepareSegment(4*e.length,y,d,this.canOverlap?s.sortKey:void 0),x=this.glyphOffsetArray.length,v=g.vertexLength,b=this.allowVerticalPlacement&&a===Vp.vertical?Math.PI/2:0,w=s.text&&s.text.sections;for(let n=0;n<e.length;n++){const{tl:i,tr:a,bl:u,br:c,tex:h,pixelOffsetTL:x,pixelOffsetBR:v,minFontScaleX:_,minFontScaleY:A,glyphOffset:S,isSDF:k,sectionIndex:I}=e[n],M=g.vertexLength,T=S[1];if(sd(y,l.x,l.y,i.x,T+i.y,h.x,h.y,r,k,x.x,x.y,_,A),sd(y,l.x,l.y,a.x,T+a.y,h.x+h.w,h.y,r,k,v.x,x.y,_,A),sd(y,l.x,l.y,u.x,T+u.y,h.x,h.y+h.h,r,k,x.x,v.y,_,A),sd(y,l.x,l.y,c.x,T+c.y,h.x+h.w,h.y+h.h,r,k,v.x,v.y,_,A),o){const{x:e,y:r,z:n}=o.anchor,[i,s,a]=o.up;ad(m,e,r,n,i,s,a),ad(m,e,r,n,i,s,a),ad(m,e,r,n,i,s,a),ad(m,e,r,n,i,s,a),od(t.dynamicLayoutVertexArray,e,r,n,b);}else od(t.dynamicLayoutVertexArray,l.x,l.y,l.z,b);d.emplaceBack(M,M+1,M+2),d.emplaceBack(M+1,M+2,M+3),g.vertexLength+=4,g.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(S[0]),n!==e.length-1&&I===e[n+1].sectionIndex||t.programConfigurations.populatePaintArrays(y.length,s,s.index,{},p,f,w&&w[I]);}const _=o?o.anchor:l;t.placedSymbolArray.emplaceBack(_.x,_.y,_.z,l.x,l.y,x,this.glyphOffsetArray.length-x,v,u,c,l.segment,r?r[0]:0,r?r[1]:0,n[0],n[1],a,0,!1,0,h,0);}_commitLayoutVertex(t,e,r,n,i,s,a){t.emplaceBack(e,r,n,i,s,Math.round(a.x),Math.round(a.y));}_addCollisionDebugVertices(t,e,r,n,i,s,a){const o=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),l=o.vertexLength,u=a.tileAnchorX,c=a.tileAnchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0);r.collisionVertexArrayExt.emplaceBack(e,-t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,t.padding),r.collisionVertexArrayExt.emplaceBack(e,-t.padding,t.padding),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new d(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new d(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new d(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,i,s,u,c,new d(t.x1,t.y2)),o.vertexLength+=4;const h=r.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),o.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._addCollisionDebugVertices(n,i,this.textCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}_addIconDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,s.placedIconSymbolIndex);this._addCollisionDebugVertices(n,i,this.iconCollisionBox,n.projectedAnchorX,n.projectedAnchorY,n.projectedAnchorZ,s);}}generateCollisionDebugBuffers(t,e){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new cd(ga,Yh.members,Ma),this.iconCollisionBox=new cd(ga,Yh.members,Ma);const r=ep(this.iconSizeData,t),n=ep(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._addTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,n){const i=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:n),s=tp(this.textSizeData,t,i)/Wh;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const n=this.icon.placedSymbolArray.get(r),i=tp(this.iconSizeData,t,n);return this.tilePixelRatio*i}_commitDebugCollisionVertexUpdate(t,e,r){t.emplaceBack(e,-r,-r),t.emplaceBack(e,r,-r),t.emplaceBack(e,r,r),t.emplaceBack(e,-r,r);}_updateTextDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceTextSize(t,s,e,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,i,n.padding);}}_updateIconDebugCollisionBoxes(t,e,r,n,i,s){for(let a=n;a<i;a++){const n=r.get(a),i=this.getSymbolInstanceIconSize(t,e,s);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,i,n.padding);}}updateCollisionDebugBuffers(t,e){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const r=ep(this.iconSizeData,t),n=ep(this.textSizeData,t);for(let i=0;i<this.symbolInstances.length;i++){const s=this.symbolInstances.get(i);this._updateTextDebugCollisionBoxes(n,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._updateTextDebugCollisionBoxes(n,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._updateIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s.placedIconSymbolIndex),this._updateIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s.placedIconSymbolIndex);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};if(e<r){const{x1:r,y1:n,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(e);u.textBox={x1:r,y1:n,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.textFeatureIndex=f;}if(n<i){const{x1:e,y1:r,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(n);u.verticalTextBox={x1:e,y1:r,x2:i,y2:s,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalTextFeatureIndex=f;}if(s<a){const{x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(s);u.iconBox={x1:e,y1:r,x2:n,y2:i,padding:a,projectedAnchorX:o,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.iconFeatureIndex=f;}if(o<l){const{x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p,featureIndex:f}=t.get(o);u.verticalIconBox={x1:e,y1:r,x2:n,y2:i,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:c,tileAnchorX:h,tileAnchorY:p},u.verticalIconFeatureIndex=f;}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.tileAnchorX+r*a.tileAnchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex);const{rightJustifiedTextSymbolIndex:r,centerJustifiedTextSymbolIndex:n,leftJustifiedTextSymbolIndex:i,verticalPlacedTextSymbolIndex:s,placedIconSymbolIndex:a,verticalPlacedIconSymbolIndex:o}=e;r>=0&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&this.addIndicesForPlacedSymbol(this.text,n),i>=0&&i!==n&&i!==r&&this.addIndicesForPlacedSymbol(this.text,i),s>=0&&this.addIndicesForPlacedSymbol(this.text,s),a>=0&&this.addIndicesForPlacedSymbol(this.icon,a),o>=0&&this.addIndicesForPlacedSymbol(this.icon,o);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}Oi(hd,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),hd.MAX_GLYPHS=65535,hd.addDynamicAttributes=od;const pd=new Js({"symbol-placement":new Ys(Ht.layout_symbol["symbol-placement"]),"symbol-spacing":new Ys(Ht.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Ys(Ht.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Hs(Ht.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Ys(Ht.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Ys(Ht.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new Ys(Ht.layout_symbol["icon-ignore-placement"]),"icon-optional":new Ys(Ht.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Ys(Ht.layout_symbol["icon-rotation-alignment"]),"icon-size":new Hs(Ht.layout_symbol["icon-size"]),"icon-text-fit":new Ys(Ht.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Ys(Ht.layout_symbol["icon-text-fit-padding"]),"icon-image":new Hs(Ht.layout_symbol["icon-image"]),"icon-rotate":new Hs(Ht.layout_symbol["icon-rotate"]),"icon-padding":new Ys(Ht.layout_symbol["icon-padding"]),"icon-keep-upright":new Ys(Ht.layout_symbol["icon-keep-upright"]),"icon-offset":new Hs(Ht.layout_symbol["icon-offset"]),"icon-anchor":new Hs(Ht.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Ys(Ht.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Ys(Ht.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Ys(Ht.layout_symbol["text-rotation-alignment"]),"text-field":new Hs(Ht.layout_symbol["text-field"]),"text-font":new Hs(Ht.layout_symbol["text-font"]),"text-size":new Hs(Ht.layout_symbol["text-size"]),"text-max-width":new Hs(Ht.layout_symbol["text-max-width"]),"text-line-height":new Hs(Ht.layout_symbol["text-line-height"]),"text-letter-spacing":new Hs(Ht.layout_symbol["text-letter-spacing"]),"text-justify":new Hs(Ht.layout_symbol["text-justify"]),"text-radial-offset":new Hs(Ht.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Ys(Ht.layout_symbol["text-variable-anchor"]),"text-anchor":new Hs(Ht.layout_symbol["text-anchor"]),"text-max-angle":new Ys(Ht.layout_symbol["text-max-angle"]),"text-writing-mode":new Ys(Ht.layout_symbol["text-writing-mode"]),"text-rotate":new Hs(Ht.layout_symbol["text-rotate"]),"text-padding":new Ys(Ht.layout_symbol["text-padding"]),"text-keep-upright":new Ys(Ht.layout_symbol["text-keep-upright"]),"text-transform":new Hs(Ht.layout_symbol["text-transform"]),"text-offset":new Hs(Ht.layout_symbol["text-offset"]),"text-allow-overlap":new Ys(Ht.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new Ys(Ht.layout_symbol["text-ignore-placement"]),"text-optional":new Ys(Ht.layout_symbol["text-optional"])});var fd={paint:new Js({"icon-opacity":new Hs(Ht.paint_symbol["icon-opacity"]),"icon-color":new Hs(Ht.paint_symbol["icon-color"]),"icon-halo-color":new Hs(Ht.paint_symbol["icon-halo-color"]),"icon-halo-width":new Hs(Ht.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Hs(Ht.paint_symbol["icon-halo-blur"]),"icon-translate":new Ys(Ht.paint_symbol["icon-translate"]),"icon-translate-anchor":new Ys(Ht.paint_symbol["icon-translate-anchor"]),"text-opacity":new Hs(Ht.paint_symbol["text-opacity"]),"text-color":new Hs(Ht.paint_symbol["text-color"],{runtimeType:le,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Hs(Ht.paint_symbol["text-halo-color"]),"text-halo-width":new Hs(Ht.paint_symbol["text-halo-width"]),"text-halo-blur":new Hs(Ht.paint_symbol["text-halo-blur"]),"text-translate":new Ys(Ht.paint_symbol["text-translate"]),"text-translate-anchor":new Ys(Ht.paint_symbol["text-translate-anchor"])}),layout:pd};class dd{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:ie,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}Oi(dd,"FormatSectionOverride",{omit:["defaultValue"]});class yd extends wo{constructor(t){super(t,fd);}recalculate(t,e){super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const r=this.layout.get("text-writing-mode");if(r){const t=[];for(const e of r)t.indexOf(e)<0&&t.push(e);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Nn(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new hd(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of fd.paint.overridableProperties){if(!yd.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new dd(e),n=new qn(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Zn("source",n):new Xn("composite",n,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new Xs(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&yd.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=fd.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Be)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof Fe&&De(e.value)===pe?s(e.value.sections):e instanceof Oe?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}getProgramConfiguration(t){return new po(this,t)}}var md={paint:new Js({"background-color":new Ys(Ht.paint_background["background-color"]),"background-pattern":new Ys(Ht.paint_background["background-pattern"]),"background-opacity":new Ys(Ht.paint_background["background-opacity"])})},gd={paint:new Js({"raster-opacity":new Ys(Ht.paint_raster["raster-opacity"]),"raster-hue-rotate":new Ys(Ht.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Ys(Ht.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Ys(Ht.paint_raster["raster-brightness-max"]),"raster-saturation":new Ys(Ht.paint_raster["raster-saturation"]),"raster-contrast":new Ys(Ht.paint_raster["raster-contrast"]),"raster-resampling":new Ys(Ht.paint_raster["raster-resampling"]),"raster-fade-duration":new Ys(Ht.paint_raster["raster-fade-duration"])})};class xd extends wo{constructor(t){super(t,{}),this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isLayerDraped(){return void 0!==this.implementation.renderToTile}shouldRedrape(){return !!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}var vd={paint:new Js({"sky-type":new Ys(Ht.paint_sky["sky-type"]),"sky-atmosphere-sun":new Ys(Ht.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new Ys(Ht.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new Ys(Ht.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new Ys(Ht.paint_sky["sky-gradient-radius"]),"sky-gradient":new Ws(Ht.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new Ys(Ht.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new Ys(Ht.paint_sky["sky-atmosphere-color"]),"sky-opacity":new Ys(Ht.paint_sky["sky-opacity"])})};function bd(t,e,r){const n=[0,0,1],i=hl([]);return fl(i,i,r?-x(t)+Math.PI:x(t)),pl(i,i,-x(e)),rl(n,n,i),Jo(n,n)}const wd={circle:class extends wo{constructor(t){super(t,Ou);}createBucket(t){return new Su(t)}queryRadius(t){const e=t;return Fu("circle-radius",this,e)+Fu("circle-stroke-width",this,e)+Ru(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=$u(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r);return qu(t,n,s,a,o,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,u)}getProgramIds(){return ["circle"]}getProgramConfiguration(t){return new po(this,t)}},heatmap:class extends wo{createBucket(t){return new Ku(t)}constructor(t){super(t,tc),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=ec({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(t){return Fu("heatmap-radius",this,t)}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=this.paint.get("heatmap-radius").evaluate(e,r);return qu(t,n,s,a,o,!0,!0,new d(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getProgramConfiguration(t){return new po(this,t)}},hillshade:class extends wo{constructor(t){super(t,rc);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}},fill:class extends wo{constructor(t){super(t,Oc);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getProgramConfiguration(t){return new po(this,t)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new $c(t)}queryRadius(){return Ru(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s){return !t.queryGeometry.isAboveHorizon&&Mu(ju(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),n)}isTileClipped(){return !0}},"fill-extrusion":class extends wo{constructor(t){super(t,Ah);}createBucket(t){return new fh(t)}queryRadius(){return Ru(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}getProgramConfiguration(t){return new po(this,t)}queryIntersectsFeature(t,e,r,n,i,s,a,o,l){const u=$u(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=[0,0],f=o&&s.elevation,y=s.elevation?s.elevation.exaggeration():1,m=t.tile.getBucket(this);if(f&&m instanceof fh){const t=m.centroidVertexArray,e=l+1;e<t.length&&(p[0]=t.geta_centroid_pos0(e),p[1]=t.geta_centroid_pos1(e));}if(0===p[0]&&1===p[1])return !1;"globe"===s.projection.name&&(n=wh([n],[new d(0,0),new d(ko,ko)],t.tileID.canonical).map((t=>t.polygon)).flat());const g=f?o:null,[x,v]=function(t,e,r,n,i,s,a,o,l,u,c){return "globe"===t.projection.name?function(t,e,r,n,i,s,a,o,l,u,c){const h=[],p=[],f=t.projection.upVectorScale(c,t.center.lat,t.worldSize).metersToTile,d=[0,0,0,1],y=[0,0,0,1],m=(t,e,r,n)=>{t[0]=e,t[1]=r,t[2]=n,t[3]=1;},g=bh();r>0&&(r+=g),n+=g;for(const g of e){const e=[],x=[];for(const h of g){const p=h.x+i.x,g=h.y+i.y,v=t.projection.projectTilePoint(p,g,c),b=t.projection.upVector(c,h.x,h.y);let w=r,_=n;if(a){const t=Ch(p,g,r,n,a,o,l,u);w+=t.base,_+=t.top;}0!==r?m(d,v.x+b[0]*f*w,v.y+b[1]*f*w,v.z+b[2]*f*w):m(d,v.x,v.y,v.z),m(y,v.x+b[0]*f*_,v.y+b[1]*f*_,v.z+b[2]*f*_),el(d,d,s),el(y,y,s),e.push(new zh(d[0],d[1],d[2])),x.push(new zh(y[0],y[1],y[2]));}h.push(e),p.push(x);}return [h,p]}(t,e,r,n,i,s,a,o,l,u,c):a?function(t,e,r,n,i,s,a,o,l){const u=[],c=[],h=[0,0,0,1];for(const p of t){const t=[],f=[];for(const u of p){const c=u.x+n.x,p=u.y+n.y,d=Ch(c,p,e,r,s,a,o,l);h[0]=c,h[1]=p,h[2]=d.base,h[3]=1,ul(h,h,i),h[3]=Math.max(h[3],1e-5);const y=new zh(h[0]/h[3],h[1]/h[3],h[2]/h[3]);h[0]=c,h[1]=p,h[2]=d.top,h[3]=1,ul(h,h,i),h[3]=Math.max(h[3],1e-5);const m=new zh(h[0]/h[3],h[1]/h[3],h[2]/h[3]);t.push(y),f.push(m);}u.push(t),c.push(f);}return [u,c]}(e,r,n,i,s,a,o,l,u):function(t,e,r,n,i){const s=[],a=[],o=i[8]*e,l=i[9]*e,u=i[10]*e,c=i[11]*e,h=i[8]*r,p=i[9]*r,f=i[10]*r,d=i[11]*r;for(const e of t){const t=[],r=[];for(const s of e){const e=s.x+n.x,a=s.y+n.y,y=i[0]*e+i[4]*a+i[12],m=i[1]*e+i[5]*a+i[13],g=i[2]*e+i[6]*a+i[14],x=i[3]*e+i[7]*a+i[15],v=y+o,b=m+l,w=g+u,_=Math.max(x+c,1e-5),A=y+h,S=m+p,k=g+f,I=Math.max(x+d,1e-5);t.push(new zh(v/_,b/_,w/_)),r.push(new zh(A/I,S/I,k/I));}s.push(t),a.push(r);}return [s,a]}(e,r,n,i,s)}(s,n,h,c,u,a,g,p,y,s.center.lat,t.tileID.canonical),b=t.queryGeometry;return function(t,e,r){let n=1/0;Mu(r,e)&&(n=Eh(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];ku(r,i)&&(n=Math.min(n,Eh(r,i)));}}return n!==1/0&&n}(x,v,b.isPointQuery()?b.screenBounds:b.screenGeometry)}},line:class extends wo{constructor(t){super(t,Uh),this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=t._styleExpression&&t._styleExpression.expression instanceof Ir,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Oh.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new jh(t)}getProgramIds(){return [this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getProgramConfiguration(t){return new po(this,t)}queryRadius(t){const e=t,r=qh(Fu("line-width",this,e),Fu("line-gap-width",this,e)),n=Fu("line-offset",this,e);return r/2+Math.abs(n)+Ru(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,s){if(t.queryGeometry.isAboveHorizon)return !1;const a=ju(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),o=t.pixelToTileUnitsFactor/2*qh(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),l=this.paint.get("line-offset").evaluate(e,r);return l&&(n=function(t,e){const r=[],n=new d(0,0);for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const r=s[t-1],i=s[t],o=s[t+1],l=0===t?n:i.sub(r)._unit()._perp(),u=t===s.length-1?n:o.sub(i)._unit()._perp(),c=l._add(u)._unit();c._mult(1/(c.x*u.x+c.y*u.y)),a.push(c._mult(e)._add(i));}r.push(a);}return r}(n,l*t.pixelToTileUnitsFactor)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(Du(t,i[e]))return !0;if(Tu(t,i,r))return !0}return !1}(a,n,o)}isTileClipped(){return !0}},symbol:yd,background:class extends wo{constructor(t){super(t,md);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}},raster:class extends wo{constructor(t){super(t,gd);}getProgramIds(){return ["raster"]}},sky:class extends wo{constructor(t){super(t,vd),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=ec({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}return !1}getCenter(t,e){if("atmosphere"===this.paint.get("sky-type")){const r=this.paint.get("sky-atmosphere-sun"),n=!r,i=t.style.light,s=i.properties.get("position");return n&&"viewport"===i.properties.get("anchor")&&U("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),n?bd(s.azimuthal,90-s.polar,e):bd(r[0],90-r[1],e)}const r=this.paint.get("sky-gradient-center");return bd(r[0],90-r[1],e)}is3D(){return !1}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}}};class _d{constructor(t,e,r,n){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,n);}update(t,r,n){const{width:i,height:s}=t,{context:a}=this,{gl:o}=a,{HTMLImageElement:l,HTMLCanvasElement:u,HTMLVideoElement:c,ImageData:h,ImageBitmap:p}=e;if(o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!r||!1!==r.premultiply)),n||this.size&&this.size[0]===i&&this.size[1]===s){const{x:e,y:r}=n||{x:0,y:0};t instanceof l||t instanceof u||t instanceof c||t instanceof h||p&&t instanceof p?o.texSubImage2D(o.TEXTURE_2D,0,e,r,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,r,i,s,o.RGBA,o.UNSIGNED_BYTE,t.data);}else this.size=[i,s],t instanceof l||t instanceof u||t instanceof c||t instanceof h||p&&t instanceof p?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,i,s,0,this.format,o.UNSIGNED_BYTE,t.data);this.useMipmap=Boolean(r&&r.useMipmap&&this.isSizePowerOfTwo()),this.useMipmap&&o.generateMipmap(o.TEXTURE_2D);}bind(t,e){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,this.useMipmap?t===n.NEAREST?n.NEAREST_MIPMAP_NEAREST:n.LINEAR_MIPMAP_NEAREST:t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Ad{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback();}),0));}remove(){this._channel=void 0,this._callback=()=>{};}}class Sd{constructor(){this.tasks={},this.taskQueue=[],V(["process"],this),this.invoker=new Ad(this.process),this.nextId=0;}add(t,e){const r=this.nextId++,n=function({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}(e);if(0===n){N();try{t();}finally{}return {cancel:()=>{}}}return this.tasks[r]={fn:t,metadata:e,priority:n,id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){N();try{if(this.taskQueue=this.taskQueue.filter((t=>!!this.tasks[t])),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const n=this.tasks[this.taskQueue[r]];n.priority<e&&(e=n.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}class kd{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}const Id=["tile","layer","source","sourceLayer","state"];class Md{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,this._z=e,this._x=r,this._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};void 0!==this.id&&(t.id=this.id);for(const e of Id)void 0!==this[e]&&(t[e]=this[e]);return t}}const Td=32,zd=33,Bd=new Uint16Array(8184);for(let t=0;t<2046;t++){let e=t+2,r=0,n=0,i=0,s=0,a=0,o=0;for(1&e?i=s=a=Td:r=n=o=Td;(e>>=1)>1;){const t=r+i>>1,l=n+s>>1;1&e?(i=r,s=n,r=a,n=o):(r=i,n=s,i=a,s=o),a=t,o=l;}const l=4*t;Bd[l+0]=r,Bd[l+1]=n,Bd[l+2]=i,Bd[l+3]=s;}const Ed=new Uint16Array(2178),Cd=new Uint8Array(1089),Pd=new Uint16Array(1089);function Dd(t){return 0===t?-.03125:32===t?.03125:0}var Vd=na([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);const Ld={type:2,extent:ko,loadGeometry:()=>[[new d(0,0),new d(8193,0),new d(8193,8193),new d(0,8193),new d(0,0)]]};class Fd{constructor(t,e,r,n,i){this.tileID=t,this.uid=E(),this.uses=0,this.tileSize=e,this.tileZoom=r,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=i,this.expiredRequestCount=0,this.state="loading",n&&n.transform&&(this.projection=n.transform.projection);}registerFadeDuration(t){const e=t+this.timeAdded;e<Nt.now()||this.fadeEndTime&&e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=Vf(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(t,e,r){if(this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const r={};if(!e)return r;for(const n of t){const t=n.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){n.layers=t,n.stateDependentLayerIds&&(n.stateDependentLayers=n.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)r[e.id]=n;}}return r}(t.buckets,e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof hd){if(this.hasSymbolBuckets=!0,!r)break;e.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof hd&&e.hasRTLText){this.hasRTLText=!0,js.isLoading()||js.isLoaded()||"deferred"!==Fs()||Rs();break}}this.queryPadding=0;for(const t in this.buckets){const r=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(r));}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),t.lineAtlas&&(this.lineAtlas=t.lineAtlas);}else this.collisionBoxArray=new Ea;}unloadVectorData(){if(this.hasData()){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded";}}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const r=this.buckets[e];r.uploadPending()&&r.upload(t);}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new _d(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new _d(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new _d(t,this.lineAtlas.image,e.ALPHA),this.lineAtlas.uploaded=!0);}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture);}queryRenderedFeatures(t,e,r,n,i,s,a,o){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({tileResult:n,pixelPosMatrix:a,transform:s,params:i,tileTransform:this.tileTransform},t,e,r):{}}querySourceFeatures(t,e){const r=this.latestFeatureIndex;if(!r||!r.rawTileData)return;const n=r.loadVTLayers(),i=e?e.sourceLayer:"",s=n._geojsonTileLayer||n[i];if(!s)return;const a=ai(e&&e.filter),{z:o,x:l,y:u}=this.tileID.canonical,c={z:o,x:l,y:u};for(let e=0;e<s.length;e++){const n=s.feature(e);if(a.needGeometry){const t=wu(n,!0);if(!a.filter(new $s(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new $s(this.tileID.overscaledZ),n))continue;const h=r.getId(n,i),p=new Md(n,o,l,u,h);p.tile=c,t.push(p);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return !!this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=G(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let r=!1;if(this.expirationTime>t)r=!1;else if(e)if(this.expirationTime<e)r=!0;else {const n=this.expirationTime-e;n?this.expirationTime=t+Math.max(n,3e4):r=!0;}else r=!0;r?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length||!e)return;const r=this.latestFeatureIndex.loadVTLayers(),n=e.style.listImages();for(const i in this.buckets){if(!e.style.hasLayer(i))continue;const s=this.buckets[i],a=s.layers[0].sourceLayer||"_geojsonTileLayer",o=r[a],l=t[a];if(!o||!l||0===Object.keys(l).length)continue;if(s.update(l,o,n,this.imageAtlas&&this.imageAtlas.patternPositions||{}),s instanceof jh||s instanceof $c){const t=e.style._getSourceCache(s.layers[0].source);e._terrain&&e._terrain.enabled&&t&&s.programConfigurations.needsUpload&&e._terrain._clearRenderCacheForTile(t.id,this.tileID);}const u=e&&e.style&&e.style.getLayer(i);u&&(this.queryPadding=Math.max(this.queryPadding,u.queryRadius(s)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<Nt.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=Nt.now()+t;}setTexture(t,e){const r=e.context,n=r.gl;this.texture=this.texture||e.getTileTexture(t.width),this.texture?this.texture.update(t,{useMipmap:!0}):(this.texture=new _d(r,t,n.RGBA,{useMipmap:!0}),this.texture.bind(n.LINEAR,n.CLAMP_TO_EDGE));}setDependencies(t,e){const r={};for(const t of e)r[t]=!0;this.dependencies[t]=r;}hasDependency(t,e){for(const r of t){const t=this.dependencies[r];if(t)for(const r of e)if(t[r])return !0}return !1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(t,e){if(!e||"mercator"===e.name||this._tileDebugBuffer)return;const r=bu(Ld,this.tileID.canonical,this.tileTransform)[0],n=new sa,i=new Ta;for(let t=0;t<r.length;t++){const{x:e,y:s}=r[t];n.emplaceBack(e,s),i.emplaceBack(t);}i.emplaceBack(0),this._tileDebugIndexBuffer=t.createIndexBuffer(i),this._tileDebugBuffer=t.createVertexBuffer(n,xl.members),this._tileDebugSegments=So.simpleSegment(0,0,n.length,i.length);}_makeTileBoundsBuffers(t,e){if(this._tileBoundsBuffer||!e||"mercator"===e.name)return;const r=bu(Ld,this.tileID.canonical,this.tileTransform)[0];let n,i;if(this.isRaster){const t=function(t,e){const r=Vf(t,e),n=Math.pow(2,t.z);for(let i=0;i<zd;i++)for(let s=0;s<zd;s++){const a=ou((t.x+(s+Dd(s))/Td)/n),o=lu((t.y+(i+Dd(i))/Td)/n),l=e.project(a,o),u=i*zd+s;Ed[2*u+0]=Math.round((l.x*r.scale-r.x)*ko),Ed[2*u+1]=Math.round((l.y*r.scale-r.y)*ko);}Cd.fill(0),Pd.fill(0);for(let t=2045;t>=0;t--){const e=4*t,r=Bd[e+0],n=Bd[e+1],i=Bd[e+2],s=Bd[e+3],a=r+i>>1,o=n+s>>1,l=a+o-n,u=o+r-a,c=n*zd+r,h=s*zd+i,p=o*zd+a,f=Math.hypot((Ed[2*c+0]+Ed[2*h+0])/2-Ed[2*p+0],(Ed[2*c+1]+Ed[2*h+1])/2-Ed[2*p+1])>=16;if(Cd[p]=Cd[p]||(f?1:0),t<1022){const t=(n+u>>1)*zd+(r+l>>1),e=(s+u>>1)*zd+(i+l>>1);Cd[p]=Cd[p]||Cd[t]||Cd[e];}}const i=new oa,s=new wa;let a=0;function o(t,e){const r=e*zd+t;return 0===Pd[r]&&(i.emplaceBack(Ed[2*r+0],Ed[2*r+1],t*ko/Td,e*ko/Td),Pd[r]=++a),Pd[r]-1}function l(t,e,r,n,i,a){const u=t+r>>1,c=e+n>>1;if(Math.abs(t-i)+Math.abs(e-a)>1&&Cd[c*zd+u])l(i,a,t,e,u,c),l(r,n,i,a,u,c);else {const l=o(t,e),u=o(r,n),c=o(i,a);s.emplaceBack(l,u,c);}}return l(0,0,Td,Td,Td,0),l(Td,Td,0,0,0,Td),{vertices:i,indices:s}}(this.tileID.canonical,e);n=t.vertices,i=t.indices;}else {n=new oa,i=new wa;for(const{x:t,y:e}of r)n.emplaceBack(t,e,0,0);const t=sc(n.int16,void 0,4);for(let e=0;e<t.length;e+=3)i.emplaceBack(t[e],t[e+1],t[e+2]);}this._tileBoundsBuffer=t.createVertexBuffer(n,Vd.members),this._tileBoundsIndexBuffer=t.createIndexBuffer(i),this._tileBoundsSegments=So.simpleSegment(0,0,n.length,i.length);}_makeGlobeTileDebugBuffers(t,e){const r=e.projection;if(!r||"globe"!==r.name||e.freezeTileCoverage)return;const n=this.tileID.canonical,i=Gl(Vl(n,e)),s=Kl(e.zoom);let a;s>0&&(a=Co(new Float64Array(16),e.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(t,n,e,i,a,s),this._makeGlobeTileDebugTextBuffer(t,n,e,i,a,s);}_globePoint(t,e,r,n,i,s,a){let o=Ol(t,e,r);if(s){const i=1<<r.z,l=iu(n.center.lng),u=su(n.center.lat),c=(r.x+.5)/i-l;let h=0;c>.5?h=-1:c<-.5&&(h=1);let p=(t/ko+r.x)/i+h,f=(e/ko+r.y)/i;p=(p-l)*n._pixelsPerMercatorPixel+l,f=(f-u)*n._pixelsPerMercatorPixel+u;const d=[p*n.worldSize,f*n.worldSize,0];el(d,d,s),o=Dl(o,d,a);}return el(o,o,i)}_makeGlobeTileDebugBorderBuffer(t,e,r,n,i,s){const a=new sa,o=new Ta,l=new aa,u=(t,u,c,h,p)=>{const f=(c-t)/(p-1),d=(h-u)/(p-1),y=a.length;for(let c=0;c<p;c++){const h=t+c*f,p=u+c*d;a.emplaceBack(h,p);const m=this._globePoint(h,p,e,r,n,i,s);l.emplaceBack(m[0],m[1],m[2]),o.emplaceBack(y+c);}},c=ko;u(0,0,c,0,16),u(c,0,c,c,16),u(c,c,0,c,16),u(0,c,0,0,16),this._tileDebugIndexBuffer=t.createIndexBuffer(o),this._tileDebugBuffer=t.createVertexBuffer(a,xl.members),this._globeTileDebugBorderBuffer=t.createVertexBuffer(l,gl.members),this._tileDebugSegments=So.simpleSegment(0,0,a.length,o.length);}_makeGlobeTileDebugTextBuffer(t,e,r,n,i,s){const a=new sa,o=new wa,l=new aa,u=25;o.reserve(32),a.reserve(u),l.reserve(u);const c=(t,e)=>u*t+e;for(let t=0;t<u;t++){const o=2048*t;for(let t=0;t<u;t++){const u=2048*t;a.emplaceBack(u,o);const c=this._globePoint(u,o,e,r,n,i,s);l.emplaceBack(c[0],c[1],c[2]);}}for(let t=0;t<4;t++)for(let e=0;e<4;e++){const r=c(t,e),n=c(t,e+1),i=c(t+1,e),s=c(t+1,e+1);o.emplaceBack(r,n,i),o.emplaceBack(i,n,s);}this._tileDebugTextIndexBuffer=t.createIndexBuffer(o),this._tileDebugTextBuffer=t.createVertexBuffer(a,xl.members),this._globeTileDebugTextBuffer=t.createVertexBuffer(l,gl.members),this._tileDebugTextSegments=So.simpleSegment(0,0,u,32);}}class Rd{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,e,r){const n=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][n]=this.stateChanges[t][n]||{},z(this.stateChanges[t][n],r),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==n&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][n]){this.deletedStates[t][n]={};for(const e in this.state[t][n])r[e]||(this.deletedStates[t][n][e]=null);}else for(const e in r)this.deletedStates[t]&&this.deletedStates[t][n]&&null===this.deletedStates[t][n][e]&&delete this.deletedStates[t][n][e];}removeFeatureState(t,e,r){if(null===this.deletedStates[t])return;const n=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},r&&void 0!==e)null!==this.deletedStates[t][n]&&(this.deletedStates[t][n]=this.deletedStates[t][n]||{},this.deletedStates[t][n][r]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][n])for(r in this.deletedStates[t][n]={},this.stateChanges[t][n])this.deletedStates[t][n][r]=null;else this.deletedStates[t][n]=null;else this.deletedStates[t]=null;}getState(t,e){const r=String(e),n=z({},(this.state[t]||{})[r],(this.stateChanges[t]||{})[r]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const r=this.deletedStates[t][e];if(null===r)return {};for(const t in r)delete n[t];}return n}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,e){const r={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const r in this.stateChanges[t])this.state[t][r]||(this.state[t][r]={}),z(this.state[t][r],this.stateChanges[t][r]),e[r]=this.state[t][r];r[t]=e;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const r in this.state[t])e[r]={},this.state[t][r]={};else for(const r in this.deletedStates[t]){if(null===this.deletedStates[t][r])this.state[t][r]={};else if(this.state[t][r])for(const e of Object.keys(this.deletedStates[t][r]))delete this.state[t][r][e];e[r]=this.state[t][r];}r[t]=r[t]||{},z(r[t],e);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(r).length)for(const n in t)t[n].setFeatureState(r,e);}}class jd{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function $d(t,e,r,n){let i=0,s=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(n[a])<1e-15){if(r[a]<t[a]||r[a]>e[a])return null}else {const o=1/n[a];let l=(t[a]-r[a])*o,u=(e[a]-r[a])*o;if(l>u){const t=l;l=u,u=t;}if(l>i&&(i=l),u<s&&(s=u),i>s)return null}return i}function Ud(t,e,r,n,i,s,a,o,l,u,c){const h=n-t,p=i-e,f=s-r,d=a-t,y=o-e,m=l-r,g=c[1]*m-c[2]*y,x=c[2]*d-c[0]*m,v=c[0]*y-c[1]*d,b=h*g+p*x+f*v;if(Math.abs(b)<1e-15)return null;const w=1/b,_=u[0]-t,A=u[1]-e,S=u[2]-r,k=(_*g+A*x+S*v)*w;if(k<0||k>1)return null;const I=A*f-S*p,M=S*h-_*f,T=_*p-A*h,z=(c[0]*I+c[1]*M+c[2]*T)*w;return z<0||k+z>1?null:(d*I+y*M+m*T)*w}function Od(t,e,r){return (t-e)/(r-e)}function qd(t,e,r,n,i,s,a,o,l){const u=1<<r,c=s-n,h=a-i,p=(t+1)/u*c+n,f=(e+0)/u*h+i,d=(e+1)/u*h+i;o[0]=(t+0)/u*c+n,o[1]=f,l[0]=p,l[1]=d;}class Nd{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let n=Math.ceil(Math.pow(2,e));const i=1/n,s=(t,e,r,n,i)=>{const s=n?1:0,a=(t+1)*r-s,o=e*r,l=(e+1)*r-s;i[0]=t*r,i[1]=o,i[2]=a,i[3]=l;};let a=new jd(n);const o=[];for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),i,!1,o);const r=Zd(o[0],o[1],t),l=Zd(o[2],o[1],t),u=Zd(o[2],o[3],t),c=Zd(o[0],o[3],t);a.minimums.push(Math.min(r,l,u,c)),a.maximums.push(Math.max(r,l,u,c)),a.leaves.push(1);}for(r.push(a),n/=2;n>=1;n/=2){const t=r[r.length-1];a=new jd(n);for(let e=0;e<n*n;e++){s(e%n,Math.floor(e/n),2,!0,o);const r=t.getElevation(o[0],o[1]),i=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),f=t.isLeaf(o[0],o[3]),d=Math.min(r.min,i.min,l.min,u.min),y=Math.max(r.max,i.max,l.max,u.max),m=c&&h&&p&&f;a.maximums.push(y),a.minimums.push(d),a.leaves.push(y-d<=5&&m?1:0);}r.push(a);}return r}(this.dem),r=e.length-1,n=e[r];this._addNode(n.minimums[0],n.maximums[0],n.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,n,i,s,a=1){return $d([t,e,-100],[r,n,this.maximums[0]*a],i,s)}raycast(t,e,r,n,i,s,a=1){if(!this.nodeCount)return null;const o=this.raycastRoot(t,e,r,n,i,s,a);if(null==o)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:o,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:o,t:f,nodex:d,nodey:y,depth:m}=p.pop();if(this.leaves[o]){qd(d,y,m,t,e,r,n,c,h);const o=1<<m,l=(d+0)/o,u=(d+1)/o,p=(y+0)/o,g=(y+1)/o,x=Zd(l,p,this.dem)*a,v=Zd(u,p,this.dem)*a,b=Zd(u,g,this.dem)*a,w=Zd(l,g,this.dem)*a,_=Ud(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,i,s),A=Ud(h[0],h[1],b,c[0],h[1],w,c[0],c[1],x,i,s),S=Math.min(null!==_?_:Number.MAX_VALUE,null!==A?A:Number.MAX_VALUE);if(S!==Number.MAX_VALUE)return S;{const t=Wo([],i,s,f);if(Gd(x,v,w,b,Od(t[0],c[0],h[0]),Od(t[1],c[1],h[1]))>=t[2])return f}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){qd((d<<1)+this._siblingOffset[p][0],(y<<1)+this._siblingOffset[p][1],m+1,t,e,r,n,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[o]+p]*a;const f=$d(c,h,i,s);if(null!=f){const t=f;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[o]+e,t:l[e],nodex:(d<<1)+this._siblingOffset[e][0],nodey:(y<<1)+this._siblingOffset[e][1],depth:m+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,n,i){if(1===t[n].isLeaf(e,r))return;this.childOffsets[i]||(this.childOffsets[i]=this.nodeCount);const s=n-1,a=t[s];let o=0,l=0;for(let t=0;t<this._siblingOffset.length;t++){const n=2*e+this._siblingOffset[t][0],i=2*r+this._siblingOffset[t][1],s=a.getElevation(n,i),u=a.isLeaf(n,i),c=this._addNode(s.min,s.max,u);u&&(o|=1<<t),l||(l=c);}for(let n=0;n<this._siblingOffset.length;n++)o&1<<n||this._construct(t,2*e+this._siblingOffset[n][0],2*r+this._siblingOffset[n][1],s,l+n);}}function Gd(t,e,r,n,i,s){return Mr(Mr(t,r,s),Mr(e,n,s),i)}function Zd(t,e,r){const n=r.dim,i=S(t*n-.5,0,n-1),s=S(e*n-.5,0,n-1),a=Math.floor(i),o=Math.floor(s),l=Math.min(a+1,n-1),u=Math.min(o+1,n-1);return Gd(r.get(a,o),r.get(l,o),r.get(a,u),r.get(l,u),i-a,s-o)}const Xd={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function Kd(t,e,r){return (256*t*256+256*e+r)/10-1e4}function Yd(t,e,r){return 256*t+e+r/256-32768}class Hd{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,n=!1,i=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return U(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const s=this.dim=e.height-2,a=new Uint32Array(e.data.buffer);if(this.pixels=new Uint8Array(e.data.buffer),this.encoding=r||"mapbox",this.borderReady=n,!n){for(let t=0;t<s;t++)a[this._idx(-1,t)]=a[this._idx(0,t)],a[this._idx(s,t)]=a[this._idx(s-1,t)],a[this._idx(t,-1)]=a[this._idx(t,0)],a[this._idx(t,s)]=a[this._idx(t,s-1)];a[this._idx(-1,-1)]=a[this._idx(0,0)],a[this._idx(s,-1)]=a[this._idx(s-1,0)],a[this._idx(-1,s)]=a[this._idx(0,s-1)],a[this._idx(s,s)]=a[this._idx(s-1,s-1)],i&&this._buildQuadTree();}}_buildQuadTree(){this._tree=new Nd(this);}get(t,e,r=!1){r&&(t=S(t,-1,this.dim),e=S(e,-1,this.dim));const n=4*this._idx(t,e);return ("terrarium"===this.encoding?Yd:Kd)(this.pixels[n],this.pixels[n+1],this.pixels[n+2])}static getUnpackVector(t){return Xd[t]}get unpackVector(){return Xd[this.encoding]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}static pack(t,e){const r=[0,0,0,0],n=Hd.getUnpackVector(e);let i=Math.floor((t+n[3])/n[2]);return r[2]=i%256,i=Math.floor(i/256),r[1]=i%256,i=Math.floor(i/256),r[0]=i,r}getPixels(){return new Qu({width:this.stride,height:this.stride},this.pixels)}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++){const n=4*this._idx(r,e),i=4*this._idx(r+o,e+l);this.pixels[n+0]=t.pixels[i+0],this.pixels[n+1]=t.pixels[i+1],this.pixels[n+2]=t.pixels[i+2],this.pixels[n+3]=t.pixels[i+3];}}onDeserialize(){this._tree&&(this._tree.dem=this);}}Oi(Hd,"DEMData"),Oi(Nd,"DemMinMaxQuadTree",{omit:["dem"]});class Wd{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,r){const n=t.wrapped().key;void 0===this.data[n]&&(this.data[n]=[]);const i={value:e,timeout:void 0};if(void 0!==r&&(i.timeout=setTimeout((()=>{this.remove(t,i);}),r)),this.data[n].push(i),this.order.push(n),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const r=t.wrapped().key,n=void 0===e?0:this.data[r].indexOf(e),i=this.data[r][n];return this.data[r].splice(n,1),i.timeout&&clearTimeout(i.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(i.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const r in this.data)for(const n of this.data[r])t(n.value)||e.push(n);for(const t of e)this.remove(t.value.tileID,t);}}class Jd{constructor(t,e,r){this.func=t,this.mask=e,this.range=r;}}Jd.ReadOnly=!1,Jd.ReadWrite=!0,Jd.disabled=new Jd(519,Jd.ReadOnly,[0,1]);const Qd=7680;class ty{constructor(t,e,r,n,i,s){this.test=t,this.ref=e,this.mask=r,this.fail=n,this.depthFail=i,this.pass=s;}}ty.disabled=new ty({func:519,mask:0},0,0,Qd,Qd,Qd);class ey{constructor(t,e,r){this.blendFunction=t,this.blendColor=e,this.mask=r;}}ey.Replace=[1,0],ey.disabled=new ey(ey.Replace,Me.transparent,[!1,!1,!1,!1]),ey.unblended=new ey(ey.Replace,Me.transparent,[!0,!0,!0,!0]),ey.alphaBlended=new ey([1,771],Me.transparent,[!0,!0,!0,!0]);const ry=1029,ny=2305;class iy{constructor(t,e,r){this.enable=t,this.mode=e,this.frontFace=r;}}iy.disabled=new iy(!1,ry,ny),iy.backCCW=new iy(!0,ry,ny),iy.backCW=new iy(!0,ry,2304),iy.frontCW=new iy(!0,1028,2304),iy.frontCCW=new iy(!0,1028,ny);class sy extends Yt{constructor(t,e,r){super(),this.id=t,this._onlySymbols=r,e.on("data",(t=>{"source"===t.dataType&&"metadata"===t.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===t.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));})),e.on("error",(()=>{this._sourceErrored=!0;})),this._source=e,this._tiles={},this._cache=new Wd(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=e.minTileCacheSize,this._maxTileCacheSize=e.maxTileCacheSize,this._loadedParentTiles={},this._coveredTiles={},this._state=new Rd,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType;}onAdd(t){this.map=t,this._minTileCacheSize=void 0===this._minTileCacheSize&&t?t._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&t?t._maxTileCacheSize:this._maxTileCacheSize;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(t,e){return t.isSymbolTile=this._onlySymbols,this._source.loadTile(t,e)}_unloadTile(t){if(this._source.unloadTile)return this._source.unloadTile(t,(()=>{}))}_abortTile(t){if(this._source.abortTile)return this._source.abortTile(t,(()=>{}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const r=this._tiles[e];r.upload(t),r.prepare(this.map.style.imageManager);}}getIds(){return T(this._tiles).map((t=>t.tileID)).sort(ay).map((t=>t.key))}getRenderableIds(t){const e=[];for(const r in this._tiles)this._isIdRenderable(+r,t)&&e.push(this._tiles[r]);return t?e.sort(((t,e)=>{const r=t.tileID,n=e.tileID,i=new d(r.canonical.x,r.canonical.y)._rotate(this.transform.angle),s=new d(n.canonical.x,n.canonical.y)._rotate(this.transform.angle);return r.overscaledZ-n.overscaledZ||s.y-i.y||s.x-i.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(ay).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(+t,"reloading");}}_reloadTile(t,e){const r=this._tiles[t];r&&("loading"!==r.state&&(r.state=e),this._loadTile(r,this._tileLoaded.bind(this,r,t,e)));}_tileLoaded(t,e,r,n){if(n)if(t.state="errored",404!==n.status)this._source.fire(new Kt(n,{tile:t}));else if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const t=this.map.painter.terrain;this.update(this.transform,t.getScaledDemTileSize(),!0),t.resetTileLookupCache(this.id);}else this.update(this.transform);else t.timeAdded=Nt.now(),"expired"===r&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this._source.type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new Xt("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(t){const e=this.getRenderableIds();for(let n=0;n<e.length;n++){const i=e[n];if(t.neighboringTiles&&t.neighboringTiles[i]){const e=this.getTileByID(i);r(t,e),r(e,t);}}function r(t,e){if(!t.dem||t.dem.borderReady)return;t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0;let r=e.tileID.canonical.x-t.tileID.canonical.x;const n=e.tileID.canonical.y-t.tileID.canonical.y,i=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===r&&0===n||Math.abs(n)>1||(Math.abs(r)>1&&(1===Math.abs(r+i)?r+=i:1===Math.abs(r-i)&&(r-=i)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,r,n),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,r,n){for(const i in this._tiles){let s=this._tiles[i];if(n[i]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>r)continue;let a=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(a=t);}let o=a;for(;o.overscaledZ>e;)if(o=o.scaledTo(o.overscaledZ-1),t[o.key]){n[a.key]=a;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const r=this._loadedParentTiles[t.key];return r&&r.tileID.overscaledZ>=e?r:null}for(let r=t.overscaledZ-1;r>=e;r--){const e=t.scaledTo(r),n=this._getLoadedTile(e);if(n)return n}}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(this._source.reparseOverscaled?t.wrapped().key:t.canonical.key)}updateCacheSize(t,e){e=e||this._source.tileSize;const r=Math.ceil(t.width/e)+1,n=Math.ceil(t.height/e)+1,i=Math.floor(r*n*5),s="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,i):i,a="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,s):s;this._cache.setMaxSize(a);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const r in this._tiles){const n=this._tiles[r];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),t[n.tileID.key]=n;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(+t,this._tiles[t]);}}update(t,e,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!r)return;let n;this.updateCacheSize(t,e),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?n=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new Mh(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(n=t.coveringTiles({tileSize:e||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!r,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.hasTile&&(n=n.filter((t=>this._source.hasTile(t))))):n=[];const i=this._updateRetainedTiles(n);if(oy(this._source.type)&&0!==n.length){const t={},e={},r=Object.keys(i);for(const n of r){const r=i[n],s=this._tiles[n];if(!s||s.fadeEndTime&&s.fadeEndTime<=Nt.now())continue;const a=this.findLoadedParent(r,Math.max(r.overscaledZ-sy.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),e[n]=r;}const s=n[n.length-1].overscaledZ;for(const t in this._tiles){const r=this._tiles[t];if(i[t]||!r.hasData())continue;let n=r.tileID;for(;n.overscaledZ>s;){n=n.scaledTo(n.overscaledZ-1);const s=this._tiles[n.key];if(s&&s.hasData()&&e[n.key]){i[t]=r.tileID;break}}}for(const e in t)i[e]||(this._coveredTiles[e]=!0,i[e]=t[e]);}for(const t in i)this._tiles[t].clearFadeHold();const s=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r}(this._tiles,i);for(const t of s){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(+t);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(+t);}_updateRetainedTiles(t){const e={};if(0===t.length)return e;const r={},n=t.reduce(((t,e)=>Math.min(t,e.overscaledZ)),1/0),i=t[0].overscaledZ,s=Math.max(i-sy.maxOverzooming,this._source.minzoom),a=Math.max(i+sy.maxUnderzooming,this._source.minzoom),o={};for(const r of t){const t=this._addTile(r);e[r.key]=r,t.hasData()||n<this._source.maxzoom&&(o[r.key]=r);}this._retainLoadedChildren(o,n,a,e);for(const n of t){let t=this._tiles[n.key];if(t.hasData())continue;if(n.canonical.z>=this._source.maxzoom){const t=n.children(this._source.maxzoom)[0],r=this.getTile(t);if(r&&r.hasData()){e[t.key]=t;continue}}else {const t=n.children(this._source.maxzoom);if(e[t[0].key]&&e[t[1].key]&&e[t[2].key]&&e[t[3].key])continue}let i=t.wasRequested();for(let a=n.overscaledZ-1;a>=s;--a){const s=n.scaledTo(a);if(r[s.key])break;if(r[s.key]=!0,t=this.getTile(s),!t&&i&&(t=this._addTile(s)),t&&(e[s.key]=s,i=t.wasRequested(),t.hasData()))break}}return e}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let r,n=this._tiles[t].tileID;for(;n.overscaledZ>0;){if(n.key in this._loadedParentTiles){r=this._loadedParentTiles[n.key];break}e.push(n.key);const t=n.scaledTo(n.overscaledZ-1);if(r=this._getLoadedTile(t),r)break;n=t;}for(const t of e)this._loadedParentTiles[t]=r;}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const r=Boolean(e);if(!r){const r=this.map?this.map.painter:null;e=new Fd(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom,r,this._isRaster),this._loadTile(e,this._tileLoaded.bind(this,e,t.key,e.state));}return e?(e.uses++,this._tiles[t.key]=e,r||this._source.fire(new Xt("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e):null}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const r=e.getExpiryTimeout();r&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t];}),r));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(+t);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id);}tilesIn(t,e,r){const n=[],i=this.transform;if(!i)return n;const s="globe"===i.projection.name,a=iu(i.center.lng);for(const o in this._tiles){const l=this._tiles[o];if(r&&l.clearQueryDebugViz(),l.holdingForFade())continue;let u;if(s){const t=l.tileID.canonical;if(0===t.z){const e=[Math.abs(S(a,...ly(t,-1))-a),Math.abs(S(a,...ly(t,1))-a)];u=[0,2*e.indexOf(Math.min(...e))-1];}else {const e=[Math.abs(S(a,...ly(t,-1))-a),Math.abs(S(a,...ly(t,0))-a),Math.abs(S(a,...ly(t,1))-a)];u=[e.indexOf(Math.min(...e))-1];}}else u=[0];for(const r of u){const s=t.containsTile(l,i,e,r);s&&n.push(s);}}return n}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));for(const t of e)t.projMatrix=this.transform.calculateProjMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return !0;if(oy(this._source.type))for(const t in this._tiles){const e=this._tiles[t];if(void 0!==e.fadeEndTime&&e.fadeEndTime>=Nt.now())return !0}return !1}setFeatureState(t,e,r){this._state.updateState(t=t||"_geojsonTileLayer",e,r);}removeFeatureState(t,e,r){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,r);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,r){const n=this._tiles[t];n&&n.setDependencies(e,r);}reloadTilesForDependencies(t,e){for(const r in this._tiles)this._tiles[r].hasDependency(t,e)&&this._reloadTile(+r,"reloading");this._cache.filter((r=>!r.hasDependency(t,e)));}_preloadTiles(t,e){const r=new Map,n=Array.isArray(t)?t:[t],i=this.map.painter.terrain,s=this.usedForTerrain&&i?i.getScaledDemTileSize():this._source.tileSize;for(const t of n){const e=t.coveringTiles({tileSize:s,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const t of e)r.set(t.key,t);this.usedForTerrain&&t.updateElevation(!1);}M(Array.from(r.values()),((t,e)=>{const r=new Fd(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster);this._loadTile(r,(t=>{"raster-dem"===this._source.type&&r.dem&&this._backfillDEM(r),e(t,r);}));}),e);}}function ay(t,e){const r=Math.abs(2*t.wrap)-+(t.wrap<0),n=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||n-r||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function oy(t){return "raster"===t||"image"===t||"video"===t||"custom"===t}function ly(t,e){const r=1<<t.z;return [t.x/r+e,(t.x+1)/r+e]}sy.maxOverzooming=10,sy.maxUnderzooming=3;class uy{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const n=r||t.findDEMTileFor(e);if(!n||!n.dem)return;const i=n.dem,s=n.tileID,a=1<<e.canonical.z-s.canonical.z;return new uy(n,n.tileSize/ko/a,[(e.canonical.x/a-s.canonical.x)*i.dim,(e.canonical.y/a-s.canonical.y)*i.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),i=Math.floor(r);return new d(n,i)}getElevationAt(t,e,r,n){const i=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],a=Math.floor(i),o=Math.floor(s),l=this._dem;return n=!!n,r?Mr(Mr(l.get(a,o,n),l.get(a,o+1,n),s-o),Mr(l.get(a+1,o,n),l.get(a+1,o+1,n),s-o),i-a):l.get(a,o,n)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*au(1,t)*this._dem.stride}}class cy{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new ji(ko,16,0),this.featureIndexArray=new ja,this.promoteId=e;}insert(t,e,r,n,i,s=0){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i,s);const o=this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<ko&&n[1]<ko&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new sh(new op(this.rawTileData)).layers,this.sourceLayerCoder=new kd(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const t in this.vtLayers)this.vtFeatures[t]=[];}return this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},s=ai(i.filter),a=t.tileResult,o=t.transform,l=a.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((t,e,r,n)=>Vu(a.bufferedTilespaceGeometry,t,e,r,n)));u.sort(py);let c=null;o.elevation&&u.length>0&&(c=uy.create(o.elevation,this.tileID));const h={};let p;for(let o=0;o<u.length;o++){const l=u[o];if(l===p)continue;p=l;const f=this.featureIndexArray.get(l);let d=null;this.loadMatchingFeature(h,f,s,i.layers,i.availableImages,e,r,n,((e,r,n,i=0)=>(d||(d=bu(e,this.tileID.canonical,t.tileTransform)),r.queryIntersectsFeature(a,e,n,d,this.z,t.transform,t.pixelPosMatrix,c,i))));}return h}loadMatchingFeature(t,e,r,n,i,s,a,o,l){const{featureIndex:u,bucketIndex:c,sourceLayerIndex:h,layoutVertexArrayOffset:p}=e,f=this.bucketLayerIDs[c];if(n&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(n,f))return;const d=this.sourceLayerCoder.decode(h),y=this.vtLayers[d].feature(u);if(r.needGeometry){const t=wu(y,!0);if(!r.filter(new $s(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!r.filter(new $s(this.tileID.overscaledZ),y))return;const m=this.getId(y,d);for(let e=0;e<f.length;e++){const r=f[e];if(n&&n.indexOf(r)<0)continue;const c=s[r];if(!c)continue;let h={};void 0!==m&&o&&(h=o.getState(c.sourceLayer||"_geojsonTileLayer",m));const d=z({},a[r]);d.paint=hy(d.paint,c.paint,y,h,i),d.layout=hy(d.layout,c.layout,y,h,i);const g=!l||l(y,c,h,p);if(!g)continue;const x=new Md(y,this.z,this.x,this.y,m);x.layer=d;let v=t[r];void 0===v&&(v=t[r]=[]),v.push({featureIndex:u,feature:x,intersectionZ:g});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=ai(i);for(const i of t)this.loadMatchingFeature(l,{bucketIndex:r,sourceLayerIndex:n,featureIndex:i,layoutVertexArrayOffset:0},u,s,a,o,e);return l}loadFeature(t){const{featureIndex:e,sourceLayerIndex:r}=t;this.loadVTLayers();const n=this.sourceLayerCoder.decode(r),i=this.vtFeatures[n];if(i[e])return i[e];const s=this.vtLayers[n].feature(e);return i[e]=s,s}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;if(this.promoteId){const n="string"==typeof this.promoteId?this.promoteId:this.promoteId[e];null!=n&&(r=t.properties[n]),"boolean"==typeof r&&(r=Number(r));}return r}}function hy(t,e,r,n,i){return F(t,((t,s)=>{const a=e instanceof Ks?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function py(t,e){return e-t}Oi(cy,"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});class fy{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.image=new Ju({width:t,height:e}),this.positions={},this.uploaded=!1;}getDash(t,e){const r=this.getKey(t,e);return this.positions[r]}trim(){const t=this.width,e=this.height=P(this.nextRow);this.image.resize({width:t,height:e});}getKey(t,e){return t.join(",")+e}getDashRanges(t,e,r){const n=[];let i=t.length%2==1?-t[t.length-1]*r:0,s=t[0]*r,a=!0;n.push({left:i,right:s,isDash:a,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){a=!a;const l=t[e];i=o*r,o+=l,s=o*r,n.push({left:i,right:s,isDash:a,zeroLength:0===l});}return n}addRoundDash(t,e,r){const n=e/2;for(let e=-r;e<=r;e++){const i=this.width*(this.nextRow+r+e);let s=0,a=t[s];for(let o=0;o<this.width;o++){o/a.right>1&&(a=t[++s]);const l=Math.abs(o-a.left),u=Math.abs(o-a.right),c=Math.min(l,u);let h;const p=e/r*(n+1);if(a.isDash){const t=n-Math.abs(p);h=Math.sqrt(c*c+t*t);}else h=n-Math.sqrt(c*c+p*p);this.image.data[i+o]=Math.max(0,Math.min(255,h+128));}}}addRegularDash(t,e){for(let e=t.length-1;e>=0;--e){const r=t[e],n=t[e+1];r.zeroLength?t.splice(e,1):n&&n.isDash===r.isDash&&(n.left=r.left,t.splice(e,1));}const r=t[0],n=t[t.length-1];r.isDash===n.isDash&&(r.left=n.left-this.width,n.right=r.right+this.width);const i=this.width*this.nextRow;let s=0,a=t[s];for(let r=0;r<this.width;r++){r/a.right>1&&(a=t[++s]);const n=Math.abs(r-a.left),o=Math.abs(r-a.right),l=Math.min(n,o);this.image.data[i+r]=Math.max(0,Math.min(255,(a.isDash?l:-l)+e+128));}}addDash(t,e){const r=this.getKey(t,e);if(this.positions[r])return this.positions[r];const n="round"===e,i=n?7:0,s=2*i+1;if(this.nextRow+s>this.height)return U("LineAtlas out of space"),null;0===t.length&&t.push(1);let a=0;for(let e=0;e<t.length;e++)t[e]<0&&(U("Negative value is found in line dasharray, replacing values with 0"),t[e]=0),a+=t[e];if(0!==a){const r=this.width/a,s=this.getDashRanges(t,this.width,r);n?this.addRoundDash(s,r,i):this.addRegularDash(s,"square"===e?.5*r:0);}const o=this.nextRow+i;this.nextRow+=s;const l={tl:[o,i],br:[a,0]};return this.positions[r]=l,l}}Oi(fy,"LineAtlas");class dy{constructor(t){const e={},r=[];for(const n in t){const i=t[n],s=e[n]={};for(const t in i.glyphs){const e=i.glyphs[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const n=e.metrics.localGlyph?2:1,a={x:0,y:0,w:e.bitmap.width+2*n,h:e.bitmap.height+2*n};r.push(a),s[t]=a;}}const{w:n,h:i}=Cp(r),s=new Ju({width:n||1,height:i||1});for(const r in t){const n=t[r];for(const t in n.glyphs){const i=n.glyphs[+t];if(!i||0===i.bitmap.width||0===i.bitmap.height)continue;const a=e[r][t],o=i.metrics.localGlyph?2:1;Ju.copy(i.bitmap,s,{x:0,y:0},{x:a.x+o,y:a.y+o},i.bitmap);}}this.image=s,this.positions=e;}}Oi(dy,"GlyphAtlas");class yy{constructor(t){this.tileID=new Mh(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.canonical=t.tileID.canonical,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.enableTerrain=!!t.enableTerrain,this.isSymbolTile=t.isSymbolTile,this.tileTransform=Vf(t.tileID.canonical,t.projection),this.projection=t.projection;}parse(t,e,r,n,i){this.status="parsing",this.data=t,this.collisionBoxArray=new Ea;const s=new kd(Object.keys(t.layers).sort()),a=new cy(this.tileID,this.promoteId);a.bucketLayerIDs=[];const o={},l=new fy(256,256),u={featureIndex:a,iconDependencies:{},patternDependencies:{},glyphDependencies:{},lineAtlas:l,availableImages:r},c=e.familiesBySource[this.source];for(const e in c){const n=t.layers[e];if(!n)continue;let i=!1,l=!1;for(const t of c[e])"symbol"===t[0].type?i=!0:l=!0;if(!0===this.isSymbolTile&&!i)continue;if(!1===this.isSymbolTile&&!l)continue;1===n.version&&U(`Vector tile source "${this.source}" layer "${e}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const h=s.encode(e),p=[];for(let t=0;t<n.length;t++){const r=n.feature(t),i=a.getId(r,e);p.push({feature:r,id:i,index:t,sourceLayerIndex:h});}for(const t of c[e]){const e=t[0];void 0!==this.isSymbolTile&&"symbol"===e.type!==this.isSymbolTile||e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(my(t,this.zoom,r),(o[e.id]=e.createBucket({index:a.bucketLayerIDs.length,layers:t,zoom:this.zoom,canonical:this.canonical,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:h,sourceID:this.source,enableTerrain:this.enableTerrain,projection:this.projection.spec,availableImages:r})).populate(p,u,this.tileID.canonical,this.tileTransform),a.bucketLayerIDs.push(t.map((t=>t.id))));}}let h,p,f,d;l.trim();const y={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},m=F(u.glyphDependencies,(t=>Object.keys(t).map(Number)));Object.keys(m).length?n.send("getGlyphs",{uid:this.uid,stacks:m},((t,e)=>{h||(h=t,p=e,v.call(this));}),void 0,!1,y):p={};const g=Object.keys(u.iconDependencies);g.length?n.send("getImages",{icons:g,source:this.source,tileID:this.tileID,type:"icons"},((t,e)=>{h||(h=t,f=e,v.call(this));}),void 0,!1,y):f={};const x=Object.keys(u.patternDependencies);function v(){if(h)return i(h);if(p&&f&&d){const t=new dy(p),e=new Dp(f,d);for(const n in o){const i=o[n];i instanceof hd?(my(i.layers,this.zoom,r),kf(i,p,t.positions,f,e.iconPositions,this.showCollisionBoxes,r,this.tileID.canonical,this.tileZoom,this.projection)):i.hasPattern&&(i instanceof jh||i instanceof $c||i instanceof fh)&&(my(i.layers,this.zoom,r),i.addFeatures(u,this.tileID.canonical,e.patternPositions,r,this.tileTransform));}this.status="done",i(null,{buckets:T(o).filter((t=>!t.isEmpty())),featureIndex:a,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,lineAtlas:l,imageAtlas:e,glyphMap:this.returnDependencies?p:null,iconMap:this.returnDependencies?f:null,glyphPositions:this.returnDependencies?t.positions:null});}}x.length?n.send("getImages",{icons:x,source:this.source,tileID:this.tileID,type:"patterns"},((t,e)=>{h||(h=t,d=e,v.call(this));}),void 0,!1,y):d={},v.call(this);}}function my(t,e,r){const n=new $s(e);for(const e of t)e.recalculate(n,r);}class gy{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,n){const i=this.entries[t]=this.entries[t]||{callbacks:[]};if(i.result){const[t,r]=i.result;return this.scheduler?this.scheduler.add((()=>{n(t,r);}),e):n(t,r),()=>{}}return i.callbacks.push(n),i.cancel||(i.cancel=r(((r,n)=>{i.result=[r,n];for(const t of i.callbacks)this.scheduler?this.scheduler.add((()=>{t(r,n);}),e):t(r,n);setTimeout((()=>delete this.entries[t]),3e3);}))),()=>{i.result||(i.callbacks=i.callbacks.filter((t=>t!==n)),i.callbacks.length||(i.cancel(),delete this.entries[t]));}}}function xy(t,e,r){const n=JSON.stringify(t.request);return t.data&&(this.deduped.entries[n]={result:[null,t.data]}),this.deduped.request(n,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},(e=>{const n=ut(t.request,((t,n,i,s)=>{t?e(t):n&&e(null,{vectorTile:r?void 0:new sh(new op(n)),rawData:n,cacheControl:i,expires:s});}));return ()=>{n.cancel(),e();}}),e)}t.ARRAY_TYPE=To,t.AUTH_ERR_MSG=yt,t.Aabb=_l,t.Actor=class{constructor(t,r,n){this.target=t,this.parent=r,this.mapId=n,this.callbacks={},this.cancelCallbacks={},V(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.globalScope=N()?t:e,this.scheduler=new Sd;}send(t,e,r,n,i=!1,s){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[a]=r);const o=X(this.globalScope)?void 0:[];return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:n,mustQueue:i,sourceMapId:this.mapId,data:Gi(e,o)},o),{cancel:()=>{r&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:n,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(e.mustQueue||N()){const t=this.callbacks[r];this.cancelCallbacks[r]=this.scheduler.add((()=>this.processTask(r,e)),t&&t.metadata||{type:"message"});}else this.processTask(r,e);}processTask(t,e){if("<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(Zi(e.error)):r(null,Zi(e.data)));}else {const r=X(this.globalScope)?void 0:[],n=e.hasCallback?(e,n)=>{delete this.cancelCallbacks[t],this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?Gi(e):null,data:Gi(n,r)},r);}:t=>{},i=Zi(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,i,n);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],i.source)[t[1]](i,n);}else n(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}},t.CanonicalTileID=kh,t.Color=Me,t.ColorMode=ey,t.CullFaceMode=iy,t.DEMData=Hd,t.DataConstantProperty=Ys,t.DedupedRequest=gy,t.DepthMode=Jd,t.EXTENT=ko,t.Elevation=class{isDataAvailableAtPoint(t){const e=this._source();if(this.isUsingMockSource()||!e||t.y<0||t.y>1)return !1;const r=e.getSource().maxzoom,n=1<<r,i=Math.floor(t.x),s=Math.floor((t.x-i)*n),a=Math.floor(t.y*n),o=this.findDEMTileFor(new Mh(r,i,r,s,a));return !(!o||!o.dem)}getAtPointOrZero(t,e=0){return this.getAtPoint(t,e)||0}getAtPoint(t,e,r=!0){if(this.isUsingMockSource())return null;null==e&&(e=null);const n=this._source();if(!n)return e;if(t.y<0||t.y>1)return e;const i=n.getSource().maxzoom,s=1<<i,a=Math.floor(t.x),o=t.x-a,l=new Mh(i,a,i,Math.floor(o*s),Math.floor(t.y*s)),u=this.findDEMTileFor(l);if(!u||!u.dem)return e;const c=u.dem,h=1<<u.tileID.canonical.z,p=(o*h-u.tileID.canonical.x)*c.dim,f=(t.y*h-u.tileID.canonical.y)*c.dim,d=Math.floor(p),y=Math.floor(f);return (r?this.exaggeration():1)*Mr(Mr(c.get(d,y),c.get(d,y+1),f-y),Mr(c.get(d+1,y),c.get(d+1,y+1),f-y),p-d)}getAtTileOffset(t,e,r){const n=1<<t.canonical.z;return this.getAtPointOrZero(new pu(t.wrap+(t.canonical.x+e/ko)/n,(t.canonical.y+r/ko)/n))}getAtTileOffsetFunc(t,e,r,n){return i=>{const s=this.getAtTileOffset(t,i.x,i.y),a=n.upVector(t.canonical,i.x,i.y);return Ho(a,a,s*n.upVectorScale(t.canonical,e,r).metersToTile),a}}getForTilePoints(t,e,r,n){if(this.isUsingMockSource())return !1;const i=uy.create(this,t,n);return !!i&&(e.forEach((t=>{t[2]=this.exaggeration()*i.getElevationAt(t[0],t[1],r);})),!0)}getMinMaxForTile(t){if(this.isUsingMockSource())return null;const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,n=e.tileID,i=1<<t.canonical.z-n.canonical.z;let s=t.canonical.x/i-n.canonical.x,a=t.canonical.y/i-n.canonical.y,o=0;for(let e=0;e<t.canonical.z-n.canonical.z&&!r.leaves[o];e++){s*=2,a*=2;const t=2*Math.floor(a)+Math.floor(s);o=r.childOffsets[o]+t,s%=1,a%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}},t.ErrorEvent=Kt,t.EvaluationParameters=$s,t.Event=Xt,t.Evented=Yt,t.FillExtrusionBucket=fh,t.Frustum=wl,t.FrustumCorners=bl,t.GLOBE_RADIUS=Al,t.GLOBE_SCALE_MATCH_LATITUDE=45,t.GLOBE_ZOOM_THRESHOLD_MAX=6,t.GLOBE_ZOOM_THRESHOLD_MIN=5,t.GlobeSharedBuffers=class{constructor(t){this._createGrid(t),this._createPoles(t);}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const t of this._poleSegments)t.destroy();for(const t of this._gridSegments)t.withSkirts.destroy(),t.withoutSkirts.destroy();if(this._wireframeIndexBuffer){this._wireframeIndexBuffer.destroy();for(const t of this._wireframeSegments)t.destroy();}}_fillGridMeshWithLods(t,e){const r=new sa,n=new wa,i=[],s=t+1+2,a=e[0]+1,o=e[0]+1+(1+e.length),l=(t,e,r)=>{let n=t===s-1?t-2:0===t?t:t-1;return n+=r?24575:0,[n,e]};for(let t=0;t<s;++t)r.emplaceBack(...l(t,0,!0));for(let t=0;t<a;++t)for(let e=0;e<s;++e)r.emplaceBack(...l(e,t,(0===e||e===s-1)&&!0));for(let t=0;t<e.length;++t){const n=e[t];for(let t=0;t<s;++t)r.emplaceBack(...l(t,n,!0));}for(let t=0;t<e.length;++t){const a=n.length,l=e[t]+1+2,u=new wa;for(let r=0;r<l-1;r++){const i=r===l-2,a=i?s*(o-e.length+t-r):s;for(let t=0;t<s-1;t++){const e=r*s+t;0===r||i||0===t||t===s-2?(u.emplaceBack(e+1,e,e+a),u.emplaceBack(e+a,e+a+1,e+1)):(n.emplaceBack(e+1,e,e+a),n.emplaceBack(e+a,e+a+1,e+1));}}const c=So.simpleSegment(0,a,r.length,n.length-a);for(let t=0;t<u.uint16.length;t+=3)n.emplaceBack(u.uint16[t],u.uint16[t+1],u.uint16[t+2]);const h=So.simpleSegment(0,a,r.length,n.length-a);i.push({withoutSkirts:c,withSkirts:h});}return {vertices:r,indices:n,segments:i}}_createGrid(t){const e=this._fillGridMeshWithLods(Sl,kl);this._gridSegments=e.segments,this._gridBuffer=t.createVertexBuffer(e.vertices,xl.members),this._gridIndexBuffer=t.createIndexBuffer(e.indices,!0);}_createPoles(t){const e=new wa;for(let t=0;t<=Sl;t++)e.emplaceBack(0,t+1,t+2);this._poleIndexBuffer=t.createIndexBuffer(e,!0);const r=new ka,n=new ka;this._poleSegments=[];for(let t=0,e=0;t<5;t++){const i=360/(1<<t);r.emplaceBack(0,-Al,0,.5,0),n.emplaceBack(0,-Al,0,.5,1);for(let t=0;t<=Sl;t++){const e=t/Sl,s=Mr(0,i,e),[a,o,l]=$l(Jl,Ql,s,Al);r.emplaceBack(a,o,l,e,0),n.emplaceBack(a,o,l,e,1);}this._poleSegments.push(So.simpleSegment(e,0,66,64)),e+=66;}this._poleNorthVertexBuffer=t.createVertexBuffer(r,ml,!1),this._poleSouthVertexBuffer=t.createVertexBuffer(n,ml,!1);}getGridBuffers(t,e){return [this._gridBuffer,this._gridIndexBuffer,e?this._gridSegments[t].withSkirts:this._gridSegments[t].withoutSkirts]}getPoleBuffers(t){return [this._poleNorthVertexBuffer,this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[t]]}getWirefameBuffers(t,e){if(!this._wireframeSegments){const e=new Ma,r=Sl,n=r+1+2,i=1;this._wireframeSegments=[];for(let t=0,s=0;t<kl.length;t++){const a=kl[t];for(let t=i;t<a+i;t++)for(let s=i;s<r+i;s++){const r=t*n+s;e.emplaceBack(r,r+1),e.emplaceBack(r,r+n),e.emplaceBack(r,r+n+1);}const o=a*r*3;this._wireframeSegments.push(So.simpleSegment(0,s,(a+1)*n,o)),s+=o;}this._wireframeIndexBuffer=t.createIndexBuffer(e);}return [this._gridBuffer,this._wireframeIndexBuffer,this._wireframeSegments[e]]}},t.GlyphManager=cf,t.ImagePosition=Pp,t.LivePerformanceUtils=Lt,t.LngLat=ru,t.LngLatBounds=Io,t.LocalGlyphMode=uf,t.MAX_MERCATOR_LATITUDE=cu,t.MercatorCoordinate=pu,t.ONE_EM=Wh,t.OverscaledTileID=Mh,t.PerformanceMarkers=Vt,t.Properties=Js,t.RGBAImage=Qu,t.Ray=vl,t.RequestManager=class{constructor(t,e,r){this._transformRequestFn=t,this._customAccessToken=e,this._silenceAuthErrors=!!r,this._createSkuToken();}_createSkuToken(){const t=function(){let t="";for(let e=0;e<10;e++)t+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",h,t].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=t.token,this._skuTokenExpiresAt=t.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeStyleURL(t,e){if(!mt(t))return t;const r=_t(t);return r.path=`/styles/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeGlyphsURL(t,e){if(!mt(t))return t;const r=_t(t);return r.path=`/fonts/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeSourceURL(t,e,r,n){if(!mt(t))return t;const i=_t(t);return i.path=`/v4/${i.authority}.json`,i.params.push("secure"),r&&i.params.push(`language=${r}`),n&&i.params.push(`worldview=${n}`),this._makeAPIURL(i,this._customAccessToken||e)}normalizeSpriteURL(t,e,r,n){const i=_t(t);return mt(t)?(i.path=`/styles/v1${i.path}/sprite${e}${r}`,this._makeAPIURL(i,this._customAccessToken||n)):(i.path+=`${e}${r}`,At(i))}normalizeTileURL(t,e,r){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!mt(t))return t;const n=_t(t);n.path=n.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${e||r&&"raster"!==n.authority&&512===r?"@2x":""}${s.supported?".webp":"$1"}`),"raster"===n.authority?n.path=`/${i.RASTER_URL_PREFIX}${n.path}`:(n.path=n.path.replace(/^.+\/v4\//,"/"),n.path=`/${i.TILE_URL_VERSION}${n.path}`);const a=this._customAccessToken||function(t){for(const e of t){const t=e.match(/^access_token=(.*)$/);if(t)return t[1]}return null}(n.params)||i.ACCESS_TOKEN;return i.REQUIRE_ACCESS_TOKEN&&a&&this._skuToken&&n.params.push(`sku=${this._skuToken}`),this._makeAPIURL(n,a)}canonicalizeTileURL(t,e){const r=_t(t);if(!r.path.match(/^(\/v4\/|\/raster\/v1\/)/)||!r.path.match(/\.[\w]+$/))return t;let n="mapbox://";r.path.match(/^\/raster\/v1\//)?n+=`raster/${r.path.replace(`/${i.RASTER_URL_PREFIX}/`,"")}`:n+=`tiles/${r.path.replace(`/${i.TILE_URL_VERSION}/`,"")}`;let s=r.params;return e&&(s=s.filter((t=>!t.match(/^access_token=/)))),s.length&&(n+=`?${s.join("&")}`),n}canonicalizeTileset(t,e){const r=!!e&&mt(e),n=[];for(const e of t.tiles||[])gt(e)?n.push(this.canonicalizeTileURL(e,r)):n.push(e);return n}_makeAPIURL(t,e){const r="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",n=_t(i.API_URL);if(t.protocol=n.protocol,t.authority=n.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==n.path&&(t.path=`${n.path}${t.path}`),!i.REQUIRE_ACCESS_TOKEN)return At(t);if(e=e||i.ACCESS_TOKEN,!this._silenceAuthErrors){if(!e)throw new Error(`An API access token is required to use Mapbox GL. ${r}`);if("s"===e[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${r}`)}return t.params=t.params.filter((t=>-1===t.indexOf("access_token"))),t.params.push(`access_token=${e||""}`),At(t)}},t.ResourceType=st,t.SegmentVector=So,t.SourceCache=sy,t.StencilMode=ty,t.StructArrayLayout1ui2=Ta,t.StructArrayLayout2f1f2i16=xa,t.StructArrayLayout2i4=sa,t.StructArrayLayout2ui4=Ma,t.StructArrayLayout3f12=ba,t.StructArrayLayout3ui6=wa,t.StructArrayLayout4i8=oa,t.StructArrayLayout5f20=ka,t.Texture=_d,t.Tile=Fd,t.Transitionable=qs,t.Uniform1f=to,t.Uniform1i=class extends Qa{constructor(t){super(t),this.current=0;}set(t,e,r){this.fetchUniformLocation(t,e)&&this.current!==r&&(this.current=r,this.gl.uniform1i(this.location,r));}},t.Uniform2f=class extends Qa{constructor(t){super(t),this.current=[0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]||(this.current=r,this.gl.uniform2f(this.location,r[0],r[1])));}},t.Uniform3f=class extends Qa{constructor(t){super(t),this.current=[0,0,0];}set(t,e,r){this.fetchUniformLocation(t,e)&&(r[0]===this.current[0]&&r[1]===this.current[1]&&r[2]===this.current[2]||(this.current=r,this.gl.uniform3f(this.location,r[0],r[1],r[2])));}},t.Uniform4f=eo,t.UniformColor=ro,t.UniformMatrix2f=class extends Qa{constructor(t){super(t),this.current=so;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<4;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix2fv(this.location,!1,r);break}}},t.UniformMatrix3f=class extends Qa{constructor(t){super(t),this.current=io;}set(t,e,r){if(this.fetchUniformLocation(t,e))for(let t=0;t<9;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix3fv(this.location,!1,r);break}}},t.UniformMatrix4f=class extends Qa{constructor(t){super(t),this.current=no;}set(t,e,r){if(this.fetchUniformLocation(t,e)){if(r[12]!==this.current[12]||r[0]!==this.current[0])return this.current=r,void this.gl.uniformMatrix4fv(this.location,!1,r);for(let t=1;t<16;t++)if(r[t]!==this.current[t]){this.current=r,this.gl.uniformMatrix4fv(this.location,!1,r);break}}}},t.UnwrappedTileID=Ih,t.ValidationError=Wn,t.VectorTileFeature=ah,t.VectorTileWorkerSource=class extends Yt{constructor(t,e,r,n,i){super(),this.actor=t,this.layerIndex=e,this.availableImages=r,this.loadVectorData=i||xy,this.loading={},this.loaded={},this.deduped=new gy(t.scheduler),this.isSpriteLoaded=n,this.scheduler=t.scheduler;}loadTile(t,e){const r=t.uid,n=t&&t.request,i=n&&n.collectResourceTiming,s=this.loading[r]=new yy(t);s.abort=this.loadVectorData(t,((a,o)=>{const l=!this.loading[r];if(delete this.loading[r],l||a||!o)return s.status="done",l||(this.loaded[r]=s),e(a);const u=o.rawData,c={};o.expires&&(c.expires=o.expires),o.cacheControl&&(c.cacheControl=o.cacheControl),s.vectorTile=o.vectorTile||new sh(new op(u));const h=()=>{s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,((t,r)=>{if(t||!r)return e(t);const s={};if(i){const t=jt(n);t.length>0&&(s.resourceTiming=JSON.parse(JSON.stringify(t)));}e(null,z({rawTileData:u.slice(0)},r,c,s));}));};this.isSpriteLoaded?h():this.once("isSpriteLoaded",(()=>{this.scheduler?this.scheduler.add(h,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom}):h();})),this.loaded=this.loaded||{},this.loaded[r]=s;}));}reloadTile(t,e){const r=this.loaded,n=t.uid,i=this;if(r&&r[n]){const s=r[n];s.showCollisionBoxes=t.showCollisionBoxes,s.enableTerrain=!!t.enableTerrain,s.projection=t.projection,s.tileTransform=Vf(t.tileID.canonical,t.projection);const a=(t,r)=>{const n=s.reloadCallback;n&&(delete s.reloadCallback,s.parse(s.vectorTile,i.layerIndex,this.availableImages,i.actor,n)),e(t,r);};"parsing"===s.status?s.reloadCallback=a:"done"===s.status&&(s.vectorTile?s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,a):a());}}abortTile(t,e){const r=t.uid,n=this.loading[r];n&&(n.abort&&n.abort(),delete this.loading[r]),e();}removeTile(t,e){const r=this.loaded,n=t.uid;r&&r[n]&&delete r[n],e();}},t.WritingMode=Vp,t.ZoomDependentExpression=Xn,t.add=Go,t.addDynamicAttributes=od,t.adjoint=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8];return t[0]=a*c-o*u,t[1]=i*u-n*c,t[2]=n*o-i*a,t[3]=o*l-s*c,t[4]=r*c-i*l,t[5]=i*s-r*o,t[6]=s*u-a*l,t[7]=n*l-r*u,t[8]=r*a-n*s,t},t.asyncAll=M,t.bezier=_,t.bindAll=V,t.boundsAttributes=Vd,t.bufferConvexPolygon=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=I(n-1,-1,t.length-1),s=I(n+1,-1,t.length-1),a=t[n],o=t[s],l=t[i].sub(a).unit(),u=o.sub(a).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(a.add(h));}return r},t.cacheEntryPossiblyAdded=function(t){it++,it>tt&&(t.getActor().send("enforceCacheSizeLimit",Q),it=0);},t.calculateGlobeLabelMatrix=function(t,e){const{x:r,y:n}=t.point,i=Xl(r,n,t.worldSize/t._pixelsPerMercatorPixel,0,0);return Po(i,i,Zl(Pl(e)))},t.calculateGlobeMatrix=function(t){const{x:e,y:r}=t.point,{lng:n,lat:i}=t._center;return Xl(e,r,t.worldSize,n,i)},t.calculateGlobeMercatorMatrix=function(t){const e=t.pixelsPerMeter,r=e/au(1,t.center.lat),n=Eo(new Float64Array(16));return Do(n,n,[t.point.x,t.point.y,0]),Vo(n,n,[r,r,e]),Float32Array.from(n)},t.circumferenceAtLatitude=nu,t.clamp=S,t.clearTileCache=function(t){if(!et())return;const r=e.caches.delete(H);t&&r.catch(t).then((()=>t()));},t.clipLine=sf,t.clone=function(t){var e=new To(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.clone$1=j,t.collisionCircleLayout=Hh,t.config=i,t.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},t.create=function(){var t=new To(16);return To!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.create$1=zo,t.createExpression=Gn,t.createLayout=na,t.createStyleLayer=function(t){return "custom"===t.type?new xd(t):new wd[t.type](t)},t.cross=tl,t.degToRad=x,t.distance=function(t,e){return Math.hypot(e[0]-t[0],e[1]-t[1],e[2]-t[2])},t.div=function(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t},t.dot=Qo,t.earthRadius=tu,t.ease=A,t.easeCubicInOut=w,t.ecefToLatLng=function([t,e,r]){const n=Math.hypot(t,e,r),i=Math.atan2(t,r),s=.5*Math.PI-Math.acos(-e/n);return new ru(v(i),v(s))},t.emitValidationErrors=Ri,t.endsWith=L,t.enforceCacheSizeLimit=function(t){rt(),W&&W.then((e=>{e.keys().then((r=>{for(let n=0;n<r.length-t;n++)e.delete(r[n]);}));}));},t.evaluateSizeForFeature=tp,t.evaluateSizeForZoom=ep,t.evaluateVariableOffset=Sf,t.evented=Ls,t.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},t.exactEquals$1=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},t.exported=Nt,t.exported$1=s,t.extend=z,t.extend$1=Wt,t.fillExtrusionHeightLift=bh,t.filterObject=R,t.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},t.fromQuat=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=r+r,o=n+n,l=i+i,u=r*a,c=n*a,h=n*o,p=i*a,f=i*o,d=i*l,y=s*a,m=s*o,g=s*l;return t[0]=1-h-d,t[1]=c+g,t[2]=p-m,t[3]=0,t[4]=c-g,t[5]=1-u-d,t[6]=f+y,t[7]=0,t[8]=p+m,t[9]=f-y,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.fromRotation=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.fromScaling=Ro,t.furthestTileCorner=function(t){const e=Math.round((t+45+360)%360/90)%4;return b[e]},t.getAABBPointSquareDist=function(t,e,r){let n=0;for(let i=0;i<2;++i){const s=r?r[i]:0;t[i]>s&&(n+=(t[i]-s)*(t[i]-s)),e[i]<s&&(n+=(s-e[i])*(s-e[i]));}return n},t.getAnchorAlignment=Zp,t.getAnchorJustification=If,t.getBounds=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {min:new d(e,r),max:new d(n,i)}},t.getColumn=Y,t.getGridMatrix=function(t,e,r,n){const i=e.getNorth(),s=e.getSouth(),a=e.getWest(),o=e.getEast(),l=1<<t.z,u=o-a,c=i-s,h=u/Sl,p=-c/kl[r],f=[0,h,0,p,0,0,i,a,0];if(t.z>0){const t=180/n;Bo(f,f,[t/u+1,0,0,0,t/c+1,0,-.5*t/h,.5*t/p,1]);}return f[2]=l,f[5]=t.x,f[8]=t.y,f},t.getImage=dt,t.getJSON=function(t,e){return lt(z(t,{type:"json"}),e)},t.getLatitudinalLod=function(t){const e=cu-5;t=S(t,-e,e)/e*90;const r=Math.pow(Math.abs(Math.sin(x(t))),3);return Math.round(r*(kl.length-1))},t.getMapSessionAPI=Pt,t.getPerformanceMeasurement=jt,t.getProjection=rd,t.getRTLTextPluginStatus=Fs,t.getReferrer=ot,t.getTilePoint=function(t,{x:e,y:r},n=0){return new d(((e-n)*t.scale-t.x)*ko,(r*t.scale-t.y)*ko)},t.getTileVec3=function(t,e,r=0){return No(((e.x-r)*t.scale-t.x)*ko,(e.y*t.scale-t.y)*ko,uu(e.z,e.y))},t.getVideo=function(t,r){const n=e.document.createElement("video");n.muted=!0,n.onloadstart=function(){r(null,n);};for(let r=0;r<t.length;r++){const i=e.document.createElement("source");ct(t[r])||(n.crossOrigin="Anonymous"),i.src=t[r],n.appendChild(i);}return {cancel:()=>{}}},t.globeCenterToScreenPoint=function(t){const e=[0,0,0],r=Eo(new Float64Array(16));return Po(r,t.pixelMatrix,t.globeMatrix),el(e,e,r),new d(e[0],e[1])},t.globeDenormalizeECEF=Zl,t.globeECEFOrigin=function(t,e){const r=[0,0,0];return el(r,r,Gl(Pl(e.canonical))),el(r,r,t),r},t.globeMetersToEcef=zl,t.globeNormalizeECEF=Gl,t.globePixelsToTileUnits=function(t,e){return ko/(512*Math.pow(2,t))*ql(Pl(e))},t.globePoleMatrixForTile=function(t,e,r){const n=Eo(new Float64Array(16)),i=(e/(1<<t)-.5)*Math.PI*2;return Fo(n,r.globeMatrix,i),Float32Array.from(n)},t.globeTileBounds=Pl,t.globeTiltAtLngLat=Yl,t.globeToMercatorTransition=Kl,t.globeUseCustomAntiAliasing=function(t,e,r){const n=Kl(r.zoom),i=t.style.map._antialias,s=!!e.extStandardDerivatives,a=e.extStandardDerivativesForceOff||t.terrain&&t.terrain.exaggeration()>0;return 0===n&&!i&&!a&&s},t.identity=Eo,t.identity$1=hl,t.invert=Co,t.isFullscreen=function(){return !!e.document.fullscreenElement||!!e.document.webkitFullscreenElement},t.isLngLatBehindGlobe=Hl,t.isMapAuthenticated=function(t){return Dt.has(t)},t.isMapboxURL=mt,t.isSafariWithAntialiasingBug=function(t){const e=t.navigator?t.navigator.userAgent:null;return !!X(t)&&e&&(e.match("Version/15.4")||e.match("Version/15.5")||e.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/))},t.latFromMercatorY=lu,t.latLngToECEF=Ul,t.len=al,t.length=qo,t.length$1=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},t.lngFromMercatorX=ou,t.loadVectorTile=xy,t.makeRequest=lt,t.mapValue=function(t,e,r,n,i){return S((t-e)/(r-e)*(i-n)+n,n,i)},t.mercatorScale=hu,t.mercatorXfromLng=iu,t.mercatorYfromLat=su,t.mercatorZfromAltitude=au,t.mul=$o,t.mul$1=sl,t.multiply=Po,t.multiply$1=Bo,t.multiply$2=Xo,t.nextPowerOfTwo=P,t.normalize=Jo,t.normalize$1=dl,t.normalize$2=ll,t.number=Mr,t.ortho=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.pbf=op,t.perspective=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t},t.pick=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.plugin=js,t.pointGeometry=d,t.polesInViewport=function(t){const e=Eo(new Float64Array(16));Po(e,t.pixelMatrix,t.globeMatrix);const r=[0,Il,0],n=[0,Ml,0];return el(r,r,e),el(n,n,e),[r[0]>0&&r[0]<=t.width&&r[1]>0&&r[1]<=t.height&&!Hl(t,new ru(t.center.lat,90)),n[0]>0&&n[0]<=t.width&&n[1]>0&&n[1]<=t.height&&!Hl(t,new ru(t.center.lat,-90))]},t.polygonContainsPoint=Du,t.polygonIntersectsBox=Vu,t.polygonIntersectsPolygon=ku,t.polygonizeBounds=function(t,e,r=0,n=!0){const i=new d(r,r),s=t.sub(i),a=e.add(i),o=[s,new d(a.x,s.y),a,new d(s.x,a.y)];return n&&o.push(s.clone()),o},t.posAttributes=xl,t.postMapLoadEvent=zt,t.postPerformanceEvent=Et,t.postTurnstileEvent=Mt,t.potpack=Cp,t.prevPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.radToDeg=v,t.refProperties=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.registerForPluginStateChange=function(t){return t({pluginStatus:Cs,pluginURL:Ps}),Ls.on("pluginStateChange",t),t},t.removeAuthState=function(t){Dt.delete(t);},t.renderColorRamp=ec,t.resample=du,t.rotateX=Lo,t.rotateX$1=pl,t.rotateY=Fo,t.rotateY$1=fl,t.rotateZ=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.rotateZ$1=function(t,e,r){r*=.5;var n=e[0],i=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=n*l+i*o,t[1]=i*l-n*o,t[2]=s*l+a*o,t[3]=a*l-s*o,t},t.scale=Vo,t.scale$1=ol,t.scale$2=Ho,t.scaleAndAdd=Wo,t.set=function(t,e,r,n){return t[0]=e,t[1]=r,t[2]=n,t},t.setCacheLimits=function(t,e){Q=t,tt=e;},t.setColumn=function(t,e,r){t[4*e+0]=r[0],t[4*e+1]=r[1],t[4*e+2]=r[2],t[4*e+3]=r[3];},t.setRTLTextPlugin=function(t,e,r=!1){if(Cs===Ts||Cs===zs||Cs===Bs)throw new Error("setRTLTextPlugin cannot be called multiple times.");Ps=Nt.resolveURL(t),Cs=Ts,Es=e,Vs(),r||Rs();},t.smoothstep=k,t.spec=Ht,t.squaredLength=function(t){var e=t[0],r=t[1],n=t[2];return e*e+r*r+n*n},t.storeAuthState=function(t,e){e?Dt.add(t):Dt.delete(t);},t.sub=il,t.subtract=Zo,t.symbolSize=rp,t.tileAABB=function(t,e,r,n,i,s,a,o,l){if("globe"===l.name)return Fl(t,e,new kh(r,n,i));const u=Vf({z:r,x:n,y:i},l);return new _l([(s+u.x/u.scale)*e,e*(u.y/u.scale),a],[(s+u.x2/u.scale)*e,e*(u.y2/u.scale),o])},t.tileCornersToBounds=Rl,t.tileTransform=Vf,t.transformMat3=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},t.transformMat4=el,t.transformMat4$1=ul,t.transformQuat=rl,t.transitionTileAABBinECEF=Vl,t.translate=Do,t.transpose=function(t,e){if(t===e){var r=e[1],n=e[2],i=e[5];t[1]=e[3],t[2]=e[6],t[3]=r,t[5]=e[7],t[6]=n,t[7]=i;}else t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8];return t},t.triggerPluginCompletionEvent=Ds,t.uniqueId=E,t.updateGlobeVertexNormal=function(t,e,r,n,i){const s=5*e+2;t.float32[s+0]=r,t.float32[s+1]=n,t.float32[s+2]=i;},t.validateCustomStyleLayer=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.validateFilter=t=>Fi(xi(t)),t.validateFog=t=>Fi(Bi(t)),t.validateLayer=t=>Fi(Ai(t)),t.validateLight=t=>Fi(Ti(t)),t.validateSource=t=>Fi(Ii(t)),t.validateStyle=Di,t.validateTerrain=t=>Fi(zi(t)),t.values=T,t.vectorTile=Xc,t.version=r,t.warnOnce=U,t.window=e,t.wrap=I;}));
    
    define(["./shared"],(function(e){"use strict";function t(e){if("number"==typeof e||"boolean"==typeof e||"string"==typeof e||null==e)return JSON.stringify(e);if(Array.isArray(e)){let r="[";for(const o of e)r+=`${t(o)},`;return `${r}]`}let r="{";for(const o of Object.keys(e).sort())r+=`${o}:${t(e[o])},`;return `${r}}`}function r(r){let o="";for(const n of e.refProperties)o+=`/${t(r[n])}`;return o}class o{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,o){for(const r of t)this._layerConfigs[r.id]=r,(this._layers[r.id]=e.createStyleLayer(r)).compileFilter(),this.keyCache[r.id]&&delete this.keyCache[r.id];for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const n=function(e,t){const o={};for(let n=0;n<e.length;n++){const i=t&&t[e[n].id]||r(e[n]);t&&(t[e[n].id]=i);let s=o[i];s||(s=o[i]=[]),s.push(e[n]);}const n=[];for(const e in o)n.push(o[e]);return n}(e.values(this._layerConfigs),this.keyCache);for(const e of n){const t=e.map((e=>this._layers[e.id])),r=t[0];if("none"===r.visibility)continue;const o=r.source||"";let n=this.familiesBySource[o];n||(n=this.familiesBySource[o]={});const i=r.sourceLayer||"_geojsonTileLayer";let s=n[i];s||(s=n[i]=[]),s.push(t);}}}class n{loadTile(t,r){const{uid:o,encoding:n,rawImageData:i,padding:s,buildQuadTree:a}=t,l=e.window.ImageBitmap&&i instanceof e.window.ImageBitmap?this.getImageData(i,s):i;r(null,new e.DEMData(o,l,n,s<1,a));}getImageData(e,t){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(e.width,e.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d",{willReadFrequently:!0})),this.offscreenCanvas.width=e.width,this.offscreenCanvas.height=e.height,this.offscreenCanvasContext.drawImage(e,0,0,e.width,e.height);const r=this.offscreenCanvasContext.getImageData(-t,-t,e.width+2*t,e.height+2*t);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),r}}var i=function e(t,r){var o,n=t&&t.type;if("FeatureCollection"===n)for(o=0;o<t.features.length;o++)e(t.features[o],r);else if("GeometryCollection"===n)for(o=0;o<t.geometries.length;o++)e(t.geometries[o],r);else if("Feature"===n)e(t.geometry,r);else if("Polygon"===n)s(t.coordinates,r);else if("MultiPolygon"===n)for(o=0;o<t.coordinates.length;o++)s(t.coordinates[o],r);return t};function s(e,t){if(0!==e.length){a(e[0],t);for(var r=1;r<e.length;r++)a(e[r],!t);}}function a(e,t){for(var r=0,o=0,n=0,i=e.length,s=i-1;n<i;s=n++){var a=(e[n][0]-e[s][0])*(e[s][1]+e[n][1]),l=r+a;o+=Math.abs(r)>=Math.abs(a)?r-l+a:a-l+r,r=l;}r+o>=0!=!!t&&e.reverse();}const l=e.VectorTileFeature.prototype.toGeoJSON;class u{constructor(t){this._feature=t,this.extent=e.EXTENT,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const r of this._feature.geometry)t.push([new e.pointGeometry(r[0],r[1])]);return t}{const t=[];for(const r of this._feature.geometry){const o=[];for(const t of r)o.push(new e.pointGeometry(t[0],t[1]));t.push(o);}return t}}toGeoJSON(e,t,r){return l.call(this,e,t,r)}}class h{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.EXTENT,this.length=t.length,this._features=t;}feature(e){return new u(this._features[e])}}var c={},f={get exports(){return c},set exports(e){c=e;}},p=e.pointGeometry,g=e.vectorTile.VectorTileFeature,d=m;function m(e,t){this.options=t||{},this.features=e,this.length=e.length;}function y(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}m.prototype.feature=function(e){return new y(this.features[e],this.options.extent)},y.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var t=0;t<e.length;t++){for(var r=e[t],o=[],n=0;n<r.length;n++)o.push(new p(r[n][0],r[n][1]));this.geometry.push(o);}return this.geometry},y.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,r=-1/0,o=1/0,n=-1/0,i=0;i<e.length;i++)for(var s=e[i],a=0;a<s.length;a++){var l=s[a];t=Math.min(t,l.x),r=Math.max(r,l.x),o=Math.min(o,l.y),n=Math.max(n,l.y);}return [t,o,r,n]},y.prototype.toGeoJSON=g.prototype.toGeoJSON;var v=e.pbf,x=d;function w(e){var t=new v;return function(e,t){for(var r in e.layers)t.writeMessage(3,S,e.layers[r]);}(e,t),t.finish()}function S(e,t){var r;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var o={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<e.length;r++)o.feature=e.feature(r),t.writeMessage(2,M,o);var n=o.keys;for(r=0;r<n.length;r++)t.writeStringField(3,n[r]);var i=o.values;for(r=0;r<i.length;r++)t.writeMessage(4,T,i[r]);}function M(e,t){var r=e.feature;void 0!==r.id&&t.writeVarintField(1,r.id),t.writeMessage(2,P,e),t.writeVarintField(3,r.type),t.writeMessage(4,I,r);}function P(e,t){var r=e.feature,o=e.keys,n=e.values,i=e.keycache,s=e.valuecache;for(var a in r.properties){var l=r.properties[a],u=i[a];if(null!==l){void 0===u&&(o.push(a),i[a]=u=o.length-1),t.writeVarint(u);var h=typeof l;"string"!==h&&"boolean"!==h&&"number"!==h&&(l=JSON.stringify(l));var c=h+":"+l,f=s[c];void 0===f&&(n.push(l),s[c]=f=n.length-1),t.writeVarint(f);}}}function b(e,t){return (t<<3)+(7&e)}function k(e){return e<<1^e>>31}function I(e,t){for(var r=e.loadGeometry(),o=e.type,n=0,i=0,s=r.length,a=0;a<s;a++){var l=r[a],u=1;1===o&&(u=l.length),t.writeVarint(b(1,u));for(var h=3===o?l.length-1:l.length,c=0;c<h;c++){1===c&&1!==o&&t.writeVarint(b(2,h-1));var f=l[c].x-n,p=l[c].y-i;t.writeVarint(k(f)),t.writeVarint(k(p)),n+=f,i+=p;}3===o&&t.writeVarint(b(7,1));}}function T(e,t){var r=typeof e;"string"===r?t.writeStringField(1,e):"boolean"===r?t.writeBooleanField(7,e):"number"===r&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}function _(e,t,r,o,n,i){if(n-o<=r)return;const s=o+n>>1;L(e,t,s,o,n,i%2),_(e,t,r,o,s-1,i+1),_(e,t,r,s+1,n,i+1);}function L(e,t,r,o,n,i){for(;n>o;){if(n-o>600){const s=n-o+1,a=r-o+1,l=Math.log(s),u=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*u*(s-u)/s)*(a-s/2<0?-1:1);L(e,t,r,Math.max(o,Math.floor(r-a*u/s+h)),Math.min(n,Math.floor(r+(s-a)*u/s+h)),i);}const s=t[2*r+i];let a=o,l=n;for(C(e,t,o,r),t[2*n+i]>s&&C(e,t,o,n);a<l;){for(C(e,t,a,l),a++,l--;t[2*a+i]<s;)a++;for(;t[2*l+i]>s;)l--;}t[2*o+i]===s?C(e,t,o,l):(l++,C(e,t,l,n)),l<=r&&(o=l+1),r<=l&&(n=l-1);}}function C(e,t,r,o){O(e,r,o),O(t,2*r,2*o),O(t,2*r+1,2*o+1);}function O(e,t,r){const o=e[t];e[t]=e[r],e[r]=o;}function z(e,t,r,o){const n=e-r,i=t-o;return n*n+i*i}f.exports=w,c.fromVectorTileJs=w,c.fromGeojsonVt=function(e,t){t=t||{};var r={};for(var o in e)r[o]=new x(e[o].features,t),r[o].name=o,r[o].version=t.version,r[o].extent=t.extent;return w({layers:r})},c.GeoJSONWrapper=x;const E=e=>e[0],F=e=>e[1];class N{constructor(e,t=E,r=F,o=64,n=Float64Array){this.nodeSize=o,this.points=e;const i=e.length<65536?Uint16Array:Uint32Array,s=this.ids=new i(e.length),a=this.coords=new n(2*e.length);for(let o=0;o<e.length;o++)s[o]=o,a[2*o]=t(e[o]),a[2*o+1]=r(e[o]);_(s,a,o,0,s.length-1,0);}range(e,t,r,o){return function(e,t,r,o,n,i,s){const a=[0,e.length-1,0],l=[];let u,h;for(;a.length;){const c=a.pop(),f=a.pop(),p=a.pop();if(f-p<=s){for(let s=p;s<=f;s++)u=t[2*s],h=t[2*s+1],u>=r&&u<=n&&h>=o&&h<=i&&l.push(e[s]);continue}const g=Math.floor((p+f)/2);u=t[2*g],h=t[2*g+1],u>=r&&u<=n&&h>=o&&h<=i&&l.push(e[g]);const d=(c+1)%2;(0===c?r<=u:o<=h)&&(a.push(p),a.push(g-1),a.push(d)),(0===c?n>=u:i>=h)&&(a.push(g+1),a.push(f),a.push(d));}return l}(this.ids,this.coords,e,t,r,o,this.nodeSize)}within(e,t,r){return function(e,t,r,o,n,i){const s=[0,e.length-1,0],a=[],l=n*n;for(;s.length;){const u=s.pop(),h=s.pop(),c=s.pop();if(h-c<=i){for(let n=c;n<=h;n++)z(t[2*n],t[2*n+1],r,o)<=l&&a.push(e[n]);continue}const f=Math.floor((c+h)/2),p=t[2*f],g=t[2*f+1];z(p,g,r,o)<=l&&a.push(e[f]);const d=(u+1)%2;(0===u?r-n<=p:o-n<=g)&&(s.push(c),s.push(f-1),s.push(d)),(0===u?r+n>=p:o+n>=g)&&(s.push(f+1),s.push(h),s.push(d));}return a}(this.ids,this.coords,e,t,r,this.nodeSize)}}const j={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},Z=Math.fround||(G=new Float32Array(1),e=>(G[0]=+e,G[0]));var G;class J{constructor(e){this.options=B(Object.create(j),e),this.trees=new Array(this.options.maxZoom+1);}load(e){const{log:t,minZoom:r,maxZoom:o,nodeSize:n}=this.options;t&&console.time("total time");const i=`prepare ${e.length} points`;t&&console.time(i),this.points=e;let s=[];for(let t=0;t<e.length;t++)e[t].geometry&&s.push(Y(e[t],t));this.trees[o+1]=new N(s,R,q,n,Float32Array),t&&console.timeEnd(i);for(let e=o;e>=r;e--){const r=+Date.now();s=this._cluster(s,e),this.trees[e]=new N(s,R,q,n,Float32Array),t&&console.log("z%d: %d clusters in %dms",e,s.length,+Date.now()-r);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let r=((e[0]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,e[1]));let n=180===e[2]?180:((e[2]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)r=-180,n=180;else if(r>n){const e=this.getClusters([r,o,180,i],t),s=this.getClusters([-180,o,n,i],t);return e.concat(s)}const s=this.trees[this._limitZoom(t)],a=s.range(A(r),D(i),A(n),D(o)),l=[];for(const e of a){const t=s.points[e];l.push(t.numPoints?X(t):this.points[t.index]);}return l}getChildren(e){const t=this._getOriginId(e),r=this._getOriginZoom(e),o="No cluster with the specified id.",n=this.trees[r];if(!n)throw new Error(o);const i=n.points[t];if(!i)throw new Error(o);const s=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=n.within(i.x,i.y,s),l=[];for(const t of a){const r=n.points[t];r.parentId===e&&l.push(r.numPoints?X(r):this.points[r.index]);}if(0===l.length)throw new Error(o);return l}getLeaves(e,t,r){const o=[];return this._appendLeaves(o,e,t=t||10,r=r||0,0),o}getTile(e,t,r){const o=this.trees[this._limitZoom(e)],n=Math.pow(2,e),{extent:i,radius:s}=this.options,a=s/i,l=(r-a)/n,u=(r+1+a)/n,h={features:[]};return this._addTileFeatures(o.range((t-a)/n,l,(t+1+a)/n,u),o.points,t,r,n,h),0===t&&this._addTileFeatures(o.range(1-a/n,l,1,u),o.points,n,r,n,h),t===n-1&&this._addTileFeatures(o.range(0,l,a/n,u),o.points,-1,r,n,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const r=this.getChildren(e);if(t++,1!==r.length)break;e=r[0].properties.cluster_id;}return t}_appendLeaves(e,t,r,o,n){const i=this.getChildren(t);for(const t of i){const i=t.properties;if(i&&i.cluster?n+i.point_count<=o?n+=i.point_count:n=this._appendLeaves(e,i.cluster_id,r,o,n):n<o?n++:e.push(t),e.length===r)break}return n}_addTileFeatures(e,t,r,o,n,i){for(const s of e){const e=t[s],a=e.numPoints;let l,u,h;if(a)l=V(e),u=e.x,h=e.y;else {const t=this.points[e.index];l=t.properties,u=A(t.geometry.coordinates[0]),h=D(t.geometry.coordinates[1]);}const c={type:1,geometry:[[Math.round(this.options.extent*(u*n-r)),Math.round(this.options.extent*(h*n-o))]],tags:l};let f;a?f=e.id:this.options.generateId?f=e.index:this.points[e.index].id&&(f=this.points[e.index].id),void 0!==f&&(c.id=f),i.features.push(c);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const r=[],{radius:o,extent:n,reduce:i,minPoints:s}=this.options,a=o/(n*Math.pow(2,t));for(let o=0;o<e.length;o++){const n=e[o];if(n.zoom<=t)continue;n.zoom=t;const l=this.trees[t+1],u=l.within(n.x,n.y,a),h=n.numPoints||1;let c=h;for(const e of u){const r=l.points[e];r.zoom>t&&(c+=r.numPoints||1);}if(c>h&&c>=s){let e=n.x*h,s=n.y*h,a=i&&h>1?this._map(n,!0):null;const f=(o<<5)+(t+1)+this.points.length;for(const r of u){const o=l.points[r];if(o.zoom<=t)continue;o.zoom=t;const u=o.numPoints||1;e+=o.x*u,s+=o.y*u,o.parentId=f,i&&(a||(a=this._map(n,!0)),i(a,this._map(o)));}n.parentId=f,r.push(W(e/c,s/c,f,c,a));}else if(r.push(n),c>1)for(const e of u){const o=l.points[e];o.zoom<=t||(o.zoom=t,r.push(o));}}return r}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t){if(e.numPoints)return t?B({},e.properties):e.properties;const r=this.points[e.index].properties,o=this.options.map(r);return t&&o===r?B({},o):o}}function W(e,t,r,o,n){return {x:Z(e),y:Z(t),zoom:1/0,id:r,parentId:-1,numPoints:o,properties:n}}function Y(e,t){const[r,o]=e.geometry.coordinates;return {x:Z(A(r)),y:Z(D(o)),zoom:1/0,index:t,parentId:-1}}function X(e){return {type:"Feature",id:e.id,properties:V(e),geometry:{type:"Point",coordinates:[(t=e.x,360*(t-.5)),$(e.y)]}};var t;}function V(e){const t=e.numPoints,r=t>=1e4?`${Math.round(t/1e3)}k`:t>=1e3?Math.round(t/100)/10+"k":t;return B(B({},e.properties),{cluster:!0,cluster_id:e.id,point_count:t,point_count_abbreviated:r})}function A(e){return e/360+.5}function D(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function $(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function B(e,t){for(const r in t)e[r]=t[r];return e}function R(e){return e.x}function q(e){return e.y}function U(e,t,r,o){for(var n,i=o,s=r-t>>1,a=r-t,l=e[t],u=e[t+1],h=e[r],c=e[r+1],f=t+3;f<r;f+=3){var p=Q(e[f],e[f+1],l,u,h,c);if(p>i)n=f,i=p;else if(p===i){var g=Math.abs(f-s);g<a&&(n=f,a=g);}}i>o&&(n-t>3&&U(e,t,n,o),e[n+2]=i,r-n>3&&U(e,n,r,o));}function Q(e,t,r,o,n,i){var s=n-r,a=i-o;if(0!==s||0!==a){var l=((e-r)*s+(t-o)*a)/(s*s+a*a);l>1?(r=n,o=i):l>0&&(r+=s*l,o+=a*l);}return (s=e-r)*s+(a=t-o)*a}function H(e,t,r,o){var n={id:void 0===e?null:e,type:t,geometry:r,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,r=e.type;if("Point"===r||"MultiPoint"===r||"LineString"===r)K(e,t);else if("Polygon"===r||"MultiLineString"===r)for(var o=0;o<t.length;o++)K(e,t[o]);else if("MultiPolygon"===r)for(o=0;o<t.length;o++)for(var n=0;n<t[o].length;n++)K(e,t[o][n]);}(n),n}function K(e,t){for(var r=0;r<t.length;r+=3)e.minX=Math.min(e.minX,t[r]),e.minY=Math.min(e.minY,t[r+1]),e.maxX=Math.max(e.maxX,t[r]),e.maxY=Math.max(e.maxY,t[r+1]);}function ee(e,t,r,o){if(t.geometry){var n=t.geometry.coordinates,i=t.geometry.type,s=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2),a=[],l=t.id;if(r.promoteId?l=t.properties[r.promoteId]:r.generateId&&(l=o||0),"Point"===i)te(n,a);else if("MultiPoint"===i)for(var u=0;u<n.length;u++)te(n[u],a);else if("LineString"===i)re(n,a,s,!1);else if("MultiLineString"===i){if(r.lineMetrics){for(u=0;u<n.length;u++)re(n[u],a=[],s,!1),e.push(H(l,"LineString",a,t.properties));return}oe(n,a,s,!1);}else if("Polygon"===i)oe(n,a,s,!0);else {if("MultiPolygon"!==i){if("GeometryCollection"===i){for(u=0;u<t.geometry.geometries.length;u++)ee(e,{id:l,geometry:t.geometry.geometries[u],properties:t.properties},r,o);return}throw new Error("Input data is not a valid GeoJSON object.")}for(u=0;u<n.length;u++){var h=[];oe(n[u],h,s,!0),a.push(h);}}e.push(H(l,i,a,t.properties));}}function te(e,t){t.push(ne(e[0])),t.push(ie(e[1])),t.push(0);}function re(e,t,r,o){for(var n,i,s=0,a=0;a<e.length;a++){var l=ne(e[a][0]),u=ie(e[a][1]);t.push(l),t.push(u),t.push(0),a>0&&(s+=o?(n*u-l*i)/2:Math.sqrt(Math.pow(l-n,2)+Math.pow(u-i,2))),n=l,i=u;}var h=t.length-3;t[2]=1,U(t,0,h,r),t[h+2]=1,t.size=Math.abs(s),t.start=0,t.end=t.size;}function oe(e,t,r,o){for(var n=0;n<e.length;n++){var i=[];re(e[n],i,r,o),t.push(i);}}function ne(e){return e/360+.5}function ie(e){var t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function se(e,t,r,o,n,i,s,a){if(o/=t,i>=(r/=t)&&s<o)return e;if(s<r||i>=o)return null;for(var l=[],u=0;u<e.length;u++){var h=e[u],c=h.geometry,f=h.type,p=0===n?h.minX:h.minY,g=0===n?h.maxX:h.maxY;if(p>=r&&g<o)l.push(h);else if(!(g<r||p>=o)){var d=[];if("Point"===f||"MultiPoint"===f)ae(c,d,r,o,n);else if("LineString"===f)le(c,d,r,o,n,!1,a.lineMetrics);else if("MultiLineString"===f)he(c,d,r,o,n,!1);else if("Polygon"===f)he(c,d,r,o,n,!0);else if("MultiPolygon"===f)for(var m=0;m<c.length;m++){var y=[];he(c[m],y,r,o,n,!0),y.length&&d.push(y);}if(d.length){if(a.lineMetrics&&"LineString"===f){for(m=0;m<d.length;m++)l.push(H(h.id,f,d[m],h.tags));continue}"LineString"!==f&&"MultiLineString"!==f||(1===d.length?(f="LineString",d=d[0]):f="MultiLineString"),"Point"!==f&&"MultiPoint"!==f||(f=3===d.length?"Point":"MultiPoint"),l.push(H(h.id,f,d,h.tags));}}}return l.length?l:null}function ae(e,t,r,o,n){for(var i=0;i<e.length;i+=3){var s=e[i+n];s>=r&&s<=o&&(t.push(e[i]),t.push(e[i+1]),t.push(e[i+2]));}}function le(e,t,r,o,n,i,s){for(var a,l,u=ue(e),h=0===n?fe:pe,c=e.start,f=0;f<e.length-3;f+=3){var p=e[f],g=e[f+1],d=e[f+2],m=e[f+3],y=e[f+4],v=0===n?p:g,x=0===n?m:y,w=!1;s&&(a=Math.sqrt(Math.pow(p-m,2)+Math.pow(g-y,2))),v<r?x>r&&(l=h(u,p,g,m,y,r),s&&(u.start=c+a*l)):v>o?x<o&&(l=h(u,p,g,m,y,o),s&&(u.start=c+a*l)):ce(u,p,g,d),x<r&&v>=r&&(l=h(u,p,g,m,y,r),w=!0),x>o&&v<=o&&(l=h(u,p,g,m,y,o),w=!0),!i&&w&&(s&&(u.end=c+a*l),t.push(u),u=ue(e)),s&&(c+=a);}var S=e.length-3;p=e[S],g=e[S+1],d=e[S+2],(v=0===n?p:g)>=r&&v<=o&&ce(u,p,g,d),S=u.length-3,i&&S>=3&&(u[S]!==u[0]||u[S+1]!==u[1])&&ce(u,u[0],u[1],u[2]),u.length&&t.push(u);}function ue(e){var t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function he(e,t,r,o,n,i){for(var s=0;s<e.length;s++)le(e[s],t,r,o,n,i,!1);}function ce(e,t,r,o){e.push(t),e.push(r),e.push(o);}function fe(e,t,r,o,n,i){var s=(i-t)/(o-t);return e.push(i),e.push(r+(n-r)*s),e.push(1),s}function pe(e,t,r,o,n,i){var s=(i-r)/(n-r);return e.push(t+(o-t)*s),e.push(i),e.push(1),s}function ge(e,t){for(var r=[],o=0;o<e.length;o++){var n,i=e[o],s=i.type;if("Point"===s||"MultiPoint"===s||"LineString"===s)n=de(i.geometry,t);else if("MultiLineString"===s||"Polygon"===s){n=[];for(var a=0;a<i.geometry.length;a++)n.push(de(i.geometry[a],t));}else if("MultiPolygon"===s)for(n=[],a=0;a<i.geometry.length;a++){for(var l=[],u=0;u<i.geometry[a].length;u++)l.push(de(i.geometry[a][u],t));n.push(l);}r.push(H(i.id,s,n,i.tags));}return r}function de(e,t){var r=[];r.size=e.size,void 0!==e.start&&(r.start=e.start,r.end=e.end);for(var o=0;o<e.length;o+=3)r.push(e[o]+t,e[o+1],e[o+2]);return r}function me(e,t){if(e.transformed)return e;var r,o,n,i=1<<e.z,s=e.x,a=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],u=l.geometry,h=l.type;if(l.geometry=[],1===h)for(o=0;o<u.length;o+=2)l.geometry.push(ye(u[o],u[o+1],t,i,s,a));else for(o=0;o<u.length;o++){var c=[];for(n=0;n<u[o].length;n+=2)c.push(ye(u[o][n],u[o][n+1],t,i,s,a));l.geometry.push(c);}}return e.transformed=!0,e}function ye(e,t,r,o,n,i){return [Math.round(r*(e*o-n)),Math.round(r*(t*o-i))]}function ve(e,t,r,o,n){for(var i=t===n.maxZoom?0:n.tolerance/((1<<t)*n.extent),s={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:o,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){s.numFeatures++,xe(s,e[a],i,n);var l=e[a].minX,u=e[a].minY,h=e[a].maxX,c=e[a].maxY;l<s.minX&&(s.minX=l),u<s.minY&&(s.minY=u),h>s.maxX&&(s.maxX=h),c>s.maxY&&(s.maxY=c);}return s}function xe(e,t,r,o){var n=t.geometry,i=t.type,s=[];if("Point"===i||"MultiPoint"===i)for(var a=0;a<n.length;a+=3)s.push(n[a]),s.push(n[a+1]),e.numPoints++,e.numSimplified++;else if("LineString"===i)we(s,n,e,r,!1,!1);else if("MultiLineString"===i||"Polygon"===i)for(a=0;a<n.length;a++)we(s,n[a],e,r,"Polygon"===i,0===a);else if("MultiPolygon"===i)for(var l=0;l<n.length;l++){var u=n[l];for(a=0;a<u.length;a++)we(s,u[a],e,r,!0,0===a);}if(s.length){var h=t.tags||null;if("LineString"===i&&o.lineMetrics){for(var c in h={},t.tags)h[c]=t.tags[c];h.mapbox_clip_start=n.start/n.size,h.mapbox_clip_end=n.end/n.size;}var f={geometry:s,type:"Polygon"===i||"MultiPolygon"===i?3:"LineString"===i||"MultiLineString"===i?2:1,tags:h};null!==t.id&&(f.id=t.id),e.features.push(f);}}function we(e,t,r,o,n,i){var s=o*o;if(o>0&&t.size<(n?s:o))r.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===o||t[l+2]>s)&&(r.numSimplified++,a.push(t[l]),a.push(t[l+1])),r.numPoints++;n&&function(e,t){for(var r=0,o=0,n=e.length,i=n-2;o<n;i=o,o+=2)r+=(e[o]-e[i])*(e[o+1]+e[i+1]);if(r>0===t)for(o=0,n=e.length;o<n/2;o+=2){var s=e[o],a=e[o+1];e[o]=e[n-2-o],e[o+1]=e[n-1-o],e[n-2-o]=s,e[n-1-o]=a;}}(a,i),e.push(a);}}function Se(e,t){var r=(t=this.options=function(e,t){for(var r in t)e[r]=t[r];return e}(Object.create(this.options),t)).debug;if(r&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var o=function(e,t){var r=[];if("FeatureCollection"===e.type)for(var o=0;o<e.features.length;o++)ee(r,e.features[o],t,o);else ee(r,"Feature"===e.type?e:{geometry:e},t);return r}(e,t);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),o=function(e,t){var r=t.buffer/t.extent,o=e,n=se(e,1,-1-r,r,0,-1,2,t),i=se(e,1,1-r,2+r,0,-1,2,t);return (n||i)&&(o=se(e,1,-r,1+r,0,-1,2,t)||[],n&&(o=ge(n,1).concat(o)),i&&(o=o.concat(ge(i,-1)))),o}(o,t),o.length&&this.splitTile(o,0,0,0),r&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function Me(e,t,r){return 32*((1<<e)*r+t)+e}function Pe(e,t){const r=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const o=this._geoJSONIndex.getTile(r.z,r.x,r.y);if(!o)return t(null,null);const n=new h(o.features);let i=c(n);0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),t(null,{vectorTile:n,rawData:i.buffer});}Se.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0},Se.prototype.splitTile=function(e,t,r,o,n,i,s){for(var a=[e,t,r,o],l=this.options,u=l.debug;a.length;){o=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();var h=1<<t,c=Me(t,r,o),f=this.tiles[c];if(!f&&(u>1&&console.time("creation"),f=this.tiles[c]=ve(e,t,r,o,l),this.tileCoords.push({z:t,x:r,y:o}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,o,f.numFeatures,f.numPoints,f.numSimplified),console.timeEnd("creation"));var p="z"+t;this.stats[p]=(this.stats[p]||0)+1,this.total++;}if(f.source=e,n){if(t===l.maxZoom||t===n)continue;var g=1<<n-t;if(r!==Math.floor(i/g)||o!==Math.floor(s/g))continue}else if(t===l.indexMaxZoom||f.numPoints<=l.indexMaxPoints)continue;if(f.source=null,0!==e.length){u>1&&console.time("clipping");var d,m,y,v,x,w,S=.5*l.buffer/l.extent,M=.5-S,P=.5+S,b=1+S;d=m=y=v=null,x=se(e,h,r-S,r+P,0,f.minX,f.maxX,l),w=se(e,h,r+M,r+b,0,f.minX,f.maxX,l),e=null,x&&(d=se(x,h,o-S,o+P,1,f.minY,f.maxY,l),m=se(x,h,o+M,o+b,1,f.minY,f.maxY,l),x=null),w&&(y=se(w,h,o-S,o+P,1,f.minY,f.maxY,l),v=se(w,h,o+M,o+b,1,f.minY,f.maxY,l),w=null),u>1&&console.timeEnd("clipping"),a.push(d||[],t+1,2*r,2*o),a.push(m||[],t+1,2*r,2*o+1),a.push(y||[],t+1,2*r+1,2*o),a.push(v||[],t+1,2*r+1,2*o+1);}}},Se.prototype.getTile=function(e,t,r){var o=this.options,n=o.extent,i=o.debug;if(e<0||e>24)return null;var s=1<<e,a=Me(e,t=(t%s+s)%s,r);if(this.tiles[a])return me(this.tiles[a],n);i>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var l,u=e,h=t,c=r;!l&&u>0;)u--,h=Math.floor(h/2),c=Math.floor(c/2),l=this.tiles[Me(u,h,c)];return l&&l.source?(i>1&&console.log("found parent tile z%d-%d-%d",u,h,c),i>1&&console.time("drilling down"),this.splitTile(l.source,u,h,c,e,t,r),i>1&&console.timeEnd("drilling down"),this.tiles[a]?me(this.tiles[a],n):null):null};class be extends e.VectorTileWorkerSource{constructor(e,t,r,o,n){super(e,t,r,o,Pe),n&&(this.loadGeoJSON=n);}loadData(t,r){const o=t&&t.request,n=o&&o.collectResourceTiming;this.loadGeoJSON(t,((s,a)=>{if(s||!a)return r(s);if("object"!=typeof a)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));{i(a,!0);try{if(t.filter){const r=e.createExpression(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const o=a.features.filter((e=>r.value.evaluate({zoom:0},e)));a={type:"FeatureCollection",features:o};}this._geoJSONIndex=t.cluster?new J(function({superclusterOptions:t,clusterProperties:r}){if(!r||!t)return t;const o={},n={},i={accumulated:null,zoom:0},s={properties:null},a=Object.keys(r);for(const t of a){const[i,s]=r[t],a=e.createExpression(s),l=e.createExpression("string"==typeof i?[i,["accumulated"],["get",t]]:i);o[t]=a.value,n[t]=l.value;}return t.map=e=>{s.properties=e;const t={};for(const e of a)t[e]=o[e].evaluate(i,s);return t},t.reduce=(e,t)=>{s.properties=t;for(const t of a)i.accumulated=e[t],e[t]=n[t].evaluate(i,s);},t}(t)).load(a.features):function(e,t){return new Se(e,t)}(a,t.geojsonVtOptions);}catch(s){return r(s)}this.loaded={};const l={};if(n){const r=e.getPerformanceMeasurement(o);r&&(l.resourceTiming={},l.resourceTiming[t.source]=JSON.parse(JSON.stringify(r)));}r(null,l);}}));}reloadTile(e,t){const r=this.loaded;return r&&r[e.uid]?super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,r){if(t.request)e.getJSON(t.request,r);else {if("string"!=typeof t.data)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return r(null,JSON.parse(t.data))}catch(e){return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class ke{constructor(t){this.self=t,this.actor=new e.Actor(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded={},this.projections={},this.defaultProjection=e.getProjection({name:"mercator"}),this.workerSourceTypes={vector:e.VectorTileWorkerSource,geojson:be},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.plugin.isParsed())throw new Error("RTL text plugin already registered.");e.plugin.applyArabicShaping=t.applyArabicShaping,e.plugin.processBidirectionalText=t.processBidirectionalText,e.plugin.processStyledBidirectionalText=t.processStyledBidirectionalText;};}clearCaches(e,t,r){delete this.layerIndexes[e],delete this.availableImages[e],delete this.workerSources[e],delete this.demWorkerSources[e],r();}checkIfReady(e,t,r){r();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,r){this.isSpriteLoaded[t]=r;for(const o in this.workerSources[t]){const n=this.workerSources[t][o];for(const t in n)n[t]instanceof e.VectorTileWorkerSource&&(n[t].isSpriteLoaded=r,n[t].fire(new e.Event("isSpriteLoaded")));}}setImages(e,t,r){this.availableImages[e]=t;for(const r in this.workerSources[e]){const o=this.workerSources[e][r];for(const e in o)o[e].availableImages=t;}r();}enableTerrain(e,t,r){this.terrain=t,r();}setProjection(t,r){this.projections[t]=e.getProjection(r);}setLayers(e,t,r){this.getLayerIndex(e).replace(t),r();}updateLayers(e,t,r){this.getLayerIndex(e).update(t.layers,t.removedIds),r();}loadTile(t,r,o){const n=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;n.projection=this.projections[t]||this.defaultProjection,this.getWorkerSource(t,r.type,r.source).loadTile(n,o);}loadDEMTile(t,r,o){const n=this.enableTerrain?e.extend({buildQuadTree:this.terrain},r):r;this.getDEMWorkerSource(t,r.source).loadTile(n,o);}reloadTile(t,r,o){const n=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;n.projection=this.projections[t]||this.defaultProjection,this.getWorkerSource(t,r.type,r.source).reloadTile(n,o);}abortTile(e,t,r){this.getWorkerSource(e,t.type,t.source).abortTile(t,r);}removeTile(e,t,r){this.getWorkerSource(e,t.type,t.source).removeTile(t,r);}removeSource(e,t,r){if(!this.workerSources[e]||!this.workerSources[e][t.type]||!this.workerSources[e][t.type][t.source])return;const o=this.workerSources[e][t.type][t.source];delete this.workerSources[e][t.type][t.source],void 0!==o.removeSource?o.removeSource(t,r):r();}loadWorkerSource(e,t,r){try{this.self.importScripts(t.url),r();}catch(e){r(e.toString());}}syncRTLPluginState(t,r,o){try{e.plugin.setState(r);const t=e.plugin.getPluginURL();if(e.plugin.isLoaded()&&!e.plugin.isParsed()&&null!=t){this.self.importScripts(t);const r=e.plugin.isParsed();o(r?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),r);}}catch(e){o(e.toString());}}getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}getLayerIndex(e){let t=this.layerIndexes[e];return t||(t=this.layerIndexes[e]=new o),t}getWorkerSource(e,t,r){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][r]){const o={send:(t,r,o,n,i,s)=>{this.actor.send(t,r,o,e,i,s);},scheduler:this.actor.scheduler};this.workerSources[e][t][r]=new this.workerSourceTypes[t](o,this.getLayerIndex(e),this.getAvailableImages(e),this.isSpriteLoaded[e]);}return this.workerSources[e][t][r]}getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new n),this.demWorkerSources[e][t]}enforceCacheSizeLimit(t,r){e.enforceCacheSizeLimit(r);}getWorkerPerformanceMetrics(e,t,r){r(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new ke(self)),ke}));
    
    define(["./shared"],(function(e){"use strict";function t(e,i){if(Array.isArray(e)){if(!Array.isArray(i)||e.length!==i.length)return !1;for(let o=0;o<e.length;o++)if(!t(e[o],i[o]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==i){if("object"!=typeof i)return !1;if(Object.keys(e).length!==Object.keys(i).length)return !1;for(const o in e)if(!t(e[o],i[o]))return !1;return !0}return e===i}var i=o;function o(e){return !function(e){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":Array.prototype&&Array.prototype.every&&Array.prototype.filter&&Array.prototype.forEach&&Array.prototype.indexOf&&Array.prototype.lastIndexOf&&Array.prototype.map&&Array.prototype.some&&Array.prototype.reduce&&Array.prototype.reduceRight&&Array.isArray?Function.prototype&&Function.prototype.bind?Object.keys&&Object.create&&Object.getPrototypeOf&&Object.getOwnPropertyNames&&Object.isSealed&&Object.isFrozen&&Object.isExtensible&&Object.getOwnPropertyDescriptor&&Object.defineProperty&&Object.defineProperties&&Object.seal&&Object.freeze&&Object.preventExtensions?"JSON"in window&&"parse"in JSON&&"stringify"in JSON?function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?"Uint8ClampedArray"in window?ArrayBuffer.isView?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===r[t=e&&e.failIfMajorPerformanceCaveat]&&(r[t]=function(e){var t,i=function(e){var t=document.createElement("canvas"),i=Object.create(o.webGLContextAttributes);return i.failIfMajorPerformanceCaveat=e,t.getContext("webgl",i)||t.getContext("experimental-webgl",i)}(e);if(!i)return !1;try{t=i.createShader(i.VERTEX_SHADER);}catch(e){return !1}return !(!t||i.isContextLost())&&(i.shaderSource(t,"void main() {}"),i.compileShader(t),!0===i.getShaderParameter(t,i.COMPILE_STATUS))}(t)),r[t]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL support"):"insufficient Canvas/getImageData support":"insufficient ArrayBuffer support":"insufficient Uint8ClampedArray support":"insufficient worker support":"insufficient JSON support":"insufficient Object support":"insufficient Function support":"insufficent Array support";var t;}(e)}var r={};function n(t,i,o){const r=e.window.document.createElement(t);return void 0!==i&&(r.className=i),o&&o.appendChild(r),r}function s(t,i,o){const r=e.window.document.createElementNS("http://www.w3.org/2000/svg",t);for(const e of Object.keys(i))r.setAttributeNS(null,e,i[e]);return o&&o.appendChild(r),r}o.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const a=e.window.document&&e.window.document.documentElement.style,l=a&&void 0!==a.userSelect?"userSelect":"WebkitUserSelect";let c;function h(){a&&l&&(c=a[l],a[l]="none");}function u(){a&&l&&(a[l]=c);}function _(t){t.preventDefault(),t.stopPropagation(),e.window.removeEventListener("click",_,!0);}function d(){e.window.addEventListener("click",_,!0),e.window.setTimeout((()=>{e.window.removeEventListener("click",_,!0);}),0);}function p(e,t){const i=e.getBoundingClientRect();return g(e,i,t)}function m(e,t){const i=e.getBoundingClientRect(),o=[];for(let r=0;r<t.length;r++)o.push(g(e,i,t[r]));return o}function f(t){return void 0!==e.window.InstallTrigger&&2===t.button&&t.ctrlKey&&e.window.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:t.button}function g(t,i,o){const r=t.offsetWidth===i.width?1:t.offsetWidth/i.width;return new e.pointGeometry((o.clientX-i.left)*r,(o.clientY-i.top)*r)}function v(e,t){var i=t[0],o=t[1],r=t[2],n=t[3],s=i*n-r*o;return s?(e[0]=n*(s=1/s),e[1]=-o*s,e[2]=-r*s,e[3]=i*s,e):null}function x(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class y extends e.Evented{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new e.RGBAImage({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,callback:t}of this.requestors)this._notify(e,t);this.requestors=[];}}hasImage(e){return !!this.getImage(e)}getImage(e){return this.images[e]}addImage(e,t){this._validate(e,t)&&(this.images[e]=t);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){return !(e&&(4!==e.length||e[0]<0||t.data.width<e[0]||e[1]<0||t.data.height<e[1]||e[2]<0||t.data.width<e[2]||e[3]<0||t.data.height<e[3]||e[2]<e[0]||e[3]<e[1]))}updateImage(e,t){t.version=this.images[e].version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(e,t){let i=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(i=!1);this.isLoaded()||i?this._notify(e,t):this.requestors.push({ids:e,callback:t});}_notify(t,i){const o={};for(const i of t){this.images[i]||this.fire(new e.Event("styleimagemissing",{id:i}));const t=this.images[i];t?o[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.warnOnce(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}i(null,o);}getPixelSize(){const{width:e,height:t}=this.atlasImage;return {width:e,height:t}}getPattern(t){const i=this.patterns[t],o=this.getImage(t);if(!o)return null;if(i&&i.position.version===o.version)return i.position;if(i)i.position.version=o.version;else {const i={w:o.data.width+2,h:o.data.height+2,x:0,y:0},r=new e.ImagePosition(i,o);this.patterns[t]={bin:i,position:r};}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const i=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new e.Texture(t,this.atlasImage,i.RGBA),this.atlasTexture&&this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:i,h:o}=e.potpack(t),r=this.atlasImage;r.resize({width:i||1,height:o||1});for(const t in this.patterns){const{bin:i}=this.patterns[t],o=i.x+1,n=i.y+1,s=this.images[t].data,a=s.width,l=s.height;e.RGBAImage.copy(s,r,{x:0,y:0},{x:o,y:n},{width:a,height:l}),e.RGBAImage.copy(s,r,{x:0,y:l-1},{x:o,y:n-1},{width:a,height:1}),e.RGBAImage.copy(s,r,{x:0,y:0},{x:o,y:n+l},{width:a,height:1}),e.RGBAImage.copy(s,r,{x:a-1,y:0},{x:o-1,y:n},{width:1,height:l}),e.RGBAImage.copy(s,r,{x:0,y:0},{x:o+a,y:n},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const t of e){if(this.callbackDispatchedThisFrame[t])continue;this.callbackDispatchedThisFrame[t]=!0;const e=this.images[t];x(e)&&this.updateImage(t,e);}}}const b=new e.Properties({anchor:new e.DataConstantProperty(e.spec.light.anchor),position:new class{constructor(){this.specification=e.spec.light.position;}possiblyEvaluate(t,i){return function([t,i,o]){const r=e.degToRad(i+90),n=e.degToRad(o);return {x:t*Math.cos(r)*Math.sin(n),y:t*Math.sin(r)*Math.sin(n),z:t*Math.cos(n),azimuthal:i,polar:o}}(t.expression.evaluate(i))}interpolate(t,i,o){return {x:e.number(t.x,i.x,o),y:e.number(t.y,i.y,o),z:e.number(t.z,i.z,o),azimuthal:e.number(t.azimuthal,i.azimuthal,o),polar:e.number(t.polar,i.polar,o)}}},color:new e.DataConstantProperty(e.spec.light.color),intensity:new e.DataConstantProperty(e.spec.light.intensity)}),w="-transition";class T extends e.Evented{constructor(t){super(),this._transitionable=new e.Transitionable(b),this.setLight(t),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(t,i={}){if(!this._validate(e.validateLight,t,i))for(const i in t){const o=t[i];e.endsWith(i,w)?this._transitionable.setTransition(i.slice(0,-w.length),o):this._transitionable.setValue(i,o);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&e.emitValidationErrors(this,t.call(e.validateStyle,e.extend({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.spec})))}}const E=new e.Properties({source:new e.DataConstantProperty(e.spec.terrain.source),exaggeration:new e.DataConstantProperty(e.spec.terrain.exaggeration)}),C="-transition";class M extends e.Evented{constructor(t,i){super(),this._transitionable=new e.Transitionable(E),this.set(t),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=i;}get(){return this._transitionable.serialize()}set(t){for(const i in t){const o=t[i];e.endsWith(i,C)?this._transitionable.setTransition(i.slice(0,-C.length),o):this._transitionable.setValue(i,o);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}}function I(t,i,o,r){const n=e.smoothstep(45,65,o),[s,a]=S(t,r),l=e.length(i);let c=1-Math.min(1,Math.exp((l-s)/(a-s)*-6));return c*=c*c,c=Math.min(1,1.00747*c),c*n*t.alpha}function S(e,t){const i=.5/Math.tan(.5*t);return [e.range[0]+i,e.range[1]+i]}const D=new e.Properties({range:new e.DataConstantProperty(e.spec.fog.range),color:new e.DataConstantProperty(e.spec.fog.color),"high-color":new e.DataConstantProperty(e.spec.fog["high-color"]),"space-color":new e.DataConstantProperty(e.spec.fog["space-color"]),"horizon-blend":new e.DataConstantProperty(e.spec.fog["horizon-blend"]),"star-intensity":new e.DataConstantProperty(e.spec.fog["star-intensity"])}),L="-transition";class A extends e.Evented{constructor(t,i){super(),this._transitionable=new e.Transitionable(D),this.set(t),this._transitioning=this._transitionable.untransitioned(),this._transform=i;}get state(){const t=this._transform,i="globe"===t.projection.name,o=e.globeToMercatorTransition(t.zoom),r=this.properties.get("range"),n=[.5,3];return {range:i?[e.number(n[0],r[0],o),e.number(n[1],r[1],o)]:r,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(t,i={}){if(!this._validate(e.validateFog,t,i)){for(const i of Object.keys(e.spec.fog))t&&void 0===t[i]&&(t[i]=e.spec.fog[i].default);for(const i in t){const o=t[i];e.endsWith(i,L)?this._transitionable.setTransition(i.slice(0,-L.length),o):this._transitionable.setValue(i,o);}}}getOpacity(t){if(!this._transform.projection.supportsFog)return 0;const i=this.properties&&this.properties.get("color")||1;return ("globe"===this._transform.projection.name?1:e.smoothstep(45,65,t))*i.a}getOpacityAtLatLng(t,i){return this._transform.projection.supportsFog?function(t,i,o){const r=e.MercatorCoordinate.fromLngLat(i),n=o.elevation?o.elevation.getAtPointOrZero(r):0,s=[r.x,r.y,n];return e.transformMat4(s,s,o.mercatorFogMatrix),I(t,s,o.pitch,o._fov)}(this.state,t,i):0}getFovAdjustedRange(e){return this._transform.projection.supportsFog?S(this.state,e):[0,1]}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&e.emitValidationErrors(this,t.call(e.validateStyle,e.extend({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.spec})))}}class z{constructor(t,i){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e.uniqueId();const o=this.workerPool.acquire(this.id);for(let e=0;e<o.length;e++){const t=new z.Actor(o[e],i,this.id);t.name=`Worker ${e}`,this.actors.push(t);}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0;}));}broadcast(t,i,o){e.asyncAll(this.actors,((e,o)=>{e.send(t,i,o);}),o=o||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((e=>{e.remove();})),this.actors=[],this.workerPool.release(this.id);}}function P(t,i,o){return i*(e.EXTENT/(t.tileSize*Math.pow(2,o-t.tileID.overscaledZ)))}z.Actor=e.Actor;class R{constructor(e,t,i,o){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,o);}static createFromScreenPoints(t,i){let o,r;if(t instanceof e.pointGeometry||"number"==typeof t[0]){const n=e.pointGeometry.convert(t);o=[n],r=i.isPointAboveHorizon(n);}else {const n=e.pointGeometry.convert(t[0]),s=e.pointGeometry.convert(t[1]);o=[n,s],r=e.polygonizeBounds(n,s).every((e=>i.isPointAboveHorizon(e)));}return new R(o,i.getCameraPoint(),r,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.polygonizeBounds(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.pointGeometry(1,1)):this.screenBounds[1],r=e.polygonizeBounds(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?r.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?r[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(r[3]=this.cameraPoint)),e.bufferConvexPolygon(r,t)}bufferedCameraGeometryGlobe(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.pointGeometry(1,1)):this.screenBounds[1],r=e.polygonizeBounds(i,o,t),n=this.cameraPoint.clone();switch(3*((n.y>i.y)+(n.y>o.y))+((n.x>i.x)+(n.x>o.x))){case 0:r[0]=n,r[4]=n.clone();break;case 1:r.splice(1,0,n);break;case 2:r[1]=n;break;case 3:r.splice(4,0,n);break;case 5:r.splice(2,0,n);break;case 6:r[3]=n;break;case 7:r.splice(3,0,n);break;case 8:r[2]=n;}return r}containsTile(t,i,o,r=0){const n=t.queryPadding/i._pixelsPerMercatorPixel+1,s=o?this._bufferedCameraMercator(n,i):this._bufferedScreenMercator(n,i);let a=t.tileID.wrap+(s.unwrapped?r:0);const l=s.polygon.map((i=>e.getTilePoint(t.tileTransform,i,a)));if(!e.polygonIntersectsBox(l,0,0,e.EXTENT,e.EXTENT))return;a=t.tileID.wrap+(this.screenGeometryMercator.unwrapped?r:0);const c=this.screenGeometryMercator.polygon.map((i=>e.getTileVec3(t.tileTransform,i,a))),h=c.map((t=>new e.pointGeometry(t[0],t[1]))),u=i.getFreeCameraOptions().position||new e.MercatorCoordinate(0,0,0),_=e.getTileVec3(t.tileTransform,u,a),d=c.map((t=>{const i=e.sub(t,t,_);return e.normalize(i,i),new e.Ray(_,i)})),p=P(t,1,i.zoom)*i._pixelsPerMercatorPixel;return {queryGeometry:this,tilespaceGeometry:h,tilespaceRays:d,bufferedTilespaceGeometry:l,bufferedTilespaceBounds:(m=e.getBounds(l),m.min.x=e.clamp(m.min.x,0,e.EXTENT),m.min.y=e.clamp(m.min.y,0,e.EXTENT),m.max.x=e.clamp(m.max.x,0,e.EXTENT),m.max.y=e.clamp(m.max.y,0,e.EXTENT),m),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:p};var m;}_bufferedScreenMercator(e,t){const i=k(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=k(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let o;return o="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=o,o}}_projectAndResample(t,i){const o=function(t,i){const o=e.multiply([],i.pixelMatrix,i.globeMatrix),r=[0,-e.GLOBE_RADIUS,0,1],n=[0,e.GLOBE_RADIUS,0,1],s=[0,0,0,1];e.transformMat4$1(r,r,o),e.transformMat4$1(n,n,o),e.transformMat4$1(s,s,o);const a=new e.pointGeometry(r[0]/r[3],r[1]/r[3]),l=new e.pointGeometry(n[0]/n[3],n[1]/n[3]),c=e.polygonContainsPoint(t,a)&&r[3]<s[3],h=e.polygonContainsPoint(t,l)&&n[3]<s[3];if(!c&&!h)return null;const u=function(e,t,i){for(let o=1;o<e.length;o++){const r=B(t.pointCoordinate3D(e[o-1]).x),n=B(t.pointCoordinate3D(e[o]).x);if(i<0){if(r<n)return {idx:o,t:-r/(n-1-r)}}else if(n<r)return {idx:o,t:(1-r)/(n+1-r)}}return null}(t,i,c?-1:1);if(!u)return null;const{idx:_,t:d}=u;let p=_>1?O(t.slice(0,_),i):[],m=_<t.length?O(t.slice(_),i):[];p=p.map((t=>new e.pointGeometry(B(t.x),t.y))),m=m.map((t=>new e.pointGeometry(B(t.x),t.y)));const f=[...p];0===f.length&&f.push(m[m.length-1]);const g=e.number(f[f.length-1].y,(0===m.length?p[0]:m[0]).y,d);let v;return v=c?[new e.pointGeometry(0,g),new e.pointGeometry(0,0),new e.pointGeometry(1,0),new e.pointGeometry(1,g)]:[new e.pointGeometry(1,g),new e.pointGeometry(1,1),new e.pointGeometry(0,1),new e.pointGeometry(0,g)],f.push(...v),0===m.length?f.push(p[0]):f.push(...m),{polygon:f.map((t=>new e.MercatorCoordinate(t.x,t.y))),unwrapped:!1}}(t,i);if(o)return o;const r=function(t,i){let o=!1,r=-1/0,n=0;for(let e=0;e<t.length-1;e++)t[e].x>r&&(r=t[e].x,n=e);for(let e=0;e<t.length-1;e++){const i=(n+e)%(t.length-1),r=t[i],s=t[i+1];Math.abs(r.x-s.x)>.5&&(r.x<s.x?(r.x+=1,0===i&&(t[t.length-1].x+=1)):(s.x+=1,i+1===t.length-1&&(t[0].x+=1)),o=!0);}const s=e.mercatorXfromLng(i.center.lng);return o&&s<Math.abs(s-1)&&t.forEach((e=>{e.x-=1;})),{polygon:t,unwrapped:o}}(O(t,i).map((t=>new e.pointGeometry(B(t.x),t.y))),i);return {polygon:r.polygon.map((t=>new e.MercatorCoordinate(t.x,t.y))),unwrapped:r.unwrapped}}}function O(t,i){return e.resample(t,(e=>{const t=i.pointCoordinate3D(e);e.x=t.x,e.y=t.y;}),1/256)}function B(e){return e<0?1+e%1:e%1}function k(e){return 100*e|0}function F(t,i,o,r,n){const s=function(o,r){if(o)return n(o);if(r){t.url&&r.tiles&&t.tiles&&delete t.tiles;const o=e.pick(e.extend(r,t),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);r.vector_layers&&(o.vectorLayers=r.vector_layers,o.vectorLayerIds=o.vectorLayers.map((e=>e.id))),o.tiles=i.canonicalizeTileset(o,t.url),n(null,o);}};return t.url?e.getJSON(i.transformRequest(i.normalizeSourceURL(t.url,null,o,r),e.ResourceType.Source),s):e.exported.frame((()=>s(null,t)))}class U{constructor(t,i,o){this.bounds=e.LngLatBounds.convert(this.validateBounds(t)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),o=Math.floor(e.mercatorXfromLng(this.bounds.getWest())*i),r=Math.floor(e.mercatorYfromLat(this.bounds.getNorth())*i),n=Math.ceil(e.mercatorXfromLng(this.bounds.getEast())*i),s=Math.ceil(e.mercatorYfromLat(this.bounds.getSouth())*i);return t.x>=o&&t.x<n&&t.y>=r&&t.y<s}}class N{constructor(e,t,i){this.context=e;const o=e.gl;this.buffer=o.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),o.bufferData(o.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?o.DYNAMIC_DRAW:o.STATIC_DRAW),this.dynamicDraw||t.destroy();}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const G={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class j{constructor(e,t,i,o){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=o,this.context=e;const r=e.gl;this.buffer=r.createBuffer(),e.bindVertexBuffer.set(this.buffer),r.bufferData(r.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||t.destroy();}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const o=t.attributes[this.attributes[i].name];void 0!==o&&e.enableVertexAttribArray(o);}}setVertexAttribPointers(e,t,i){for(let o=0;o<this.attributes.length;o++){const r=this.attributes[o],n=t.attributes[r.name];void 0!==n&&e.vertexAttribPointer(n,r.components,e[G[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class Z{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class V extends Z{getDefault(){return e.Color.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class W extends Z{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class X extends Z{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class q extends Z{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class $ extends Z{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class H extends Z{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class Y extends Z{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class K extends Z{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class J extends Z{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class Q extends Z{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class ee extends Z{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class te extends Z{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class ie extends Z{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class oe extends Z{getDefault(){const e=this.gl;return [e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1);}}class re extends Z{getDefault(){return e.Color.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class ne extends Z{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1);}}class se extends Z{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class ae extends Z{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class le extends Z{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}class ce extends Z{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}}class he extends Z{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class ue extends Z{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class _e extends Z{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class de extends Z{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class pe extends Z{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class me extends Z{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class fe extends Z{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class ge extends Z{constructor(e){super(e),this.vao=e.extVertexArrayObject;}getDefault(){return null}set(e){this.vao&&(e!==this.current||this.dirty)&&(this.vao.bindVertexArrayOES(e),this.current=e,this.dirty=!1);}}class ve extends Z{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class xe extends Z{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class ye extends Z{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class be extends Z{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class we extends be{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class Te extends be{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,this.attachment(),t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class Ee extends Te{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}}class Ce{constructor(e,t,i,o){this.context=e,this.width=t,this.height=i;const r=this.framebuffer=e.gl.createFramebuffer();this.colorAttachment=new we(e,r),o&&(this.depthAttachment=new Te(e,r));}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}e.deleteFramebuffer(this.framebuffer);}}class Me{constructor(e,t=!1){if(this.gl=e,this.isWebGL2=t,this.extVertexArrayObject=this.gl.getExtension("OES_vertex_array_object"),t){const t=e;this.extVertexArrayObject={createVertexArrayOES:t.createVertexArray.bind(e),deleteVertexArrayOES:t.deleteVertexArray.bind(e),bindVertexArrayOES:t.bindVertexArray.bind(e)};}this.clearColor=new V(this),this.clearDepth=new W(this),this.clearStencil=new X(this),this.colorMask=new q(this),this.depthMask=new $(this),this.stencilMask=new H(this),this.stencilFunc=new Y(this),this.stencilOp=new K(this),this.stencilTest=new J(this),this.depthRange=new Q(this),this.depthTest=new ee(this),this.depthFunc=new te(this),this.blend=new ie(this),this.blendFunc=new oe(this),this.blendColor=new re(this),this.blendEquation=new ne(this),this.cullFace=new se(this),this.cullFaceSide=new ae(this),this.frontFace=new le(this),this.program=new ce(this),this.activeTexture=new he(this),this.viewport=new ue(this),this.bindFramebuffer=new _e(this),this.bindRenderbuffer=new de(this),this.bindTexture=new pe(this),this.bindVertexBuffer=new me(this),this.bindElementBuffer=new fe(this),this.bindVertexArrayOES=this.extVertexArrayObject&&new ge(this),this.pixelStoreUnpack=new ve(this),this.pixelStoreUnpackPremultiplyAlpha=new xe(this),this.pixelStoreUnpackFlipY=new ye(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.extTextureFilterAnisotropicForceOff=!1,this.extStandardDerivativesForceOff=!1,this.extDebugRendererInfo=e.getExtension("WEBGL_debug_renderer_info"),this.extDebugRendererInfo&&(this.renderer=e.getParameter(this.extDebugRendererInfo.UNMASKED_RENDERER_WEBGL),this.vendor=e.getParameter(this.extDebugRendererInfo.UNMASKED_VENDOR_WEBGL)),t||(this.extTextureHalfFloat=e.getExtension("OES_texture_half_float")),(t||this.extTextureHalfFloat&&e.getExtension("OES_texture_half_float_linear"))&&(this.extRenderToTextureHalfFloat=e.getExtension("EXT_color_buffer_half_float")),this.extStandardDerivatives=t||e.getExtension("OES_standard_derivatives"),this.extTimerQuery=e.getExtension("EXT_disjoint_timer_query"),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE);}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.extVertexArrayObject&&(this.bindVertexArrayOES.dirty=!0),this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(e,t){return new N(this,e,t)}createVertexBuffer(e,t,i){return new j(this,e,t,i)}createRenderbuffer(e,t,i){const o=this.gl,r=o.createRenderbuffer();return this.bindRenderbuffer.set(r),o.renderbufferStorage(o.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),r}createFramebuffer(e,t,i){return new Ce(this,e,t,i)}clear({color:e,depth:t,stencil:i}){const o=this.gl;let r=0;e&&(r|=o.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(r|=o.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(r|=o.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),o.clear(r);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(i){t(i.blendFunction,e.ColorMode.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(i.blendFunction),this.blendColor.set(i.blendColor)),this.colorMask.set(i.mask);}unbindVAO(){this.extVertexArrayObject&&this.bindVertexArrayOES.set(null);}}class Ie extends e.Evented{constructor(t,i,o,r){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.extend(this,e.pick(i,["url","scheme","tileSize","promoteId"])),this._options=e.extend({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r),this._tileWorkers={},this._deduped=new e.DedupedRequest;}load(t){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"}));const i=Array.isArray(this.map._language)?this.map._language.join():this.map._language,o=this.map._worldview;this._tileJSONRequest=F(this._options,this.map._requestManager,i,o,((r,n)=>{this._tileJSONRequest=null,this._loaded=!0,r?(i&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${i}`),o&&2!==o.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${o}`),this.fire(new e.ErrorEvent(r))):n&&(e.extend(this,n),n.bounds&&(this.tileBounds=new U(n.bounds,this.minzoom,this.maxzoom)),e.postTurnstileEvent(n.tiles,this.map._requestManager._customAccessToken),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"}))),t&&t(r);}));}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest(),this.load((()=>this.map.style._clearSource(this.id)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest();}serialize(){return e.extend({},this._options)}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(o,e.ResourceType.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:e.exported.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile};if(r.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",r,n.bind(this));else if(t.actor=this._tileWorkers[o]=this._tileWorkers[o]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",r,n.bind(this),void 0,!0);else {const i=e.loadVectorTile.call({deduped:this._deduped},r,((e,i)=>{e||!i?n.call(this,e):(r.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",r,n.bind(this),void 0,!0));}),!0);t.request={cancel:i};}function n(o,r){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(r&&r.resourceTiming&&(t.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&r&&t.setExpiryData(r),t.loadVectorData(r,this.map.painter),e.cacheEntryPossiblyAdded(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id});}unloadTile(e){e.unloadVectorData(),e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id});}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}class Se extends e.Evented{constructor(t,i,o,r){super(),this.id=t,this.dispatcher=o,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.extend({type:"raster"},i),e.extend(this,e.pick(i,["url","scheme","tileSize"]));}load(t){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=F(this._options,this.map._requestManager,null,null,((i,o)=>{this._tileJSONRequest=null,this._loaded=!0,i?this.fire(new e.ErrorEvent(i)):o&&(e.extend(this,o),o.bounds&&(this.tileBounds=new U(o.bounds,this.minzoom,this.maxzoom)),e.postTurnstileEvent(o.tiles),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"}))),t&&t(i);}));}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}reload(){this.cancelTileJSONRequest(),this.load((()=>this.map.style._clearSource(this.id)));}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest();}serialize(){return e.extend({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.exported.devicePixelRatio>=2,r=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.getImage(this.map._requestManager.transformRequest(r,e.ResourceType.Tile),((o,r,n,s)=>(delete t.request,t.aborted?(t.state="unloaded",i(null)):o?(t.state="errored",i(o)):r?(this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:n,expires:s}),t.setTexture(r,this.map.painter),t.state="loaded",e.cacheEntryPossiblyAdded(this.dispatcher),void i(null)):i(null))));}static loadTileData(e,t,i){e.setTexture(t,i);}static unloadTileData(e,t){e.texture&&t.saveTileTexture(e.texture);}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t();}unloadTile(e,t){e.texture&&this.map.painter.saveTileTexture(e.texture),t();}hasTransition(){return !1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}}let De;function Le(t,i,o,r,n,s,a,l){const c=[t,o,n,i,r,s,1,1,1],h=[a,l,1],u=e.adjoint([],c),[_,d,p]=e.transformMat3(h,h,e.transpose(u,u));return e.multiply$1(c,[_,0,0,0,d,0,0,0,p],c)}class Ae extends e.Evented{constructor(e,t,i,o){super(),this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(o),this.options=t,this._dirty=!1;}load(t,i){this._loaded=i||!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this.url=this.options.url,this._imageRequest=e.getImage(this.map._requestManager.transformRequest(this.url,e.ResourceType.Image),((i,o)=>{if(this._imageRequest=null,this._loaded=!0,i)this.fire(new e.ErrorEvent(i));else if(o){const{HTMLImageElement:i}=e.window;this.image=o instanceof i?e.exported.getImageData(o):o,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading();}}));}loaded(){return this._loaded}updateImage(e){return this.image&&e.url?(this._imageRequest&&e.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=e.url,this.load(e.coordinates,this._loaded),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}onRemove(){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),this.texture&&this.texture.destroy();}setCoordinates(t){this.coordinates=t,this._boundsArray=void 0;const i=t.map(e.MercatorCoordinate.fromLngLat);return this.tileID=function(t){let i=1/0,o=1/0,r=-1/0,n=-1/0;for(const e of t)i=Math.min(i,e.x),o=Math.min(o,e.y),r=Math.max(r,e.x),n=Math.max(n,e.y);const s=Math.max(r-i,n-o),a=Math.max(0,Math.floor(-Math.log(s)/Math.LN2)),l=Math.pow(2,a);return new e.CanonicalTileID(a,Math.floor((i+r)/2*l),Math.floor((o+n)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z,this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0;}_prepareData(t){for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture);}if(this._boundsArray)return;const i=e.tileTransform(this.tileID,this.map.transform.projection),[o,r,n,s]=this.coordinates.map((t=>{const o=i.projection.project(t[0],t[1]);return e.getTilePoint(i,o)._round()}));this.perspectiveTransform=function(t,i,o,r,n,s,a,l,c,h){const u=Le(0,0,t,0,0,i,t,i),_=Le(o,r,n,s,a,l,c,h);return e.multiply$1(_,e.adjoint(u,u),_),[_[6]/_[8]*t/e.EXTENT,_[7]/_[8]*i/e.EXTENT]}(this.width,this.height,o.x,o.y,r.x,r.y,s.x,s.y,n.x,n.y);const a=this._boundsArray=new e.StructArrayLayout4i8;a.emplaceBack(o.x,o.y,0,0),a.emplaceBack(r.x,r.y,e.EXTENT,0),a.emplaceBack(s.x,s.y,0,e.EXTENT),a.emplaceBack(n.x,n.y,e.EXTENT,e.EXTENT),this.boundsBuffer&&this.boundsBuffer.destroy(),this.boundsBuffer=t.createVertexBuffer(a,e.boundsAttributes.members),this.boundsSegments=e.SegmentVector.simpleSegment(0,0,4,2);}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,i=t.gl;this._dirty&&(this.texture?this.texture.update(this.image):(this.texture=new e.Texture(t,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE)),this._dirty=!1),this._prepareData(t);}loadTile(e,t){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={},t(null)):(e.state="errored",t(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}const ze={vector:Ie,raster:Se,"raster-dem":class extends Se{constructor(t,i,o,r){super(t,i,o,r),this.type="raster-dem",this.maxzoom=22,this._options=e.extend({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function r(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.getImage(this.map._requestManager.transformRequest(o,e.ResourceType.Tile),function(o,n,s,a){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(n){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:s,expires:a});const i=e.window.ImageBitmap&&n instanceof e.window.ImageBitmap&&(null==De&&(De=e.window.OffscreenCanvas&&new e.window.OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof e.window.createImageBitmap),De),o=1-(n.width-e.prevPowerOfTwo(n.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const l=i?n:e.exported.getImageData(n,o),c={uid:t.uid,coord:t.tileID,source:this.id,rawImageData:l,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",c,r.bind(this),void 0,!0));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),r=(i.x-1+o)%o,n=0===i.x?t.wrap-1:t.wrap,s=(i.x+1+o)%o,a=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.OverscaledTileID(t.overscaledZ,n,i.z,r,i.y).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,a,i.z,s,i.y).key]={backfilled:!1},i.y>0&&(l[new e.OverscaledTileID(t.overscaledZ,n,i.z,r,i.y-1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,a,i.z,s,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.OverscaledTileID(t.overscaledZ,n,i.z,r,i.y+1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,a,i.z,s,i.y+1).key]={backfilled:!1}),l}unloadTile(e){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded";}},geojson:class extends e.Evented{constructor(t,i,o,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(r),this._data=i.data,this._options=e.extend({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const n=e.EXTENT/this.tileSize;this.workerOptions=e.extend({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*n,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*n,extent:e.EXTENT,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.EXTENT,radius:(void 0!==i.clusterRadius?i.clusterRadius:50)*n,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions);}onAdd(e){this.map=e,this.setData(this._data);}setData(e){return this._data=e,this._updateWorkerData(),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new e.Event("dataloading",{dataType:"source"})),this._loaded=!1;const t=e.extend({},this.workerOptions),i=this._data;"string"==typeof i?(t.request=this.map._requestManager.transformRequest(e.exported.resolveURL(i),e.ResourceType.Source),t.request.collectResourceTiming=this._collectResourceTiming):t.data=JSON.stringify(i),this._pendingLoad=this.actor.send(`${this.type}.loadData`,t,((t,i)=>{if(this._loaded=!0,this._pendingLoad=null,t)this.fire(new e.ErrorEvent(t));else {const t={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&i&&i.resourceTiming&&i.resourceTiming[this.id]&&(t.resourceTiming=i.resourceTiming[this.id]),this.fire(new e.Event("data",t)),this._metadataFired=!0;}this._coalesce&&(this._updateWorkerData(),this._coalesce=!1);}));}loaded(){return this._loaded}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor,t.request=this.actor.send(o,{type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:e.exported.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId},((e,r)=>(delete t.request,t.unloadVectorData(),t.aborted?i(null):e?i(e):(t.loadVectorData(r,this.map.painter,"reloadTile"===o),i(null)))),void 0,"loadTile"===o);}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e){e.unloadVectorData(),this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id});}onRemove(){this._pendingLoad&&this._pendingLoad.cancel();}serialize(){return e.extend({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends Ae{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.ResourceType.Source).url);e.getVideo(this.urls,((t,i)=>{this._loaded=!0,t?this.fire(new e.ErrorEvent(t)):i&&(this.video=i,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading());}));}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.Texture(t,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(t);}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:Ae,canvas:class extends Ae{constructor(t,i,o,r){super(t,i,o,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof e.window.HTMLCanvasElement||this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof e.window.HTMLCanvasElement?this.options.canvas:e.window.document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.ErrorEvent(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context;this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.Texture(i,this.canvas,i.gl.RGBA,{premultiply:!0}),this._prepareData(i);}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}},custom:class extends e.Evented{constructor(t,i,o,r){super(),this.id=t,this.type="custom",this._dataType="raster",this._dispatcher=o,this._implementation=i,this.setEventedParent(r),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new e.ErrorEvent(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new e.ErrorEvent(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new U(this._implementation.bounds,this.minzoom,this.maxzoom)),i.update=this._update.bind(this),i.clearTiles=this._clearTiles.bind(this),i.coveringTiles=this._coveringTiles.bind(this),e.extend(this,e.pick(i,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]));}serialize(){return e.pick(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"}));}loaded(){return this._loaded}onAdd(t){this._map=t,this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(t),this.load();}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e);}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:o}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:o})}return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const{x:o,y:r,z:n}=t.tileID.canonical,s=new e.window.AbortController;t.request=Promise.resolve(this._implementation.loadTile({x:o,y:r,z:n},{signal:s.signal})).then(function(o){return delete t.request,t.aborted?(t.state="unloaded",i(null)):void 0===o?(t.state="errored",i(null)):null===o?(this.loadTileData(t,{width:this.tileSize,height:this.tileSize,data:null}),t.state="loaded",i(null)):function(t){return t instanceof e.window.ImageData||t instanceof e.window.HTMLCanvasElement||t instanceof e.window.ImageBitmap||t instanceof e.window.HTMLImageElement}(o)?(this.loadTileData(t,o),t.state="loaded",void i(null)):(t.state="errored",i(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((e=>{20!==e.code&&(t.state="errored",i(e));})),t.request.cancel=()=>s.abort();}loadTileData(e,t){Se.loadTileData(e,t,this._map.painter);}unloadTileData(e){Se.unloadTileData(e,this._map.painter);}unloadTile(e,t){if(this.unloadTileData(e),this._implementation.unloadTile){const{x:t,y:i,z:o}=e.tileID.canonical;this._implementation.unloadTile({x:t,y:i,z:o});}t();}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t();}hasTransition(){return !1}_coveringTiles(){return this._map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){this._map.style._clearSource(this.id);}_update(){this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"}));}}},Pe=function(t,i,o,r){const n=new ze[i.type](t,i,o,r);if(n.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${n.id}`);return e.bindAll(["load","abort","unload","serialize","prepare"],n),n};function Re(t,i){const o=e.identity([]);return e.scale(o,o,[.5*t.width,.5*-t.height,1]),e.translate(o,o,[1,-1,0]),e.multiply(o,o,t.calculateProjMatrix(i.toUnwrapped())),Float32Array.from(o)}function Oe(e,t,i,o,r,n,s,a=!1){const l=e.tilesIn(o,s,a);l.sort(ke);const c=[];for(const o of l)c.push({wrappedTileID:o.tile.tileID.wrapped().key,queryResults:o.tile.queryRenderedFeatures(t,i,e._state,o,r,n,Re(e.transform,o.tile.tileID),a)});const h=function(e){const t={},i={};for(const o of e){const e=o.queryResults,r=o.wrappedTileID,n=i[r]=i[r]||{};for(const i in e){const o=e[i],r=n[i]=n[i]||{},s=t[i]=t[i]||[];for(const e of o)r[e.featureIndex]||(r[e.featureIndex]=!0,s.push(e));}}return t}(c);for(const t in h)h[t].forEach((t=>{const i=t.feature,o=i.layer;o&&"background"!==o.type&&"sky"!==o.type&&(i.source=o.source,o["source-layer"]&&(i.sourceLayer=o["source-layer"]),i.state=void 0!==i.id?e.getFeatureState(o["source-layer"],i.id):{});}));return h}function Be(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),o=[],r={};for(let e=0;e<i.length;e++){const n=i[e],s=n.tileID.canonical.key;r[s]||(r[s]=!0,n.querySourceFeatures(o,t));}return o}function ke(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function Fe(){return null!=fn.workerClass?new fn.workerClass:new e.window.Worker(fn.workerUrl)}const Ue="mapboxgl_preloaded_worker_pool";class Ne{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<Ne.workerCount;)this.workers.push(new Fe);return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[Ue]}numActive(){return Object.keys(this.active).length}}let Ge;function je(){return Ge||(Ge=new Ne),Ge}function Ze(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.refProperties.forEach((e=>{e in i&&(o[e]=i[e]);})),o}function Ve(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=Ze(e[i],t[e[i].ref]));return e}Ne.workerCount=2;const We={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setProjection:"setProjection"};function Xe(e,t,i){i.push({command:We.addSource,args:[e,t[e]]});}function qe(e,t,i){t.push({command:We.removeSource,args:[e]}),i[e]=!0;}function $e(e,t,i,o){qe(e,i,o),Xe(e,t,i);}function He(e,i,o){let r;for(r in e[o])if(e[o].hasOwnProperty(r)&&"data"!==r&&!t(e[o][r],i[o][r]))return !1;for(r in i[o])if(i[o].hasOwnProperty(r)&&"data"!==r&&!t(e[o][r],i[o][r]))return !1;return !0}function Ye(e,i,o,r,n,s){let a;for(a in i=i||{},e=e||{})e.hasOwnProperty(a)&&(t(e[a],i[a])||o.push({command:s,args:[r,a,i[a],n]}));for(a in i)i.hasOwnProperty(a)&&!e.hasOwnProperty(a)&&(t(e[a],i[a])||o.push({command:s,args:[r,a,i[a],n]}));}function Ke(e){return e.id}function Je(e,t){return e[t.id]=t,e}class Qe{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.clamp(t,0,1);let i=1,o=this._distances[i];const r=t*this.paddedLength+this.padding;for(;o<r&&i<this._distances.length;)o=this._distances[++i];const n=i-1,s=this._distances[n],a=o-s,l=a>0?(r-s)/a:0;return this.points[n].mult(1-l).add(this.points[i].mult(l))}}class et{constructor(e,t,i){const o=this.boxCells=[],r=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),r.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,r){this._forEachCell(t,i,o,r,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(r);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,r,n){this.boxCells[r].push(n);}_insertCircleCell(e,t,i,o,r,n){this.circleCells[r].push(n);}_query(e,t,i,o,r,n){if(i<0||e>this.width||o<0||t>this.height)return !r&&[];const s=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(r)return !0;for(let e=0;e<this.boxKeys.length;e++)s.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];s.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return n?s.filter(n):s}return this._forEachCell(e,t,i,o,this._queryCell,s,{hitTest:r,seenUids:{box:{},circle:{}}},n),r?s.length>0:s}_queryCircle(e,t,i,o,r){const n=e-i,s=e+i,a=t-i,l=t+i;if(s<0||n>this.width||l<0||a>this.height)return !o&&[];const c=[];return this._forEachCell(n,a,s,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},r),o?c.length>0:c}query(e,t,i,o,r){return this._query(e,t,i,o,!1,r)}hitTest(e,t,i,o,r){return this._query(e,t,i,o,!0,r)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,r,n,s,a){const l=s.seenUids,c=this.boxCells[r];if(null!==c){const r=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=r[c+2]&&t<=r[c+3]&&i>=r[c+0]&&o>=r[c+1]&&(!a||a(this.boxKeys[h]))){if(s.hitTest)return n.push(!0),!0;n.push({key:this.boxKeys[h],x1:r[c],y1:r[c+1],x2:r[c+2],y2:r[c+3]});}}}const h=this.circleCells[r];if(null!==h){const r=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(r[h],r[h+1],r[h+2],e,t,i,o)&&(!a||a(this.circleKeys[c]))){if(s.hitTest)return n.push(!0),!0;{const e=r[h],t=r[h+1],i=r[h+2];n.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,r,n,s,a){const l=s.circle,c=s.seenUids,h=this.boxCells[r];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!a||a(this.boxKeys[t])))return n.push(!0),!0}}const u=this.circleCells[r];if(null!==u){const e=this.circles;for(const t of u)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!a||a(this.circleKeys[t])))return n.push(!0),!0}}}_forEachCell(e,t,i,o,r,n,s,a){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let _=l;_<=h;_++)for(let l=c;l<=u;l++)if(r.call(this,e,t,i,o,this.xCellCount*l+_,n,s,a))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,r,n){const s=o-e,a=r-t,l=i+n;return l*l>s*s+a*a}_circleAndRectCollide(e,t,i,o,r,n,s){const a=(n-o)/2,l=Math.abs(e-(o+a));if(l>a+i)return !1;const c=(s-r)/2,h=Math.abs(t-(r+c));if(h>c+i)return !1;if(l<=a||h<=c)return !0;const u=l-a,_=h-c;return u*u+_*_<=i*i}}const tt=Math.tan(85*Math.PI/180);function it(t,i,o,r,n,s,a){const l=e.create();if(o)if("globe"===s.name){const t=e.calculateGlobeLabelMatrix(n,i);e.multiply(l,l,t);}else {const t=v([],a);l[0]=t[0],l[1]=t[1],l[4]=t[2],l[5]=t[3],r||e.rotateZ(l,l,n.angle);}else e.multiply(l,n.labelPlaneMatrix,t);return l}function ot(e,t,i,o,r,n,s){const a=it(e,t,i,o,r,n,s);return "globe"===n.name&&i||(a[2]=a[6]=a[10]=a[14]=0),a}function rt(t,i,o,r,n,s,a){if(o){if("globe"===s.name){const l=it(t,i,o,r,n,s,a);return e.invert(l,l),e.multiply(l,t,l),l}{const i=e.clone(t),o=e.identity([]);return o[0]=a[0],o[1]=a[1],o[4]=a[2],o[5]=a[3],e.multiply(i,i,o),r||e.rotateZ(i,i,-n.angle),i}}return n.glCoordMatrix}function nt(t,i,o,r){const n=[t,i,o,1];o?e.transformMat4$1(n,n,r):ft(n,n,r);const s=n[3];return n[0]/=s,n[1]/=s,n[2]/=s,n}function st(e,t){return Math.min(.5+e/t*.5,1.5)}function at(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function lt(t,i,o,r,n,s,a,l,c,h){const u=o.transform,_=r?t.textSizeData:t.iconSizeData,d=e.evaluateSizeForZoom(_,o.transform.zoom),p="globe"===u.projection.name,m=[256/o.width*2+1,256/o.height*2+1],f=r?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;f.clear();let g=null;p&&(g=r?t.text.globeExtVertexArray:t.icon.globeExtVertexArray);const v=t.lineVertexArray,x=r?t.text.placedSymbolArray:t.icon.placedSymbolArray,y=o.transform.width/o.transform.height;let b,w=!1;for(let r=0;r<x.length;r++){const p=x.get(r),{numGlyphs:T,writingMode:E}=p;if(E!==e.WritingMode.vertical||w||b===e.WritingMode.horizontal||(w=!0),b=E,(p.hidden||E===e.WritingMode.vertical)&&!w){mt(T,f);continue}w=!1;const C=new e.pointGeometry(p.tileAnchorX,p.tileAnchorY);let{x:M,y:I,z:S}=u.projection.projectTilePoint(C.x,C.y,h.canonical);if(c){const[e,t,i]=c(C);M+=e,I+=t,S+=i;}const D=[M,I,S,1];if(e.transformMat4$1(D,D,i),!at(D,m)){mt(T,f);continue}const L=st(o.transform.cameraToCenterDistance,D[3]),A=e.evaluateSizeForFeature(_,d,p),z=a?A/L:A*L,P=nt(M,I,S,n);if(P[3]<=0){mt(T,f);continue}let R={};const O=a?null:c,B=ut(p,z,!1,l,i,n,s,t.glyphOffsetArray,v,f,g,P,C,R,y,O,u.projection,h,a);w=B.useVertical,O&&B.needsFlipping&&(R={}),(B.notEnoughRoom||w||B.needsFlipping&&ut(p,z,!0,l,i,n,s,t.glyphOffsetArray,v,f,g,P,C,R,y,O,u.projection,h,a).notEnoughRoom)&&mt(T,f);}r?(t.text.dynamicLayoutVertexBuffer.updateData(f),g&&t.text.globeExtVertexBuffer.updateData(g)):(t.icon.dynamicLayoutVertexBuffer.updateData(f),g&&t.icon.globeExtVertexBuffer.updateData(g));}function ct(e,t,i,o,r,n,s,a,l,c,h,u,_,d,p,m){const{lineStartIndex:f,glyphStartIndex:g,segment:v}=a,x=g+a.numGlyphs,y=f+a.lineLength,b=t.getoffsetX(g),w=t.getoffsetX(x-1),T=pt(e*b,i,o,r,n,s,v,f,y,l,c,h,u,_,!0,d,p,m);if(!T)return null;const E=pt(e*w,i,o,r,n,s,v,f,y,l,c,h,u,_,!0,d,p,m);return E?{first:T,last:E}:null}function ht(t,i,o,r){return t===e.WritingMode.horizontal&&Math.abs(r)>Math.abs(o)?{useVertical:!0}:t===e.WritingMode.vertical?r>0?{needsFlipping:!0}:null:0!==i&&function(e,t){return 0===e||Math.abs(t/e)>tt}(o,r)?1===i?{needsFlipping:!0}:null:o<0?{needsFlipping:!0}:null}function ut(t,i,o,r,n,s,a,l,c,h,u,_,d,p,m,f,g,v,x){const y=i/24,b=t.lineOffsetX*y,w=t.lineOffsetY*y,{lineStartIndex:T,glyphStartIndex:E,numGlyphs:C,segment:M,writingMode:I,flipState:S}=t,D=T+t.lineLength,L=t=>{if(u){const[i,o,r]=t.up,n=h.length;e.updateGlobeVertexNormal(u,n+0,i,o,r),e.updateGlobeVertexNormal(u,n+1,i,o,r),e.updateGlobeVertexNormal(u,n+2,i,o,r),e.updateGlobeVertexNormal(u,n+3,i,o,r);}const[i,o,r]=t.point;e.addDynamicAttributes(h,i,o,r,t.angle);};if(C>1){const e=ct(y,l,b,w,o,_,d,t,c,s,p,f,!1,g,v,x);if(!e)return {notEnoughRoom:!0};if(r&&!o){let[i,o,r]=e.first.point,[n,s,l]=e.last.point;[i,o]=nt(i,o,r,a),[n,s]=nt(n,s,l,a);const c=ht(I,S,(n-i)*m,s-o);if(t.flipState=c&&c.needsFlipping?1:2,c)return c}L(e.first);for(let e=E+1;e<E+C-1;e++){const t=pt(y*l.getoffsetX(e),b,w,o,_,d,M,T,D,c,s,p,f,!1,!1,g,v,x);if(!t)return h.length-=4*(e-E),{notEnoughRoom:!0};L(t);}L(e.last);}else {if(r&&!o){const i=nt(d.x,d.y,0,n),o=T+M+1,r=new e.pointGeometry(c.getx(o),c.gety(o)),s=nt(r.x,r.y,0,n),a=s[3]>0?s:dt(d,r,i,1,n,void 0,g,v.canonical),l=ht(I,S,(a[0]-i[0])*m,a[1]-i[1]);if(t.flipState=l&&l.needsFlipping?1:2,l)return l}const i=pt(y*l.getoffsetX(E),b,w,o,_,d,M,T,D,c,s,p,f,!1,!1,g,v,x);if(!i)return {notEnoughRoom:!0};L(i);}return {}}function _t(e,t,i,o,r){const{x:n,y:s,z:a}=o.projectTilePoint(e.x,e.y,t);if(!r)return nt(n,s,a,i);const[l,c,h]=r(e);return nt(n+l,s+c,a+h,i)}function dt(t,i,o,r,n,s,a,l){const c=_t(t.sub(i)._unit()._add(t),l,n,a,s);return e.sub(c,o,c),e.normalize(c,c),e.scaleAndAdd(c,o,c,r)}function pt(t,i,o,r,n,s,a,l,c,h,u,_,d,p,m,f,g,v){const x=r?t-i:t+i;let y=x>0?1:-1,b=0;r&&(y*=-1,b=Math.PI),y<0&&(b+=Math.PI);let w=l+a+(y>0?0:1)|0,T=n,E=n,C=0,M=0;const I=Math.abs(x),S=[],D=[];let L=s,A=L;const z=()=>dt(A,L,E,I-C+1,u,d,f,g.canonical);for(;C+M<=I;){if(w+=y,w<l||w>=c)return null;if(E=T,A=L,S.push(E),p&&D.push(A),L=new e.pointGeometry(h.getx(w),h.gety(w)),T=_[w],!T){const e=_t(L,g.canonical,u,f,d);T=e[3]>0?_[w]=e:z();}C+=M,M=e.distance(E,T);}m&&d&&(_[w]&&(T=z(),M=e.distance(E,T)),_[w]=T);const P=(I-C)/M,R=L.sub(A)._mult(P)._add(A),O=e.sub([],T,E),B=e.scaleAndAdd([],E,O,P);let k=[0,0,1],F=O[0],U=O[1];if(v&&(k=f.upVector(g.canonical,R.x,R.y),0!==k[0]||0!==k[1]||1!==k[2])){const t=[k[2],0,-k[0]],i=e.cross([],k,t);e.normalize(t,t),e.normalize(i,i),F=e.dot(O,t),U=e.dot(O,i);}if(o){const t=e.cross([],k,O);e.normalize(t,t),e.scaleAndAdd(B,B,t,o*y);}const N=b+Math.atan2(U,F);return S.push(B),p&&D.push(R),{point:B,angle:N,path:S,tilePath:D,up:k}}function mt(e,t){const i=t.length,o=i+4*e;t.resize(o),t.float32.fill(-1/0,4*i,4*o);}function ft(e,t,i){const o=t[0],r=t[1];return e[0]=i[0]*o+i[4]*r+i[12],e[1]=i[1]*o+i[5]*r+i[13],e[3]=i[3]*o+i[7]*r+i[15],e}const gt=100;class vt{constructor(e,t,i=new et(e.width+200,e.height+200,25),o=new et(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=o,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+gt,this.screenBottomBoundary=e.height+gt,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t;}placeCollisionBox(e,t,i,o,r,n,s,a){let l=i.projectedAnchorX,c=i.projectedAnchorY,h=i.projectedAnchorZ;const u=i.elevation,_=i.tileID,d=e.getProjection();if(u&&_){const[e,t,o]=d.upVector(_.canonical,i.tileAnchorX,i.tileAnchorY),r=d.upVectorScale(_.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;l+=e*u*r,c+=t*u*r,h+=o*u*r;}const p=this.projectAndGetPerspectiveRatio(s,l,c,h,i.tileID,"globe"===d.name||!!u||this.transform.pitch>0,d),m=n*p.perspectiveRatio,f=(i.x1*t+o.x-i.padding)*m+p.point.x,g=(i.y1*t+o.y-i.padding)*m+p.point.y,v=(i.x2*t+o.x+i.padding)*m+p.point.x,x=(i.y2*t+o.y+i.padding)*m+p.point.y,y=p.perspectiveRatio<=.55||p.occluded;return !this.isInsideGrid(f,g,v,x)||!r&&this.grid.hitTest(f,g,v,x,a)||y?{box:[],offscreen:!1,occluded:p.occluded}:{box:[f,g,v,x],offscreen:this.isOffscreen(f,g,v,x),occluded:!1}}placeCollisionCircles(t,i,o,r,n,s,a,l,c,h,u,_,d,p,m){const f=[],g=this.transform.elevation,v=t.getProjection(),x=g?g.getAtTileOffsetFunc(m,this.transform.center.lat,this.transform.worldSize,v):null,y=new e.pointGeometry(o.tileAnchorX,o.tileAnchorY);let{x:b,y:w,z:T}=v.projectTilePoint(y.x,y.y,m.canonical);if(x){const[e,t,i]=x(y);b+=e,w+=t,T+=i;}const E="globe"===v.name,C=this.projectAndGetPerspectiveRatio(a,b,w,T,m,E||!!g||this.transform.pitch>0,v),{perspectiveRatio:M}=C,I=(u?s/M:s*M)/e.ONE_EM,S=nt(b,w,T,l),D=C.signedDistanceFromCamera>0?ct(I,n,o.lineOffsetX*I,o.lineOffsetY*I,!1,S,y,o,r,l,{},g&&!u?x:null,u&&!!g,v,m,u):null;let L=!1,A=!1,z=!0;if(D&&!C.occluded){const t=.5*d*M+p,o=new e.pointGeometry(-100,-100),r=new e.pointGeometry(this.screenRightBoundary,this.screenBottomBoundary),n=new Qe,{first:s,last:a}=D,l=s.path.length;let u=[];for(let e=l-1;e>=1;e--)u.push(s.path[e]);for(let e=1;e<a.path.length;e++)u.push(a.path[e]);const m=2.5*t;c&&(u=u.map((([e,t,i],o)=>(x&&!E&&(i=x(o<l-1?s.tilePath[l-1-o]:a.tilePath[o-l+2])[2]),nt(e,t,i,c)))),u.some((e=>e[3]<=0))&&(u=[]));let g=[];if(u.length>0){let t=1/0,i=-1/0,n=1/0,s=-1/0;for(const e of u)t=Math.min(t,e[0]),n=Math.min(n,e[1]),i=Math.max(i,e[0]),s=Math.max(s,e[1]);i>=o.x&&t<=r.x&&s>=o.y&&n<=r.y&&(g=[u.map((t=>new e.pointGeometry(t[0],t[1])))],(t<o.x||i>r.x||n<o.y||s>r.y)&&(g=e.clipLine(g,o.x,o.y,r.x,r.y)));}for(const e of g){n.reset(e,.25*t);let o=0;o=n.length<=.5*t?1:Math.ceil(n.paddedLength/m)+1;for(let e=0;e<o;e++){const r=e/Math.max(o-1,1),s=n.lerp(r),a=s.x+gt,l=s.y+gt;f.push(a,l,t,0);const c=a-t,u=l-t,d=a+t,p=l+t;if(z=z&&this.isOffscreen(c,u,d,p),A=A||this.isInsideGrid(c,u,d,p),!i&&this.grid.hitTestCircle(a,l,t,_)&&(L=!0,!h))return {circles:[],offscreen:!1,collisionDetected:L,occluded:!1}}}}return {circles:!h&&L||!A?[]:f,offscreen:z,collisionDetected:L,occluded:C.occluded}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,r=1/0,n=-1/0,s=-1/0;for(const a of t){const t=new e.pointGeometry(a.x+gt,a.y+gt);o=Math.min(o,t.x),r=Math.min(r,t.y),n=Math.max(n,t.x),s=Math.max(s,t.y),i.push(t);}const a=this.grid.query(o,r,n,s).concat(this.ignoredGrid.query(o,r,n,s)),l={},c={};for(const t of a){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const r=[new e.pointGeometry(t.x1,t.y1),new e.pointGeometry(t.x2,t.y1),new e.pointGeometry(t.x2,t.y2),new e.pointGeometry(t.x1,t.y2)];e.polygonIntersectsPolygon(i,r)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,r){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:r},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,r){const n=t?this.ignoredGrid:this.grid,s={bucketInstanceId:i,featureIndex:o,collisionGroupID:r};for(let t=0;t<e.length;t+=4)n.insertCircle(s,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,r,n,s,a){const l=[i,o,r,1];let c=!1;if(r||this.transform.pitch>0){e.transformMat4$1(l,l,t);const s="globe"===a.name;if(this.fogState&&n&&!s){const t=function(t,i,o,r,n,s){const a=s.calculateFogTileMatrix(n),l=[i,o,r];return e.transformMat4(l,l,a),I(t,l,s.pitch,s._fov)}(this.fogState,i,o,r,n.toUnwrapped(),this.transform);c=t>.9;}}else ft(l,l,t);const h=l[3];return {point:new e.pointGeometry((l[0]/h+1)/2*this.transform.width+gt,(-l[1]/h+1)/2*this.transform.height+gt),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(a)/h*.5,1.5),signedDistanceFromCamera:h,occluded:s&&l[2]>h||c}}isOffscreen(e,t,i,o){return i<gt||e>=this.screenRightBoundary||o<gt||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.identity([]);return e.translate(t,t,[-100,-100,0]),t}}function xt(t,i,o){const r=i.createTileMatrix(t,t.worldSize,o.toUnwrapped());return e.multiply(new Float32Array(16),t.projMatrix,r)}function yt(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const o=i.clone();return o.setProjection(t.projection),xt(o,t.getProjection(),e)}function bt(e,t,i){return t.name===i.projection.name?e.projMatrix:xt(i,t,e)}class wt{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class Tt{constructor(e,t,i,o,r,n=!1){this.text=new wt(e?e.text:null,t,i,r),this.icon=new wt(e?e.icon:null,t,o,r),this.clipped=n;}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Et{constructor(e,t,i,o=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=o;}}class Ct{constructor(){this.invProjMatrix=e.create(),this.viewportMatrix=e.create(),this.circles=[];}}class Mt{constructor(e,t,i,o,r){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=r;}}class It{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function St(t,i,o,r,n){const{horizontalAlign:s,verticalAlign:a}=e.getAnchorAlignment(t),l=-(s-.5)*i,c=-(a-.5)*o,h=e.evaluateVariableOffset(t,r);return new e.pointGeometry(l+h[0]*n,c+h[1]*n)}function Dt(t,i,o,r,n){const s=new e.pointGeometry(t,i);return o&&s._rotate(r?n:-n),s}class Lt{constructor(e,t,i,o,r){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new vt(this.transform,r),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new It(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,o,r){const n=o.getBucket(i),s=o.latestFeatureIndex;if(!n||!s||i.id!==n.layerIds[0])return;const a=n.layers[0].layout,l=o.collisionBoxArray,c=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),h=o.tileSize/e.EXTENT,u=o.tileID.toUnwrapped();this.transform.setProjection(n.projection);const _=(d=o.tileID,p=n.getProjection(),m=this.transform,p.name===this.projection?m.calculateProjMatrix(d.toUnwrapped()):xt(m,p,d));var d,p,m;const f="map"===a.get("text-pitch-alignment"),g="map"===a.get("text-rotation-alignment");i.compileFilter();const v=i.dynamicFilter(),x=i.dynamicFilterNeedsFeature(),y=this.transform.calculatePixelsToTileUnitsMatrix(o),b=ot(_,o.tileID.canonical,f,g,this.transform,n.getProjection(),y);let w=null;if(f){const t=rt(_,o.tileID.canonical,f,g,this.transform,n.getProjection(),y);w=e.multiply([],this.transform.labelPlaneMatrix,t);}let T=null;v&&o.latestFeatureIndex&&(T={unwrappedTileID:u,dynamicFilter:v,dynamicFilterNeedsFeature:x,featureIndex:o.latestFeatureIndex}),this.retainedQueryData[n.bucketInstanceId]=new Mt(n.bucketInstanceId,s,n.sourceLayerIndex,n.index,o.tileID);const E={bucket:n,layout:a,posMatrix:_,textLabelPlaneMatrix:b,labelToScreenMatrix:w,clippingData:T,scale:c,textPixelRatio:h,holdingForFade:o.holdingForFade(),collisionBoxArray:l,partiallyEvaluatedTextSize:e.evaluateSizeForZoom(n.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:e.evaluateSizeForZoom(n.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:r,parameters:E});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:E});}attemptAnchorPlacement(e,t,i,o,r,n,s,a,l,c,h,u,_,d,p,m,f,g){const{textOffset0:v,textOffset1:x,crossTileID:y}=u,b=[v,x],w=St(e,i,o,b,r),T=this.collisionIndex.placeCollisionBox(d,r,t,Dt(w.x,w.y,n,s,this.transform.angle),h,a,l,c.predicate);if(m){const e=d.getSymbolInstanceIconSize(g,this.transform.zoom,u.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(d,e,m,Dt(w.x,w.y,n,s,this.transform.angle),h,a,l,c.predicate).box.length)return}if(T.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[y]&&this.prevPlacement.placements[y]&&this.prevPlacement.placements[y].text&&(t=this.prevPlacement.variableOffsets[y].anchor),this.variableOffsets[y]={textOffset:b,width:i,height:o,anchor:e,textScale:r,prevAnchor:t},this.markUsedJustification(d,e,u,p),d.allowVerticalPlacement&&(this.markUsedOrientation(d,p,u),this.placedOrientations[y]=p),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,i,o,r){const{bucket:n,layout:s,posMatrix:a,textLabelPlaneMatrix:l,labelToScreenMatrix:c,clippingData:h,textPixelRatio:u,holdingForFade:_,collisionBoxArray:d,partiallyEvaluatedTextSize:p,partiallyEvaluatedIconSize:m,collisionGroup:f}=t.parameters,g=s.get("text-optional"),v=s.get("icon-optional"),x=s.get("text-allow-overlap"),y=s.get("icon-allow-overlap"),b="map"===s.get("text-rotation-alignment"),w="map"===s.get("text-pitch-alignment"),T="none"!==s.get("icon-text-fit"),E="viewport-y"===s.get("symbol-z-order");this.transform.setProjection(n.projection);let C=x&&(y||!n.hasIconData()||v),M=y&&(x||!n.hasTextData()||g);!n.collisionArrays&&d&&n.deserializeCollisionBoxes(d),o&&r&&n.updateCollisionDebugBuffers(this.transform.zoom,d);const I=(t,r,d)=>{const{crossTileID:E,numVerticalGlyphVertices:I}=t;if(h){const o={zoom:this.transform.zoom,pitch:this.transform.pitch};let r=null;if(h.dynamicFilterNeedsFeature){const e=this.retainedQueryData[n.bucketInstanceId];r=h.featureIndex.loadFeature({featureIndex:t.featureIndex,bucketIndex:e.bucketIndex,sourceLayerIndex:e.sourceLayerIndex,layoutVertexArrayOffset:0});}if(!(0,h.dynamicFilter)(o,r,this.retainedQueryData[n.bucketInstanceId].tileID.canonical,new e.pointGeometry(t.tileAnchorX,t.tileAnchorY),this.transform.calculateDistanceTileData(h.unwrappedTileID)))return this.placements[E]=new Et(!1,!1,!1,!0),void(i[E]=!0)}if(i[E])return;if(_)return void(this.placements[E]=new Et(!1,!1,!1));let S=!1,D=!1,L=!0,A=!1,z=!1,P=null,R={box:null,offscreen:null,occluded:null},O={box:null,offscreen:null,occluded:null},B=null,k=null,F=null,U=0,N=0,G=0;d.textFeatureIndex?U=d.textFeatureIndex:t.useRuntimeCollisionCircles&&(U=t.featureIndex),d.verticalTextFeatureIndex&&(N=d.verticalTextFeatureIndex);const j=e=>{e.tileID=this.retainedQueryData[n.bucketInstanceId].tileID;const t=this.transform.elevation;(t||e.elevation)&&(e.elevation=t?t.getAtTileOffset(e.tileID,e.tileAnchorX,e.tileAnchorY):0);},Z=d.textBox;if(Z){j(Z);const i=i=>{let o=e.WritingMode.horizontal;if(n.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[E];e&&(this.placedOrientations[E]=e,o=e,this.markUsedOrientation(n,o,t));}return o},o=(t,i)=>{if(n.allowVerticalPlacement&&I>0&&d.verticalTextBox){for(const o of n.writingModes)if(o===e.WritingMode.vertical?(R=i(),O=R):R=t(),R&&R.box&&R.box.length)break}else R=t();};if(s.get("text-variable-anchor")){let l=s.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[E]){const e=this.prevPlacement.variableOffsets[E];l.indexOf(e.anchor)>0&&(l=l.filter((t=>t!==e.anchor)),l.unshift(e.anchor));}const c=(e,i,o)=>{const s=n.getSymbolInstanceTextSize(p,t,this.transform.zoom,r),c=(e.x2-e.x1)*s+2*e.padding,h=(e.y2-e.y1)*s+2*e.padding,_=T&&!y?i:null;_&&j(_);let d={box:[],offscreen:!1,occluded:!1};const g=x?2*l.length:l.length;for(let i=0;i<g;++i){const g=this.attemptAnchorPlacement(l[i%l.length],e,c,h,s,b,w,u,a,f,i>=l.length,t,r,n,o,_,p,m);if(g&&(d=g.placedGlyphBoxes,d&&d.box&&d.box.length)){S=!0,P=g.shift;break}}return d};o((()=>c(Z,d.iconBox,e.WritingMode.horizontal)),(()=>{const t=d.verticalTextBox;return t&&j(t),n.allowVerticalPlacement&&!(R&&R.box&&R.box.length)&&I>0&&t?c(t,d.verticalIconBox,e.WritingMode.vertical):{box:null,offscreen:null,occluded:null}})),R&&(S=R.box,L=R.offscreen,A=R.occluded);const h=i(R&&R.box);if(!S&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[E];e&&(this.variableOffsets[E]=e,this.markUsedJustification(n,e.anchor,t,h));}}else {const s=(i,o)=>{const s=n.getSymbolInstanceTextSize(p,t,this.transform.zoom,r),l=this.collisionIndex.placeCollisionBox(n,s,i,new e.pointGeometry(0,0),x,u,a,f.predicate);return l&&l.box&&l.box.length&&(this.markUsedOrientation(n,o,t),this.placedOrientations[E]=o),l};o((()=>s(Z,e.WritingMode.horizontal)),(()=>{const t=d.verticalTextBox;return n.allowVerticalPlacement&&I>0&&t?(j(t),s(t,e.WritingMode.vertical)):{box:null,offscreen:null,occluded:null}})),i(R&&R.box&&R.box.length);}}if(B=R,S=B&&B.box&&B.box.length>0,L=B&&B.offscreen,A=B&&B.occluded,t.useRuntimeCollisionCircles){const i=n.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex),r=e.evaluateSizeForFeature(n.textSizeData,p,i),h=s.get("text-padding");k=this.collisionIndex.placeCollisionCircles(n,x,i,n.lineVertexArray,n.glyphOffsetArray,r,a,l,c,o,w,f.predicate,t.collisionCircleDiameter*r/e.ONE_EM,h,this.retainedQueryData[n.bucketInstanceId].tileID),S=x||k.circles.length>0&&!k.collisionDetected,L=L&&k.offscreen,A=k.occluded;}if(d.iconFeatureIndex&&(G=d.iconFeatureIndex),d.iconBox){const i=i=>{j(i);const o=T&&P?Dt(P.x,P.y,b,w,this.transform.angle):new e.pointGeometry(0,0),r=n.getSymbolInstanceIconSize(m,this.transform.zoom,t.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(n,r,i,o,y,u,a,f.predicate)};O&&O.box&&O.box.length&&d.verticalIconBox?(F=i(d.verticalIconBox),D=F.box.length>0):(F=i(d.iconBox),D=F.box.length>0),L=L&&F.offscreen,z=F.occluded;}const V=g||0===t.numHorizontalGlyphVertices&&0===I,W=v||0===t.numIconVertices;if(V||W?W?V||(D=D&&S):S=D&&S:D=S=D&&S,S&&B&&B.box&&this.collisionIndex.insertCollisionBox(B.box,s.get("text-ignore-placement"),n.bucketInstanceId,O&&O.box&&N?N:U,f.ID),D&&F&&this.collisionIndex.insertCollisionBox(F.box,s.get("icon-ignore-placement"),n.bucketInstanceId,G,f.ID),k&&(S&&this.collisionIndex.insertCollisionCircles(k.circles,s.get("text-ignore-placement"),n.bucketInstanceId,U,f.ID),o)){const e=n.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new Ct);for(let e=0;e<k.circles.length;e+=4)t.circles.push(k.circles[e+0]),t.circles.push(k.circles[e+1]),t.circles.push(k.circles[e+2]),t.circles.push(k.collisionDetected?1:0);}const X="globe"!==n.projection.name;C=C&&(X||!A),M=M&&(X||!z),this.placements[E]=new Et(S||C,D||M,L||n.justReloaded),i[E]=!0;};if(E){const e=n.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];I(n.symbolInstances.get(i),i,n.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)I(n.symbolInstances.get(e),e,n.collisionArrays[e]);if(o&&n.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[n.bucketInstanceId];e.invert(t.invProjMatrix,a),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}n.justReloaded=!1;}markUsedJustification(t,i,o,r){const{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:s,rightJustifiedTextSymbolIndex:a,verticalPlacedTextSymbolIndex:l,crossTileID:c}=o,h=e.getAnchorJustification(i),u=r===e.WritingMode.vertical?l:"left"===h?n:"center"===h?s:"right"===h?a:-1;n>=0&&(t.text.placedSymbolArray.get(n).crossTileID=u>=0&&n!==u?0:c),s>=0&&(t.text.placedSymbolArray.get(s).crossTileID=u>=0&&s!==u?0:c),a>=0&&(t.text.placedSymbolArray.get(a).crossTileID=u>=0&&a!==u?0:c),l>=0&&(t.text.placedSymbolArray.get(l).crossTileID=u>=0&&l!==u?0:c);}markUsedOrientation(t,i,o){const r=i===e.WritingMode.horizontal||i===e.WritingMode.horizontalOnly?i:0,n=i===e.WritingMode.vertical?i:0,{leftJustifiedTextSymbolIndex:s,centerJustifiedTextSymbolIndex:a,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=o,h=t.text.placedSymbolArray;s>=0&&(h.get(s).placedOrientation=r),a>=0&&(h.get(a).placedOrientation=r),l>=0&&(h.get(l).placedOrientation=r),c>=0&&(h.get(c).placedOrientation=n);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,r=t?t.opacities:{},n=t?t.variableOffsets:{},s=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],n=r[e];n?(this.opacities[e]=new Tt(n,o,t.text,t.icon,null,t.clipped),i=i||t.text!==n.text.placed||t.icon!==n.icon.placed):(this.opacities[e]=new Tt(null,o,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon);}for(const e in r){const t=r[e];if(!this.opacities[e]){const r=new Tt(t,o,!1,!1);r.isHidden()||(this.opacities[e]=r,i=i||t.text.placed||t.icon.placed);}}for(const e in n)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=n[e]);for(const e in s)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=s[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i={};for(const o of t){const t=o.getBucket(e);t&&o.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,i,o.collisionBoxArray);}}updateBucketOpacities(t,i,o){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const r=t.layers[0].layout,n=!!t.layers[0].dynamicFilter(),s=new Tt(null,0,!1,!1,!0),a=r.get("text-allow-overlap"),l=r.get("icon-allow-overlap"),c=r.get("text-variable-anchor"),h="map"===r.get("text-rotation-alignment"),u="map"===r.get("text-pitch-alignment"),_="none"!==r.get("icon-text-fit"),d=new Tt(null,0,a&&(l||!t.hasIconData()||r.get("icon-optional")),l&&(a||!t.hasTextData()||r.get("text-optional")),!0);!t.collisionArrays&&o&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(o);const p=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};let m=0;for(let o=0;o<t.symbolInstances.length;o++){const r=t.symbolInstances.get(o),{numHorizontalGlyphVertices:a,numVerticalGlyphVertices:l,crossTileID:f,numIconVertices:g}=r;let v=this.opacities[f];i[f]?v=s:v||(v=d,this.opacities[f]=v),i[f]=!0;const x=a>0||l>0,y=g>0,b=this.placedOrientations[f],w=b===e.WritingMode.vertical,T=b===e.WritingMode.horizontal||b===e.WritingMode.horizontalOnly;if(!x&&!y||v.isHidden()||m++,x){const e=Ut(v.text);p(t.text,a,w?Nt:e),p(t.text,l,T?Nt:e);const i=v.text.isHidden(),{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:n,rightJustifiedTextSymbolIndex:s,verticalPlacedTextSymbolIndex:c}=r,h=t.text.placedSymbolArray,u=i||w?1:0;o>=0&&(h.get(o).hidden=u),n>=0&&(h.get(n).hidden=u),s>=0&&(h.get(s).hidden=u),c>=0&&(h.get(c).hidden=i||T?1:0);const _=this.variableOffsets[f];_&&this.markUsedJustification(t,_.anchor,r,b);const d=this.placedOrientations[f];d&&(this.markUsedJustification(t,"left",r,d),this.markUsedOrientation(t,d,r));}if(y){const e=Ut(v.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:o}=r,n=t.icon.placedSymbolArray,s=v.icon.isHidden()?1:0;i>=0&&(p(t.icon,g,w?Nt:e),n.get(i).hidden=s),o>=0&&(p(t.icon,r.numVerticalIconVertices,T?Nt:e),n.get(o).hidden=s);}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[o];if(i){let o=new e.pointGeometry(0,0),r=!0;if(i.textBox||i.verticalTextBox){if(c){const e=this.variableOffsets[f];e?(o=St(e.anchor,e.width,e.height,e.textOffset,e.textScale),h&&o._rotate(u?this.transform.angle:-this.transform.angle)):r=!1;}n&&(r=!v.clipped),i.textBox&&At(t.textCollisionBox.collisionVertexArray,v.text.placed,!r||w,o.x,o.y),i.verticalTextBox&&At(t.textCollisionBox.collisionVertexArray,v.text.placed,!r||T,o.x,o.y);}const s=r&&Boolean(!T&&i.verticalIconBox);i.iconBox&&At(t.iconCollisionBox.collisionVertexArray,v.icon.placed,s,_?o.x:0,_?o.y:0),i.verticalIconBox&&At(t.iconCollisionBox.collisionVertexArray,v.icon.placed,!s,_?o.x:0,_?o.y:0);}}}if(t.fullyClipped=0===m,t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function At(e,t,i,o,r){e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0),e.emplaceBack(t?1:0,i?1:0,o||0,r||0);}const zt=Math.pow(2,25),Pt=Math.pow(2,24),Rt=Math.pow(2,17),Ot=Math.pow(2,16),Bt=Math.pow(2,9),kt=Math.pow(2,8),Ft=Math.pow(2,1);function Ut(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*zt+t*Pt+i*Rt+t*Ot+i*Bt+t*kt+i*Ft+t}const Nt=0;class Gt{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(e,t,i,o,r){const n=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(n,o,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,r())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,n.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<n.length;){const e=n[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart),this._currentPartIndex++,r())return !0}return !1}}class jt{constructor(e,t,i,o,r,n,s,a){this.placement=new Lt(e,r,n,s,a),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o){const r=e.exported.now(),n=()=>{const t=e.exported.now()-r;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const e=i[t[this._currentPlacementIndex]],r=this.placement.collisionIndex.transform.zoom;if("symbol"===e.type&&(!e.minzoom||e.minzoom<=r)&&(!e.maxzoom||e.maxzoom>r)){if(this._inProgressLayer||(this._inProgressLayer=new Gt(e)),this._inProgressLayer.continuePlacement(o[e.source],this.placement,this._showCollisionBoxes,e,n))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Zt=512/e.EXTENT/2;class Vt{constructor(e,t,i){this.tileID=e,this.indexedSymbolInstances={},this.bucketInstanceId=i;for(let i=0;i<t.length;i++){const o=t.get(i),r=o.key;this.indexedSymbolInstances[r]||(this.indexedSymbolInstances[r]=[]),this.indexedSymbolInstances[r].push({crossTileID:o.crossTileID,coord:this.getScaledCoordinates(o,e)});}}getScaledCoordinates(t,i){const o=Zt/Math.pow(2,i.canonical.z-this.tileID.canonical.z);return {x:Math.floor((i.canonical.x*e.EXTENT+t.tileAnchorX)*o),y:Math.floor((i.canonical.y*e.EXTENT+t.tileAnchorY)*o)}}findMatches(e,t,i){const o=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let r=0;r<e.length;r++){const n=e.get(r);if(n.crossTileID)continue;const s=this.indexedSymbolInstances[n.key];if(!s)continue;const a=this.getScaledCoordinates(n,t);for(const e of s)if(Math.abs(e.coord.x-a.x)<=o&&Math.abs(e.coord.y-a.y)<=o&&!i[e.crossTileID]){i[e.crossTileID]=!0,n.crossTileID=e.crossTileID;break}}}}class Wt{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class Xt{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const r=i[e];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),o[r.tileID.key]=r;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const r=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in r){const n=r[i];n.tileID.isChildOf(e)&&n.findMatches(t.symbolInstances,e,o);}else {const n=r[e.scaledTo(Number(i)).key];n&&n.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e);r.crossTileID||(r.crossTileID=i.generate(),o[r.crossTileID]=!0);}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new Vt(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i in t.indexedSymbolInstances)for(const o of t.indexedSymbolInstances[i])delete this.usedCrossTileIDs[e][o.crossTileID];}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const r in o)e[o[r].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[r]),delete o[r],t=!0);}return t}}class qt{constructor(){this.layerIndexes={},this.crossTileIDs=new Wt,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i,o){let r=this.layerIndexes[e.id];void 0===r&&(r=this.layerIndexes[e.id]=new Xt);let n=!1;const s={};"globe"!==o.name&&r.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,t,this.crossTileIDs)&&(n=!0),s[t.bucketInstanceId]=!0);}return r.removeStaleBuckets(s)&&(n=!0),n}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}const $t=(t,i)=>e.emitValidationErrors(t,i&&i.filter((e=>"source.canvas"!==e.identifier))),Ht=e.pick(We,["addLayer","removeLayer","setPaintProperty","setLayoutProperty","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain","setFog","setProjection"]),Yt=e.pick(We,["setCenter","setZoom","setBearing","setPitch"]),Kt={version:8,layers:[],sources:{}},Jt={fill:!0,line:!0,background:!0,hillshade:!0,raster:!0};class Qt extends e.Evented{constructor(t,i={}){super(),this.map=t,this.dispatcher=new z(je(),this),this.imageManager=new y,this.imageManager.setEventedParent(this),this.glyphManager=new e.GlyphManager(t._requestManager,i.localFontFamily?e.LocalGlyphMode.all:i.localIdeographFontFamily?e.LocalGlyphMode.ideographs:e.LocalGlyphMode.none,i.localFontFamily||i.localIdeographFontFamily),this.crossTileSymbolIndex=new qt,this._layers={},this._num3DLayers=0,this._numSymbolLayers=0,this._numCircleLayers=0,this._serializedLayers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this._loaded=!1,this._availableImages=[],this._order=[],this._drapedFirstOrder=[],this._markersNeedUpdate=!1,this._resetUpdates(),this.dispatcher.broadcast("setReferrer",e.getReferrer());const o=this;this._rtlTextPluginCallback=Qt.registerForPluginStateChange((t=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:t.pluginStatus,pluginURL:t.pluginURL},((t,i)=>{if(e.triggerPluginCompletionEvent(t),i&&i.every((e=>e)))for(const e in o._sourceCaches){const t=o._sourceCaches[e],i=t.getSource().type;"vector"!==i&&"geojson"!==i||t.reload();}}));})),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i);}}));}loadURL(t,i={}){this.fire(new e.Event("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!e.isMapboxURL(t);t=this.map._requestManager.normalizeStyleURL(t,i.accessToken);const r=this.map._requestManager.transformRequest(t,e.ResourceType.Style);this._request=e.getJSON(r,((t,i)=>{this._request=null,t?this.fire(new e.ErrorEvent(t)):i&&this._load(i,o);}));}loadJSON(t,i={}){this.fire(new e.Event("dataloading",{dataType:"style"})),this._request=e.exported.frame((()=>{this._request=null,this._load(t,!1!==i.validate);}));}loadEmpty(){this.fire(new e.Event("dataloading",{dataType:"style"})),this._load(Kt,!1);}_updateLayerCount(e,t){const i=t?1:-1;e.is3D()&&(this._num3DLayers+=i),"circle"===e.type&&(this._numCircleLayers+=i),"symbol"===e.type&&(this._numSymbolLayers+=i);}_load(t,i){if(i&&$t(this,e.validateStyle(t)))return;this._loaded=!0,this.stylesheet=e.clone$1(t),this._updateMapProjection();for(const e in t.sources)this.addSource(e,t.sources[e],{validate:!1});this._changed=!1,t.sprite?this._loadSprite(t.sprite):(this.imageManager.setLoaded(!0),this.dispatcher.broadcast("spriteLoaded",!0)),this.glyphManager.setURL(t.glyphs);const o=Ve(this.stylesheet.layers);this._order=o.map((e=>e.id)),this._layers={},this._serializedLayers={};for(const t of o){const i=e.createStyleLayer(t);i.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=i,this._serializedLayers[i.id]=i.serialize(),this._updateLayerCount(i,!0);}this.dispatcher.broadcast("setLayers",this._serializeLayers(this._order)),this.light=new T(this.stylesheet.light),this.stylesheet.terrain&&!this.terrainSetForDrapingOnly()&&this._createTerrain(this.stylesheet.terrain,1),this.stylesheet.fog&&this._createFog(this.stylesheet.fog),this._updateDrapeFirstLayers(),this.fire(new e.Event("data",{dataType:"style"})),this.fire(new e.Event("style.load"));}terrainSetForDrapingOnly(){return !!this.terrain&&0===this.terrain.drapeRenderMode}setProjection(e){e?this.stylesheet.projection=e:delete this.stylesheet.projection,this._updateMapProjection();}applyProjectionUpdate(){this._loaded&&(this.dispatcher.broadcast("setProjection",this.map.transform.projectionOptions),this.map.transform.projection.requiresDraping?this.getTerrain()||this.stylesheet.terrain||this.setTerrainForDraping():this.terrainSetForDrapingOnly()&&this.setTerrain(null));}_updateMapProjection(){this.map._useExplicitProjection?this.applyProjectionUpdate():this.map._prioritizeAndUpdateProjection(null,this.stylesheet.projection);}_loadSprite(t){this._spriteRequest=function(t,i,o){let r,n,s;const a=e.exported.devicePixelRatio>1?"@2x":"";let l=e.getJSON(i.transformRequest(i.normalizeSpriteURL(t,a,".json"),e.ResourceType.SpriteJSON),((e,t)=>{l=null,s||(s=e,r=t,h());})),c=e.getImage(i.transformRequest(i.normalizeSpriteURL(t,a,".png"),e.ResourceType.SpriteImage),((e,t)=>{c=null,s||(s=e,n=t,h());}));function h(){if(s)o(s);else if(r&&n){const t=e.exported.getImageData(n),i={};for(const o in r){const{width:n,height:s,x:a,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:_,content:d}=r[o],p=new e.RGBAImage({width:n,height:s});e.RGBAImage.copy(t,p,{x:a,y:l},{x:0,y:0},{width:n,height:s}),i[o]={data:p,pixelRatio:h,sdf:c,stretchX:u,stretchY:_,content:d};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(t,this.map._requestManager,((t,i)=>{if(this._spriteRequest=null,t)this.fire(new e.ErrorEvent(t));else if(i)for(const e in i)this.imageManager.addImage(e,i[e]);this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),this.dispatcher.broadcast("setImages",this._availableImages),this.dispatcher.broadcast("spriteLoaded",!0),this.fire(new e.Event("data",{dataType:"style"}));}));}_validateLayer(t){const i=this.getSource(t.source);if(!i)return;const o=t.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new e.ErrorEvent(new Error(`Source layer "${o}" does not exist on source "${i.id}" as specified by style layer "${t.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];"custom"!==e.type&&t.push(e.serialize());}return t}hasTransitions(){if(this.light&&this.light.hasTransition())return !0;if(this.fog&&this.fog.hasTransition())return !0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}get order(){return this.map._optimizeForTerrain&&this.terrain?this._drapedFirstOrder:this._order}isLayerDraped(e){return !!this.terrain&&("function"==typeof e.isLayerDraped?e.isLayerDraped():Jt[e.type])}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}update(t){if(!this._loaded)return;const i=this._changed;if(this._changed){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const e in this._updatedSources){const t=this._updatedSources[e];"reload"===t?this._reloadSource(e):"clear"===t&&this._clearSource(e);}this._updateTilesForChangedImages();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.fog&&this.fog.updateTransitions(t),this._resetUpdates();}const o={};for(const e in this._sourceCaches){const t=this._sourceCaches[e];o[e]=t.used,t.used=!1;}for(const e of this._order){const i=this._layers[e];if(i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)){const e=this._getLayerSourceCache(i);e&&(e.used=!0);}const o=this.map.painter;if(o){const e=i.getProgramIds();if(!e)continue;const r=i.getProgramConfiguration(t.zoom);for(const t of e)o.useProgram(t,r);}}for(const t in o){const i=this._sourceCaches[t];o[t]!==i.used&&i.getSource().fire(new e.Event("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light.recalculate(t),this.terrain&&this.terrain.recalculate(t),this.fog&&this.fog.recalculate(t),this.z=t.zoom,this._markersNeedUpdate&&(this._updateMarkersOpacity(),this._markersNeedUpdate=!1),i&&this.fire(new e.Event("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this._sourceCaches)this._sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={};}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("updateLayers",{layers:this._serializeLayers(e),removedIds:t});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={};}setState(i){if(this._checkLoaded(),$t(this,e.validateStyle(i)))return !1;(i=e.clone$1(i)).layers=Ve(i.layers);const o=function(e,i){if(!e)return [{command:We.setStyle,args:[i]}];let o=[];try{if(!t(e.version,i.version))return [{command:We.setStyle,args:[i]}];t(e.center,i.center)||o.push({command:We.setCenter,args:[i.center]}),t(e.zoom,i.zoom)||o.push({command:We.setZoom,args:[i.zoom]}),t(e.bearing,i.bearing)||o.push({command:We.setBearing,args:[i.bearing]}),t(e.pitch,i.pitch)||o.push({command:We.setPitch,args:[i.pitch]}),t(e.sprite,i.sprite)||o.push({command:We.setSprite,args:[i.sprite]}),t(e.glyphs,i.glyphs)||o.push({command:We.setGlyphs,args:[i.glyphs]}),t(e.transition,i.transition)||o.push({command:We.setTransition,args:[i.transition]}),t(e.light,i.light)||o.push({command:We.setLight,args:[i.light]}),t(e.fog,i.fog)||o.push({command:We.setFog,args:[i.fog]}),t(e.projection,i.projection)||o.push({command:We.setProjection,args:[i.projection]});const r={},n=[];!function(e,i,o,r){let n;for(n in i=i||{},e=e||{})e.hasOwnProperty(n)&&(i.hasOwnProperty(n)||qe(n,o,r));for(n in i){if(!i.hasOwnProperty(n))continue;const s=i[n];e.hasOwnProperty(n)?t(e[n],s)||("geojson"===e[n].type&&"geojson"===s.type&&He(e,i,n)?o.push({command:We.setGeoJSONSourceData,args:[n,s.data]}):$e(n,i,o,r)):Xe(n,i,o);}}(e.sources,i.sources,n,r);const s=[];e.layers&&e.layers.forEach((e=>{e.source&&r[e.source]?o.push({command:We.removeLayer,args:[e.id]}):s.push(e);}));let a=e.terrain;a&&r[a.source]&&(o.push({command:We.setTerrain,args:[void 0]}),a=void 0),o=o.concat(n),t(a,i.terrain)||o.push({command:We.setTerrain,args:[i.terrain]}),function(e,i,o){i=i||[];const r=(e=e||[]).map(Ke),n=i.map(Ke),s=e.reduce(Je,{}),a=i.reduce(Je,{}),l=r.slice(),c=Object.create(null);let h,u,_,d,p,m,f;for(h=0,u=0;h<r.length;h++)_=r[h],a.hasOwnProperty(_)?u++:(o.push({command:We.removeLayer,args:[_]}),l.splice(l.indexOf(_,u),1));for(h=0,u=0;h<n.length;h++)_=n[n.length-1-h],l[l.length-1-h]!==_&&(s.hasOwnProperty(_)?(o.push({command:We.removeLayer,args:[_]}),l.splice(l.lastIndexOf(_,l.length-u),1)):u++,m=l[l.length-h],o.push({command:We.addLayer,args:[a[_],m]}),l.splice(l.length-h,0,_),c[_]=!0);for(h=0;h<n.length;h++)if(_=n[h],d=s[_],p=a[_],!c[_]&&!t(d,p))if(t(d.source,p.source)&&t(d["source-layer"],p["source-layer"])&&t(d.type,p.type)){for(f in Ye(d.layout,p.layout,o,_,null,We.setLayoutProperty),Ye(d.paint,p.paint,o,_,null,We.setPaintProperty),t(d.filter,p.filter)||o.push({command:We.setFilter,args:[_,p.filter]}),t(d.minzoom,p.minzoom)&&t(d.maxzoom,p.maxzoom)||o.push({command:We.setLayerZoomRange,args:[_,p.minzoom,p.maxzoom]}),d)d.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ye(d[f],p[f],o,_,f.slice(6),We.setPaintProperty):t(d[f],p[f])||o.push({command:We.setLayerProperty,args:[_,f,p[f]]}));for(f in p)p.hasOwnProperty(f)&&!d.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ye(d[f],p[f],o,_,f.slice(6),We.setPaintProperty):t(d[f],p[f])||o.push({command:We.setLayerProperty,args:[_,f,p[f]]}));}else o.push({command:We.removeLayer,args:[_]}),m=l[l.lastIndexOf(_)+1],o.push({command:We.addLayer,args:[p,m]});}(s,i.layers,o);}catch(e){console.warn("Unable to compute style diff:",e),o=[{command:We.setStyle,args:[i]}];}return o}(this.serialize(),i).filter((e=>!(e.command in Yt)));if(0===o.length)return !1;const r=o.filter((e=>!(e.command in Ht)));if(r.length>0)throw new Error(`Unimplemented: ${r.map((e=>e.command)).join(", ")}.`);return o.forEach((e=>{"setTransition"!==e.command&&"setProjection"!==e.command&&this[e.command].apply(this,e.args);})),this.stylesheet=i,this._updateMapProjection(),!0}addImage(t,i){return this.getImage(t)?this.fire(new e.ErrorEvent(new Error("An image with this name already exists."))):(this.imageManager.addImage(t,i),this._afterImageUpdated(t),this)}updateImage(e,t){this.imageManager.updateImage(e,t);}getImage(e){return this.imageManager.getImage(e)}removeImage(t){return this.getImage(t)?(this.imageManager.removeImage(t),this._afterImageUpdated(t),this):this.fire(new e.ErrorEvent(new Error("No image with this name exists.")))}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new e.Event("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this._availableImages.slice()}addSource(t,i,o={}){if(this._checkLoaded(),void 0!==this.getSource(t))throw new Error("There is already a source with this ID");if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(e.validateSource,`sources.${t}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const r=Pe(t,i,this.dispatcher,this);r.setEventedParent(this,(()=>({isSourceLoaded:this._isSourceCacheLoaded(t),source:r.serialize(),sourceId:t})));const n=i=>{const o=(i?"symbol:":"other:")+t,n=this._sourceCaches[o]=new e.SourceCache(o,r,i);(i?this._symbolSourceCaches:this._otherSourceCaches)[t]=n,n.style=this,n.onAdd(this.map);};n(!1),"vector"!==i.type&&"geojson"!==i.type||n(!0),r.onAdd&&r.onAdd(this.map),this._changed=!0;}removeSource(t){this._checkLoaded();const i=this.getSource(t);if(!i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.ErrorEvent(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.get().source===t)return this.fire(new e.ErrorEvent(new Error(`Source "${t}" cannot be removed while terrain is using it.`)));const o=this._getSourceCaches(t);for(const t of o)delete this._sourceCaches[t.id],delete this._updatedSources[t.id],t.fire(new e.Event("data",{sourceDataType:"metadata",dataType:"source",sourceId:t.getSource().id})),t.setEventedParent(null),t.clearTiles();return delete this._otherSourceCaches[t],delete this._symbolSourceCaches[t],i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changed=!0,this}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getSource(e).setData(t),this._changed=!0;}getSource(e){const t=this._getSourceCache(e);return t&&t.getSource()}_getSources(){const e=[];for(const t in this._otherSourceCaches){const i=this._getSourceCache(t);i&&e.push(i.getSource());}return e}addLayer(t,i,o={}){this._checkLoaded();const r=t.id;if(this.getLayer(r))return void this.fire(new e.ErrorEvent(new Error(`Layer with id "${r}" already exists on this map`)));let n;if("custom"===t.type){if($t(this,e.validateCustomStyleLayer(t)))return;n=e.createStyleLayer(t);}else {if("object"==typeof t.source&&(this.addSource(r,t.source),t=e.clone$1(t),t=e.extend(t,{source:r})),this._validate(e.validateLayer,`layers.${r}`,t,{arrayIndex:-1},o))return;n=e.createStyleLayer(t),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}}),this._serializedLayers[n.id]=n.serialize(),this._updateLayerCount(n,!0);}const s=i?this._order.indexOf(i):this._order.length;if(i&&-1===s)return void this.fire(new e.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`)));this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=n;const a=this._getLayerSourceCache(n);if(this._removedLayers[r]&&n.source&&a&&"custom"!==n.type){const e=this._removedLayers[r];delete this._removedLayers[r],e.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",a.pause());}this._updateLayer(n),n.onAdd&&n.onAdd(this.map),this._updateDrapeFirstLayers();}moveLayer(t,i){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===i)return;const o=this._order.indexOf(t);this._order.splice(o,1);const r=i?this._order.indexOf(i):this._order.length;i&&-1===r?this.fire(new e.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`))):(this._order.splice(r,0,t),this._layerOrderChanged=!0,this._updateDrapeFirstLayers());}removeLayer(t){this._checkLoaded();const i=this._layers[t];if(!i)return void this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be removed.`)));i.setEventedParent(null),this._updateLayerCount(i,!1);const o=this._order.indexOf(t);this._order.splice(o,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=i,delete this._layers[t],delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],i.onRemove&&i.onRemove(this.map),this._updateDrapeFirstLayers();}getLayer(e){return this._layers[e]}hasLayer(e){return e in this._layers}hasLayerType(e){for(const t in this._layers)if(this._layers[t].type===e)return !0;return !1}setLayerZoomRange(t,i,o){this._checkLoaded();const r=this.getLayer(t);r?r.minzoom===i&&r.maxzoom===o||(null!=i&&(r.minzoom=i),null!=o&&(r.maxzoom=o),this._updateLayer(r)):this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot have zoom extent.`)));}setFilter(i,o,r={}){this._checkLoaded();const n=this.getLayer(i);if(n){if(!t(n.filter,o))return null==o?(n.filter=void 0,void this._updateLayer(n)):void(this._validate(e.validateFilter,`layers.${n.id}.filter`,o,{layerType:n.type},r)||(n.filter=e.clone$1(o),this._updateLayer(n)))}else this.fire(new e.ErrorEvent(new Error(`The layer '${i}' does not exist in the map's style and cannot be filtered.`)));}getFilter(t){const i=this.getLayer(t);return i&&e.clone$1(i.filter)}setLayoutProperty(i,o,r,n={}){this._checkLoaded();const s=this.getLayer(i);s?t(s.getLayoutProperty(o),r)||(s.setLayoutProperty(o,r,n),this._updateLayer(s)):this.fire(new e.ErrorEvent(new Error(`The layer '${i}' does not exist in the map's style and cannot be styled.`)));}getLayoutProperty(t,i){const o=this.getLayer(t);if(o)return o.getLayoutProperty(i);this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style.`)));}setPaintProperty(i,o,r,n={}){this._checkLoaded();const s=this.getLayer(i);s?t(s.getPaintProperty(o),r)||(s.setPaintProperty(o,r,n)&&this._updateLayer(s),this._changed=!0,this._updatedPaintProps[i]=!0):this.fire(new e.ErrorEvent(new Error(`The layer '${i}' does not exist in the map's style and cannot be styled.`)));}getPaintProperty(e,t){const i=this.getLayer(e);return i&&i.getPaintProperty(t)}setFeatureState(t,i){this._checkLoaded();const o=t.source,r=t.sourceLayer,n=this.getSource(o);if(!n)return void this.fire(new e.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const s=n.type;if("geojson"===s&&r)return void this.fire(new e.ErrorEvent(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===s&&!r)return void this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===t.id&&this.fire(new e.ErrorEvent(new Error("The feature id parameter must be provided.")));const a=this._getSourceCaches(o);for(const e of a)e.setFeatureState(r,t.id,i);}removeFeatureState(t,i){this._checkLoaded();const o=t.source,r=this.getSource(o);if(!r)return void this.fire(new e.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const n=r.type,s="vector"===n?t.sourceLayer:void 0;if("vector"===n&&!s)return void this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof t.id&&"number"!=typeof t.id)return void this.fire(new e.ErrorEvent(new Error("A feature id is required to remove its specific state property.")));const a=this._getSourceCaches(o);for(const e of a)e.removeFeatureState(s,t.id,i);}getFeatureState(t){this._checkLoaded();const i=t.source,o=t.sourceLayer,r=this.getSource(i);if(r){if("vector"!==r.type||o)return void 0===t.id&&this.fire(new e.ErrorEvent(new Error("The feature id parameter must be provided."))),this._getSourceCaches(i)[0].getFeatureState(o,t.id);this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));}else this.fire(new e.ErrorEvent(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return e.extend({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){const t={};for(const e in this._sourceCaches){const i=this._sourceCaches[e].getSource();t[i.id]||(t[i.id]=i.serialize());}return e.filterObject({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,light:this.stylesheet.light,terrain:this.getTerrain()||void 0,fog:this.stylesheet.fog,center:this.stylesheet.center,zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,projection:this.stylesheet.projection,sources:t,layers:this._serializeLayers(this._order)},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0;const t=this._getLayerSourceCache(e);e.source&&!this._updatedSources[e.source]&&t&&"raster"!==t.getSource().type&&(this._updatedSources[e.source]="reload",t.pause()),this._changed=!0,e.invalidateCompiledFilter();}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},o=[];for(let r=this._order.length-1;r>=0;r--){const n=this._order[r];if(t(n)){i[n]=r;for(const t of e){const e=t[n];if(e)for(const t of e)o.push(t);}}}o.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const r=[];for(let n=this._order.length-1;n>=0;n--){const s=this._order[n];if(t(s))for(let e=o.length-1;e>=0;e--){const t=o[e].feature;if(i[t.layer.id]<n)break;r.push(t),o.pop();}else for(const t of e){const e=t[s];if(e)for(const t of e)r.push(t.feature);}}return r}queryRenderedFeatures(t,i,o){i&&i.filter&&this._validate(e.validateFilter,"queryRenderedFeatures.filter",i.filter,null,i);const r={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new e.ErrorEvent(new Error("parameters.layers must be an Array."))),[];for(const t of i.layers){const i=this._layers[t];if(!i)return this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[i.source]=!0;}}const n=[];i.availableImages=this._availableImages;const s=i&&i.layers?i.layers.some((e=>{const t=this.getLayer(e);return t&&t.is3D()})):this.has3DLayers(),a=R.createFromScreenPoints(t,o);for(const e in this._sourceCaches){const t=this._sourceCaches[e].getSource().id;i.layers&&!r[t]||n.push(Oe(this._sourceCaches[e],this._layers,this._serializedLayers,a,i,o,s,!!this.map._showQueryGeometry));}return this.placement&&n.push(function(e,t,i,o,r,n,s){const a={},l=n.queryRenderedSymbols(o),c=[];for(const e of Object.keys(l).map(Number))c.push(s[e]);c.sort(ke);for(const i of c){const o=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,r.filter,r.layers,r.availableImages,e);for(const e in o){const t=a[e]=a[e]||[],r=o[e];r.sort(((e,t)=>{const o=i.featureSortOrder;if(o){const i=o.indexOf(e.featureIndex);return o.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of r)t.push(e);}}for(const t in a)a[t].forEach((o=>{const r=o.feature,n=i(e[t]);if(!n)return;const s=n.getFeatureState(r.layer["source-layer"],r.id);r.source=r.layer.source,r.layer["source-layer"]&&(r.sourceLayer=r.layer["source-layer"]),r.state=s;}));return a}(this._layers,this._serializedLayers,this._getLayerSourceCache.bind(this),a.screenGeometry,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(t,i){i&&i.filter&&this._validate(e.validateFilter,"querySourceFeatures.filter",i.filter,null,i);const o=this._getSourceCaches(t);let r=[];for(const e of o)r=r.concat(Be(e,i));return r}addSourceType(e,t,i){return Qt.getSourceType(e)?i(new Error(`A source type called "${e}" already exists.`)):(Qt.setSourceType(e,t),t.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:e,url:t.workerSourceURL},i):i(null,null))}getLight(){return this.light.getLight()}setLight(e,i={}){this._checkLoaded();const o=this.light.getLight();let r=!1;for(const i in e)if(!t(e[i],o[i])){r=!0;break}if(!r)return;const n=this._setTransitionParameters({duration:300,delay:0});this.light.setLight(e,i),this.light.updateTransitions(n);}getTerrain(){return this.terrain&&1===this.terrain.drapeRenderMode?this.terrain.get():null}setTerrainForDraping(){this.setTerrain({source:"",exaggeration:0},0);}setTerrain(i,o=1){if(this._checkLoaded(),!i)return delete this.terrain,delete this.stylesheet.terrain,this.dispatcher.broadcast("enableTerrain",!1),this._force3DLayerUpdate(),void(this._markersNeedUpdate=!0);let r=i;if(1===o){if("object"==typeof r.source){const t="terrain-dem-src";this.addSource(t,r.source),r=e.clone$1(r),r=e.extend(r,{source:t});}if(this._validate(e.validateTerrain,"terrain",r))return}if(!this.terrain||this.terrain&&o!==this.terrain.drapeRenderMode){if(!r)return;this._createTerrain(r,o);}else {const i=this.terrain,o=i.get();for(const t of Object.keys(e.spec.terrain))!r.hasOwnProperty(t)&&e.spec.terrain[t].default&&(r[t]=e.spec.terrain[t].default);for(const e in r)if(!t(r[e],o[e])){i.set(r),this.stylesheet.terrain=r;const e=this._setTransitionParameters({duration:0});i.updateTransitions(e);break}}this._updateDrapeFirstLayers(),this._markersNeedUpdate=!0;}_createFog(e){const t=this.fog=new A(e,this.map.transform);this.stylesheet.fog=e;const i=this._setTransitionParameters({duration:0});t.updateTransitions(i);}_updateMarkersOpacity(){0!==this.map._markers.length&&this.map._requestDomTask((()=>{for(const e of this.map._markers)e._evaluateOpacity();}));}getFog(){return this.fog?this.fog.get():null}setFog(e){if(this._checkLoaded(),!e)return delete this.fog,delete this.stylesheet.fog,void(this._markersNeedUpdate=!0);if(this.fog){const i=this.fog,o=i.get();0===Object.keys(e).length&&i.set(e);for(const r in e)if(!t(e[r],o[r])){i.set(e),this.stylesheet.fog=e;const t=this._setTransitionParameters({duration:0});i.updateTransitions(t);break}}else this._createFog(e);this._markersNeedUpdate=!0;}_setTransitionParameters(t){return {now:e.exported.now(),transition:e.extend(t,this.stylesheet.transition)}}_updateDrapeFirstLayers(){if(!this.map._optimizeForTerrain||!this.terrain)return;const e=this._order.filter((e=>this.isLayerDraped(this._layers[e]))),t=this._order.filter((e=>!this.isLayerDraped(this._layers[e])));this._drapedFirstOrder=[],this._drapedFirstOrder.push(...e),this._drapedFirstOrder.push(...t);}_createTerrain(e,t){const i=this.terrain=new M(e,t);this.stylesheet.terrain=e,this.dispatcher.broadcast("enableTerrain",!this.terrainSetForDrapingOnly()),this._force3DLayerUpdate();const o=this._setTransitionParameters({duration:0});i.updateTransitions(o);}_force3DLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"fill-extrusion"===t.type&&this._updateLayer(t);}}_forceSymbolLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"symbol"===t.type&&this._updateLayer(t);}}_validate(t,i,o,r,n={}){return (!n||!1!==n.validate)&&$t(this,t.call(e.validateStyle,e.extend({key:i,style:this.serialize(),value:o,styleSpec:e.spec},r)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),e.evented.off("pluginStateChange",this._rtlTextPluginCallback);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this._sourceCaches)this._sourceCaches[e].clearTiles(),this._sourceCaches[e].setEventedParent(null);this.imageManager.setEventedParent(null),this.setEventedParent(null),this.dispatcher.remove();}_clearSource(e){const t=this._getSourceCaches(e);for(const e of t)e.clearTiles();}_reloadSource(e){const t=this._getSourceCaches(e);for(const e of t)e.resume(),e.reload();}_reloadSources(){for(const e of this._getSources())e.reload&&e.reload();}_updateSources(e){for(const t in this._sourceCaches)this._sourceCaches[t].update(e);}_generateCollisionBoxes(){for(const e in this._sourceCaches){const t=this._sourceCaches[e];t.resume(),t.reload();}}_updatePlacement(t,i,o,r,n=!1){let s=!1,a=!1;const l={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!l[i.source]){const e=this._getLayerSourceCache(i);if(!e)continue;l[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const o=this.crossTileSymbolIndex.addLayer(i,l[i.source],t.center.lng,t.projection);s=s||o;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),n=n||this._layerOrderChanged||0===o,this._layerOrderChanged&&this.fire(new e.Event("neworder")),(n||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(e.exported.now(),t.zoom))&&(this.pauseablePlacement=new jt(t,this._order,n,i,o,r,this.placement,this.fog&&t.projection.supportsFog?this.fog.state:null),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(e.exported.now()),a=!0),s&&this.pauseablePlacement.placement.setStale()),a||s)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,l[t.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(e.exported.now())}_releaseSymbolFadeTiles(){for(const e in this._sourceCaches)this._sourceCaches[e].releaseSymbolFadeTiles();}getImages(e,t,i){this.imageManager.getImages(t.icons,i),this._updateTilesForChangedImages();const o=e=>{e&&e.setDependencies(t.tileID.key,t.type,t.icons);};o(this._otherSourceCaches[t.source]),o(this._symbolSourceCaches[t.source]);}getGlyphs(e,t,i){this.glyphManager.getGlyphs(t.stacks,i);}getResource(t,i,o){return e.makeRequest(i,o)}_getSourceCache(e){return this._otherSourceCaches[e]}_getLayerSourceCache(e){return "symbol"===e.type?this._symbolSourceCaches[e.source]:this._otherSourceCaches[e.source]}_getSourceCaches(e){const t=[];return this._otherSourceCaches[e]&&t.push(this._otherSourceCaches[e]),this._symbolSourceCaches[e]&&t.push(this._symbolSourceCaches[e]),t}_isSourceCacheLoaded(t){const i=this._getSourceCaches(t);return 0===i.length?(this.fire(new e.ErrorEvent(new Error(`There is no source with ID '${t}'`))),!1):i.every((e=>e.loaded()))}has3DLayers(){return this._num3DLayers>0}hasSymbolLayers(){return this._numSymbolLayers>0}hasCircleLayers(){return this._numCircleLayers>0}_clearWorkerCaches(){this.dispatcher.broadcast("clearCaches");}destroy(){this._clearWorkerCaches(),this.terrainSetForDrapingOnly()&&(delete this.terrain,delete this.stylesheet.terrain);}}Qt.getSourceType=function(e){return ze[e]},Qt.setSourceType=function(e,t){ze[e]=t;},Qt.registerForPluginStateChange=e.registerForPluginStateChange;var ei="\n#define EPSILON 0.0000001\n#define PI 3.141592653589793\n#define EXTENT 8192.0\n#define HALF_PI PI/2.0\n#define QUARTER_PI PI/4.0\n#define RAD_TO_DEG 180.0/PI\n#define DEG_TO_RAD PI/180.0\n#define GLOBE_RADIUS EXTENT/PI/2.0",ti="attribute highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;varying highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}",ii="\n#define ELEVATION_SCALE 7.0\n#define ELEVATION_OFFSET 450.0\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_tl_up;uniform vec3 u_tile_tr_up;uniform vec3 u_tile_br_up;uniform vec3 u_tile_bl_up;uniform float u_tile_up_scale;vec3 elevationVector(vec2 pos) {vec2 uv=pos/EXTENT;vec3 up=normalize(mix(\nmix(u_tile_tl_up,u_tile_tr_up,uv.xxx),mix(u_tile_bl_up,u_tile_br_up,uv.xxx),uv.yyy));return up*u_tile_up_scale;}\n#else\nvec3 elevationVector(vec2 pos) { return vec3(0,0,1); }\n#endif\nconst float skirtOffset=24575.0;vec3 decomposeToPosAndSkirt(vec2 posWithComposedSkirt)\n{float skirt=float(posWithComposedSkirt.x >=skirtOffset);vec2 pos=posWithComposedSkirt-vec2(skirt*skirtOffset,0.0);return vec3(pos,skirt);}\n#ifdef TERRAIN\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nuniform highp sampler2D u_dem;uniform highp sampler2D u_dem_prev;\n#else\nuniform sampler2D u_dem;uniform sampler2D u_dem_prev;\n#endif\nuniform vec4 u_dem_unpack;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float decodeElevation(vec4 v) {return dot(vec4(v.xyz*255.0,-1.0),u_dem_unpack);}float currentElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale+u_dem_tl)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture2D(u_dem,pos).a;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem,pos));\n#ifdef TERRAIN_DEM_NEAREST_FILTER\nreturn u_exaggeration*tl;\n#endif\nfloat tr=decodeElevation(texture2D(u_dem,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}float prevElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale_prev+u_dem_tl_prev)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture2D(u_dem_prev,pos).a;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem_prev,pos));float tr=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem_prev,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nfloat nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nreturn currentElevation(apos);}\n#endif\nhighp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture2D(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture2D(u_depth,uv-df.xz)),unpack_depth(texture2D(u_depth,uv+df.xz)),unpack_depth(texture2D(u_depth,uv-df.zy)),unpack_depth(texture2D(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nfloat tl=texture2D(u_dem,pos).a;float tr=texture2D(u_dem,pos+vec2(off.x,0.0)).a;float bl=texture2D(u_dem,pos+vec2(0.0,off.y)).a;float br=texture2D(u_dem,pos+off).a;\n#else\nvec4 demtl=vec4(texture2D(u_dem,pos).xyz*255.0,-1.0);float tl=dot(demtl,u_dem_unpack);vec4 demtr=vec4(texture2D(u_dem,pos+vec2(off.x,0.0)).xyz*255.0,-1.0);float tr=dot(demtr,u_dem_unpack);vec4 dembl=vec4(texture2D(u_dem,pos+vec2(0.0,off.y)).xyz*255.0,-1.0);float bl=dot(dembl,u_dem_unpack);vec4 dembr=vec4(texture2D(u_dem,pos+off).xyz*255.0,-1.0);float br=dot(dembr,u_dem_unpack);\n#endif\nreturn vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*(word/ELEVATION_SCALE-ELEVATION_OFFSET);}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",oi="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump mat4 u_fog_matrix;varying vec3 v_fog_pos;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}vec3 fog_position(vec3 pos) {return (u_fog_matrix*vec4(pos,1.0)).xyz;}vec3 fog_position(vec2 pos) {return fog_position(vec3(pos,0.0));}float fog(vec3 pos) {float depth=length(pos);float opacity=fog_opacity(fog_range(depth));return opacity*fog_horizon_blending(pos/depth);}\n#endif",ri="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump float u_fog_temporal_offset;varying vec3 v_fog_pos;uniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform highp vec2 u_viewport;uniform float u_globe_transition;uniform int u_is_globe;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}float globe_glow_progress() {highp vec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);highp vec3 dir=normalize(ray_dir);highp vec3 closest_point=dot(u_globe_pos,dir)*dir;highp float sdf=length(closest_point-u_globe_pos)/u_globe_radius;return sdf+PI*0.5;}float fog_opacity(vec3 pos) {float depth=length(pos);return fog_opacity(fog_range(depth));}vec3 fog_apply(vec3 color,vec3 pos) {float depth=length(pos);float opacity;if (u_is_globe==1) {float glow_progress=globe_glow_progress();float t=mix(glow_progress,depth,u_globe_transition);opacity=fog_opacity(fog_range(t));} else {opacity=fog_opacity(fog_range(depth));opacity*=fog_horizon_blending(pos/depth);}return mix(color,u_fog_color.rgb,opacity);}vec4 fog_apply_from_vert(vec4 color,float fog_opac) {float alpha=EPSILON+color.a;color.rgb=mix(color.rgb/alpha,u_fog_color.rgb,fog_opac)*alpha;return color;}vec3 fog_apply_sky_gradient(vec3 camera_ray,vec3 sky_color) {float horizon_blend=fog_horizon_blending(normalize(camera_ray));return mix(sky_color,u_fog_color.rgb,horizon_blend);}vec4 fog_apply_premultiplied(vec4 color,vec3 pos) {float alpha=EPSILON+color.a;color.rgb=fog_apply(color.rgb/alpha,pos)*alpha;return color;}vec3 fog_dither(vec3 color) {vec2 dither_seed=gl_FragCoord.xy+u_fog_temporal_offset;return dither(color,dither_seed);}vec4 fog_dither(vec4 color) {return vec4(fog_dither(color.rgb),color.a);}\n#endif";let ni={},si={};const ai=[];_i(ei,ai),_i(ii,ai),_i(oi,ai),_i(ri,ai),ni=di("",ii),si=di(ri,oi);const li=di("\n#if __VERSION__ >=300\n#define varying in\n#define gl_FragColor glFragColor\n#define texture2D texture\n#define textureCube texture\nout vec4 glFragColor;\n#endif\nhighp vec3 hash(highp vec2 p) {highp vec3 p3=fract(p.xyx*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract((p3.xxy+p3.yzz)*p3.zyx);}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;return color+rnd/255.0;}highp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}highp vec4 pack_depth(highp float ndc_z) {highp float depth=ndc_z*0.5+0.5;const highp vec4 bit_shift=vec4(255.0*255.0*255.0,255.0*255.0,255.0,1.0);const highp vec4 bit_mask =vec4(0.0,1.0/255.0,1.0/255.0,1.0/255.0);highp vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}","\n#if __VERSION__ >=300\n#define attribute in\n#define varying out\n#define texture2D texture\n#endif\nfloat wrap(float n,float min,float max) {float d=max-min;float w=mod(mod(n-min,d)+d,d)+min;return (w==min) ? max : w;}\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 mercator_tile_position(mat4 matrix,vec2 tile_anchor,vec3 tile_id,vec2 mercator_center) {\n#ifndef PROJECTED_POS_ON_VIEWPORT\nfloat tiles=tile_id.z;vec2 mercator=(tile_anchor/EXTENT+tile_id.xy)/tiles;mercator-=mercator_center;mercator.x=wrap(mercator.x,-0.5,0.5);vec4 mercator_tile=vec4(mercator.xy*EXTENT,EXTENT/(2.0*PI),1.0);mercator_tile=matrix*mercator_tile;return mercator_tile.xyz;\n#else\nreturn vec3(0.0);\n#endif\n}vec3 mix_globe_mercator(vec3 globe,vec3 mercator,float t) {return mix(globe,mercator,t);}mat3 globe_mercator_surface_vectors(vec3 pos_normal,vec3 up_dir,float zoom_transition) {vec3 normal=zoom_transition==0.0 ? pos_normal : normalize(mix(pos_normal,up_dir,zoom_transition));vec3 xAxis=normalize(vec3(normal.z,0.0,-normal.x));vec3 yAxis=normalize(cross(normal,xAxis));return mat3(xAxis,yAxis,normal);}\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}const vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);//Normalized device coordinate that is not rendered."),ci=ei,hi="\n#ifdef GL_ES\nprecision mediump float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif";var ui={background:di("uniform vec4 u_color;uniform float u_opacity;\n#ifdef LIGHTING_3D_MODE\nvarying vec4 v_color;\n#endif\nvoid main() {vec4 out_color;\n#ifdef LIGHTING_3D_MODE\nout_color=v_color;\n#else\nout_color=u_color;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#ifdef LIGHTING_3D_MODE\nuniform vec4 u_color;varying vec4 v_color;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef LIGHTING_3D_MODE\nv_color=apply_lighting(u_color);\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),backgroundPattern:di("uniform vec2 u_pattern_tl;uniform vec2 u_pattern_br;uniform vec2 u_texsize;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos;void main() {vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(u_pattern_tl/u_texsize,u_pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_pattern_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),circle:di("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);vec4 out_color=mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_apply_premultiplied(out_color,v_fog_pos);\n#endif\ngl_FragColor=out_color*(v_visibility*opacity_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform mat2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h5=elevation(c4)+ELEVATION_BIAS;return max(h5,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale,mat3 surface_vectors) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\n#ifdef PROJECTION_GLOBE_VIEW\nreturn u_matrix*( world_center+vec4(sample_offset.x*surface_vectors[0]+sample_offset.y*surface_vectors[1],0) );\n#else\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#endif\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);vec4 world_center;mat3 surface_vectors;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(circle_center)*circle_elevation(circle_center);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*circle_elevation(circle_center);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,circle_center,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;vec3 pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);world_center=vec4(pos,1);\n#else \nsurface_vectors=mat3(1.0);float height=circle_elevation(circle_center);world_center=vec4(circle_center,height,1);\n#endif\nvec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale,surface_vectors);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();vec4 occlusion_world_center;vec4 occlusion_projected_center;\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);occlusion_world_center=vec4(circle_center,cantilevered_height,1);occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nocclusion_world_center=world_center;occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale,surface_vectors);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);\n#ifdef FOG\nv_fog_pos=fog_position(world_center.xyz);\n#endif\n}"),clippingMask:di("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:di("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef FOG\nif (u_is_globe==0) {gl_FragColor.r*=pow(1.0-fog_opacity(v_fog_pos),2.0);}\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 tilePos=floor(a_pos*0.5);vec3 pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;mat3 surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(tilePos)*elevation(tilePos);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*elevation(tilePos);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,tilePos,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#else\npos=vec3(tilePos+extrude,elevation(tilePos));\n#endif\ngl_Position=u_matrix*vec4(pos,1);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),heatmapTexture:di("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=vec4(a_pos,0,1);v_pos=a_pos*0.5+0.5;}"),collisionBox:di("varying float v_placed;varying float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);gl_FragColor =mix(red,blue,step(0.5,v_placed))*0.5;gl_FragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}","attribute vec3 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;attribute float a_size_scale;attribute vec2 a_padding;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_pos+elevationVector(a_anchor_pos)*elevation(a_anchor_pos),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=projectedPoint;gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:di("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos_2f;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:di("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;\n#endif\nvarying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\ngl_Position=u_matrix*vec4(a_pos_3+elevationVector(a_pos)*h,1);\n#else\ngl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);\n#endif\n}"),fill:di("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nvec4 out_color=color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillOutline:di("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=outline_color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillOutlinePattern:di("uniform vec2 u_texsize;uniform sampler2D u_image;varying vec2 v_pos;varying vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);float dist=length(v_pos_world-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;varying vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);v_pos_world=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillPattern:di("uniform vec2 u_texsize;uniform sampler2D u_image;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillExtrusion:di("varying vec4 v_color;\n#ifdef RENDER_SHADOWS\nvarying highp vec4 v_pos_light_view_0;varying highp vec4 v_pos_light_view_1;varying float v_depth;\n#endif\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef ZERO_ROOF_RADIUS\nvarying vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nvarying highp vec3 v_normal;\n#endif\nvoid main() {\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nvec3 normal=v_normal;\n#endif\nfloat z;vec4 color;\n#ifdef ZERO_ROOF_RADIUS\nz=float(normal.z > 0.00001);color=mix(v_color,v_roof_color,z);\n#else\ncolor=v_color;\n#endif\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h=max(0.0,v_ao.z);float h_floors=h/u_ao[1];float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);float shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;\n#ifdef ZERO_ROOF_RADIUS\nconcave*=(1.0-z);\n#endif\nfloat x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);shade*=mix(1.0,x_shade*x_shade*x_shade,concave);color.rgb=color.rgb*shade;\n#endif\n#ifdef RENDER_SHADOWS\n#ifdef ZERO_ROOF_RADIUS\nnormal=mix(normal,vec3(0.0,0.0,1.0),z);\n#endif\ncolor.xyz=shadowed_color_normal(color.xyz,normalize(normal),v_pos_light_view_0,v_pos_light_view_1,v_depth);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform float u_edge_radius;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nvarying vec4 v_color;\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;varying highp vec4 v_pos_light_view_0;varying highp vec4 v_pos_light_view_1;varying float v_depth;\n#endif\n#ifdef ZERO_ROOF_RADIUS\nvarying vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nvarying highp vec3 v_normal;\n#endif\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec4 pos_nx=floor(a_pos_normal_ed*0.5);vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nv_normal=normal;\n#endif\nbase=max(0.0,base);height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=0.0;float c_ele;vec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);pos=vec3(pos_nx.xy,h);\n#else\nh=t > 0.0 ? height : base;pos=vec3(pos_nx.xy,h);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*h);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,pos.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*pos.z;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(pos,1),AWAY,hidden);\n#ifdef RENDER_SHADOWS\nv_pos_light_view_0=u_light_matrix_0*vec4(pos,1);v_pos_light_view_1=u_light_matrix_1*vec4(pos,1);v_depth=gl_Position.w;\n#endif\nfloat NdotL=0.0;float colorvalue=0.0;\n#ifdef LIGHTING_3D_MODE\nNdotL=calculate_NdotL(normal);\n#else\ncolorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;NdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),NdotL);\n#endif\nif (normal.y !=0.0) {float r=0.84;\n#ifndef LIGHTING_3D_MODE\nr=mix(0.7,0.98,1.0-u_lightintensity);\n#endif\nNdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}v_color=vec4(0.0,0.0,0.0,1.0);\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec3(mix(concave,-concave,start),y_ground,h-ele);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\nv_color=apply_lighting(color,NdotL);\n#else\nv_color.rgb+=clamp(color.rgb*NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));\n#endif\nv_color*=u_opacity;\n#ifdef ZERO_ROOF_RADIUS\nv_roof_color=vec4(0.0,0.0,0.0,1.0);\n#ifdef LIGHTING_3D_MODE\nv_roof_color=apply_lighting(color,calculate_NdotL(vec3(0.0,0.0,1.0)));\n#else\nfloat roofNdotL=clamp(u_lightpos.z,0.0,1.0);roofNdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),roofNdotL);v_roof_color.rgb+=clamp(color.rgb*roofNdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));\n#endif\nv_roof_color*=u_opacity;\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),fillExtrusionPattern:di("uniform vec2 u_texsize;uniform sampler2D u_image;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nvarying float v_NdotL;\n#endif\nvarying vec2 v_pos;varying vec4 v_lighting;uniform lowp float u_opacity;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color,v_NdotL)*u_opacity;\n#else\nout_color=out_color*v_lighting;\n#endif\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h=max(0.0,v_ao.z);float h_floors=h/u_ao[1];float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);float shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;float x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);shade*=mix(1.0,x_shade*x_shade*x_shade,concave);out_color.rgb=out_color.rgb*shade;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform float u_tile_units_to_pixels;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nvarying vec2 v_pos;varying vec4 v_lighting;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nvarying float v_NdotL;\n#endif\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec4 pos_nx=floor(a_pos_normal_ed*0.5);mediump vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;mediump vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=z;vec3 p;float c_ele;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);p=vec3(pos_nx.xy,h);\n#else\np=vec3(pos_nx.xy,z);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*(p.z+lift));vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,p.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*p.z;p=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(p,1),AWAY,hidden);vec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float NdotL=0.0;\n#ifdef LIGHTING_3D_MODE\nNdotL=calculate_NdotL(normal);\n#else\nNdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),NdotL);\n#endif\nif (normal.y !=0.0) {float r=0.84;\n#ifndef LIGHTING_3D_MODE\nr=mix(0.7,0.98,1.0-u_lightintensity);\n#endif\nNdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec3(mix(concave,-concave,start),y_ground,h-ele);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\nv_NdotL=NdotL;\n#else\nv_lighting.rgb+=clamp(NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;\n#endif \n#ifdef FOG\nv_fog_pos=fog_position(p);\n#endif\n}"),hillshadePrepare:di("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nreturn texture2D(u_image,coord).a/4.0;\n#else\nvec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;\n#endif\n}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y));float b=getElevation(v_pos+vec2(0,-epsilon.y));float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y));float d=getElevation(v_pos+vec2(-epsilon.x,0));float e=getElevation(v_pos+vec2(epsilon.x,0));float f=getElevation(v_pos+vec2(-epsilon.x,epsilon.y));float g=getElevation(v_pos+vec2(0,epsilon.y));float h=getElevation(v_pos+vec2(epsilon.x,epsilon.y));float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+e+e+h)-(a+d+d+f),(f+g+g+h)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:di("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;void main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef LIGHTING_3D_MODE\ngl_FragColor=apply_lighting(gl_FragColor);\n#endif\n#ifdef FOG\ngl_FragColor=fog_dither(fog_apply_premultiplied(gl_FragColor,v_fog_pos));\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),line:di("uniform lowp float u_device_pixel_ratio;uniform float u_alpha_discard_threshold;uniform highp vec2 u_trim_offset;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform sampler2D u_dash_image;varying vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform sampler2D u_gradient_image;\n#endif\nuniform float u_border_width;uniform vec4 u_border_color;float luminance(vec3 c) {return (c.r+c.r+c.b+c.g+c.g+c.g)*0.1667;}\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nfloat linearstep(float edge0,float edge1,float x) {return  clamp((x-edge0)/(edge1-edge0),0.0,1.0);}void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);\n#ifdef RENDER_LINE_DASH\nfloat sdfdist=texture2D(u_dash_image,v_tex).a;float sdfgamma=1.0/(2.0*u_device_pixel_ratio)/dash.z;alpha*=linearstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);\n#endif\nhighp vec4 out_color;\n#ifdef RENDER_LINE_GRADIENT\nout_color=texture2D(u_gradient_image,v_uv.xy);\n#else\nout_color=color;\n#endif\nfloat trimmed=1.0;\n#ifdef RENDER_LINE_TRIM_OFFSET\nhighp float start=v_uv[2];highp float end=v_uv[3];highp float trim_start=u_trim_offset[0];highp float trim_end=u_trim_offset[1];highp float line_progress=(start+(v_uv.x)*(end-start));if (trim_end > trim_start) {if (line_progress <=trim_end && line_progress >=trim_start) {out_color=vec4(0,0,0,0);trimmed=0.0;}}\n#endif\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\n#ifdef RENDER_LINE_ALPHA_DISCARD\nif (alpha < u_alpha_discard_threshold) {discard;}\n#endif\n#ifdef RENDER_LINE_BORDER\nfloat edgeBlur=(u_border_width+1.0/u_device_pixel_ratio);float alpha2=clamp(min(dist-(v_width2.t-edgeBlur),v_width2.s-dist)/edgeBlur,0.0,1.0);if (alpha2 < 1.) {float smoothAlpha=smoothstep(0.6,1.0,alpha2);\n#ifdef RENDER_LINE_BORDER_AUTO\nfloat Y=(out_color.a > 0.01) ? luminance(out_color.rgb/out_color.a) : 1.;float adjustment=(Y > 0.) ? 0.5/Y : 0.45;if (out_color.a > 0.25 && Y < 0.25) {vec3 borderColor=(Y > 0.) ? out_color.rgb : vec3(1,1,1)*out_color.a;out_color.rgb=out_color.rgb+borderColor*(adjustment*(1.0-smoothAlpha));} else {out_color.rgb*=(0.6 +0.4*smoothAlpha);}\n#else\nout_color.rgb=mix(u_border_color.rgb*u_border_color.a*trimmed,out_color.rgb,smoothAlpha);\n#endif\n}\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define EXTRUDE_SCALE 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nattribute highp vec4 a_packed;\n#endif\n#ifdef RENDER_LINE_DASH\nattribute float a_linesofar;\n#endif\nuniform mat4 u_matrix;uniform mat2 u_pixels_to_tile_units;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform vec2 u_texsize;uniform float u_tile_units_to_pixels;varying vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform float u_image_height;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*EXTRUDE_SCALE;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*EXTRUDE_SCALE*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nfloat a_uv_x=a_packed[0];float a_split_index=a_packed[1];highp float a_clip_start=a_packed[2];highp float a_clip_end=a_packed[3];\n#ifdef RENDER_LINE_GRADIENT\nhighp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec4(a_uv_x,a_split_index*texel_height-half_texel_height,a_clip_start,a_clip_end);\n#else\nv_uv=vec4(a_uv_x,0.0,a_clip_start,a_clip_end);\n#endif\n#endif\n#ifdef RENDER_LINE_DASH\nfloat scale=dash.z==0.0 ? 0.0 : u_tile_units_to_pixels/dash.z;float height=dash.y;v_tex=vec2(a_linesofar*scale/floorwidth,(-normal.y*height+dash.x+0.5)/u_texsize.y);\n#endif\nv_width2=vec2(outset,inset);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),linePattern:di("uniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_tile_units_to_pixels;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;vec2 pattern_size=vec2(display_size.x/u_tile_units_to_pixels,display_size.y);float aspect=display_size.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x=mod(v_linesofar/pattern_size.x*aspect,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos=mix(pattern_tl*texel_size-texel_size,pattern_br*texel_size+texel_size,vec2(x,y));vec4 color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\ncolor=apply_lighting(color);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mat2 u_pixels_to_tile_units;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),raster:di("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);vec3 out_color=mix(u_high_vec,u_low_vec,rgb);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply(out_color,v_fog_pos));\n#endif\ngl_FragColor=vec4(out_color*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform vec2 u_perspective_transform;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {float w=1.0+dot(a_texture_pos,u_perspective_transform);gl_Position=u_matrix*vec4(a_pos*w,0,w);v_pos0=a_texture_pos/8192.0;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),symbolIcon:di("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform vec3 u_up_vector;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nvarying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_min_font_scale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;vec3 h=elevationVector(tile_anchor)*elevation(tile_anchor);float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjected_point;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetProjected_point=u_matrix*vec4(a_globe_anchor+displacement,1);\n#else\noffsetProjected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);\n#endif\nvec2 a=projected_point.xy/projected_point.w;vec2 b=offsetProjected_point.xy/offsetProjected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_min_font_scale,font_scale)+a_pxoffset/16.0);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#endif\nfloat projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nv_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;v_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change))*projection_transition_fade;}"),symbolSDF:di("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nvarying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;vec3 h=elevationVector(tile_anchor)*elevation(tile_anchor);float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetprojected_point;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetprojected_point=u_matrix*vec4(a_globe_anchor+displacement,1);\n#else\noffsetprojected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);\n#endif\nvec2 a=projected_point.xy/projected_point.w;vec2 b=offsetprojected_point.xy/offsetprojected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#endif\nfloat gamma_scale=gl_Position.w;float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity*projection_transition_fade);}"),symbolTextAndIcon:di("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;uniform vec2 u_texsize_icon;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nvarying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;vec3 h=elevationVector(tile_anchor)*elevation(tile_anchor);float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offset_projected_point=u_matrix*vec4(a_pos+vec2(1,0),0,1);vec2 a=projected_point.xy/projected_point.w;vec2 b=offset_projected_point.xy/offset_projected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*font_scale);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#endif\nfloat gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nv_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity*projection_transition_fade,is_sdf);}"),terrainRaster:di("uniform sampler2D u_image0;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nvarying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#endif\nvoid main() {vec4 color=texture2D(u_image0,v_pos0);\n#ifdef RENDER_SHADOWS\ncolor.xyz=shadowed_color(color.xyz,v_pos_light_view_0,v_pos_light_view_1,v_depth);\n#endif\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#else\ncolor=fog_dither(fog_apply_from_vert(color,v_fog_opacity));\n#endif\n#endif\ngl_FragColor=color;\n#ifdef TERRAIN_WIREFRAME\ngl_FragColor=vec4(1.0,0.0,0.0,0.8);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_skirt_height;attribute vec2 a_pos;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;varying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#endif\nconst float wireframeOffset=0.00015;void main() {vec3 decomposedPosAndSkirt=decomposeToPosAndSkirt(a_pos);float skirt=decomposedPosAndSkirt.z;vec2 decodedPos=decomposedPosAndSkirt.xy;float elevation=elevation(decodedPos)-skirt*u_skirt_height;\n#ifdef TERRAIN_WIREFRAME\nelevation+=wireframeOffset;\n#endif\nv_pos0=decodedPos/8192.0;gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\nv_fog_pos=fog_position(decodedPos);\n#else\nv_fog_opacity=fog(fog_position(vec3(decodedPos,elevation)));\n#endif\n#endif\n#ifdef RENDER_SHADOWS\nvec3 pos=vec3(decodedPos,elevation);v_pos_light_view_0=u_light_matrix_0*vec4(pos,1.);v_pos_light_view_1=u_light_matrix_1*vec4(pos,1.);v_depth=gl_Position.w;\n#endif\n}"),terrainDepth:di("#ifdef GL_ES\nprecision highp float;\n#endif\nvarying float v_depth;void main() {gl_FragColor=pack_depth(v_depth);}","uniform mat4 u_matrix;attribute vec2 a_pos;varying float v_depth;void main() {float elevation=elevation(a_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}"),skybox:di("\nvarying lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=textureCube(u_cubemap,uv).rgb;\n#ifdef FOG\nsky_color=fog_apply_sky_gradient(v_uv.xzy,sky_color);\n#endif\nsky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);gl_FragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",ti),skyboxGradient:di("varying highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform highp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture2D(u_color_ramp,vec2(progress,0.5));\n#ifdef FOG\ncolor.rgb=fog_apply_sky_gradient(v_uv.xzy,color.rgb/color.a)*color.a;\n#endif\ncolor*=u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",ti),skyboxCapture:di("\nvarying highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;\n#ifdef GL_ES\nprecision highp float;\n#endif\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;gl_FragColor=vec4(color,1.0);}","attribute highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;varying highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}"),globeRaster:di("uniform sampler2D u_image0;varying vec2 v_pos0;\n#ifndef FOG\nuniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform vec2 u_viewport;\n#endif\nvoid main() {vec4 color;\n#ifdef CUSTOM_ANTIALIASING\nvec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);vec3 dir=normalize(ray_dir);vec3 closest_point=dot(u_globe_pos,dir)*dir;float norm_dist_from_center=1.0-length(closest_point-u_globe_pos)/u_globe_radius;const float antialias_pixel=2.0;float antialias_factor=antialias_pixel*fwidth(norm_dist_from_center);float antialias=smoothstep(0.0,antialias_factor,norm_dist_from_center);vec4 raster=texture2D(u_image0,v_pos0);color=vec4(raster.rgb*antialias,raster.a*antialias);\n#else\ncolor=texture2D(u_image0,v_pos0);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color;\n#ifdef TERRAIN_WIREFRAME\ngl_FragColor=vec4(1.0,0.0,0.0,0.8);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_proj_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform float u_zoom_transition;uniform vec2 u_merc_center;uniform mat3 u_grid_matrix;uniform float u_skirt_height;\n#ifdef GLOBE_POLES\nattribute vec3 a_globe_pos;attribute vec2 a_uv;\n#else\nattribute vec2 a_pos;\n#endif\nvarying vec2 v_pos0;const float wireframeOffset=1e3;float mercatorXfromLng(float lng) {return (180.0+lng)/360.0;}float mercatorYfromLat(float lat) {return (180.0-(RAD_TO_DEG*log(tan(QUARTER_PI+lat/2.0*DEG_TO_RAD))))/360.0;}vec3 latLngToECEF(vec2 latLng) {latLng=DEG_TO_RAD*latLng;float cosLat=cos(latLng[0]);float sinLat=sin(latLng[0]);float cosLng=cos(latLng[1]);float sinLng=sin(latLng[1]);float sx=cosLat*sinLng*GLOBE_RADIUS;float sy=-sinLat*GLOBE_RADIUS;float sz=cosLat*cosLng*GLOBE_RADIUS;return vec3(sx,sy,sz);}void main() {\n#ifdef GLOBE_POLES\nvec3 globe_pos=a_globe_pos;vec2 uv=a_uv;\n#else\nfloat tiles=u_grid_matrix[0][2];float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];vec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);float mercatorY=mercatorYfromLat(latLng[0]);float uvY=mercatorY*tiles-idy;float mercatorX=mercatorXfromLng(latLng[1]);float uvX=mercatorX*tiles-idx;vec3 globe_pos=latLngToECEF(latLng.xy);vec2 merc_pos=vec2(mercatorX,mercatorY);vec2 uv=vec2(uvX,uvY);\n#endif\nv_pos0=uv;vec2 tile_pos=uv*EXTENT;vec3 globe_derived_up_vector=normalize(globe_pos)*u_tile_up_scale;\n#ifdef GLOBE_POLES\nvec3 up_vector=globe_derived_up_vector;\n#else\nvec3 up_vector=elevationVector(tile_pos);\n#endif\nfloat height=elevation(tile_pos);\n#ifdef TERRAIN_WIREFRAME\nheight+=wireframeOffset;\n#endif\nglobe_pos+=up_vector*height;\n#ifndef GLOBE_POLES\nglobe_pos-=globe_derived_up_vector*u_skirt_height*decomposed_pos_and_skirt.z;\n#endif\n#ifdef GLOBE_POLES\nvec4 interpolated_pos=u_globe_matrix*vec4(globe_pos,1.0);\n#else\nvec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);if (u_zoom_transition > 0.0) {merc_world_pos=vec4(merc_pos,height-u_skirt_height*decomposed_pos_and_skirt.z,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition),1.0);\n#endif\ngl_Position=u_proj_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n}"),globeAtmosphere:di("uniform float u_transition;uniform highp float u_fadeout_range;uniform highp float u_temporal_offset;uniform vec3 u_start_color;uniform vec4 u_color;uniform vec4 u_space_color;uniform vec4 u_high_color;uniform float u_star_intensity;uniform float u_star_size;uniform float u_star_density;uniform float u_horizon_angle;uniform mat4 u_rotation_matrix;varying highp vec3 v_ray_dir;varying highp vec3 v_horizon_dir;highp float random(highp vec3 p) {p=fract(p*vec3(23.2342,97.1231,91.2342));p+=dot(p.zxy,p.yxz+123.1234);return fract(p.x*p.y);}float stars(vec3 p,float scale,vec2 offset) {vec2 uv_scale=(u_viewport/u_star_size)*scale;vec3 position=vec3(p.xy*uv_scale+offset*u_viewport,p.z);vec3 q=fract(position)-0.5;vec3 id=floor(position);float random_visibility=step(random(id),u_star_density);float circle=smoothstep(0.5+u_star_intensity,0.5,length(q));return circle*random_visibility;}void main() {highp vec3 dir=normalize(v_ray_dir);float globe_pos_dot_dir;\n#ifdef PROJECTION_GLOBE_VIEW\nglobe_pos_dot_dir=dot(u_globe_pos,dir);highp vec3 closest_point_forward=abs(globe_pos_dot_dir)*dir;float norm_dist_from_center=length(closest_point_forward-u_globe_pos)/u_globe_radius;if (norm_dist_from_center < 0.98) {discard;return;}\n#endif\nhighp vec3 horizon_dir=normalize(v_horizon_dir);float horizon_angle_mercator=dir.y < horizon_dir.y ?\n0.0 : max(acos(dot(dir,horizon_dir)),0.0);float horizon_angle;\n#ifdef PROJECTION_GLOBE_VIEW\nhighp vec3 closest_point=globe_pos_dot_dir*dir;float closest_point_to_center=length(closest_point-u_globe_pos);float theta=asin(clamp(closest_point_to_center/length(u_globe_pos),-1.0,1.0));horizon_angle=globe_pos_dot_dir < 0.0 ?\nPI-theta-u_horizon_angle : theta-u_horizon_angle;float angle_t=pow(u_transition,10.0);horizon_angle=mix(horizon_angle,horizon_angle_mercator,angle_t);\n#else\nhorizon_angle=horizon_angle_mercator;\n#endif\nhorizon_angle/=PI;float t=exp(-horizon_angle/u_fadeout_range);float alpha_0=u_color.a;float alpha_1=u_high_color.a;float alpha_2=u_space_color.a;vec3 color_stop_0=u_color.rgb;vec3 color_stop_1=u_high_color.rgb;vec3 color_stop_2=u_space_color.rgb;vec3 c0=mix(color_stop_2,color_stop_1,alpha_1);vec3 c1=mix(c0,color_stop_0,alpha_0);vec3 c2=mix(c0,c1,t);vec3 c =mix(color_stop_2,c2,t);float a0=mix(alpha_2,1.0,alpha_1);float a1=mix(a0,1.0,alpha_0);float a2=mix(a0,a1,t);float a =mix(alpha_2,a2,t);vec2 uv=gl_FragCoord.xy/u_viewport-0.5;float aspect_ratio=u_viewport.x/u_viewport.y;vec4 uv_dir=vec4(normalize(vec3(uv.x*aspect_ratio,uv.y,1.0)),1.0);uv_dir=u_rotation_matrix*uv_dir;vec3 n=abs(uv_dir.xyz);vec2 uv_remap=(n.x > n.y && n.x > n.z) ? uv_dir.yz/uv_dir.x:\n(n.y > n.x && n.y > n.z) ? uv_dir.zx/uv_dir.y:\nuv_dir.xy/uv_dir.z;uv_remap.x/=aspect_ratio;vec3 D=vec3(uv_remap,1.0);highp float star_field=0.0;if (u_star_intensity > 0.0) {star_field+=stars(D,1.2,vec2(0.0,0.0));star_field+=stars(D,1.0,vec2(1.0,0.0));star_field+=stars(D,0.8,vec2(0.0,1.0));star_field+=stars(D,0.6,vec2(1.0,1.0));star_field*=(1.0-pow(t,0.25+(1.0-u_high_color.a)*0.75));c+=star_field*alpha_2;}c=dither(c,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=vec4(c,a);}","attribute vec3 a_pos;attribute vec2 a_uv;uniform vec3 u_frustum_tl;uniform vec3 u_frustum_tr;uniform vec3 u_frustum_br;uniform vec3 u_frustum_bl;uniform float u_horizon;varying highp vec3 v_ray_dir;varying highp vec3 v_horizon_dir;void main() {v_ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,a_uv.x),mix(u_frustum_bl,u_frustum_br,a_uv.x),a_uv.y);v_horizon_dir=mix(\nmix(u_frustum_tl,u_frustum_bl,u_horizon),mix(u_frustum_tr,u_frustum_br,u_horizon),a_uv.x);gl_Position=vec4(a_pos,1.0);}")};function _i(e,t){const i=e.replace(/\s*\/\/[^\n]*\n/g,"\n").split("\n");for(let e of i)if(e=e.trim(),"#"===e[0]&&e.includes("if")&&!e.includes("endif")){e=e.replace("#","").replace(/ifdef|ifndef|elif|if/g,"").replace(/!|defined|\(|\)|\|\||&&/g,"").replace(/\s+/g," ").trim();const i=e.split(" ");for(const e of i)t.includes(e)||t.push(e);}}function di(e,t){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,o=t.match(/attribute (highp |mediump |lowp )?([\w]+) ([\w]+)/g),r={},n=[...ai];return _i(e,n),_i(t,n),{fragmentSource:e=e.replace(i,((e,t,i,o,n)=>(r[n]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nvarying ${i} ${o} ${n};\n#else\nuniform ${i} ${o} u_${n};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${n}\n    ${i} ${o} ${n} = u_${n};\n#endif\n`))),vertexSource:t=t.replace(i,((e,t,i,o,n)=>{const s="float"===o?"vec2":"vec4",a=n.match(/color/)?"color":s;return r[n]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nattribute ${i} ${s} a_${n};\nvarying ${i} ${o} ${n};\n#else\nuniform ${i} ${o} u_${n};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = a_${n};\n#else\n    ${i} ${o} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = unpack_mix_${a}(a_${n}, u_${n}_t);\n#else\n    ${i} ${o} ${n} = u_${n};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nattribute ${i} ${s} a_${n};\n#else\nuniform ${i} ${o} u_${n};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${o} ${n} = a_${n};\n#else\n    ${i} ${o} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${o} ${n} = unpack_mix_${a}(a_${n}, u_${n}_t);\n#else\n    ${i} ${o} ${n} = u_${n};\n#endif\n`})),staticAttributes:o,usedDefines:n}}class pi{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffers=[],this.vao=null;}bind(e,t,i,o,r,n,s){this.context=e;let a=this.boundPaintVertexBuffers.length!==o.length;for(let e=0;!a&&e<o.length;e++)this.boundPaintVertexBuffers[e]!==o[e]&&(a=!0);let l=this.boundDynamicVertexBuffers.length!==s.length;for(let e=0;!l&&e<s.length;e++)this.boundDynamicVertexBuffers[e]!==s[e]&&(l=!0);if(!e.extVertexArrayObject||!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||a||l||this.boundIndexBuffer!==r||this.boundVertexOffset!==n)this.freshBind(t,i,o,r,n,s);else {e.bindVertexArrayOES.set(this.vao);for(const e of s)e&&e.bind();r&&r.dynamicDraw&&r.bind();}}freshBind(e,t,i,o,r,n){let s;const a=e.numAttributes,l=this.context,c=l.gl;if(l.extVertexArrayObject)this.vao&&this.destroy(),this.vao=l.extVertexArrayObject.createVertexArrayOES(),l.bindVertexArrayOES.set(this.vao),s=0,this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=o,this.boundVertexOffset=r,this.boundDynamicVertexBuffers=n;else {s=l.currentNumAttributes||0;for(let e=a;e<s;e++)c.disableVertexAttribArray(e);}t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,r);for(const t of i)t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,r);for(const t of n)t&&(t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,r));o&&o.bind(),l.currentNumAttributes=a;}destroy(){this.vao&&(this.context.extVertexArrayObject.deleteVertexArrayOES(this.vao),this.vao=null);}}function mi(t,i){const o=Math.pow(2,i.canonical.z),r=i.canonical.y;return [new e.MercatorCoordinate(0,r/o).toLngLat().lat,new e.MercatorCoordinate(0,(r+1)/o).toLngLat().lat]}function fi(t,i,o,r,n,s,a){const l=t.context,c=l.gl,h=o.fbo;if(!h)return;t.prepareDrawTile();const u=t.useProgram("hillshade");l.activeTexture.set(c.TEXTURE0),c.bindTexture(c.TEXTURE_2D,h.colorAttachment.get());const _=((e,t,i,o)=>{const r=i.paint.get("hillshade-shadow-color"),n=i.paint.get("hillshade-highlight-color"),s=i.paint.get("hillshade-accent-color");let a=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(a-=e.transform.angle);const l=!e.options.moving;return {u_matrix:o||e.transform.calculateProjMatrix(t.tileID.toUnwrapped(),l),u_image:0,u_latrange:mi(0,t.tileID),u_light:[i.paint.get("hillshade-exaggeration"),a],u_shadow:r,u_highlight:n,u_accent:s}})(t,o,r,t.terrain?i.projMatrix:null);t.prepareDrawProgram(l,u,i.toUnwrapped());const{tileBoundsBuffer:d,tileBoundsIndexBuffer:p,tileBoundsSegments:m}=t.getTileBoundsBuffers(o);u.draw(l,c.TRIANGLES,n,s,a,e.CullFaceMode.disabled,_,r.id,d,p,m);}function gi(t,i,o){if(!i.needsDEMTextureUpload)return;const r=t.context,n=r.gl;r.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(o.stride);const s=o.getPixels();i.demTexture?i.demTexture.update(s,{premultiply:!1}):i.demTexture=new e.Texture(r,s,n.RGBA,{premultiply:!1}),i.needsDEMTextureUpload=!1;}function vi(t,i,o,r,n,s){const a=t.context,l=a.gl;if(!i.dem)return;const c=i.dem;if(a.activeTexture.set(l.TEXTURE1),gi(t,i,c),!i.demTexture)return;i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);const h=c.dim;a.activeTexture.set(l.TEXTURE0);let u=i.fbo;if(!u){const t=new e.Texture(a,{width:h,height:h,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),u=i.fbo=a.createFramebuffer(h,h,!0),u.colorAttachment.set(t.texture);}a.bindFramebuffer.set(u.framebuffer),a.viewport.set([0,0,h,h]);const{tileBoundsBuffer:_,tileBoundsIndexBuffer:d,tileBoundsSegments:p}=t.getMercatorTileBoundsBuffers();t.useProgram("hillshadePrepare").draw(a,l.TRIANGLES,r,n,s,e.CullFaceMode.disabled,((t,i)=>{const o=i.stride,r=e.create();return e.ortho(r,0,e.EXTENT,-e.EXTENT,0,0,1),e.translate(r,r,[0,-e.EXTENT,0]),{u_matrix:r,u_image:1,u_dimension:[o,o],u_zoom:t.overscaledZ,u_unpack:i.unpackVector}})(i.tileID,c),o.id,_,d,p),i.needsHillshadePrepare=!1;}const xi=t=>({u_matrix:new e.UniformMatrix4f(t),u_image0:new e.Uniform1i(t),u_skirt_height:new e.Uniform1f(t)}),yi=(e,t)=>({u_matrix:e,u_image0:0,u_skirt_height:t}),bi=(e,t,i,o,r,n,s,a,l,c,h,u,_,d,p)=>({u_proj_matrix:Float32Array.from(e),u_globe_matrix:t,u_normalize_matrix:Float32Array.from(o),u_merc_matrix:i,u_zoom_transition:r,u_merc_center:n,u_image0:0,u_frustum_tl:s,u_frustum_tr:a,u_frustum_br:l,u_frustum_bl:c,u_globe_pos:h,u_globe_radius:u,u_viewport:_,u_grid_matrix:p?Float32Array.from(p):new Float32Array(9),u_skirt_height:d});function wi(e,t){return null!=e&&null!=t&&!(!e.hasData()||!t.hasData())&&null!=e.demTexture&&null!=t.demTexture&&e.tileID.key!==t.tileID.key}const Ti=new class{constructor(){this.operations={};}newMorphing(e,t,i,o,r){if(e in this.operations){const t=this.operations[e];t.to.tileID.key!==i.tileID.key&&(t.queued=i);}else this.operations[e]={startTime:o,phase:0,duration:r,from:t,to:i,queued:null};}getMorphValuesForProxy(e){if(!(e in this.operations))return null;const t=this.operations[e];return {from:t.from,to:t.to,phase:t.phase}}update(e){for(const t in this.operations){const i=this.operations[t];for(i.phase=(e-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,e)){delete this.operations[t];break}}}_nextOp(e,t){return !!e.queued&&(e.from=e.to,e.to=e.queued,e.queued=null,e.phase=0,e.startTime=t,!0)}_validOp(e){return e.from.hasData()&&e.to.hasData()}},Ei={0:null,1:"TERRAIN_VERTEX_MORPHING",2:"TERRAIN_WIREFRAME"};function Ci(e){return 6*Math.pow(1.5,22-e)}function Mi(e,t){const i=1<<e.z;return !t&&(0===e.x||e.x===i-1)||0===e.y||e.y===i-1}const Ii=e=>({u_matrix:e});function Si(t,i,o,r,n){if(n>0){const s=e.exported.now(),a=(s-t.timeAdded)/n,l=i?(s-i.timeAdded)/n:-1,c=o.getSource(),h=r.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),u=!i||Math.abs(i.tileID.overscaledZ-h)>Math.abs(t.tileID.overscaledZ-h),_=u&&t.refreshedUponExpiration?1:e.clamp(u?a:1-l,0,1);return t.refreshedUponExpiration&&a>=1&&(t.refreshedUponExpiration=!1),i?{opacity:1,mix:1-_}:{opacity:_,mix:0}}return {opacity:1,mix:0}}class Di extends e.SourceCache{constructor(e){const t={type:"raster-dem",maxzoom:e.transform.maxZoom},i=new z(je(),null),o=Pe("mock-dem",t,i,e.style);super("mock-dem",o,!1),o.setEventedParent(this),this._sourceLoaded=!0;}_loadTile(e,t){e.state="loaded",t(null);}}class Li extends e.SourceCache{constructor(e){const t=Pe("proxy",{type:"geojson",maxzoom:e.transform.maxZoom},new z(je(),null),e.style);super("proxy",t,!1),t.setEventedParent(this),this.map=this.getSource().map=e,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}update(t,i,o){if(t.freezeTileCoverage)return;this.transform=t;const r=t.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled}).reduce(((i,o)=>{if(i[o.key]="",!this._tiles[o.key]){const i=new e.Tile(o,this._source.tileSize*o.overscaleFactor(),t.tileZoom);i.state="loaded",this._tiles[o.key]=i;}return i}),{});for(const e in this._tiles)e in r||(this.freeFBO(e),this._tiles[e].unloadVectorData(),delete this._tiles[e]);}freeFBO(e){const t=this.proxyCachedFBO[e];if(void 0!==t){const i=Object.values(t);this.renderCachePool.push(...i),delete this.proxyCachedFBO[e];}}deallocRenderCache(){this.renderCache.forEach((e=>e.fb.destroy())),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}}class Ai extends e.OverscaledTileID{constructor(e,t,i){super(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y),this.proxyTileKey=t,this.projMatrix=i;}}class zi extends e.Elevation{constructor(t,i){super(),this.painter=t,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[o,r,n]=function(t){const i=new e.StructArrayLayout2i4,o=new e.StructArrayLayout3ui6,r=131;i.reserve(17161),o.reserve(33800);const n=e.EXTENT/128,s=e.EXTENT+n/2,a=s+n;for(let t=-n;t<a;t+=n)for(let o=-n;o<a;o+=n){const r=o<0||o>s||t<0||t>s?24575:0,n=e.clamp(Math.round(o),0,e.EXTENT),a=e.clamp(Math.round(t),0,e.EXTENT);i.emplaceBack(n+r,a);}const l=(e,t)=>{const i=t*r+e;o.emplaceBack(i+1,i,i+r),o.emplaceBack(i+r,i+r+1,i+1);};for(let e=1;e<129;e++)for(let t=1;t<129;t++)l(t,e);return [0,129].forEach((e=>{for(let t=0;t<130;t++)l(t,e),l(e,t);})),[i,o,32768]}(),s=t.context;this.gridBuffer=s.createVertexBuffer(o,e.posAttributes.members),this.gridIndexBuffer=s.createIndexBuffer(r),this.gridSegments=e.SegmentVector.simpleSegment(0,0,o.length,r.length),this.gridNoSkirtSegments=e.SegmentVector.simpleSegment(0,0,o.length,n),this.proxyCoords=[],this.proxiedCoords={},this._visibleDemTiles=[],this._drapedRenderBatches=[],this._sourceTilesOverlap={},this.proxySourceCache=new Li(i.map),this.orthoMatrix=e.create(),e.ortho(this.orthoMatrix,"globe"===this.painter.transform.projection.name?.015:0,e.EXTENT,0,e.EXTENT,0,1);const a=s.gl;this._overlapStencilMode=new e.StencilMode({func:a.GEQUAL,mask:255},0,255,a.KEEP,a.KEEP,a.REPLACE),this._previousZoom=t.transform.zoom,this.pool=[],this._findCoveringTileCache={},this._tilesDirty={},this.style=i,this._useVertexMorphing=!0,this._exaggeration=1,this._mockSourceCache=new Di(i.map);}set style(e){e.on("data",this._onStyleDataEvent.bind(this)),e.on("neworder",this._checkRenderCacheEfficiency.bind(this)),this._style=e,this._checkRenderCacheEfficiency(),this._style.map.on("moveend",(()=>{this._clearLineLayersFromRenderCache();}));}update(t,i,o){if(t&&t.terrain){this._style!==t&&(this.style=t),this.enabled=!0;const r=t.terrain.properties;this.sourceCache=0===t.terrain.drapeRenderMode?this._mockSourceCache:t._getSourceCache(r.get("source")),this._exaggeration=r.get("exaggeration");const n=()=>{this.sourceCache.used&&e.warnOnce(`Raster DEM source '${this.sourceCache.id}' is used both for terrain and as layer source.\nThis leads to lower resolution of hillshade. For full hillshade resolution but higher memory consumption, define another raster DEM source.`);const t=this.getScaledDemTileSize();this.sourceCache.update(i,t,!0),this.resetTileLookupCache(this.sourceCache.id);};this.sourceCache.usedForTerrain||(this.resetTileLookupCache(this.sourceCache.id),this.sourceCache.usedForTerrain=!0,n(),this._initializing=!0),n(),i.updateElevation(!0,o),this.resetTileLookupCache(this.proxySourceCache.id),this.proxySourceCache.update(i),this._emptyDEMTextureDirty=!0;}else this._disable();}resetTileLookupCache(e){this._findCoveringTileCache[e]={};}getScaledDemTileSize(){return this.sourceCache.getSource().tileSize/128*this.proxySourceCache.getSource().tileSize}_checkRenderCacheEfficiency(){const t=this.renderCacheEfficiency(this._style);this._style.map._optimizeForTerrain||100!==t.efficiency&&e.warnOnce(`Terrain render cache efficiency is not optimal (${t.efficiency}%) and performance\n                may be affected negatively, consider placing all background, fill and line layers before layer\n                with id '${t.firstUndrapedLayer}' or create a map using optimizeForTerrain: true option.`);}_onStyleDataEvent(e){e.coord&&"source"===e.dataType?this._clearRenderCacheForTile(e.sourceCacheId,e.coord):"style"===e.dataType&&(this._invalidateRenderCache=!0);}_disable(){if(this.enabled&&(this.enabled=!1,this._sharedDepthStencil=void 0,this.proxySourceCache.deallocRenderCache(),this._style))for(const e in this._style._sourceCaches)this._style._sourceCaches[e].usedForTerrain=!1;}destroy(){this._disable(),this._emptyDEMTexture&&this._emptyDEMTexture.destroy(),this._emptyDepthBufferTexture&&this._emptyDepthBufferTexture.destroy(),this.pool.forEach((e=>e.fb.destroy())),this.pool=[],this._depthFBO&&(this._depthFBO.destroy(),this._depthFBO=void 0,this._depthTexture=void 0);}_source(){return this.enabled?this.sourceCache:null}isUsingMockSource(){return this.sourceCache===this._mockSourceCache}exaggeration(){return this._exaggeration}get visibleDemTiles(){return this._visibleDemTiles}get drapeBufferSize(){const e=2*this.proxySourceCache.getSource().tileSize;return [e,e]}set useVertexMorphing(e){this._useVertexMorphing=e;}updateTileBinding(t){if(!this.enabled)return;this.prevTerrainTileForTile=this.terrainTileForTile;const i=this.proxySourceCache,o=this.painter.transform;this._initializing&&(this._initializing=0===o._centerAltitude&&-1===this.getAtPointOrZero(e.MercatorCoordinate.fromLngLat(o.center),-1),this._emptyDEMTextureDirty=!this._initializing);const r=this.proxyCoords=i.getIds().map((e=>{const t=i.getTileByID(e).tileID;return t.projMatrix=o.calculateProjMatrix(t.toUnwrapped()),t}));!function(t,i){const o=i.transform.pointCoordinate(i.transform.getCameraPoint()),r=new e.pointGeometry(o.x,o.y);t.sort(((t,i)=>{if(i.overscaledZ-t.overscaledZ)return i.overscaledZ-t.overscaledZ;const o=new e.pointGeometry(t.canonical.x+(1<<t.canonical.z)*t.wrap,t.canonical.y),n=new e.pointGeometry(i.canonical.x+(1<<i.canonical.z)*i.wrap,i.canonical.y),s=r.mult(1<<t.canonical.z);return s.x-=.5,s.y-=.5,s.distSqr(o)-s.distSqr(n)}));}(r,this.painter),this._previousZoom=o.zoom;const n=this.proxyToSource||{};this.proxyToSource={},r.forEach((e=>{this.proxyToSource[e.key]={};})),this.terrainTileForTile={};const s=this._style._sourceCaches;for(const e in s){const i=s[e];if(!i.used)continue;if(i!==this.sourceCache&&this.resetTileLookupCache(i.id),this._setupProxiedCoordsForOrtho(i,t[e],n),i.usedForTerrain)continue;const o=t[e];i.getSource().reparseOverscaled&&this._assignTerrainTiles(o);}this.proxiedCoords[i.id]=r.map((e=>new Ai(e,e.key,this.orthoMatrix))),this._assignTerrainTiles(r),this._prepareDEMTextures(),this._setupDrapedRenderBatches(),this._initFBOPool(),this._setupRenderCache(n),this.renderingToTexture=!1,this._updateTimestamp=e.exported.now();const a={};this._visibleDemTiles=[];for(const e of this.proxyCoords){const t=this.terrainTileForTile[e.key];if(!t)continue;const i=t.tileID.key;i in a||(this._visibleDemTiles.push(t),a[i]=i);}}_assignTerrainTiles(e){this._initializing||e.forEach((e=>{if(this.terrainTileForTile[e.key])return;const t=this._findTileCoveringTileID(e,this.sourceCache);t&&(this.terrainTileForTile[e.key]=t);}));}_prepareDEMTextures(){const e=this.painter.context,t=e.gl;for(const i in this.terrainTileForTile){const o=this.terrainTileForTile[i],r=o.dem;!r||o.demTexture&&!o.needsDEMTextureUpload||(e.activeTexture.set(t.TEXTURE1),gi(this.painter,o,r));}}_prepareDemTileUniforms(e,t,i,o){if(!t||null==t.demTexture)return !1;const r=e.tileID.canonical,n=Math.pow(2,t.tileID.canonical.z-r.z),s=o||"";return i[`u_dem_tl${s}`]=[r.x*n%1,r.y*n%1],i[`u_dem_scale${s}`]=n,!0}get emptyDEMTexture(){return !this._emptyDEMTextureDirty&&this._emptyDEMTexture?this._emptyDEMTexture:this._updateEmptyDEMTexture()}get emptyDepthBufferTexture(){const t=this.painter.context,i=t.gl;if(!this._emptyDepthBufferTexture){const o=new e.RGBAImage({width:1,height:1},Uint8Array.of(255,255,255,255));this._emptyDepthBufferTexture=new e.Texture(t,o,i.RGBA,{premultiply:!1});}return this._emptyDepthBufferTexture}_getLoadedAreaMinimum(){let e=0;const t=this._visibleDemTiles.reduce(((t,i)=>{if(!i.dem)return t;const o=i.dem.tree.minimums[0];return o>0&&e++,t+o}),0);return e?t/e:0}_updateEmptyDEMTexture(){const t=this.painter.context,i=t.gl;t.activeTexture.set(i.TEXTURE2);const o=this._getLoadedAreaMinimum(),r=new e.RGBAImage({width:1,height:1},new Uint8Array(e.DEMData.pack(o,this.sourceCache.getSource().encoding)));this._emptyDEMTextureDirty=!1;let n=this._emptyDEMTexture;return n?n.update(r,{premultiply:!1}):n=this._emptyDEMTexture=new e.Texture(t,r,i.RGBA,{premultiply:!1}),n}setupElevationDraw(t,i,o){const r=this.painter.context,n=r.gl,s=(a=this.sourceCache.getSource().encoding,{u_dem:2,u_dem_prev:4,u_dem_unpack:e.DEMData.getUnpackVector(a),u_dem_tl:[0,0],u_dem_tl_prev:[0,0],u_dem_scale:0,u_dem_scale_prev:0,u_dem_size:0,u_dem_lerp:1,u_depth:3,u_depth_size_inv:[0,0],u_exaggeration:0});var a;s.u_dem_size=this.sourceCache.getSource().tileSize,s.u_exaggeration=this.exaggeration();let l=null,c=null,h=1;if(o&&o.morphing&&this._useVertexMorphing){const e=o.morphing.srcDemTile,i=o.morphing.dstDemTile;h=o.morphing.phase,e&&i&&(this._prepareDemTileUniforms(t,e,s,"_prev")&&(c=e),this._prepareDemTileUniforms(t,i,s)&&(l=i));}if(c&&l?(r.activeTexture.set(n.TEXTURE2),l.demTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE,n.NEAREST),r.activeTexture.set(n.TEXTURE4),c.demTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE,n.NEAREST),s.u_dem_lerp=h):(l=this.terrainTileForTile[t.tileID.key],r.activeTexture.set(n.TEXTURE2),(this._prepareDemTileUniforms(t,l,s)?l.demTexture:this.emptyDEMTexture).bind(n.NEAREST,n.CLAMP_TO_EDGE)),r.activeTexture.set(n.TEXTURE3),o&&o.useDepthForOcclusion?(this._depthTexture&&this._depthTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),this._depthFBO&&(s.u_depth_size_inv=[1/this._depthFBO.width,1/this._depthFBO.height])):(this.emptyDepthBufferTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),s.u_depth_size_inv=[1,1]),o&&o.useMeterToDem&&l){const t=(1<<l.tileID.canonical.z)*e.mercatorZfromAltitude(1,this.painter.transform.center.lat)*this.sourceCache.getSource().tileSize;s.u_meter_to_dem=t;}if(o&&o.labelPlaneMatrixInv&&(s.u_label_plane_matrix_inv=o.labelPlaneMatrixInv),i.setTerrainUniformValues(r,s),"globe"===this.painter.transform.projection.name){const e=this.globeUniformValues(this.painter.transform,t.tileID.canonical,o&&o.useDenormalizedUpVectorScale);i.setGlobeUniformValues(r,e);}}globeUniformValues(t,i,o){const r=t.projection;return {u_tile_tl_up:r.upVector(i,0,0),u_tile_tr_up:r.upVector(i,e.EXTENT,0),u_tile_br_up:r.upVector(i,e.EXTENT,e.EXTENT),u_tile_bl_up:r.upVector(i,0,e.EXTENT),u_tile_up_scale:o?e.globeMetersToEcef(1):r.upVectorScale(i,t.center.lat,t.worldSize).metersToTile}}renderToBackBuffer(t){const i=this.painter,o=this.painter.context;0!==t.length&&(o.bindFramebuffer.set(null),o.viewport.set([0,0,i.width,i.height]),i.gpuTimingDeferredRenderStart(),this.renderingToTexture=!1,function(t,i,o,r,n){if("globe"===t.transform.projection.name)!function(t,i,o,r,n){const s=t.context,a=s.gl;let l,c;const h=t.options.showTerrainWireframe?2:0,u=t.transform,_=e.globeUseCustomAntiAliasing(t,s,u),d=(e,i)=>{if(c===e)return;const o=[Ei[e],"PROJECTION_GLOBE_VIEW"];_&&o.push("CUSTOM_ANTIALIASING"),i&&o.push(Ei[h]),l=t.useProgram("globeRaster",null,o),c=e;},p=t.colorModeForRenderPass(),m=new e.DepthMode(a.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);Ti.update(n);const f=e.calculateGlobeMercatorMatrix(u),g=[e.mercatorXfromLng(u.center.lng),e.mercatorYfromLat(u.center.lat)],v=h?[!1,!0]:[!1],x=t.globeSharedBuffers,y=[u.width*e.exported.devicePixelRatio,u.height*e.exported.devicePixelRatio],b=Float32Array.from(u.globeMatrix),w={useDenormalizedUpVectorScale:!0};if(v.forEach((h=>{const u=t.transform,_=Ci(u.zoom)*i.exaggeration();c=-1;const v=h?a.LINES:a.TRIANGLES;for(const c of r){const r=o.getTile(c),T=e.StencilMode.disabled,E=i.prevTerrainTileForTile[c.key],C=i.terrainTileForTile[c.key];wi(E,C)&&Ti.newMorphing(c.key,E,C,n,250),s.activeTexture.set(a.TEXTURE0),r.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE);const M=Ti.getMorphValuesForProxy(c.key),I=M?1:0;M&&e.extend$1(w,{morphing:{srcDemTile:M.from,dstDemTile:M.to,phase:e.easeCubicInOut(M.phase)}});const S=e.tileCornersToBounds(c.canonical),D=e.getLatitudinalLod(S.getCenter().lat),L=e.getGridMatrix(c.canonical,S,D,u.worldSize/u._pixelsPerMercatorPixel),A=e.globeNormalizeECEF(e.globeTileBounds(c.canonical)),z=bi(u.projMatrix,b,f,A,e.globeToMercatorTransition(u.zoom),g,u.frustumCorners.TL,u.frustumCorners.TR,u.frustumCorners.BR,u.frustumCorners.BL,u.globeCenterInViewSpace,u.globeRadius,y,_,L);if(d(I,h),i.setupElevationDraw(r,l,w),t.prepareDrawProgram(s,l,c.toUnwrapped()),x){const[i,o,r]=h?x.getWirefameBuffers(t.context,D):x.getGridBuffers(D,0!==_);l.draw(s,v,m,T,p,e.CullFaceMode.backCCW,z,"globe_raster",i,o,r);}}})),x){const n=["GLOBE_POLES","PROJECTION_GLOBE_VIEW"];_&&n.push("CUSTOM_ANTIALIASING"),l=t.useProgram("globeRaster",null,n);for(const n of r){const{x:r,y:c,z:h}=n.canonical,_=0===c,d=c===(1<<h)-1,[f,v,b,T]=x.getPoleBuffers(h);if(T&&(_||d)){const c=o.getTile(n);s.activeTexture.set(a.TEXTURE0),c.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE);let x=e.globePoleMatrixForTile(h,r,u);const E=e.globeNormalizeECEF(e.globeTileBounds(n.canonical)),C=(t,i)=>t.draw(s,a.TRIANGLES,m,e.StencilMode.disabled,p,e.CullFaceMode.disabled,bi(u.projMatrix,x,x,E,0,g,u.frustumCorners.TL,u.frustumCorners.TR,u.frustumCorners.BR,u.frustumCorners.BL,u.globeCenterInViewSpace,u.globeRadius,y,0),"globe_pole_raster",i,b,T);i.setupElevationDraw(c,l,w),t.prepareDrawProgram(s,l,n.toUnwrapped()),_&&C(l,f),d&&(x=e.scale(e.create(),x,[1,-1,1]),C(l,v));}}}}(t,i,o,r,n);else {const s=t.context,a=s.gl;let l,c;const h=t.options.showTerrainWireframe?2:0,u=(e,i)=>{if(c===e)return;const o=[Ei[e]];i&&o.push(Ei[h]),l=t.useProgram("terrainRaster",null,o),c=e;},_=t.colorModeForRenderPass(),d=new e.DepthMode(a.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);Ti.update(n);const p=t.transform,m=Ci(p.zoom)*i.exaggeration();(h?[!1,!0]:[!1]).forEach((h=>{c=-1;const f=h?a.LINES:a.TRIANGLES,[g,v]=h?i.getWirefameBuffer():[i.gridIndexBuffer,i.gridSegments];for(const c of r){const r=o.getTile(c),x=e.StencilMode.disabled,y=i.prevTerrainTileForTile[c.key],b=i.terrainTileForTile[c.key];wi(y,b)&&Ti.newMorphing(c.key,y,b,n,250),s.activeTexture.set(a.TEXTURE0),r.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE,a.LINEAR_MIPMAP_NEAREST);const w=Ti.getMorphValuesForProxy(c.key),T=w?1:0;let E;w&&(E={morphing:{srcDemTile:w.from,dstDemTile:w.to,phase:e.easeCubicInOut(w.phase)}});const C=yi(c.projMatrix,Mi(c.canonical,p.renderWorldCopies)?m/10:m);u(T,h),i.setupElevationDraw(r,l,E),t.prepareDrawProgram(s,l,c.toUnwrapped()),l.draw(s,f,d,x,_,e.CullFaceMode.backCCW,C,"terrain_raster",i.gridBuffer,g,v);}}));}}(i,this,this.proxySourceCache,t,this._updateTimestamp),this.renderingToTexture=!0,i.gpuTimingDeferredRenderEnd(),t.splice(0,t.length));}renderBatch(t){if(0===this._drapedRenderBatches.length)return t+1;this.renderingToTexture=!0;const i=this.painter,o=this.painter.context,r=this.proxySourceCache,n=this.proxiedCoords[r.id],s=this._drapedRenderBatches.shift(),a=[],l=i.style.order;let c=0;for(const h of n){const n=r.getTileByID(h.proxyTileKey),u=r.proxyCachedFBO[h.key]?r.proxyCachedFBO[h.key][t]:void 0,_=void 0!==u?r.renderCache[u]:this.pool[c++],d=void 0!==u;if(n.texture=_.tex,d&&!_.dirty){a.push(n.tileID);continue}let p;o.bindFramebuffer.set(_.fb.framebuffer),this.renderedToTile=!1,_.dirty&&(o.clear({color:e.Color.transparent,stencil:0}),_.dirty=!1);for(let e=s.start;e<=s.end;++e){const t=i.style._layers[l[e]];if(t.isHidden(i.transform.zoom))continue;const r=i.style._getLayerSourceCache(t),n=r?this.proxyToSource[h.key][r.id]:[h];if(!n)continue;const s=n;o.viewport.set([0,0,_.fb.width,_.fb.height]),p!==(r?r.id:null)&&(this._setupStencil(_,n,t,r),p=r?r.id:null),i.renderLayer(i,r,t,s);}this.renderedToTile?(_.dirty=!0,a.push(n.tileID)):d||--c,5===c&&(c=0,this.renderToBackBuffer(a));}return this.renderToBackBuffer(a),this.renderingToTexture=!1,o.bindFramebuffer.set(null),o.viewport.set([0,0,i.width,i.height]),s.end+1}postRender(){}renderCacheEfficiency(e){const t=e.order.length;if(0===t)return {efficiency:100};let i,o=0,r=0,n=!1;for(let s=0;s<t;++s){const t=e._layers[e.order[s]];this._style.isLayerDraped(t)?(n&&++o,++r):n||(n=!0,i=t.id);}return 0===r?{efficiency:100}:{efficiency:100*(1-o/r),firstUndrapedLayer:i}}getMinElevationBelowMSL(){let e=0;return this._visibleDemTiles.filter((e=>e.dem)).forEach((t=>{e=Math.min(e,t.dem.tree.minimums[0]);})),0===e?e:(e-30)*this._exaggeration}raycast(e,t,i){if(!this._visibleDemTiles)return null;const o=this._visibleDemTiles.filter((e=>e.dem)).map((o=>{const r=o.tileID,n=1<<r.overscaledZ,{x:s,y:a}=r.canonical,l=s/n,c=(s+1)/n,h=a/n,u=(a+1)/n;return {minx:l,miny:h,maxx:c,maxy:u,t:o.dem.tree.raycastRoot(l,h,c,u,e,t,i),tile:o}}));o.sort(((e,t)=>(null!==e.t?e.t:Number.MAX_VALUE)-(null!==t.t?t.t:Number.MAX_VALUE)));for(const r of o){if(null==r.t)return null;const o=r.tile.dem.tree.raycast(r.minx,r.miny,r.maxx,r.maxy,e,t,i);if(null!=o)return o}return null}_createFBO(){const t=this.painter.context,i=t.gl,o=this.drapeBufferSize;t.activeTexture.set(i.TEXTURE0);const r=new e.Texture(t,{width:o[0],height:o[1],data:null},i.RGBA);r.bind(i.LINEAR,i.CLAMP_TO_EDGE);const n=t.createFramebuffer(o[0],o[1],!1);return n.colorAttachment.set(r.texture),n.depthAttachment=new Ee(t,n.framebuffer),void 0===this._sharedDepthStencil?(this._sharedDepthStencil=t.createRenderbuffer(t.gl.DEPTH_STENCIL,o[0],o[1]),this._stencilRef=0,n.depthAttachment.set(this._sharedDepthStencil),t.clear({stencil:0})):n.depthAttachment.set(this._sharedDepthStencil),t.extTextureFilterAnisotropic&&!t.extTextureFilterAnisotropicForceOff&&i.texParameterf(i.TEXTURE_2D,t.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,t.extTextureFilterAnisotropicMax),{fb:n,tex:r,dirty:!1}}_initFBOPool(){for(;this.pool.length<Math.min(5,this.proxyCoords.length);)this.pool.push(this._createFBO());}_shouldDisableRenderCache(){if(this._style.light&&this._style.light.hasTransition())return !0;for(const e in this._style._sourceCaches)if(this._style._sourceCaches[e].hasTransition())return !0;return this._style.order.some((e=>{const t=this._style._layers[e],i=t.isHidden(this.painter.transform.zoom);return "custom"===t.type?!i&&t.shouldRedrape():!i&&t.hasTransition()}))}_clearLineLayersFromRenderCache(){let t=!1;for(const e of this._style._getSources())if(e instanceof Ie){t=!0;break}if(!t)return;const i={};for(let t=0;t<this._style.order.length;++t){const o=this._style._layers[this._style.order[t]],r=this._style._getLayerSourceCache(o);if(r&&!i[r.id]&&!o.isHidden(this.painter.transform.zoom)&&"line"===o.type&&o.widthExpression()instanceof e.ZoomDependentExpression){i[r.id]=!0;for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][r.id];if(t)for(const e of t)this._clearRenderCacheForTile(r.id,e);}}}}_clearRasterLayersFromRenderCache(){let e=!1;for(const t in this._style._sourceCaches)if(this._style._sourceCaches[t]._source instanceof Se){e=!0;break}if(!e)return;const t={};for(let e=0;e<this._style.order.length;++e){const i=this._style._layers[this._style.order[e]],o=this._style._getLayerSourceCache(i);if(!o||t[o.id])continue;if(i.isHidden(this.painter.transform.zoom)||"raster"!==i.type)continue;const r=i.paint.get("raster-fade-duration");for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][o.id];if(t)for(const e of t){const t=Si(o.getTile(e),o.findLoadedParent(e,0),o,this.painter.transform,r);(1!==t.opacity||0!==t.mix)&&this._clearRenderCacheForTile(o.id,e);}}}}_setupDrapedRenderBatches(){const e=this._style.order,t=e.length;if(0===t)return;const i=[];let o,r=0,n=this._style._layers[e[r]];for(;!this._style.isLayerDraped(n)&&n.isHidden(this.painter.transform.zoom)&&++r<t;)n=this._style._layers[e[r]];for(;r<t;++r){const t=this._style._layers[e[r]];t.isHidden(this.painter.transform.zoom)||(this._style.isLayerDraped(t)?void 0===o&&(o=r):void 0!==o&&(i.push({start:o,end:r-1}),o=void 0));}void 0!==o&&i.push({start:o,end:r-1}),this._drapedRenderBatches=i;}_setupRenderCache(e){const t=this.proxySourceCache;if(this._shouldDisableRenderCache()||this._invalidateRenderCache){if(this._invalidateRenderCache=!1,t.renderCache.length>t.renderCachePool.length){const e=Object.values(t.proxyCachedFBO);t.proxyCachedFBO={};for(let i=0;i<e.length;++i){const o=Object.values(e[i]);t.renderCachePool.push(...o);}}return}this._clearRasterLayersFromRenderCache();const i=this.proxyCoords,o=this._tilesDirty;for(let r=i.length-1;r>=0;r--){const n=i[r];if(t.getTileByID(n.key),void 0!==t.proxyCachedFBO[n.key]){const i=e[n.key],r=this.proxyToSource[n.key];let s=0;for(const e in r){const t=r[e],n=i[e];if(!n||n.length!==t.length||t.some(((t,i)=>t!==n[i]||o[e]&&o[e].hasOwnProperty(t.key)))){s=-1;break}++s;}for(const e in t.proxyCachedFBO[n.key])t.renderCache[t.proxyCachedFBO[n.key][e]].dirty=s<0||s!==Object.values(i).length;}}const r=[...this._drapedRenderBatches];r.sort(((e,t)=>t.end-t.start-(e.end-e.start)));for(const e of r)for(const o of i){if(t.proxyCachedFBO[o.key])continue;let i=t.renderCachePool.pop();void 0===i&&t.renderCache.length<50&&(i=t.renderCache.length,t.renderCache.push(this._createFBO())),void 0!==i&&(t.proxyCachedFBO[o.key]={},t.proxyCachedFBO[o.key][e.start]=i,t.renderCache[i].dirty=!0);}this._tilesDirty={};}_setupStencil(e,t,i,o){if(!o||!this._sourceTilesOverlap[o.id])return void(this._overlapStencilType&&(this._overlapStencilType=!1));const r=this.painter.context,n=r.gl;if(t.length<=1)return void(this._overlapStencilType=!1);let s;if(i.isTileClipped())s=t.length,this._overlapStencilMode.test={func:n.EQUAL,mask:255},this._overlapStencilType="Clip";else {if(!(t[0].overscaledZ>t[t.length-1].overscaledZ))return void(this._overlapStencilType=!1);s=1,this._overlapStencilMode.test={func:n.GREATER,mask:255},this._overlapStencilType="Mask";}this._stencilRef+s>255&&(r.clear({stencil:0}),this._stencilRef=0),this._stencilRef+=s,this._overlapStencilMode.ref=this._stencilRef,i.isTileClipped()&&this._renderTileClippingMasks(t,this._overlapStencilMode.ref);}clipOrMaskOverlapStencilType(){return "Clip"===this._overlapStencilType||"Mask"===this._overlapStencilType}stencilModeForRTTOverlap(t){return this.renderingToTexture&&this._overlapStencilType?("Clip"===this._overlapStencilType&&(this._overlapStencilMode.ref=this.painter._tileClippingMaskIDs[t.key]),this._overlapStencilMode):e.StencilMode.disabled}_renderTileClippingMasks(t,i){const o=this.painter,r=this.painter.context,n=r.gl;o._tileClippingMaskIDs={},r.setColorMode(e.ColorMode.disabled),r.setDepthMode(e.DepthMode.disabled);const s=o.useProgram("clippingMask");for(const a of t){const t=o._tileClippingMaskIDs[a.key]=--i;s.draw(r,n.TRIANGLES,e.DepthMode.disabled,new e.StencilMode({func:n.ALWAYS,mask:0},t,255,n.KEEP,n.KEEP,n.REPLACE),e.ColorMode.disabled,e.CullFaceMode.disabled,Ii(a.projMatrix),"$clipping",o.tileExtentBuffer,o.quadTriangleIndexBuffer,o.tileExtentSegments);}}pointCoordinate(t){const i=this.painter.transform;if(t.x<0||t.x>i.width||t.y<0||t.y>i.height)return null;const o=[t.x,t.y,1,1];e.transformMat4$1(o,o,i.pixelMatrixInverse),e.scale$1(o,o,1/o[3]),o[0]/=i.worldSize,o[1]/=i.worldSize;const r=i._camera.position,n=e.mercatorZfromAltitude(1,i.center.lat),s=[r[0],r[1],r[2]/n,0],a=e.subtract([],o.slice(0,3),s);e.normalize(a,a);const l=this.raycast(s,a,this._exaggeration);return null!==l&&l?(e.scaleAndAdd(s,s,a,l),s[3]=s[2],s[2]*=n,s):null}drawDepth(){const t=this.painter,i=t.context,o=this.proxySourceCache,r=Math.ceil(t.width),n=Math.ceil(t.height);if(!this._depthFBO||this._depthFBO.width===r&&this._depthFBO.height===n||(this._depthFBO.destroy(),this._depthFBO=void 0,this._depthTexture=void 0),!this._depthFBO){const t=i.gl,o=i.createFramebuffer(r,n,!0);i.activeTexture.set(t.TEXTURE0);const s=new e.Texture(i,{width:r,height:n,data:null},t.RGBA);s.bind(t.NEAREST,t.CLAMP_TO_EDGE),o.colorAttachment.set(s.texture);const a=i.createRenderbuffer(i.gl.DEPTH_COMPONENT16,r,n);o.depthAttachment.set(a),this._depthFBO=o,this._depthTexture=s;}i.bindFramebuffer.set(this._depthFBO.framebuffer),i.viewport.set([0,0,r,n]),function(t,i,o,r){if("globe"===t.transform.projection.name)return;const n=t.context,s=n.gl;n.clear({depth:1});const a=t.useProgram("terrainDepth"),l=new e.DepthMode(s.LESS,e.DepthMode.ReadWrite,t.depthRangeFor3D);for(const t of r){const r=o.getTile(t),c=yi(t.projMatrix,0);i.setupElevationDraw(r,a),a.draw(n,s.TRIANGLES,l,e.StencilMode.disabled,e.ColorMode.unblended,e.CullFaceMode.backCCW,c,"terrain_depth",i.gridBuffer,i.gridIndexBuffer,i.gridNoSkirtSegments);}}(t,this,o,this.proxyCoords);}_setupProxiedCoordsForOrtho(e,t,i){if(e.getSource()instanceof Ae)return this._setupProxiedCoordsForImageSource(e,t,i);this._findCoveringTileCache[e.id]=this._findCoveringTileCache[e.id]||{};const o=this.proxiedCoords[e.id]=[],r=this.proxyCoords;for(let t=0;t<r.length;t++){const n=r[t],s=this._findTileCoveringTileID(n,e);if(s){const t=this._createProxiedId(n,s,i[n.key]&&i[n.key][e.id]);o.push(t),this.proxyToSource[n.key][e.id]=[t];}}let n=!1;for(let r=0;r<t.length;r++){const s=e.getTile(t[r]);if(!s||!s.hasData())continue;const a=this._findTileCoveringTileID(s.tileID,this.proxySourceCache);if(a&&a.tileID.canonical.z!==s.tileID.canonical.z){const t=this.proxyToSource[a.tileID.key][e.id],r=this._createProxiedId(a.tileID,s,i[a.tileID.key]&&i[a.tileID.key][e.id]);t?t.splice(t.length-1,0,r):this.proxyToSource[a.tileID.key][e.id]=[r],o.push(r),n=!0;}}this._sourceTilesOverlap[e.id]=n;}_setupProxiedCoordsForImageSource(t,i,o){if(!t.getSource().loaded())return;const r=this.proxiedCoords[t.id]=[],n=this.proxyCoords,s=t.getSource(),a=new e.pointGeometry(s.tileID.x,s.tileID.y)._div(1<<s.tileID.z),l=s.coordinates.map(e.MercatorCoordinate.fromLngLat).reduce(((e,t)=>(e.min.x=Math.min(e.min.x,t.x-a.x),e.min.y=Math.min(e.min.y,t.y-a.y),e.max.x=Math.max(e.max.x,t.x-a.x),e.max.y=Math.max(e.max.y,t.y-a.y),e)),{min:new e.pointGeometry(Number.MAX_VALUE,Number.MAX_VALUE),max:new e.pointGeometry(-Number.MAX_VALUE,-Number.MAX_VALUE)}),c=(t,i)=>{const o=t.wrap+t.canonical.x/(1<<t.canonical.z),r=t.canonical.y/(1<<t.canonical.z),n=e.EXTENT/(1<<t.canonical.z),s=i.wrap+i.canonical.x/(1<<i.canonical.z),a=i.canonical.y/(1<<i.canonical.z);return o+n<s+l.min.x||o>s+l.max.x||r+n<a+l.min.y||r>a+l.max.y};for(let e=0;e<n.length;e++){const s=n[e];for(let e=0;e<i.length;e++){const n=t.getTile(i[e]);if(!n||!n.hasData())continue;if(c(s,n.tileID))continue;const a=this._createProxiedId(s,n,o[s.key]&&o[s.key][t.id]),l=this.proxyToSource[s.key][t.id];l?l.push(a):this.proxyToSource[s.key][t.id]=[a],r.push(a);}}}_createProxiedId(t,i,o){let r=this.orthoMatrix;if(o){const e=o.find((e=>e.key===i.tileID.key));if(e)return e}if(i.tileID.key!==t.key){const o=t.canonical.z-i.tileID.canonical.z;let n,s,a;r=e.create();const l=i.tileID.wrap-t.wrap<<t.overscaledZ;o>0?(n=e.EXTENT>>o,s=n*((i.tileID.canonical.x<<o)-t.canonical.x+l),a=n*((i.tileID.canonical.y<<o)-t.canonical.y)):(n=e.EXTENT<<-o,s=e.EXTENT*(i.tileID.canonical.x-(t.canonical.x+l<<-o)),a=e.EXTENT*(i.tileID.canonical.y-(t.canonical.y<<-o))),e.ortho(r,0,n,0,n,0,1),e.translate(r,r,[s,a,0]);}return new Ai(i.tileID,t.key,r)}_findTileCoveringTileID(t,i){let o=i.getTile(t);if(o&&o.hasData())return o;const r=this._findCoveringTileCache[i.id],n=r[t.key];if(o=n?i.getTileByID(n):null,o&&o.hasData()||null===n)return o;let s=o?o.tileID:t,a=s.overscaledZ;const l=i.getSource().minzoom,c=[];if(!n){const r=i.getSource().maxzoom;if(t.canonical.z>=r){const o=t.canonical.z-r;i.getSource().reparseOverscaled?(a=Math.max(t.canonical.z+2,i.transform.tileZoom),s=new e.OverscaledTileID(a,t.wrap,r,t.canonical.x>>o,t.canonical.y>>o)):0!==o&&(a=r,s=new e.OverscaledTileID(a,t.wrap,r,t.canonical.x>>o,t.canonical.y>>o));}s.key!==t.key&&(c.push(s.key),o=i.getTile(s));}const h=e=>{c.forEach((t=>{r[t]=e;})),c.length=0;};for(a-=1;a>=l&&(!o||!o.hasData());a--){o&&h(o.tileID.key);const e=s.calculateScaledKey(a);if(o=i.getTileByID(e),o&&o.hasData())break;const t=r[e];if(null===t)break;void 0===t?c.push(e):o=i.getTileByID(t);}return h(o?o.tileID.key:null),o&&o.hasData()?o:null}findDEMTileFor(e){return this.enabled?this._findTileCoveringTileID(e,this.sourceCache):null}prepareDrawTile(){this.renderedToTile=!0;}_clearRenderCacheForTile(e,t){let i=this._tilesDirty[e];i||(i=this._tilesDirty[e]={}),i[t.key]=!0;}getWirefameBuffer(){if(!this.wireframeSegments){const t=function(t){let i=0;const o=new e.StructArrayLayout2ui4,r=131;for(let e=1;e<129;e++){for(let t=1;t<129;t++)i=e*r+t,o.emplaceBack(i,i+1),o.emplaceBack(i,i+r),o.emplaceBack(i+1,i+r),128===e&&o.emplaceBack(i+r,i+r+1);o.emplaceBack(i+1,i+1+r);}return o}();this.wireframeIndexBuffer=this.painter.context.createIndexBuffer(t),this.wireframeSegments=e.SegmentVector.simpleSegment(0,0,this.gridBuffer.length,t.length);}return [this.wireframeIndexBuffer,this.wireframeSegments]}}class Pi{static cacheKey(e,t,i,o){let r=`${t}${o?o.cacheKey:""}`;for(const t of i)e.usedDefines.includes(t)&&(r+=`/${t}`);return r}constructor(t,i,o,r,n,s){const a=t.gl;this.program=a.createProgram();const l=function(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const o=e[i].split(" ");t.push(o.pop());}return t}(o.staticAttributes),c=r?r.getBinderAttributes():[],h=l.concat(c);let u=r?r.defines():[];u=u.concat(s.map((e=>`#define ${e}`)));const _=t.isWebGL2?"#version 300 es\n":"",d=_+u.concat(t.extStandardDerivatives&&0===_.length?"#extension GL_OES_standard_derivatives : enable\n".concat(hi):hi,hi,ci,li.fragmentSource,si.fragmentSource,o.fragmentSource).join("\n"),p=_+u.concat("\n#ifdef GL_ES\nprecision highp float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif",ci,li.vertexSource,si.vertexSource,ni.vertexSource,o.vertexSource).join("\n"),m=a.createShader(a.FRAGMENT_SHADER);if(a.isContextLost())return void(this.failedToCreate=!0);a.shaderSource(m,d),a.compileShader(m),a.attachShader(this.program,m);const f=a.createShader(a.VERTEX_SHADER);if(a.isContextLost())this.failedToCreate=!0;else {a.shaderSource(f,p),a.compileShader(f),a.attachShader(this.program,f),this.attributes={},this.numAttributes=h.length;for(let e=0;e<this.numAttributes;e++)h[e]&&(a.bindAttribLocation(this.program,e,h[e]),this.attributes[h[e]]=e);a.linkProgram(this.program),a.deleteShader(f),a.deleteShader(m),this.fixedUniforms=n(t),this.binderUniforms=r?r.getUniforms(t):[],s.includes("TERRAIN")&&(this.terrainUniforms=(t=>({u_dem:new e.Uniform1i(t),u_dem_prev:new e.Uniform1i(t),u_dem_unpack:new e.Uniform4f(t),u_dem_tl:new e.Uniform2f(t),u_dem_scale:new e.Uniform1f(t),u_dem_tl_prev:new e.Uniform2f(t),u_dem_scale_prev:new e.Uniform1f(t),u_dem_size:new e.Uniform1f(t),u_dem_lerp:new e.Uniform1f(t),u_exaggeration:new e.Uniform1f(t),u_depth:new e.Uniform1i(t),u_depth_size_inv:new e.Uniform2f(t),u_meter_to_dem:new e.Uniform1f(t),u_label_plane_matrix_inv:new e.UniformMatrix4f(t)}))(t)),s.includes("GLOBE")&&(this.globeUniforms=(t=>({u_tile_tl_up:new e.Uniform3f(t),u_tile_tr_up:new e.Uniform3f(t),u_tile_br_up:new e.Uniform3f(t),u_tile_bl_up:new e.Uniform3f(t),u_tile_up_scale:new e.Uniform1f(t)}))(t)),s.includes("FOG")&&(this.fogUniforms=(t=>({u_fog_matrix:new e.UniformMatrix4f(t),u_fog_range:new e.Uniform2f(t),u_fog_color:new e.Uniform4f(t),u_fog_horizon_blend:new e.Uniform1f(t),u_fog_temporal_offset:new e.Uniform1f(t),u_frustum_tl:new e.Uniform3f(t),u_frustum_tr:new e.Uniform3f(t),u_frustum_br:new e.Uniform3f(t),u_frustum_bl:new e.Uniform3f(t),u_globe_pos:new e.Uniform3f(t),u_globe_radius:new e.Uniform1f(t),u_globe_transition:new e.Uniform1f(t),u_is_globe:new e.Uniform1i(t),u_viewport:new e.Uniform2f(t)}))(t));}}setTerrainUniformValues(e,t){if(!this.terrainUniforms)return;const i=this.terrainUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e]&&i[e].set(this.program,e,t[e]);}}setGlobeUniformValues(e,t){if(!this.globeUniforms)return;const i=this.globeUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e]&&i[e].set(this.program,e,t[e]);}}setFogUniformValues(e,t){if(!this.fogUniforms)return;const i=this.fogUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].set(this.program,e,t[e]);}}draw(e,t,i,o,r,n,s,a,l,c,h,u,_,d,p){const m=e.gl;if(this.failedToCreate)return;e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(o),e.setColorMode(r),e.setCullFace(n);for(const e of Object.keys(this.fixedUniforms))this.fixedUniforms[e].set(this.program,e,s[e]);d&&d.setUniforms(this.program,e,this.binderUniforms,u,{zoom:_});const f={[m.LINES]:2,[m.TRIANGLES]:3,[m.LINE_STRIP]:1}[t];for(const i of h.get()){const o=i.vaos||(i.vaos={});(o[a]||(o[a]=new pi)).bind(e,this,l,d?d.getPaintVertexBuffers():[],c,i.vertexOffset,p||[]),m.drawElements(t,i.primitiveLength*f,m.UNSIGNED_SHORT,i.primitiveOffset*f*2);}}}function Ri(e,t){const i=Math.pow(2,t.tileID.overscaledZ),o=t.tileSize*Math.pow(2,e.transform.tileZoom)/i,r=o*(t.tileID.canonical.x+t.tileID.wrap*i),n=o*t.tileID.canonical.y;return {u_image:0,u_texsize:t.imageAtlasTexture.size,u_tile_units_to_pixels:1/P(t,1,e.transform.tileZoom),u_pixel_coord_upper:[r>>16,n>>16],u_pixel_coord_lower:[65535&r,65535&n]}}const Oi=e.create(),Bi=(t,i,o,r,n,s,a,l,c,h,u)=>{const _=i.style.light,d=_.properties.get("position"),p=[d.x,d.y,d.z],m=e.create$1();"viewport"===_.properties.get("anchor")&&(e.fromRotation(m,-i.transform.angle),e.transformMat3(p,p,m));const f=_.properties.get("color"),g=i.transform,v={u_matrix:t,u_lightpos:p,u_lightintensity:_.properties.get("intensity"),u_lightcolor:[f.r,f.g,f.b],u_vertical_gradient:+o,u_opacity:r,u_tile_id:[0,0,0],u_zoom_transition:0,u_inv_rot_matrix:Oi,u_merc_center:[0,0],u_up_dir:[0,0,0],u_height_lift:0,u_ao:n,u_edge_radius:s};return "globe"===g.projection.name&&(v.u_tile_id=[a.canonical.x,a.canonical.y,1<<a.canonical.z],v.u_zoom_transition=c,v.u_inv_rot_matrix=u,v.u_merc_center=h,v.u_up_dir=g.projection.upVector(new e.CanonicalTileID(0,0,0),h[0]*e.EXTENT,h[1]*e.EXTENT),v.u_height_lift=l),v},ki=(t,i,o,r,n,s,a,l,c,h,u,_)=>{const d=Bi(t,i,o,r,n,s,a,c,h,u,_),p={u_height_factor:-Math.pow(2,a.overscaledZ)/l.tileSize/8};return e.extend(d,Ri(i,l),p)},Fi=e=>({u_matrix:e}),Ui=(t,i,o)=>e.extend(Fi(t),Ri(i,o)),Ni=(e,t)=>({u_matrix:e,u_world:t}),Gi=(t,i,o,r)=>e.extend(Ui(t,i,o),{u_world:r}),ji=e.create(),Zi=(t,i,o,r,n,s)=>{const a=t.transform,l="globe"===a.projection.name;let c;if("map"===s.paint.get("circle-pitch-alignment"))if(l){const t=e.globePixelsToTileUnits(a.zoom,i.canonical)*a._pixelsPerMercatorPixel;c=Float32Array.from([t,0,0,t]);}else c=a.calculatePixelsToTileUnitsMatrix(o);else c=new Float32Array([a.pixelsToGLUnits[0],0,0,a.pixelsToGLUnits[1]]);const h={u_camera_to_center_distance:a.cameraToCenterDistance,u_matrix:t.translatePosMatrix(i.projMatrix,o,s.paint.get("circle-translate"),s.paint.get("circle-translate-anchor")),u_device_pixel_ratio:e.exported.devicePixelRatio,u_extrude_scale:c,u_inv_rot_matrix:ji,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0]};if(l){h.u_inv_rot_matrix=r,h.u_merc_center=n,h.u_tile_id=[i.canonical.x,i.canonical.y,1<<i.canonical.z],h.u_zoom_transition=e.globeToMercatorTransition(a.zoom);const t=n[0]*e.EXTENT,o=n[1]*e.EXTENT;h.u_up_dir=a.projection.upVector(new e.CanonicalTileID(0,0,0),t,o);}return h},Vi=e=>{const t=[];return "map"===e.paint.get("circle-pitch-alignment")&&t.push("PITCH_WITH_MAP"),"map"===e.paint.get("circle-pitch-scale")&&t.push("SCALE_WITH_MAP"),t},Wi=(t,i,o,r)=>{const n=e.EXTENT/o.tileSize;return {u_matrix:t,u_camera_to_center_distance:i.getCameraToCenterDistance(r),u_extrude_scale:[i.pixelsToGLUnits[0]/n,i.pixelsToGLUnits[1]/n]}},Xi=(e,t,i=1)=>({u_matrix:e,u_color:t,u_overlay:0,u_overlay_scale:i}),qi=e.create(),$i=(t,i,o,r,n,s,a)=>{const l=t.transform,c="globe"===l.projection.name,h=c?e.globePixelsToTileUnits(l.zoom,i.canonical)*l._pixelsPerMercatorPixel:P(o,1,s),u={u_matrix:i.projMatrix,u_extrude_scale:h,u_intensity:a,u_inv_rot_matrix:qi,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0]};if(c){u.u_inv_rot_matrix=r,u.u_merc_center=n,u.u_tile_id=[i.canonical.x,i.canonical.y,1<<i.canonical.z],u.u_zoom_transition=e.globeToMercatorTransition(l.zoom);const t=n[0]*e.EXTENT,o=n[1]*e.EXTENT;u.u_up_dir=l.projection.upVector(new e.CanonicalTileID(0,0,0),t,o);}return u},Hi=(e,t,i,o,r,n,s)=>{const a=e.transform,l=a.calculatePixelsToTileUnitsMatrix(t);return {u_matrix:Ji(e,t,i,o),u_pixels_to_tile_units:l,u_device_pixel_ratio:n,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:r,u_texsize:Qi(i)?t.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:Ki(t,e.transform),u_alpha_discard_threshold:0,u_trim_offset:s}},Yi=(e,t,i,o,r)=>{const n=e.transform;return {u_matrix:Ji(e,t,i,o),u_texsize:t.imageAtlasTexture.size,u_pixels_to_tile_units:n.calculatePixelsToTileUnitsMatrix(t),u_device_pixel_ratio:r,u_image:0,u_tile_units_to_pixels:Ki(t,n),u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]],u_alpha_discard_threshold:0}};function Ki(e,t){return 1/P(e,1,t.tileZoom)}function Ji(e,t,i,o){return e.translatePosMatrix(o||t.tileID.projMatrix,t,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}function Qi(e){const t=e.paint.get("line-dasharray").value;return t.value||"constant"!==t.kind}const eo=(e,t,i,o,r,n)=>{return {u_matrix:e,u_tl_parent:t,u_scale_parent:i,u_fade_t:o.mix,u_opacity:o.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(a=r.paint.get("raster-saturation"),a>0?1-1/(1.001-a):-a),u_contrast_factor:(s=r.paint.get("raster-contrast"),s>0?1/(1-s):1+s),u_spin_weights:to(r.paint.get("raster-hue-rotate")),u_perspective_transform:n};var s,a;};function to(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return [(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const io=e.create(),oo=(t,i,o,r,n,s,a,l,c,h,u,_,d,p,m,f)=>{const g=n.transform,v={u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:i?i.uSizeT:0,u_size:i?i.uSize:0,u_camera_to_center_distance:g.cameraToCenterDistance,u_rotate_symbol:+o,u_aspect_ratio:g.width/g.height,u_fade_change:n.options.fadeDuration?n.symbolFadeChange:1,u_matrix:s,u_label_plane_matrix:a,u_coord_matrix:l,u_is_text:+c,u_pitch_with_map:+r,u_texsize:h,u_texture:0,u_tile_id:[0,0,0],u_zoom_transition:0,u_inv_rot_matrix:io,u_merc_center:[0,0],u_camera_forward:[0,0,0],u_ecef_origin:[0,0,0],u_tile_matrix:io,u_up_vector:[0,-1,0]};return "globe"===f.name&&(v.u_tile_id=[u.canonical.x,u.canonical.y,1<<u.canonical.z],v.u_zoom_transition=_,v.u_inv_rot_matrix=p,v.u_merc_center=d,v.u_camera_forward=g._camera.forward(),v.u_ecef_origin=e.globeECEFOrigin(g.globeMatrix,u.toUnwrapped()),v.u_tile_matrix=Float32Array.from(g.globeMatrix),v.u_up_vector=m),v},ro=(t,i,o,r,n,s,a,l,c,h,u,_,d,p,m,f,g)=>e.extend(oo(t,i,o,r,n,s,a,l,c,h,_,d,p,m,f,g),{u_gamma_scale:r?n.transform.cameraToCenterDistance*Math.cos(n.terrain?0:n.transform._pitch):1,u_device_pixel_ratio:e.exported.devicePixelRatio,u_is_halo:+u}),no=(t,i,o,r,n,s,a,l,c,h,u,_,d,p,m,f)=>e.extend(ro(t,i,o,r,n,s,a,l,!0,c,!0,u,_,d,p,m,f),{u_texsize_icon:h,u_texture_icon:1}),so=(e,t,i)=>({u_matrix:e,u_opacity:t,u_color:i}),ao=(t,i,o,r,n)=>e.extend(function(e,t,i){const o=t.imageManager.getPattern(e.toString()),{width:r,height:n}=t.imageManager.getPixelSize(),s=Math.pow(2,i.tileID.overscaledZ),a=i.tileSize*Math.pow(2,t.transform.tileZoom)/s,l=a*(i.tileID.canonical.x+i.tileID.wrap*s),c=a*i.tileID.canonical.y;return {u_image:0,u_pattern_tl:o.tl,u_pattern_br:o.br,u_texsize:[r,n],u_pattern_size:o.displaySize,u_tile_units_to_pixels:1/P(i,1,t.transform.tileZoom),u_pixel_coord_upper:[l>>16,c>>16],u_pixel_coord_lower:[65535&l,65535&c]}}(r,o,n),{u_matrix:t,u_opacity:i}),lo={fillExtrusion:t=>({u_matrix:new e.UniformMatrix4f(t),u_lightpos:new e.Uniform3f(t),u_lightintensity:new e.Uniform1f(t),u_lightcolor:new e.Uniform3f(t),u_vertical_gradient:new e.Uniform1f(t),u_opacity:new e.Uniform1f(t),u_edge_radius:new e.Uniform1f(t),u_ao:new e.Uniform2f(t),u_tile_id:new e.Uniform3f(t),u_zoom_transition:new e.Uniform1f(t),u_inv_rot_matrix:new e.UniformMatrix4f(t),u_merc_center:new e.Uniform2f(t),u_up_dir:new e.Uniform3f(t),u_height_lift:new e.Uniform1f(t)}),fillExtrusionPattern:t=>({u_matrix:new e.UniformMatrix4f(t),u_lightpos:new e.Uniform3f(t),u_lightintensity:new e.Uniform1f(t),u_lightcolor:new e.Uniform3f(t),u_vertical_gradient:new e.Uniform1f(t),u_height_factor:new e.Uniform1f(t),u_edge_radius:new e.Uniform1f(t),u_ao:new e.Uniform2f(t),u_tile_id:new e.Uniform3f(t),u_zoom_transition:new e.Uniform1f(t),u_inv_rot_matrix:new e.UniformMatrix4f(t),u_merc_center:new e.Uniform2f(t),u_up_dir:new e.Uniform3f(t),u_height_lift:new e.Uniform1f(t),u_image:new e.Uniform1i(t),u_texsize:new e.Uniform2f(t),u_pixel_coord_upper:new e.Uniform2f(t),u_pixel_coord_lower:new e.Uniform2f(t),u_tile_units_to_pixels:new e.Uniform1f(t),u_opacity:new e.Uniform1f(t)}),fill:t=>({u_matrix:new e.UniformMatrix4f(t)}),fillPattern:t=>({u_matrix:new e.UniformMatrix4f(t),u_image:new e.Uniform1i(t),u_texsize:new e.Uniform2f(t),u_pixel_coord_upper:new e.Uniform2f(t),u_pixel_coord_lower:new e.Uniform2f(t),u_tile_units_to_pixels:new e.Uniform1f(t)}),fillOutline:t=>({u_matrix:new e.UniformMatrix4f(t),u_world:new e.Uniform2f(t)}),fillOutlinePattern:t=>({u_matrix:new e.UniformMatrix4f(t),u_world:new e.Uniform2f(t),u_image:new e.Uniform1i(t),u_texsize:new e.Uniform2f(t),u_pixel_coord_upper:new e.Uniform2f(t),u_pixel_coord_lower:new e.Uniform2f(t),u_tile_units_to_pixels:new e.Uniform1f(t)}),circle:t=>({u_camera_to_center_distance:new e.Uniform1f(t),u_extrude_scale:new e.UniformMatrix2f(t),u_device_pixel_ratio:new e.Uniform1f(t),u_matrix:new e.UniformMatrix4f(t),u_inv_rot_matrix:new e.UniformMatrix4f(t),u_merc_center:new e.Uniform2f(t),u_tile_id:new e.Uniform3f(t),u_zoom_transition:new e.Uniform1f(t),u_up_dir:new e.Uniform3f(t)}),collisionBox:t=>({u_matrix:new e.UniformMatrix4f(t),u_camera_to_center_distance:new e.Uniform1f(t),u_extrude_scale:new e.Uniform2f(t)}),collisionCircle:t=>({u_matrix:new e.UniformMatrix4f(t),u_inv_matrix:new e.UniformMatrix4f(t),u_camera_to_center_distance:new e.Uniform1f(t),u_viewport_size:new e.Uniform2f(t)}),debug:t=>({u_color:new e.UniformColor(t),u_matrix:new e.UniformMatrix4f(t),u_overlay:new e.Uniform1i(t),u_overlay_scale:new e.Uniform1f(t)}),clippingMask:t=>({u_matrix:new e.UniformMatrix4f(t)}),heatmap:t=>({u_extrude_scale:new e.Uniform1f(t),u_intensity:new e.Uniform1f(t),u_matrix:new e.UniformMatrix4f(t),u_inv_rot_matrix:new e.UniformMatrix4f(t),u_merc_center:new e.Uniform2f(t),u_tile_id:new e.Uniform3f(t),u_zoom_transition:new e.Uniform1f(t),u_up_dir:new e.Uniform3f(t)}),heatmapTexture:t=>({u_image:new e.Uniform1i(t),u_color_ramp:new e.Uniform1i(t),u_opacity:new e.Uniform1f(t)}),hillshade:t=>({u_matrix:new e.UniformMatrix4f(t),u_image:new e.Uniform1i(t),u_latrange:new e.Uniform2f(t),u_light:new e.Uniform2f(t),u_shadow:new e.UniformColor(t),u_highlight:new e.UniformColor(t),u_accent:new e.UniformColor(t)}),hillshadePrepare:t=>({u_matrix:new e.UniformMatrix4f(t),u_image:new e.Uniform1i(t),u_dimension:new e.Uniform2f(t),u_zoom:new e.Uniform1f(t),u_unpack:new e.Uniform4f(t)}),line:t=>({u_matrix:new e.UniformMatrix4f(t),u_pixels_to_tile_units:new e.UniformMatrix2f(t),u_device_pixel_ratio:new e.Uniform1f(t),u_units_to_pixels:new e.Uniform2f(t),u_dash_image:new e.Uniform1i(t),u_gradient_image:new e.Uniform1i(t),u_image_height:new e.Uniform1f(t),u_texsize:new e.Uniform2f(t),u_tile_units_to_pixels:new e.Uniform1f(t),u_alpha_discard_threshold:new e.Uniform1f(t),u_trim_offset:new e.Uniform2f(t)}),linePattern:t=>({u_matrix:new e.UniformMatrix4f(t),u_texsize:new e.Uniform2f(t),u_pixels_to_tile_units:new e.UniformMatrix2f(t),u_device_pixel_ratio:new e.Uniform1f(t),u_image:new e.Uniform1i(t),u_units_to_pixels:new e.Uniform2f(t),u_tile_units_to_pixels:new e.Uniform1f(t),u_alpha_discard_threshold:new e.Uniform1f(t)}),raster:t=>({u_matrix:new e.UniformMatrix4f(t),u_tl_parent:new e.Uniform2f(t),u_scale_parent:new e.Uniform1f(t),u_fade_t:new e.Uniform1f(t),u_opacity:new e.Uniform1f(t),u_image0:new e.Uniform1i(t),u_image1:new e.Uniform1i(t),u_brightness_low:new e.Uniform1f(t),u_brightness_high:new e.Uniform1f(t),u_saturation_factor:new e.Uniform1f(t),u_contrast_factor:new e.Uniform1f(t),u_spin_weights:new e.Uniform3f(t),u_perspective_transform:new e.Uniform2f(t)}),symbolIcon:t=>({u_is_size_zoom_constant:new e.Uniform1i(t),u_is_size_feature_constant:new e.Uniform1i(t),u_size_t:new e.Uniform1f(t),u_size:new e.Uniform1f(t),u_camera_to_center_distance:new e.Uniform1f(t),u_rotate_symbol:new e.Uniform1i(t),u_aspect_ratio:new e.Uniform1f(t),u_fade_change:new e.Uniform1f(t),u_matrix:new e.UniformMatrix4f(t),u_label_plane_matrix:new e.UniformMatrix4f(t),u_coord_matrix:new e.UniformMatrix4f(t),u_is_text:new e.Uniform1i(t),u_pitch_with_map:new e.Uniform1i(t),u_texsize:new e.Uniform2f(t),u_tile_id:new e.Uniform3f(t),u_zoom_transition:new e.Uniform1f(t),u_inv_rot_matrix:new e.UniformMatrix4f(t),u_merc_center:new e.Uniform2f(t),u_camera_forward:new e.Uniform3f(t),u_tile_matrix:new e.UniformMatrix4f(t),u_up_vector:new e.Uniform3f(t),u_ecef_origin:new e.Uniform3f(t),u_texture:new e.Uniform1i(t)}),symbolSDF:t=>({u_is_size_zoom_constant:new e.Uniform1i(t),u_is_size_feature_constant:new e.Uniform1i(t),u_size_t:new e.Uniform1f(t),u_size:new e.Uniform1f(t),u_camera_to_center_distance:new e.Uniform1f(t),u_rotate_symbol:new e.Uniform1i(t),u_aspect_ratio:new e.Uniform1f(t),u_fade_change:new e.Uniform1f(t),u_matrix:new e.UniformMatrix4f(t),u_label_plane_matrix:new e.UniformMatrix4f(t),u_coord_matrix:new e.UniformMatrix4f(t),u_is_text:new e.Uniform1i(t),u_pitch_with_map:new e.Uniform1i(t),u_texsize:new e.Uniform2f(t),u_texture:new e.Uniform1i(t),u_gamma_scale:new e.Uniform1f(t),u_device_pixel_ratio:new e.Uniform1f(t),u_tile_id:new e.Uniform3f(t),u_zoom_transition:new e.Uniform1f(t),u_inv_rot_matrix:new e.UniformMatrix4f(t),u_merc_center:new e.Uniform2f(t),u_camera_forward:new e.Uniform3f(t),u_tile_matrix:new e.UniformMatrix4f(t),u_up_vector:new e.Uniform3f(t),u_ecef_origin:new e.Uniform3f(t),u_is_halo:new e.Uniform1i(t)}),symbolTextAndIcon:t=>({u_is_size_zoom_constant:new e.Uniform1i(t),u_is_size_feature_constant:new e.Uniform1i(t),u_size_t:new e.Uniform1f(t),u_size:new e.Uniform1f(t),u_camera_to_center_distance:new e.Uniform1f(t),u_rotate_symbol:new e.Uniform1i(t),u_aspect_ratio:new e.Uniform1f(t),u_fade_change:new e.Uniform1f(t),u_matrix:new e.UniformMatrix4f(t),u_label_plane_matrix:new e.UniformMatrix4f(t),u_coord_matrix:new e.UniformMatrix4f(t),u_is_text:new e.Uniform1i(t),u_pitch_with_map:new e.Uniform1i(t),u_texsize:new e.Uniform2f(t),u_texsize_icon:new e.Uniform2f(t),u_texture:new e.Uniform1i(t),u_texture_icon:new e.Uniform1i(t),u_gamma_scale:new e.Uniform1f(t),u_device_pixel_ratio:new e.Uniform1f(t),u_is_halo:new e.Uniform1i(t)}),background:t=>({u_matrix:new e.UniformMatrix4f(t),u_opacity:new e.Uniform1f(t),u_color:new e.UniformColor(t)}),backgroundPattern:t=>({u_matrix:new e.UniformMatrix4f(t),u_opacity:new e.Uniform1f(t),u_image:new e.Uniform1i(t),u_pattern_tl:new e.Uniform2f(t),u_pattern_br:new e.Uniform2f(t),u_texsize:new e.Uniform2f(t),u_pattern_size:new e.Uniform2f(t),u_pixel_coord_upper:new e.Uniform2f(t),u_pixel_coord_lower:new e.Uniform2f(t),u_tile_units_to_pixels:new e.Uniform1f(t)}),terrainRaster:xi,terrainDepth:xi,skybox:t=>({u_matrix:new e.UniformMatrix4f(t),u_sun_direction:new e.Uniform3f(t),u_cubemap:new e.Uniform1i(t),u_opacity:new e.Uniform1f(t),u_temporal_offset:new e.Uniform1f(t)}),skyboxGradient:t=>({u_matrix:new e.UniformMatrix4f(t),u_color_ramp:new e.Uniform1i(t),u_center_direction:new e.Uniform3f(t),u_radius:new e.Uniform1f(t),u_opacity:new e.Uniform1f(t),u_temporal_offset:new e.Uniform1f(t)}),skyboxCapture:t=>({u_matrix_3f:new e.UniformMatrix3f(t),u_sun_direction:new e.Uniform3f(t),u_sun_intensity:new e.Uniform1f(t),u_color_tint_r:new e.Uniform4f(t),u_color_tint_m:new e.Uniform4f(t),u_luminance:new e.Uniform1f(t)}),globeRaster:t=>({u_proj_matrix:new e.UniformMatrix4f(t),u_globe_matrix:new e.UniformMatrix4f(t),u_normalize_matrix:new e.UniformMatrix4f(t),u_merc_matrix:new e.UniformMatrix4f(t),u_zoom_transition:new e.Uniform1f(t),u_merc_center:new e.Uniform2f(t),u_image0:new e.Uniform1i(t),u_grid_matrix:new e.UniformMatrix3f(t),u_skirt_height:new e.Uniform1f(t),u_frustum_tl:new e.Uniform3f(t),u_frustum_tr:new e.Uniform3f(t),u_frustum_br:new e.Uniform3f(t),u_frustum_bl:new e.Uniform3f(t),u_globe_pos:new e.Uniform3f(t),u_globe_radius:new e.Uniform1f(t),u_viewport:new e.Uniform2f(t)}),globeAtmosphere:t=>({u_frustum_tl:new e.Uniform3f(t),u_frustum_tr:new e.Uniform3f(t),u_frustum_br:new e.Uniform3f(t),u_frustum_bl:new e.Uniform3f(t),u_horizon:new e.Uniform1f(t),u_transition:new e.Uniform1f(t),u_fadeout_range:new e.Uniform1f(t),u_color:new e.Uniform4f(t),u_high_color:new e.Uniform4f(t),u_space_color:new e.Uniform4f(t),u_star_intensity:new e.Uniform1f(t),u_star_density:new e.Uniform1f(t),u_star_size:new e.Uniform1f(t),u_temporal_offset:new e.Uniform1f(t),u_horizon_angle:new e.Uniform1f(t),u_rotation_matrix:new e.UniformMatrix4f(t)})};let co;function ho(t,i,o,r,n,s,a){const l=t.context,c=l.gl,h=t.transform,u=t.useProgram("collisionBox"),_=[];let d=0,p=0;for(let m=0;m<r.length;m++){const f=r[m],g=i.getTile(f),v=g.getBucket(o);if(!v)continue;const x=yt(f,v,h);let y=x;0===n[0]&&0===n[1]||(y=t.translatePosMatrix(x,g,n,s));const b=a?v.textCollisionBox:v.iconCollisionBox,w=v.collisionCircleArray;if(w.length>0){const t=e.create(),i=y;e.mul(t,v.placementInvProjMatrix,h.glCoordMatrix),e.mul(t,t,v.placementViewportMatrix),_.push({circleArray:w,circleOffset:p,transform:i,invTransform:t,projection:v.getProjection()}),d+=w.length/4,p=d;}b&&(t.terrain&&t.terrain.setupElevationDraw(g,u),u.draw(l,c.LINES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,Wi(y,h,g,v.getProjection()),o.id,b.layoutVertexBuffer,b.indexBuffer,b.segments,null,h.zoom,null,[b.collisionVertexBuffer,b.collisionVertexBufferExt]));}if(!a||!_.length)return;const m=t.useProgram("collisionCircle"),f=new e.StructArrayLayout2f1f2i16;f.resize(4*d),f._trim();let g=0;for(const e of _)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,o=e.circleArray[i+0],r=e.circleArray[i+1],n=e.circleArray[i+2],s=e.circleArray[i+3];f.emplace(g++,o,r,n,s,0),f.emplace(g++,o,r,n,s,1),f.emplace(g++,o,r,n,s,2),f.emplace(g++,o,r,n,s,3);}(!co||co.length<2*d)&&(co=function(t){const i=2*t,o=new e.StructArrayLayout3ui6;o.resize(i),o._trim();for(let e=0;e<i;e++){const t=6*e;o.uint16[t+0]=4*e+0,o.uint16[t+1]=4*e+1,o.uint16[t+2]=4*e+2,o.uint16[t+3]=4*e+2,o.uint16[t+4]=4*e+3,o.uint16[t+5]=4*e+0;}return o}(d));const v=l.createIndexBuffer(co,!0),x=l.createVertexBuffer(f,e.collisionCircleLayout.members,!0);for(const i of _){const r={u_matrix:i.transform,u_inv_matrix:i.invTransform,u_camera_to_center_distance:(y=h).getCameraToCenterDistance(i.projection),u_viewport_size:[y.width,y.height]};m.draw(l,c.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,r,o.id,x,v,e.SegmentVector.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,h.zoom);}var y;x.destroy(),v.destroy();}const uo=e.create();function _o({width:t,height:i,anchor:o,textOffset:r,textScale:n},s){const{horizontalAlign:a,verticalAlign:l}=e.getAnchorAlignment(o),c=-(a-.5)*t,h=-(l-.5)*i,u=e.evaluateVariableOffset(o,r);return new e.pointGeometry((c/n+u[0])*s,(h/n+u[1])*s)}function po(t,i,o,r,n,s,a,l,c,h,u){const _=t.text.placedSymbolArray,d=t.text.dynamicLayoutVertexArray,p=t.icon.dynamicLayoutVertexArray,m={},f=t.getProjection(),g=bt(l,f,s),v=s.elevation,x=f.upVectorScale(l.canonical,s.center.lat,s.worldSize).metersToTile;d.clear();for(let p=0;p<_.length;p++){const y=_.get(p),{tileAnchorX:b,tileAnchorY:w,numGlyphs:T}=y,E=t.allowVerticalPlacement&&!y.placedOrientation,C=y.hidden||!y.crossTileID||E?null:r[y.crossTileID];if(C){let r=0,_=0,p=0;if(v){const e=v?v.getAtTileOffset(l,b,w):0,[t,i,o]=f.upVector(l.canonical,b,w);r=e*t*x,_=e*i*x,p=e*o*x;}let[E,M,I,S]=nt(y.projectedAnchorX+r,y.projectedAnchorY+_,y.projectedAnchorZ+p,o?g:a);const D=st(s.getCameraToCenterDistance(f),S);let L=n.evaluateSizeForFeature(t.textSizeData,h,y)*D/e.ONE_EM;o&&(L*=t.tilePixelRatio/c);const A=_o(C,L);o?(({x:E,y:M,z:I}=f.projectTilePoint(b+A.x,w+A.y,l.canonical)),[E,M,I]=nt(E+r,M+_,I+p,a)):(i&&A._rotate(-s.angle),E+=A.x,M+=A.y,I=0);const z=t.allowVerticalPlacement&&y.placedOrientation===e.WritingMode.vertical?Math.PI/2:0;for(let t=0;t<T;t++)e.addDynamicAttributes(d,E,M,I,z);u&&y.associatedIconIndex>=0&&(m[y.associatedIconIndex]={x:E,y:M,z:I,angle:z});}else mt(T,d);}if(u){p.clear();const i=t.icon.placedSymbolArray;for(let t=0;t<i.length;t++){const o=i.get(t),{numGlyphs:r}=o,n=m[t];if(o.hidden||!n)mt(r,p);else {const{x:t,y:i,z:o,angle:s}=n;for(let n=0;n<r;n++)e.addDynamicAttributes(p,t,i,o,s);}}t.icon.dynamicLayoutVertexBuffer.updateData(p);}t.text.dynamicLayoutVertexBuffer.updateData(d);}function mo(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function fo(t,i,o,r,n,s,a,l,c,h,u,_){const d=t.context,p=d.gl,m=t.transform,f="map"===l,g="map"===c,v=f&&"point"!==o.layout.get("symbol-placement"),x=f&&!g&&!v,y=void 0!==o.layout.get("symbol-sort-key").constantOr(1);let b=!1;const w=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),T=[e.mercatorXfromLng(m.center.lng),e.mercatorYfromLat(m.center.lat)],E=o.layout.get("text-variable-anchor"),C="globe"===m.projection.name,M=[],I=[0,-1,0];let S=I;!C&&!m.mercatorFromTransition||f||(S=function(t){const i=t._camera.getWorldToCamera(t.worldSize,1),o=e.multiply([],i,t.globeMatrix);e.invert(o,o);const r=[0,0,0],n=[0,1,0,0];return e.transformMat4$1(n,n,o),r[0]=n[0],r[1]=n[1],r[2]=n[2],e.normalize(r,r),r}(m));for(const l of r){const r=i.getTile(l),c=r.getBucket(o);if(!c)continue;if("mercator"===c.projection.name&&C)continue;const u=n?c.text:c.icon;if(!u||c.fullyClipped||!u.segments.get().length)continue;const _=u.programConfigurations.get(o.id),d=n||c.sdfIcons,w=n?c.textSizeData:c.iconSizeData,D=g||0!==m.pitch,L=e.evaluateSizeForZoom(w,m.zoom);let A,z,P,R,O=[0,0],B=null;if(n){if(z=r.glyphAtlasTexture,P=p.LINEAR,A=r.glyphAtlasTexture.size,c.iconsInText){O=r.imageAtlasTexture.size,B=r.imageAtlasTexture;const e="composite"===w.kind||"camera"===w.kind;R=D||t.options.rotating||t.options.zooming||e?p.LINEAR:p.NEAREST;}}else {const e=1!==o.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;z=r.imageAtlasTexture,P=d||t.options.rotating||t.options.zooming||e||D?p.LINEAR:p.NEAREST,A=r.imageAtlasTexture.size;}const k="globe"===c.projection.name,F=k?S:I,U=k?e.globeToMercatorTransition(m.zoom):0,N=bt(l,c.getProjection(),m),G=m.calculatePixelsToTileUnitsMatrix(r),j=it(N,r.tileID.canonical,g,f,m,c.getProjection(),G),Z=t.terrain&&g&&v?e.invert(e.create(),j):uo,V=rt(N,r.tileID.canonical,g,f,m,c.getProjection(),G),W=E&&c.hasTextData(),X="none"!==o.layout.get("icon-text-fit")&&W&&c.hasIconData();if(v){const e=m.elevation,i=e?e.getAtTileOffsetFunc(l,m.center.lat,m.worldSize,c.getProjection()):null,o=ot(N,r.tileID.canonical,g,f,m,c.getProjection(),G);lt(c,N,t,n,o,V,g,h,i,l);}const q=v||n&&E||X,$=t.translatePosMatrix(N,r,s,a),H=q?uo:j,Y=t.translatePosMatrix(V,r,s,a,!0),K=c.getProjection().createInversionMatrix(m,l.canonical),J=[];t.terrainRenderModeElevated()&&g&&J.push("PITCH_WITH_MAP_TERRAIN"),k&&J.push("PROJECTION_GLOBE_VIEW"),q&&J.push("PROJECTED_POS_ON_VIEWPORT");const Q=d&&0!==o.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let ee;ee=d?c.iconsInText?no(w.kind,L,x,g,t,$,H,Y,A,O,l,U,T,K,F,c.getProjection()):ro(w.kind,L,x,g,t,$,H,Y,n,A,!0,l,U,T,K,F,c.getProjection()):oo(w.kind,L,x,g,t,$,H,Y,n,A,l,U,T,K,F,c.getProjection());const te={program:t.useProgram(mo(d,n,c),_,J),buffers:u,uniformValues:ee,atlasTexture:z,atlasTextureIcon:B,atlasInterpolation:P,atlasInterpolationIcon:R,isSDF:d,hasHalo:Q,tile:r,labelPlaneMatrixInv:Z};if(y&&c.canOverlap){b=!0;const t=u.segments.get();for(const i of t)M.push({segments:new e.SegmentVector([i]),sortKey:i.sortKey,state:te});}else M.push({segments:u.segments,sortKey:0,state:te});}b&&M.sort(((e,t)=>e.sortKey-t.sortKey));for(const e of M){const i=e.state;if(t.terrain&&t.terrain.setupElevationDraw(i.tile,i.program,{useDepthForOcclusion:!C,labelPlaneMatrixInv:i.labelPlaneMatrixInv}),d.activeTexture.set(p.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,p.CLAMP_TO_EDGE),i.atlasTextureIcon&&(d.activeTexture.set(p.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,p.CLAMP_TO_EDGE)),i.isSDF){const r=i.uniformValues;i.hasHalo&&(r.u_is_halo=1,go(i.buffers,e.segments,o,t,i.program,w,u,_,r)),r.u_is_halo=0;}go(i.buffers,e.segments,o,t,i.program,w,u,_,i.uniformValues);}}function go(t,i,o,r,n,s,a,l,c){const h=r.context,u=[t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer,t.globeExtVertexBuffer];n.draw(h,h.gl.TRIANGLES,s,a,l,e.CullFaceMode.disabled,c,o.id,t.layoutVertexBuffer,t.indexBuffer,i,o.paint,r.transform.zoom,t.programConfigurations.get(o.id),u);}function vo(t,i,o,r,n,s,a){const l=t.context.gl,c=o.paint.get("fill-pattern"),h=c&&c.constantOr(1);let u,_,d,p,m;a?(_=h&&!o.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",u=l.LINES):(_=h?"fillPattern":"fill",u=l.TRIANGLES);for(const f of r){const r=i.getTile(f);if(h&&!r.patternsLoaded())continue;const g=r.getBucket(o);if(!g)continue;t.prepareDrawTile();const v=g.programConfigurations.get(o.id),x=t.useProgram(_,v);h&&(t.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),v.updatePaintBuffers());const y=c.constantOr(null);if(y&&r.imageAtlas){const e=r.imageAtlas.patternPositions[y.toString()];e&&v.setConstantPatternPositions(e);}const b=t.translatePosMatrix(f.projMatrix,r,o.paint.get("fill-translate"),o.paint.get("fill-translate-anchor"));if(a){p=g.indexBuffer2,m=g.segments2;const e=t.terrain&&t.terrain.renderingToTexture?t.terrain.drapeBufferSize:[l.drawingBufferWidth,l.drawingBufferHeight];d="fillOutlinePattern"===_&&h?Gi(b,t,r,e):Ni(b,e);}else p=g.indexBuffer,m=g.segments,d=h?Ui(b,t,r):Fi(b);t.prepareDrawProgram(t.context,x,f.toUnwrapped()),x.draw(t.context,u,n,t.stencilModeForClipping(f),s,e.CullFaceMode.disabled,d,o.id,g.layoutVertexBuffer,p,m,o.paint,t.transform.zoom,v);}}function xo(t,i,o,r,n,s,a){const l=t.context,c=l.gl,h=t.transform,u=o.paint.get("fill-extrusion-pattern"),_=u.constantOr(1),d=o.paint.get("fill-extrusion-opacity"),p=[o.paint.get("fill-extrusion-ambient-occlusion-intensity"),o.paint.get("fill-extrusion-ambient-occlusion-radius")],m=o.layout.get("fill-extrusion-edge-radius"),f="globe"===h.projection.name?e.fillExtrusionHeightLift():0,g="globe"===h.projection.name,v=g?e.globeToMercatorTransition(h.zoom):0,x=[e.mercatorXfromLng(h.center.lng),e.mercatorYfromLat(h.center.lat)],y=[];g&&y.push("PROJECTION_GLOBE_VIEW"),p[0]>0&&y.push("FAUX_AO");for(const b of r){const r=i.getTile(b),w=r.getBucket(o);if(!w||w.projection.name!==h.projection.name)continue;const T=w.programConfigurations.get(o.id),E=t.useProgram(_?"fillExtrusionPattern":"fillExtrusion",T,y);if(t.terrain){const e=t.terrain;if(t.style.terrainSetForDrapingOnly())e.setupElevationDraw(r,E,{useMeterToDem:!0});else {if(!w.enableTerrain)continue;if(e.setupElevationDraw(r,E,{useMeterToDem:!0}),yo(l,i,b,w,o,e),!w.centroidVertexBuffer){const e=E.attributes.a_centroid_pos;void 0!==e&&c.vertexAttrib2f(e,0,0);}}}_&&(t.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),T.updatePaintBuffers());const C=u.constantOr(null);if(C&&r.imageAtlas){const e=r.imageAtlas.patternPositions[C.toString()];e&&T.setConstantPatternPositions(e);}const M=t.translatePosMatrix(b.projMatrix,r,o.paint.get("fill-extrusion-translate"),o.paint.get("fill-extrusion-translate-anchor")),I=h.projection.createInversionMatrix(h,b.canonical),S=o.paint.get("fill-extrusion-vertical-gradient"),D=_?ki(M,t,S,d,p,m,b,r,f,v,x,I):Bi(M,t,S,d,p,m,b,f,v,x,I);t.prepareDrawProgram(l,E,b.toUnwrapped());const L=[];t.terrain&&L.push(w.centroidVertexBuffer),g&&L.push(w.layoutVertexExtBuffer),E.draw(l,l.gl.TRIANGLES,n,s,a,e.CullFaceMode.backCCW,D,o.id,w.layoutVertexBuffer,w.indexBuffer,w.segments,o.paint,t.transform.zoom,T,L);}}function yo(t,i,o,r,n,s){const a=[t=>{let i=t.canonical.x-1,o=t.wrap;return i<0&&(i=(1<<t.canonical.z)-1,o--),new e.OverscaledTileID(t.overscaledZ,o,t.canonical.z,i,t.canonical.y)},t=>{let i=t.canonical.x+1,o=t.wrap;return i===1<<t.canonical.z&&(i=0,o++),new e.OverscaledTileID(t.overscaledZ,o,t.canonical.z,i,t.canonical.y)},t=>new e.OverscaledTileID(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new e.OverscaledTileID(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)],l=e=>{const t=i.getSource().minzoom,o=e=>{const t=i.getTileByID(e);if(t&&t.hasData())return t.getBucket(n)},r=[0,-1,1];for(const i of r){if(e.overscaledZ+i<t)continue;const r=o(e.calculateScaledKey(e.overscaledZ+i));if(r)return r}},c=[0,0,0],h=(t,i)=>(c[0]=Math.min(t.min.y,i.min.y),c[1]=Math.max(t.max.y,i.max.y),c[2]=e.EXTENT-i.min.x>t.max.x?i.min.x-e.EXTENT:t.max.x,c),u=(t,i)=>(c[0]=Math.min(t.min.x,i.min.x),c[1]=Math.max(t.max.x,i.max.x),c[2]=e.EXTENT-i.min.y>t.max.y?i.min.y-e.EXTENT:t.max.y,c),_=[(e,t)=>h(e,t),(e,t)=>h(t,e),(e,t)=>u(e,t),(e,t)=>u(t,e)],d=new e.pointGeometry(0,0);let p,m,f;const g=(t,i,r,n,a)=>{const l=[[n?r:t,n?t:r,0],[n?r:i,n?i:r,0]],c=a<0?e.EXTENT+a:a,h=[n?c:(t+i)/2,n?(t+i)/2:c,0];return 0===r&&a<0||0!==r&&a>0?s.getForTilePoints(f,[h],!0,m):l.push(h),s.getForTilePoints(o,l,!0,p),Math.max(l[0][2],l[1][2],h[2])/s.exaggeration()};for(let t=0;t<4;t++){const i=(t<2?1:5)-t,n=r.borders[t];if(0===n.length)continue;const c=f=a[t](o),h=l(c);if(!(h&&h instanceof e.FillExtrusionBucket&&h.enableTerrain))continue;if(r.borderDoneWithNeighborZ[t]===h.canonical.z&&h.borderDoneWithNeighborZ[i]===r.canonical.z)continue;if(m=s.findDEMTileFor(c),!m||!m.dem)continue;if(!p){const e=s.findDEMTileFor(o);if(!e||!e.dem)return;p=e;}const u=h.borders[i];let v=0;const x=h.borderDoneWithNeighborZ[i]!==r.canonical.z;if(r.canonical.z===h.canonical.z){for(let o=0;o<n.length;o++){const s=r.featuresOnBorder[n[o]],a=s.borders[t];let l;for(;v<u.length&&(l=h.featuresOnBorder[u[v]],!(l.borders[i][1]>a[0]+3));)x&&h.encodeCentroid(void 0,l,!1),v++;if(l&&v<u.length){const o=v;let n=0;for(;!(l.borders[i][0]>a[1]-3)&&(n++,++v!==u.length);)l=h.featuresOnBorder[u[v]];if(l=h.featuresOnBorder[u[o]],s.intersectsCount()>1||l.intersectsCount()>1||1!==n){1!==n&&(v=o),r.encodeCentroid(void 0,s,!1),x&&h.encodeCentroid(void 0,l,!1);continue}const c=_[t](s,l),p=t%2?e.EXTENT-1:0;d.x=g(c[0],Math.min(e.EXTENT-1,c[1]),p,t<2,c[2]),d.y=0,r.encodeCentroid(d,s,!1),x&&h.encodeCentroid(d,l,!1);}else r.encodeCentroid(void 0,s,!1);}r.borderDoneWithNeighborZ[t]=h.canonical.z,r.needsCentroidUpdate=!0,x&&(h.borderDoneWithNeighborZ[i]=r.canonical.z,h.needsCentroidUpdate=!0);}else {for(const e of n)r.encodeCentroid(void 0,r.featuresOnBorder[e],!1);if(x){for(const e of u)h.encodeCentroid(void 0,h.featuresOnBorder[e],!1);h.borderDoneWithNeighborZ[i]=r.canonical.z,h.needsCentroidUpdate=!0;}r.borderDoneWithNeighborZ[t]=h.canonical.z,r.needsCentroidUpdate=!0;}}(r.needsCentroidUpdate||!r.centroidVertexBuffer&&0!==r.centroidVertexArray.length)&&r.uploadCentroid(t);}const bo=new e.Color(1,0,0,1),wo=new e.Color(0,1,0,1),To=new e.Color(0,0,1,1),Eo=new e.Color(1,0,1,1),Co=new e.Color(0,1,1,1);function Mo(t,i,o){const r=t.context,n=t.transform,s=r.gl,a="globe"===n.projection.name,l=a?["PROJECTION_GLOBE_VIEW"]:null;let c=o.projMatrix;if(a&&e.globeToMercatorTransition(n.zoom)>0){const t=e.transitionTileAABBinECEF(o.canonical,n),i=e.globeDenormalizeECEF(t);c=e.multiply(new Float32Array(16),n.globeMatrix,i),e.multiply(c,n.projMatrix,c);}const h=t.useProgram("debug",null,l),u=i.getTileByID(o.key);t.terrain&&t.terrain.setupElevationDraw(u,h);const _=e.DepthMode.disabled,d=e.StencilMode.disabled,p=t.colorModeForRenderPass(),m="$debug";r.activeTexture.set(s.TEXTURE0),t.emptyTexture.bind(s.LINEAR,s.CLAMP_TO_EDGE),a?u._makeGlobeTileDebugBuffers(t.context,n):u._makeDebugTileBoundsBuffers(t.context,n.projection);const f=u._tileDebugBuffer||t.debugBuffer,g=u._tileDebugIndexBuffer||t.debugIndexBuffer,v=u._tileDebugSegments||t.debugSegments;h.draw(r,s.LINE_STRIP,_,d,p,e.CullFaceMode.disabled,Xi(c,e.Color.red),m,f,g,v,null,null,null,[u._globeTileDebugBorderBuffer]);const x=u.latestRawTileData,y=Math.floor((x&&x.byteLength||0)/1024),b=i.getTile(o).tileSize,w=512/Math.min(b,512)*(o.overscaledZ/n.zoom)*.5;let T=o.canonical.toString();o.overscaledZ!==o.canonical.z&&(T+=` => ${o.overscaledZ}`),T+=` ${y}kb`,function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,o=e.context.gl,r=e.debugOverlayCanvas.getContext("2d");r.clearRect(0,0,i.width,i.height),r.shadowColor="white",r.shadowBlur=2,r.lineWidth=1.5,r.strokeStyle="white",r.textBaseline="top",r.font="bold 36px Open Sans, sans-serif",r.fillText(t,5,5),r.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE);}(t,T);const E=u._tileDebugTextBuffer||t.debugBuffer,C=u._tileDebugTextIndexBuffer||t.quadTriangleIndexBuffer,M=u._tileDebugTextSegments||t.debugSegments;h.draw(r,s.TRIANGLES,_,d,e.ColorMode.alphaBlended,e.CullFaceMode.disabled,Xi(c,e.Color.transparent,w),m,E,C,M,null,null,null,[u._globeTileDebugTextBuffer]);}function Io(e,t,i,o){Do(e,0,t+i/2,e.transform.width,i,o);}function So(e,t,i,o){Do(e,t-i/2,0,i,e.transform.height,o);}function Do(t,i,o,r,n,s){const a=t.context,l=a.gl;l.enable(l.SCISSOR_TEST),l.scissor(i*e.exported.devicePixelRatio,o*e.exported.devicePixelRatio,r*e.exported.devicePixelRatio,n*e.exported.devicePixelRatio),a.clear({color:s}),l.disable(l.SCISSOR_TEST);}const Lo=e.createLayout([{name:"a_pos_3f",components:3,type:"Float32"}]),{members:Ao}=Lo;function zo(e,t,i,o){e.emplaceBack(t,i,o);}class Po{constructor(t){this.vertexArray=new e.StructArrayLayout3f12,this.indices=new e.StructArrayLayout3ui6,zo(this.vertexArray,-1,-1,1),zo(this.vertexArray,1,-1,1),zo(this.vertexArray,-1,1,1),zo(this.vertexArray,1,1,1),zo(this.vertexArray,-1,-1,-1),zo(this.vertexArray,1,-1,-1),zo(this.vertexArray,-1,1,-1),zo(this.vertexArray,1,1,-1),this.indices.emplaceBack(5,1,3),this.indices.emplaceBack(3,7,5),this.indices.emplaceBack(6,2,0),this.indices.emplaceBack(0,4,6),this.indices.emplaceBack(2,6,7),this.indices.emplaceBack(7,3,2),this.indices.emplaceBack(5,4,0),this.indices.emplaceBack(0,1,5),this.indices.emplaceBack(0,2,3),this.indices.emplaceBack(3,1,0),this.indices.emplaceBack(7,6,4),this.indices.emplaceBack(4,5,7),this.vertexBuffer=t.createVertexBuffer(this.vertexArray,Ao),this.indexBuffer=t.createIndexBuffer(this.indices),this.segment=e.SegmentVector.simpleSegment(0,0,36,12);}}function Ro(t,i,o,r,n,s){const a=t.gl,l=i.paint.get("sky-atmosphere-color"),c=i.paint.get("sky-atmosphere-halo-color"),h=i.paint.get("sky-atmosphere-sun-intensity"),u=((e,t,i,o,r)=>({u_matrix_3f:e,u_sun_direction:t,u_sun_intensity:i,u_color_tint_r:[o.r,o.g,o.b,o.a],u_color_tint_m:[r.r,r.g,r.b,r.a],u_luminance:5e-5}))(e.fromMat4(e.create$1(),r),n,h,l,c);a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_POSITIVE_X+s,i.skyboxTexture,0),o.draw(t,a.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,e.ColorMode.unblended,e.CullFaceMode.frontCW,u,"skyboxCapture",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}const Oo=e.createLayout([{type:"Float32",name:"a_pos",components:3},{type:"Float32",name:"a_uv",components:2}]);class Bo{constructor(t){const i=new e.StructArrayLayout5f20;i.emplaceBack(-1,1,1,0,0),i.emplaceBack(1,1,1,1,0),i.emplaceBack(1,-1,1,1,1),i.emplaceBack(-1,-1,1,0,1);const o=new e.StructArrayLayout3ui6;o.emplaceBack(0,1,2),o.emplaceBack(2,3,0),this.vertexBuffer=t.createVertexBuffer(i,Oo.members),this.indexBuffer=t.createIndexBuffer(o),this.segments=e.SegmentVector.simpleSegment(0,0,4,2);}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy();}}const ko={symbol:function(t,i,o,r,n){if("translucent"!==t.renderPass)return;const s=e.StencilMode.disabled,a=t.colorModeForRenderPass();o.layout.get("text-variable-anchor")&&function(t,i,o,r,n,s,a){const l=i.transform,c="map"===n,h="map"===s;for(const i of t){const t=r.getTile(i),n=t.getBucket(o);if(!n||!n.text||!n.text.segments.get().length)continue;const s=e.evaluateSizeForZoom(n.textSizeData,l.zoom),u=bt(i,n.getProjection(),l),_=l.calculatePixelsToTileUnitsMatrix(t),d=it(u,t.tileID.canonical,h,c,l,n.getProjection(),_),p="none"!==o.layout.get("icon-text-fit")&&n.hasIconData();if(s){const o=Math.pow(2,l.zoom-t.tileID.overscaledZ);po(n,c,h,a,e.symbolSize,l,d,i,o,s,p);}}}(r,t,o,i,o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),n),0!==o.paint.get("icon-opacity").constantOr(1)&&fo(t,i,o,r,!1,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),o.layout.get("icon-rotation-alignment"),o.layout.get("icon-pitch-alignment"),o.layout.get("icon-keep-upright"),s,a),0!==o.paint.get("text-opacity").constantOr(1)&&fo(t,i,o,r,!0,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),o.layout.get("text-keep-upright"),s,a),i.map.showCollisionBoxes&&(ho(t,i,o,r,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),!0),ho(t,i,o,r,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),!1));},circle:function(t,i,o,r){if("translucent"!==t.renderPass)return;const n=o.paint.get("circle-opacity"),s=o.paint.get("circle-stroke-width"),a=o.paint.get("circle-stroke-opacity"),l=void 0!==o.layout.get("circle-sort-key").constantOr(1);if(0===n.constantOr(1)&&(0===s.constantOr(1)||0===a.constantOr(1)))return;const c=t.context,h=c.gl,u=t.transform,_=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),d=e.StencilMode.disabled,p=t.colorModeForRenderPass(),m="globe"===u.projection.name,f=[e.mercatorXfromLng(u.center.lng),e.mercatorYfromLat(u.center.lat)],g=[];for(let n=0;n<r.length;n++){const s=r[n],a=i.getTile(s),c=a.getBucket(o);if(!c||c.projection.name!==u.projection.name)continue;const h=c.programConfigurations.get(o.id),_=Vi(o);m&&_.push("PROJECTION_GLOBE_VIEW");const d=t.useProgram("circle",h,_),p=c.layoutVertexBuffer,v=c.globeExtVertexBuffer,x=c.indexBuffer,y=u.projection.createInversionMatrix(u,s.canonical),b={programConfiguration:h,program:d,layoutVertexBuffer:p,globeExtVertexBuffer:v,indexBuffer:x,uniformValues:Zi(t,s,a,y,f,o),tile:a};if(l){const t=c.segments.get();for(const i of t)g.push({segments:new e.SegmentVector([i]),sortKey:i.sortKey,state:b});}else g.push({segments:c.segments,sortKey:0,state:b});}l&&g.sort(((e,t)=>e.sortKey-t.sortKey));const v={useDepthForOcclusion:!m};for(const i of g){const{programConfiguration:r,program:n,layoutVertexBuffer:s,globeExtVertexBuffer:a,indexBuffer:l,uniformValues:m,tile:f}=i.state,g=i.segments;t.terrain&&t.terrain.setupElevationDraw(f,n,v),t.prepareDrawProgram(c,n,f.tileID.toUnwrapped()),n.draw(c,h.TRIANGLES,_,d,p,e.CullFaceMode.disabled,m,o.id,s,l,g,o.paint,u.zoom,r,[a]);}},heatmap:function(t,i,o,r){if(0!==o.paint.get("heatmap-opacity"))if("offscreen"===t.renderPass){const n=t.context,s=n.gl,a=e.StencilMode.disabled,l=new e.ColorMode([s.ONE,s.ONE],e.Color.transparent,[!0,!0,!0,!0]);!function(e,t,i,o){const r=e.gl,n=t.width*o,s=t.height*o;e.activeTexture.set(r.TEXTURE1),e.viewport.set([0,0,n,s]);let a=i.heatmapFbo;if(!a||a&&(a.width!==n||a.height!==s)){a&&a.destroy();const t=r.createTexture();r.bindTexture(r.TEXTURE_2D,t),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,r.CLAMP_TO_EDGE),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,r.CLAMP_TO_EDGE),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.LINEAR),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.LINEAR),a=i.heatmapFbo=e.createFramebuffer(n,s,!1),function(e,t,i,o,r,n){const s=e.gl;s.texImage2D(s.TEXTURE_2D,0,e.isWebGL2&&e.extRenderToTextureHalfFloat?s.RGBA16F:s.RGBA,r,n,0,s.RGBA,e.extRenderToTextureHalfFloat?e.isWebGL2?s.HALF_FLOAT:e.extTextureHalfFloat.HALF_FLOAT_OES:s.UNSIGNED_BYTE,null),o.colorAttachment.set(i);}(e,0,t,a,n,s);}else r.bindTexture(r.TEXTURE_2D,a.colorAttachment.get()),e.bindFramebuffer.set(a.framebuffer);}(n,t,o,"globe"===t.transform.projection.name?.5:.25),n.clear({color:e.Color.transparent});const c=t.transform,h="globe"===c.projection.name,u=h?["PROJECTION_GLOBE_VIEW"]:null,_=h?e.CullFaceMode.frontCCW:e.CullFaceMode.disabled,d=[e.mercatorXfromLng(c.center.lng),e.mercatorYfromLat(c.center.lat)];for(let p=0;p<r.length;p++){const m=r[p];if(i.hasRenderableParent(m))continue;const f=i.getTile(m),g=f.getBucket(o);if(!g||g.projection.name!==c.projection.name)continue;const v=g.programConfigurations.get(o.id),x=t.useProgram("heatmap",v,u),{zoom:y}=t.transform;t.terrain&&t.terrain.setupElevationDraw(f,x),t.prepareDrawProgram(n,x,m.toUnwrapped());const b=c.projection.createInversionMatrix(c,m.canonical);x.draw(n,s.TRIANGLES,e.DepthMode.disabled,a,l,_,$i(t,m,f,b,d,y,o.paint.get("heatmap-intensity")),o.id,g.layoutVertexBuffer,g.indexBuffer,g.segments,o.paint,t.transform.zoom,v,h?[g.globeExtVertexBuffer]:null);}n.viewport.set([0,0,t.width,t.height]);}else "translucent"===t.renderPass&&(t.context.setColorMode(t.colorModeForRenderPass()),function(t,i){const o=t.context,r=o.gl,n=i.heatmapFbo;if(!n)return;o.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),o.activeTexture.set(r.TEXTURE1);let s=i.colorRampTexture;s||(s=i.colorRampTexture=new e.Texture(o,i.colorRamp,r.RGBA)),s.bind(r.LINEAR,r.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(o,r.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,((e,t,i,o)=>({u_image:0,u_color_ramp:1,u_opacity:t.paint.get("heatmap-opacity")}))(0,i),i.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,i.paint,t.transform.zoom);}(t,o));},line:function(t,i,o,r){if("translucent"!==t.renderPass)return;const n=o.paint.get("line-opacity"),s=o.paint.get("line-width");if(0===n.constantOr(1)||0===s.constantOr(1))return;const a=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),l=t.colorModeForRenderPass(),c=t.terrain&&t.terrain.renderingToTexture?1:e.exported.devicePixelRatio,h=o.paint.get("line-dasharray"),u=h.constantOr(1),_=o.layout.get("line-cap"),d=o.paint.get("line-pattern"),p=d.constantOr(1),m=o.paint.get("line-gradient"),f=p?"linePattern":"line",g=t.context,v=g.gl,x=(e=>{const t=[];Qi(e)&&t.push("RENDER_LINE_DASH"),e.paint.get("line-gradient")&&t.push("RENDER_LINE_GRADIENT");const i=e.paint.get("line-trim-offset");0===i[0]&&0===i[1]||t.push("RENDER_LINE_TRIM_OFFSET");const o=e.paint.get("line-pattern").constantOr(1),r=1!==e.paint.get("line-opacity").constantOr(1);return !o&&r&&t.push("RENDER_LINE_ALPHA_DISCARD"),t})(o);let y=x.includes("RENDER_LINE_ALPHA_DISCARD");t.terrain&&t.terrain.clipOrMaskOverlapStencilType()&&(y=!1);for(const n of r){const r=i.getTile(n);if(p&&!r.patternsLoaded())continue;const s=r.getBucket(o);if(!s)continue;t.prepareDrawTile();const b=s.programConfigurations.get(o.id),w=t.useProgram(f,b,x),T=d.constantOr(null);if(T&&r.imageAtlas){const e=r.imageAtlas.patternPositions[T.toString()];e&&b.setConstantPatternPositions(e);}const E=h.constantOr(null),C=_.constantOr(null);if(!p&&E&&C&&r.lineAtlas){const e=r.lineAtlas.getDash(E,C);e&&b.setConstantPatternPositions(e);}let[M,I]=o.paint.get("line-trim-offset");if("round"===C||"square"===C){const e=1;M!==I&&(0===M&&(M-=e),1===I&&(I+=e));}const S=t.terrain?n.projMatrix:null,D=p?Yi(t,r,o,S,c):Hi(t,r,o,S,s.lineClipsArray.length,c,[M,I]);if(m){const r=s.gradients[o.id];let a=r.texture;if(o.gradientVersion!==r.version){let l=256;if(o.stepInterpolant){const o=i.getSource().maxzoom,r=n.canonical.z===o?Math.ceil(1<<t.transform.maxZoom-n.canonical.z):1;l=e.clamp(e.nextPowerOfTwo(s.maxLineLength/e.EXTENT*1024*r),256,g.maxTextureSize);}r.gradient=e.renderColorRamp({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:r.gradient||void 0,clips:s.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new e.Texture(g,r.gradient,v.RGBA),r.version=o.gradientVersion,a=r.texture;}g.activeTexture.set(v.TEXTURE1),a.bind(o.stepInterpolant?v.NEAREST:v.LINEAR,v.CLAMP_TO_EDGE);}u&&(g.activeTexture.set(v.TEXTURE0),r.lineAtlasTexture.bind(v.LINEAR,v.REPEAT),b.updatePaintBuffers()),p&&(g.activeTexture.set(v.TEXTURE0),r.imageAtlasTexture.bind(v.LINEAR,v.CLAMP_TO_EDGE),b.updatePaintBuffers()),t.prepareDrawProgram(g,w,n.toUnwrapped());const L=i=>{w.draw(g,v.TRIANGLES,a,i,l,e.CullFaceMode.disabled,D,o.id,s.layoutVertexBuffer,s.indexBuffer,s.segments,o.paint,t.transform.zoom,b,[s.layoutVertexBuffer2]);};if(y){const i=t.stencilModeForClipping(n).ref;0===i&&t.terrain&&g.clear({stencil:0});const o={func:v.EQUAL,mask:255};D.u_alpha_discard_threshold=.8,L(new e.StencilMode(o,i,255,v.KEEP,v.KEEP,v.INVERT)),D.u_alpha_discard_threshold=0,L(new e.StencilMode(o,i,255,v.KEEP,v.KEEP,v.KEEP));}else L(t.stencilModeForClipping(n));}y&&(t.resetStencilClippingMasks(),t.terrain&&g.clear({stencil:0}));},fill:function(t,i,o,r){const n=o.paint.get("fill-color"),s=o.paint.get("fill-opacity");if(0===s.constantOr(1))return;const a=t.colorModeForRenderPass(),l=o.paint.get("fill-pattern"),c=t.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===n.constantOr(e.Color.transparent).a&&1===s.constantOr(0)?"opaque":"translucent";if(t.renderPass===c){const n=t.depthModeForSublayer(1,"opaque"===t.renderPass?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly);vo(t,i,o,r,n,a,!1);}if("translucent"===t.renderPass&&o.paint.get("fill-antialias")){const n=t.depthModeForSublayer(o.getPaintProperty("fill-outline-color")?2:0,e.DepthMode.ReadOnly);vo(t,i,o,r,n,a,!0);}},"fill-extrusion":function(t,i,o,r){const n=o.paint.get("fill-extrusion-opacity");if(0!==n&&"translucent"===t.renderPass){const s=new e.DepthMode(t.context.gl.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);if(1!==n||o.paint.get("fill-extrusion-pattern").constantOr(1))xo(t,i,o,r,s,e.StencilMode.disabled,e.ColorMode.disabled),xo(t,i,o,r,s,t.stencilModeFor3D(),t.colorModeForRenderPass()),t.resetStencilClippingMasks();else {const n=t.colorModeForRenderPass();xo(t,i,o,r,s,e.StencilMode.disabled,n);}}},hillshade:function(t,i,o,r){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const n=t.context,s=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),a=t.colorModeForRenderPass(),l=t.terrain&&t.terrain.renderingToTexture,[c,h]="translucent"!==t.renderPass||l?[{},r]:t.stencilConfigForOverlap(r);for(const r of h){const n=i.getTile(r);if(n.needsHillshadePrepare&&"offscreen"===t.renderPass)vi(t,n,o,s,e.StencilMode.disabled,a);else if("translucent"===t.renderPass){const e=l&&t.terrain?t.terrain.stencilModeForRTTOverlap(r):c[r.overscaledZ];fi(t,r,n,o,s,e,a);}}n.viewport.set([0,0,t.width,t.height]),t.resetStencilClippingMasks();},raster:function(t,i,o,r,n,s){if("translucent"!==t.renderPass)return;if(0===o.paint.get("raster-opacity"))return;if(!r.length)return;const a=t.context,l=a.gl,c=i.getSource(),h=t.useProgram("raster"),u=t.colorModeForRenderPass(),_=t.terrain&&t.terrain.renderingToTexture,[d,p]=c instanceof Ae||_?[{},r]:t.stencilConfigForOverlap(r),m=p[p.length-1].overscaledZ,f=!t.options.moving;for(const r of p){const n=_?e.DepthMode.disabled:t.depthModeForSublayer(r.overscaledZ-m,1===o.paint.get("raster-opacity")?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly,l.LESS),p=r.toUnwrapped(),g=i.getTile(r);if(_&&(!g||!g.hasData()))continue;const v=_?r.projMatrix:t.transform.calculateProjMatrix(p,f),x=t.terrain&&_?t.terrain.stencilModeForRTTOverlap(r):d[r.overscaledZ],y=s?0:o.paint.get("raster-fade-duration");g.registerFadeDuration(y);const b=i.findLoadedParent(r,0),w=Si(g,b,i,t.transform,y);let T,E;t.terrain&&t.terrain.prepareDrawTile();const C="nearest"===o.paint.get("raster-resampling")?l.NEAREST:l.LINEAR;a.activeTexture.set(l.TEXTURE0),g.texture.bind(C,l.CLAMP_TO_EDGE),a.activeTexture.set(l.TEXTURE1),b?(b.texture.bind(C,l.CLAMP_TO_EDGE),T=Math.pow(2,b.tileID.overscaledZ-g.tileID.overscaledZ),E=[g.tileID.canonical.x*T%1,g.tileID.canonical.y*T%1]):g.texture.bind(C,l.CLAMP_TO_EDGE),g.texture.useMipmap&&a.extTextureFilterAnisotropic&&t.transform.pitch>20&&l.texParameterf(l.TEXTURE_2D,a.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,a.extTextureFilterAnisotropicMax);const M=eo(v,E||[0,0],T||1,w,o,c instanceof Ae?c.perspectiveTransform:[0,0]);if(t.prepareDrawProgram(a,h,p),c instanceof Ae)c.boundsBuffer&&c.boundsSegments&&h.draw(a,l.TRIANGLES,n,e.StencilMode.disabled,u,e.CullFaceMode.disabled,M,o.id,c.boundsBuffer,t.quadTriangleIndexBuffer,c.boundsSegments);else {const{tileBoundsBuffer:i,tileBoundsIndexBuffer:r,tileBoundsSegments:s}=t.getTileBoundsBuffers(g);h.draw(a,l.TRIANGLES,n,x,u,e.CullFaceMode.disabled,M,o.id,i,r,s);}}t.resetStencilClippingMasks();},background:function(t,i,o,r){const n=o.paint.get("background-color"),s=o.paint.get("background-opacity");if(0===s)return;const a=t.context,l=a.gl,c=t.transform,h=c.tileSize,u=o.paint.get("background-pattern");if(t.isPatternMissing(u))return;const _=!u&&1===n.a&&1===s&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==_)return;const d=e.StencilMode.disabled,p=t.depthModeForSublayer(0,"opaque"===_?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly),m=t.colorModeForRenderPass(),f=t.useProgram(u?"backgroundPattern":"background");let g,v=r;v||(g=t.getBackgroundTiles(),v=Object.values(g).map((e=>e.tileID))),u&&(a.activeTexture.set(l.TEXTURE0),t.imageManager.bind(t.context));for(const _ of v){const v=_.toUnwrapped(),x=r?_.projMatrix:t.transform.calculateProjMatrix(v);t.prepareDrawTile();const y=i?i.getTile(_):g?g[_.key]:new e.Tile(_,h,c.zoom,t),b=u?ao(x,s,t,u,{tileID:_,tileSize:h}):so(x,s,n);t.prepareDrawProgram(a,f,v);const{tileBoundsBuffer:w,tileBoundsIndexBuffer:T,tileBoundsSegments:E}=t.getTileBoundsBuffers(y);f.draw(a,l.TRIANGLES,p,d,m,e.CullFaceMode.disabled,b,o.id,w,T,E);}},sky:function(t,i,o){const r=t.transform,n="mercator"===r.projection.name||"globe"===r.projection.name?1:e.smoothstep(7,8,r.zoom),s=o.paint.get("sky-opacity")*n;if(0===s)return;const a=t.context,l=o.paint.get("sky-type"),c=new e.DepthMode(a.gl.LEQUAL,e.DepthMode.ReadOnly,[0,1]),h=t.frameCounter/1e3%1;"atmosphere"===l?"offscreen"===t.renderPass?o.needsSkyboxCapture(t)&&(function(t,i,o,r){const n=t.context,s=n.gl;let a=i.skyboxFbo;if(!a){a=i.skyboxFbo=n.createFramebuffer(32,32,!1),i.skyboxGeometry=new Po(n),i.skyboxTexture=n.gl.createTexture(),s.bindTexture(s.TEXTURE_CUBE_MAP,i.skyboxTexture),s.texParameteri(s.TEXTURE_CUBE_MAP,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_CUBE_MAP,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_CUBE_MAP,s.TEXTURE_MIN_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_CUBE_MAP,s.TEXTURE_MAG_FILTER,s.LINEAR);for(let e=0;e<6;++e)s.texImage2D(s.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,s.RGBA,32,32,0,s.RGBA,s.UNSIGNED_BYTE,null);}n.bindFramebuffer.set(a.framebuffer),n.viewport.set([0,0,32,32]);const l=i.getCenter(t,!0),c=t.useProgram("skyboxCapture"),h=new Float64Array(16);e.identity(h),e.rotateY(h,h,.5*-Math.PI),Ro(n,i,c,h,l,0),e.identity(h),e.rotateY(h,h,.5*Math.PI),Ro(n,i,c,h,l,1),e.identity(h),e.rotateX(h,h,.5*-Math.PI),Ro(n,i,c,h,l,2),e.identity(h),e.rotateX(h,h,.5*Math.PI),Ro(n,i,c,h,l,3),e.identity(h),Ro(n,i,c,h,l,4),e.identity(h),e.rotateY(h,h,Math.PI),Ro(n,i,c,h,l,5),n.viewport.set([0,0,t.width,t.height]);}(t,o),o.markSkyboxValid(t)):"sky"===t.renderPass&&function(t,i,o,r,n){const s=t.context,a=s.gl,l=t.transform,c=t.useProgram("skybox");s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_CUBE_MAP,i.skyboxTexture);const h=((e,t,i,o,r)=>({u_matrix:e,u_sun_direction:t,u_cubemap:0,u_opacity:o,u_temporal_offset:r}))(l.skyboxMatrix,i.getCenter(t,!1),0,r,n);t.prepareDrawProgram(s,c),c.draw(s,a.TRIANGLES,o,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.backCW,h,"skybox",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(t,o,c,s,h):"gradient"===l&&"sky"===t.renderPass&&function(t,i,o,r,n){const s=t.context,a=s.gl,l=t.transform,c=t.useProgram("skyboxGradient");i.skyboxGeometry||(i.skyboxGeometry=new Po(s)),s.activeTexture.set(a.TEXTURE0);let h=i.colorRampTexture;h||(h=i.colorRampTexture=new e.Texture(s,i.colorRamp,a.RGBA)),h.bind(a.LINEAR,a.CLAMP_TO_EDGE);const u=((t,i,o,r,n)=>({u_matrix:t,u_color_ramp:0,u_center_direction:i,u_radius:e.degToRad(o),u_opacity:r,u_temporal_offset:n}))(l.skyboxMatrix,i.getCenter(t,!1),i.paint.get("sky-gradient-radius"),r,n);t.prepareDrawProgram(s,c),c.draw(s,a.TRIANGLES,o,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.backCW,u,"skyboxGradient",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(t,o,c,s,h);},debug:function(e,t,i){for(let o=0;o<i.length;o++)Mo(e,t,i[o]);},custom:function(t,i,o,r){const n=t.context,s=o.implementation;if(!t.transform.projection.unsupportedLayers||!t.transform.projection.unsupportedLayers.includes("custom")||t.terrain&&(t.terrain.renderingToTexture||"offscreen"===t.renderPass)&&o.isLayerDraped()){if("offscreen"===t.renderPass){const i=s.prerender;if(i){if(t.setCustomLayerDefaults(),n.setColorMode(t.colorModeForRenderPass()),"globe"===t.transform.projection.name){const o=t.transform.pointMerc;i.call(s,n.gl,t.transform.customLayerMatrix(),t.transform.getProjection(),t.transform.globeToMercatorMatrix(),e.globeToMercatorTransition(t.transform.zoom),[o.x,o.y],t.transform.pixelsPerMeterRatio);}else i.call(s,n.gl,t.transform.customLayerMatrix());n.setDirty(),t.setBaseState();}}else if("translucent"===t.renderPass){if(t.terrain&&t.terrain.renderingToTexture){const i=s.renderToTile;if(i){const o=r[0].canonical,a=new e.MercatorCoordinate(o.x+r[0].wrap*(1<<o.z),o.y,o.z);n.setDepthMode(e.DepthMode.disabled),n.setStencilMode(e.StencilMode.disabled),n.setColorMode(t.colorModeForRenderPass()),t.setCustomLayerDefaults(),i.call(s,n.gl,a),n.setDirty(),t.setBaseState();}return}t.setCustomLayerDefaults(),n.setColorMode(t.colorModeForRenderPass()),n.setStencilMode(e.StencilMode.disabled);const i="3d"===s.renderingMode?new e.DepthMode(t.context.gl.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D):t.depthModeForSublayer(0,e.DepthMode.ReadOnly);if(n.setDepthMode(i),"globe"===t.transform.projection.name){const i=t.transform.pointMerc;s.render(n.gl,t.transform.customLayerMatrix(),t.transform.getProjection(),t.transform.globeToMercatorMatrix(),e.globeToMercatorTransition(t.transform.zoom),[i.x,i.y],t.transform.pixelsPerMeterRatio);}else s.render(n.gl,t.transform.customLayerMatrix());n.setDirty(),t.setBaseState(),n.bindFramebuffer.set(null);}}else e.warnOnce("Custom layers are not yet supported with this projection. Use mercator or globe to enable usage of custom layers.");}};class Fo{constructor(t,i,o=!1){this.context=new Me(t,o),this.transform=i,this._tileTextures={},this.frameCopies=[],this.loadTimeStamps=[],this.setup(),this.numSublayers=e.SourceCache.maxUnderzooming+e.SourceCache.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new qt,this.deferredRenderGpuTimeQueries=[],this.gpuTimers={},this.frameCounter=0,this._backgroundTiles={};}updateTerrain(e,t){const i=!!e&&!!e.terrain&&this.transform.projection.supportsTerrain;if(!(i||this._terrain&&this._terrain.enabled))return;this._terrain||(this._terrain=new zi(this,e));const o=this._terrain;this.transform.elevation=i?o:null,o.update(e,this.transform,t);}_updateFog(e){const t=e.fog;if(!t||"globe"===this.transform.projection.name||t.getOpacity(this.transform.pitch)<1||t.properties.get("horizon-blend")<.03)return void(this.transform.fogCullDistSq=null);const[i,o]=t.getFovAdjustedRange(this.transform._fov);if(i>o)return void(this.transform.fogCullDistSq=null);const r=i+.78*(o-i);this.transform.fogCullDistSq=r*r;}get terrain(){return this.transform._terrainEnabled()&&this._terrain&&this._terrain.enabled?this._terrain:null}resize(t,i){if(this.width=t*e.exported.devicePixelRatio,this.height=i*e.exported.devicePixelRatio,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style.order)this.style._layers[e].resize();}setup(){const t=this.context,i=new e.StructArrayLayout2i4;i.emplaceBack(0,0),i.emplaceBack(e.EXTENT,0),i.emplaceBack(0,e.EXTENT),i.emplaceBack(e.EXTENT,e.EXTENT),this.tileExtentBuffer=t.createVertexBuffer(i,e.posAttributes.members),this.tileExtentSegments=e.SegmentVector.simpleSegment(0,0,4,2);const o=new e.StructArrayLayout2i4;o.emplaceBack(0,0),o.emplaceBack(e.EXTENT,0),o.emplaceBack(0,e.EXTENT),o.emplaceBack(e.EXTENT,e.EXTENT),this.debugBuffer=t.createVertexBuffer(o,e.posAttributes.members),this.debugSegments=e.SegmentVector.simpleSegment(0,0,4,5);const r=new e.StructArrayLayout2i4;r.emplaceBack(-1,-1),r.emplaceBack(1,-1),r.emplaceBack(-1,1),r.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(r,e.posAttributes.members),this.viewportSegments=e.SegmentVector.simpleSegment(0,0,4,2);const n=new e.StructArrayLayout4i8;n.emplaceBack(0,0,0,0),n.emplaceBack(e.EXTENT,0,e.EXTENT,0),n.emplaceBack(0,e.EXTENT,0,e.EXTENT),n.emplaceBack(e.EXTENT,e.EXTENT,e.EXTENT,e.EXTENT),this.mercatorBoundsBuffer=t.createVertexBuffer(n,e.boundsAttributes.members),this.mercatorBoundsSegments=e.SegmentVector.simpleSegment(0,0,4,2);const s=new e.StructArrayLayout3ui6;s.emplaceBack(0,1,2),s.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(s);const a=new e.StructArrayLayout1ui2;for(const e of [0,1,3,2,0])a.emplaceBack(e);this.debugIndexBuffer=t.createIndexBuffer(a),this.emptyTexture=new e.Texture(t,new e.RGBAImage({width:1,height:1},Uint8Array.of(0,0,0,0)),t.gl.RGBA),this.identityMat=e.create();const l=this.context.gl;this.stencilClearMode=new e.StencilMode({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.loadTimeStamps.push(e.window.performance.now()),this.atmosphereBuffer=new Bo(this.context);}getMercatorTileBoundsBuffers(){return {tileBoundsBuffer:this.mercatorBoundsBuffer,tileBoundsIndexBuffer:this.quadTriangleIndexBuffer,tileBoundsSegments:this.mercatorBoundsSegments}}getTileBoundsBuffers(e){return e._makeTileBoundsBuffers(this.context,this.transform.projection),e._tileBoundsBuffer?{tileBoundsBuffer:e._tileBoundsBuffer,tileBoundsIndexBuffer:e._tileBoundsIndexBuffer,tileBoundsSegments:e._tileBoundsSegments}:this.getMercatorTileBoundsBuffers()}clearStencil(){const t=this.context,i=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0,this._tileClippingMaskIDs={},this.useProgram("clippingMask").draw(t,i.TRIANGLES,e.DepthMode.disabled,this.stencilClearMode,e.ColorMode.disabled,e.CullFaceMode.disabled,Ii(this.identityMat),"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}resetStencilClippingMasks(){this.terrain||(this.currentStencilSource=void 0,this._tileClippingMaskIDs={});}_renderTileClippingMasks(t,i,o){if(!i||this.currentStencilSource===i.id||!t.isTileClipped()||!o||0===o.length)return;if(this._tileClippingMaskIDs&&!this.terrain){let e=!1;for(const t of o)if(void 0===this._tileClippingMaskIDs[t.key]){e=!0;break}if(!e)return}this.currentStencilSource=i.id;const r=this.context,n=r.gl;this.nextStencilID+o.length>256&&this.clearStencil(),r.setColorMode(e.ColorMode.disabled),r.setDepthMode(e.DepthMode.disabled);const s=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const t of o){const o=i.getTile(t),a=this._tileClippingMaskIDs[t.key]=this.nextStencilID++,{tileBoundsBuffer:l,tileBoundsIndexBuffer:c,tileBoundsSegments:h}=this.getTileBoundsBuffers(o);s.draw(r,n.TRIANGLES,e.DepthMode.disabled,new e.StencilMode({func:n.ALWAYS,mask:0},a,255,n.KEEP,n.KEEP,n.REPLACE),e.ColorMode.disabled,e.CullFaceMode.disabled,Ii(t.projMatrix),"$clipping",l,c,h);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,i=this.context.gl;return new e.StencilMode({func:i.NOTEQUAL,mask:255},t,255,i.KEEP,i.KEEP,i.REPLACE)}stencilModeForClipping(t){if(this.terrain)return this.terrain.stencilModeForRTTOverlap(t);const i=this.context.gl;return new e.StencilMode({func:i.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,i.KEEP,i.KEEP,i.REPLACE)}stencilConfigForOverlap(t){const i=this.context.gl,o=t.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),r=o[o.length-1].overscaledZ,n=o[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const t={};for(let o=0;o<n;o++)t[o+r]=new e.StencilMode({func:i.GEQUAL,mask:255},o+this.nextStencilID,255,i.KEEP,i.KEEP,i.REPLACE);return this.nextStencilID+=n,[t,o]}return [{[r]:e.StencilMode.disabled},o]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new e.ColorMode([t.CONSTANT_COLOR,t.ONE],new e.Color(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?e.ColorMode.unblended:e.ColorMode.alphaBlended}depthModeForSublayer(t,i,o){if(!this.opaquePassEnabledForLayer())return e.DepthMode.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new e.DepthMode(o||this.context.gl.LEQUAL,i,[r,r])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,i){this.style=t,this.options=i,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(e.exported.now()),this.imageManager.beginFrame();const o=this.style.order,r=this.style._sourceCaches;for(const e in r){const t=r[e];t.used&&t.prepare(this.context);}const n={},s={},a={};for(const e in r){const t=r[e];n[e]=t.getVisibleCoordinates(),s[e]=n[e].slice().reverse(),a[e]=t.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let e=0;e<o.length;e++)if(this.style._layers[o[e]].is3D()){this.opaquePassCutoff=e;break}if(this.terrain&&(this.terrain.updateTileBinding(a),this.opaquePassCutoff=0),"globe"!==this.transform.projection.name||this.globeSharedBuffers||(this.globeSharedBuffers=new e.GlobeSharedBuffers(this.context)),!e.isMapAuthenticated(this.context.gl))return;this.renderPass="offscreen";for(const e of o){const i=this.style._layers[e],o=t._getLayerSourceCache(i);if(!i.hasOffscreenPass()||i.isHidden(this.transform.zoom))continue;const r=o?s[o.id]:void 0;("custom"===i.type||i.isSky()||r&&r.length)&&this.renderLayer(this,o,i,r);}this.depthRangeFor3D=[0,1-(t.order.length+2)*this.numSublayers*this.depthEpsilon];const l=this.terrain;if(l&&(this.style.hasSymbolLayers()||this.style.hasCircleLayers())&&l.drawDepth(),this.context.bindFramebuffer.set(null),this.context.viewport.set([0,0,this.width,this.height]),this.context.clear({color:i.showOverdrawInspector?e.Color.black:e.Color.transparent,depth:1}),this.clearStencil(),this._showOverdrawInspector=i.showOverdrawInspector,this.renderPass="opaque",!this.terrain)for(this.currentLayer=o.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky())continue;const r=i?s[i.id]:void 0;this._renderTileClippingMasks(e,i,r),this.renderLayer(this,i,e,r);}if(this.style.fog&&this.transform.projection.supportsFog&&function(t,i){const o=t.context,r=o.gl,n=t.transform,s=new e.DepthMode(r.LEQUAL,e.DepthMode.ReadOnly,[0,1]),a=t.useProgram("globeAtmosphere",null,"globe"===n.projection.name?["PROJECTION_GLOBE_VIEW","FOG"]:["FOG"]),l=e.globeToMercatorTransition(n.zoom),c=i.properties.get("color").toArray01(),h=i.properties.get("high-color").toArray01(),u=i.properties.get("space-color").toArray01PremultipliedAlpha(),_=e.identity$1([]);e.rotateY$1(_,_,-e.degToRad(n._center.lng)),e.rotateX$1(_,_,e.degToRad(n._center.lat)),e.rotateZ$1(_,_,n.angle),e.rotateX$1(_,_,-n._pitch);const d=e.fromQuat(new Float32Array(16),_),p=e.mapValue(i.properties.get("star-intensity"),0,1,0,.25),m=5e-4,f=e.mapValue(i.properties.get("horizon-blend"),0,1,m,.25),g=e.globeUseCustomAntiAliasing(t,o,n)&&f===m?n.worldSize/(2*Math.PI*1.025)-1:n.globeRadius,v=t.frameCounter/1e3%1,x=e.length(n.globeCenterInViewSpace),y=Math.sqrt(Math.pow(x,2)-Math.pow(g,2)),b=Math.acos(y/x),w=((t,i,o,r,n,s,a,l,c,h,u,_,d,p)=>({u_frustum_tl:t,u_frustum_tr:i,u_frustum_br:o,u_frustum_bl:r,u_horizon:n,u_transition:s,u_fadeout_range:a,u_color:l,u_high_color:c,u_space_color:h,u_star_intensity:u,u_star_size:5*e.exported.devicePixelRatio,u_star_density:0,u_temporal_offset:_,u_horizon_angle:d,u_rotation_matrix:p}))(n.frustumCorners.TL,n.frustumCorners.TR,n.frustumCorners.BR,n.frustumCorners.BL,n.frustumCorners.horizon,l,f,c,h,u,p,v,b,d);t.prepareDrawProgram(o,a);const T=t.atmosphereBuffer;T&&a.draw(o,r.TRIANGLES,s,e.StencilMode.disabled,e.ColorMode.alphaBlended,e.CullFaceMode.backCW,w,"skybox",T.vertexBuffer,T.indexBuffer,T.segments);}(this,this.style.fog),this.renderPass="sky",(e.globeToMercatorTransition(this.transform.zoom)>0||"globe"!==this.transform.projection.name)&&this.transform.isHorizonVisible())for(this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);e.isSky()&&this.renderLayer(this,i,e,i?s[i.id]:void 0);}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<o.length;){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky()){++this.currentLayer;continue}if(this.terrain&&this.style.isLayerDraped(e)){if(e.isHidden(this.transform.zoom)){++this.currentLayer;continue}this.currentLayer=this.terrain.renderBatch(this.currentLayer);continue}const r=i?("symbol"===e.type?a:s)[i.id]:void 0;this._renderTileClippingMasks(e,i,i?n[i.id]:void 0),this.renderLayer(this,i,e,r),++this.currentLayer;}if(this.terrain&&this.terrain.postRender(),this.options.showTileBoundaries||this.options.showQueryGeometry||this.options.showTileAABBs){let i=null;e.values(this.style._layers).forEach((e=>{const o=t._getLayerSourceCache(e);o&&!e.isHidden(this.transform.zoom)&&(!i||i.getSource().maxzoom<o.getSource().maxzoom)&&(i=o);})),i&&this.options.showTileBoundaries&&ko.debug(this,i,i.getVisibleCoordinates());}this.options.showPadding&&function(e){const t=e.transform.padding;Io(e,e.transform.height-(t.top||0),3,bo),Io(e,t.bottom||0,3,wo),So(e,t.left||0,3,To),So(e,e.transform.width-(t.right||0),3,Eo);const i=e.transform.centerPoint;!function(e,t,i,o){Do(e,t-1,i-10,2,20,o),Do(e,t-10,i-1,20,2,o);}(e,i.x,e.transform.height-i.y,Co);}(this),this.context.setDefault(),this.frameCounter=(this.frameCounter+1)%Number.MAX_SAFE_INTEGER,this.tileLoaded&&this.options.speedIndexTiming&&(this.loadTimeStamps.push(e.window.performance.now()),this.saveCanvasCopy());}renderLayer(e,t,i,o){i.isHidden(this.transform.zoom)||("background"===i.type||"sky"===i.type||"custom"===i.type||o&&o.length)&&(this.id=i.id,this.gpuTimingStart(i),(!e.transform.projection.unsupportedLayers||!e.transform.projection.unsupportedLayers.includes(i.type)||e.terrain&&"custom"===i.type)&&ko[i.type](e,t,i,o,this.style.placement.variableOffsets,this.options.isInitialLoad),this.gpuTimingEnd());}gpuTimingStart(e){if(!this.options.gpuTiming)return;const t=this.context.extTimerQuery;let i=this.gpuTimers[e.id];i||(i=this.gpuTimers[e.id]={calls:0,cpuTime:0,query:t.createQueryEXT()}),i.calls++,t.beginQueryEXT(t.TIME_ELAPSED_EXT,i.query);}gpuTimingDeferredRenderStart(){if(this.options.gpuTimingDeferredRender){const e=this.context.extTimerQuery,t=e.createQueryEXT();this.deferredRenderGpuTimeQueries.push(t),e.beginQueryEXT(e.TIME_ELAPSED_EXT,t);}}gpuTimingDeferredRenderEnd(){if(!this.options.gpuTimingDeferredRender)return;const e=this.context.extTimerQuery;e.endQueryEXT(e.TIME_ELAPSED_EXT);}gpuTimingEnd(){if(!this.options.gpuTiming)return;const e=this.context.extTimerQuery;e.endQueryEXT(e.TIME_ELAPSED_EXT);}collectGpuTimers(){const e=this.gpuTimers;return this.gpuTimers={},e}collectDeferredRenderGpuQueries(){const e=this.deferredRenderGpuTimeQueries;return this.deferredRenderGpuTimeQueries=[],e}queryGpuTimers(e){const t={};for(const i in e){const o=e[i],r=this.context.extTimerQuery,n=r.getQueryObjectEXT(o.query,r.QUERY_RESULT_EXT)/1e6;r.deleteQueryEXT(o.query),t[i]=n;}return t}queryGpuTimeDeferredRender(e){if(!this.options.gpuTimingDeferredRender)return 0;const t=this.context.extTimerQuery;let i=0;for(const o of e)i+=t.getQueryObjectEXT(o,t.QUERY_RESULT_EXT)/1e6,t.deleteQueryEXT(o);return i}translatePosMatrix(t,i,o,r,n){if(!o[0]&&!o[1])return t;const s=n?"map"===r?this.transform.angle:0:"viewport"===r?-this.transform.angle:0;if(s){const e=Math.sin(s),t=Math.cos(s);o=[o[0]*t-o[1]*e,o[0]*e+o[1]*t];}const a=[n?o[0]:P(i,o[0],this.transform.zoom),n?o[1]:P(i,o[1],this.transform.zoom),0],l=new Float32Array(16);return e.translate(l,t,a),l}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e];}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){return null===e||void 0!==e&&!this.imageManager.getPattern(e.toString())}terrainRenderModeElevated(){return this.style&&!!this.style.getTerrain()&&!!this.terrain&&!this.terrain.renderingToTexture}currentGlobalDefines(){const e=this.terrain&&this.terrain.renderingToTexture,t=this.terrain&&0===this.terrain.exaggeration(),i=this.style&&this.style.fog,o=[];return this.terrainRenderModeElevated()&&o.push("TERRAIN"),"globe"===this.transform.projection.name&&o.push("GLOBE"),t&&o.push("ZERO_EXAGGERATION"),i&&!e&&0!==i.getOpacity(this.transform.pitch)&&o.push("FOG"),e&&o.push("RENDER_TO_TEXTURE"),this._showOverdrawInspector&&o.push("OVERDRAW_INSPECTOR"),o}useProgram(e,t,i){this.cache=this.cache||{};const o=i||[],r=this.currentGlobalDefines().concat(o),n=Pi.cacheKey(ui[e],e,r,t);return this.cache[n]||(this.cache[n]=new Pi(this.context,e,ui[e],t,lo[e],r)),this.cache[n]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.frontFace.setDefault(),this.context.cullFaceSide.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=e.window.document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new e.Texture(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this._terrain&&this._terrain.destroy(),this.globeSharedBuffers&&this.globeSharedBuffers.destroy(),this.emptyTexture.destroy(),this.debugOverlayTexture&&this.debugOverlayTexture.destroy(),this.atmosphereBuffer&&this.atmosphereBuffer.destroy();}prepareDrawTile(){this.terrain&&this.terrain.prepareDrawTile();}prepareDrawProgram(t,i,o){if(this.terrain&&this.terrain.renderingToTexture)return;const r=this.style.fog;if(r){const n=r.getOpacity(this.transform.pitch),s=((t,i,o,r,n,s,a,l,c,h,u)=>{const _=t.transform,d=i.properties.get("color").toArray01();d[3]=r;const p=t.frameCounter/1e3%1;return {u_fog_matrix:o?_.calculateFogTileMatrix(o):t.identityMat,u_fog_range:i.getFovAdjustedRange(_._fov),u_fog_color:d,u_fog_horizon_blend:i.properties.get("horizon-blend"),u_fog_temporal_offset:p,u_frustum_tl:n,u_frustum_tr:s,u_frustum_br:a,u_frustum_bl:l,u_globe_pos:c,u_globe_radius:h,u_viewport:u,u_globe_transition:e.globeToMercatorTransition(_.zoom),u_is_globe:+("globe"===_.projection.name)}})(this,r,o,n,this.transform.frustumCorners.TL,this.transform.frustumCorners.TR,this.transform.frustumCorners.BR,this.transform.frustumCorners.BL,this.transform.globeCenterInViewSpace,this.transform.globeRadius,[this.transform.width*e.exported.devicePixelRatio,this.transform.height*e.exported.devicePixelRatio]);i.setFogUniformValues(t,s);}}setTileLoadedFlag(e){this.tileLoaded=e;}saveCanvasCopy(){const e=this.canvasCopy();e&&(this.frameCopies.push(e),this.tileLoaded=!1);}canvasCopy(){const e=this.context.gl,t=e.createTexture();return e.bindTexture(e.TEXTURE_2D,t),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGBA,0,0,e.drawingBufferWidth,e.drawingBufferHeight,0),t}getCanvasCopiesAndTimestamps(){return {canvasCopies:this.frameCopies,timeStamps:this.loadTimeStamps}}averageElevationNeedsEasing(){if(!this.transform._elevation)return !1;const e=this.style&&this.style.fog;return !!e&&0!==e.getOpacity(this.transform.pitch)}getBackgroundTiles(){const t=this._backgroundTiles,i=this._backgroundTiles={},o=this.transform.coveringTiles({tileSize:512});for(const r of o)i[r.key]=t[r.key]||new e.Tile(r,512,this.transform.tileZoom,this);return i}clearBackgroundTiles(){this._backgroundTiles={};}}class Uo{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.number(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.number(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.number(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.number(t.right,i.right,o)),this}getCenter(t,i){const o=e.clamp((this.left+t-this.right)/2,0,t),r=e.clamp((this.top+i-this.bottom)/2,0,i);return new e.pointGeometry(o,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Uo(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function No(t,i){const o=e.getColumn(t,3);e.fromQuat(t,i),e.setColumn(t,3,o);}function Go(t,i){const o=e.identity$1([]);return e.rotateZ$1(o,o,-i),e.rotateX$1(o,o,-t),o}function jo(t,i){const o=[t[0],t[1],0],r=[i[0],i[1],0];if(e.length(o)>=1e-15){const t=e.normalize([],o);e.scale$2(r,t,e.dot(r,t)),i[0]=r[0],i[1]=r[1];}const n=e.cross([],i,t);if(e.len(n)<1e-15)return null;const s=Math.atan2(-n[1],n[0]);return Go(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),s)}class Zo{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){if(t){const i=t instanceof e.MercatorCoordinate?t:new e.MercatorCoordinate(t[0],t[1],t[2]);this._renderWorldCopies&&(i.x=e.wrap(i.x,0,1)),this._position=i;}else this._position=null;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this.position,r=this._elevation?this._elevation.getAtPointOrZero(e.MercatorCoordinate.fromLngLat(t)):0,n=e.MercatorCoordinate.fromLngLat(t,r),s=[n.x-o.x,n.y-o.y,n.z-o.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=jo(s,i);}setPitchBearing(t,i){this.orientation=Go(e.degToRad(t),e.degToRad(-i));}}class Vo{constructor(t,i){this._transform=e.identity([]),this.orientation=i,this.position=t;}get mercatorPosition(){const t=this.position;return new e.MercatorCoordinate(t[0],t[1],t[2])}get position(){const t=e.getColumn(this._transform,3);return [t[0],t[1],t[2]]}set position(t){var i;t&&e.setColumn(this._transform,3,[(i=t)[0],i[1],i[2],1]);}get orientation(){return this._orientation}set orientation(t){this._orientation=t||e.identity$1([]),t&&No(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=Go(e,t),No(this._transform,this._orientation);}forward(){const t=e.getColumn(this._transform,2);return [-t[0],-t[1],-t[2]]}up(){const t=e.getColumn(this._transform,1);return [-t[0],-t[1],-t[2]]}right(){const t=e.getColumn(this._transform,0);return [t[0],t[1],t[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.invert(o,this.getWorldToCamera(t,i)),o}getWorldToCameraPosition(t,i,o){const r=this.position;e.scale$2(r,r,-t);const n=new Float64Array(16);return e.fromScaling(n,[o,o,o]),e.translate(n,n,r),n[10]*=i,n}getWorldToCamera(t,i){const o=new Float64Array(16),r=new Float64Array(4),n=this.position;return e.conjugate(r,this._orientation),e.scale$2(n,n,-t),e.fromQuat(o,r),e.translate(o,o,n),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,r){const n=new Float64Array(16);return e.perspective(n,t,i,o,r),n}getDistanceToElevation(t,i=!1){const o=0===t?0:e.mercatorZfromAltitude(t,i?e.latFromMercatorY(this.position[1]):this.position[1]),r=this.forward();return (o-this.position[2])/r[2]}clone(){return new Vo([...this.position],[...this.orientation])}}function Wo(t,i){const o=qo(t.projection,t.zoom,t.width,t.height),r=function(t,i,o,r,n){const s=new e.LngLat(o.lng-180*$o,o.lat),a=new e.LngLat(o.lng+180*$o,o.lat),l=t.project(s.lng,s.lat),c=t.project(a.lng,a.lat),h=-Math.atan2(c.y-l.y,c.x-l.x),u=e.MercatorCoordinate.fromLngLat(o);u.y=e.clamp(u.y,-.999975,.999975);const _=u.toLngLat(),d=t.project(_.lng,_.lat),p=e.MercatorCoordinate.fromLngLat(_);p.x+=$o;const m=p.toLngLat(),f=t.project(m.lng,m.lat),g=Yo(f.x-d.x,f.y-d.y,h),v=e.MercatorCoordinate.fromLngLat(_);v.y+=$o;const x=v.toLngLat(),y=t.project(x.lng,x.lat),b=Yo(y.x-d.x,y.y-d.y,h),w=Math.abs(g.x)/Math.abs(b.y),T=e.identity([]);e.rotateZ(T,T,-h*(1-(n?0:r)));const E=e.identity([]);return e.scale(E,E,[1,1-(1-w)*r,1]),E[4]=-b.x/b.y*r,e.rotateZ(E,E,h),e.multiply(E,T,E),E}(t.projection,0,t.center,o,i),n=Xo(t);return e.scale(r,r,[n,n,1]),r}function Xo(t){const i=t.projection,o=qo(t.projection,t.zoom,t.width,t.height),r=Ho(i,t.center),n=Ho(i,e.LngLat.convert(i.center));return Math.pow(2,r*o+(1-o)*n)}function qo(t,i,o,r,n=1/0){const s=t.range;if(!s)return 0;const a=Math.min(n,Math.max(o,r)),l=Math.log(a/1024)/Math.LN2;return e.smoothstep(s[0]+l,s[1]+l,i)}const $o=1/4e4;function Ho(t,i){const o=e.clamp(i.lat,-e.MAX_MERCATOR_LATITUDE,e.MAX_MERCATOR_LATITUDE),r=new e.LngLat(i.lng-180*$o,o),n=new e.LngLat(i.lng+180*$o,o),s=t.project(r.lng,o),a=t.project(n.lng,o),l=e.MercatorCoordinate.fromLngLat(r),c=e.MercatorCoordinate.fromLngLat(n),h=a.x-s.x,u=a.y-s.y,_=c.x-l.x,d=c.y-l.y,p=Math.sqrt((_*_+d*d)/(h*h+u*u));return Math.log(p)/Math.LN2}function Yo(e,t,i){const o=Math.cos(i),r=Math.sin(i);return {x:e*o-t*r,y:e*r+t*o}}class Ko{constructor(t,i,o,r,n,s,a){this.tileSize=512,this._renderWorldCopies=void 0===n||n,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=null==o?0:o,this._maxPitch=null==r?60:r,this.setProjection(s),this.setMaxBounds(a),this.width=0,this.height=0,this._center=new e.LngLat(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new Uo,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._distanceTileDataCache={},this._camera=new Vo,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._horizonShift=.1;}clone(){const e=new Ko(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection());return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices());}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices();}getProjection(){return e.pick(this.projection,["name","center","parallels"])}setProjection(i){this.projectionOptions=i||{name:"mercator"};const o=this.projection?this.getProjection():void 0;this.projection=e.getProjection(this.projectionOptions);const r=!t(o,this.getProjection());return r&&this._calcMatrices(),this.mercatorFromTransition=!1,r}setMercatorFromTransition(){const t=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=e.getProjection({name:"mercator"});const i=t!==this.projection.name;return i&&this._calcMatrices(),i}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return e.mercatorZfromAltitude(this.center.lat,this.cameraWorldSizeForFog)}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.pointGeometry(this.width,this.height)}get bearing(){return e.wrap(this.rotation,-180,180)}set bearing(e){this.rotation=e;}get rotation(){return -this.angle/Math.PI*180}set rotation(t){const i=-t*Math.PI/180;var o;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=(o=new e.ARRAY_TYPE(4),e.ARRAY_TYPE!=Float32Array&&(o[1]=0,o[2]=0),o[0]=1,o[3]=1,o),function(e,t,i){var o=t[0],r=t[1],n=t[2],s=t[3],a=Math.sin(i),l=Math.cos(i);e[0]=o*l+n*a,e[1]=r*l+s*a,e[2]=o*-a+n*l,e[3]=r*-a+s*l;}(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.clamp(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=e.degToRad(t),this._calcMatrices());}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={};}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}_updateCameraOnTerrain(){if(!this._elevation||!this._elevation.isDataAvailableAtPoint(this.locationCoordinate(this.center)))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const e=this._elevation;this._centerAltitude=e.getAtPointOrZero(this.locationCoordinate(this.center)),this._centerAltitudeValidForExaggeration=e.exaggeration(),this._updateSeaLevelZoom();}_updateSeaLevelZoom(){void 0!==this._centerAltitudeValidForExaggeration&&(this._seaLevelZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize));}sampleAverageElevation(){if(!this._elevation)return 0;const t=this._elevation,i=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],o=this.horizonLineFromTop();let r=0,n=0;for(let s=0;s<i.length;s++){const a=new e.pointGeometry(i[s][0]*this.width,o+i[s][1]*(this.height-o)),l=t.pointCoordinate(a);if(!l)continue;const c=1/Math.hypot(l[0]-this._camera.position[0],l[1]-this._camera.position[1]);r+=l[3]*c,n+=c;}return 0===n?NaN:r/n}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,o=this._mercatorZfromZoom(e),r=this._mercatorZfromZoom(this._maxZoom),n=Math.max(o-i,r);this._setZoom(this._zoomFromMercatorZ(n));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const r=e.length(e.sub([],this._camera.position,o));return e.clamp(this._zoomFromMercatorZ(r),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.exactEquals(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.exactEquals$1(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new Zo;return i.position=new e.MercatorCoordinate(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this.renderWorldCopies,i}_setCameraOrientation(t){if(!e.length$1(t))return !1;e.normalize$1(t,t);const i=e.transformQuat([],[0,0,-1],t),o=e.transformQuat([],[0,-1,0],t);if(o[2]<0)return !1;const r=jo(i,o);return !!r&&(this._camera.orientation=r,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,r=this.cameraToCenterDistance;t[2]=e.clamp(t[2],r/o,r/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.UnwrappedTileID(0,t)];if(this.renderWorldCopies){const o=this.pointCoordinate(new e.pointGeometry(0,0)),r=this.pointCoordinate(new e.pointGeometry(this.width,0)),n=this.pointCoordinate(new e.pointGeometry(this.width,this.height)),s=this.pointCoordinate(new e.pointGeometry(0,this.height)),a=Math.floor(Math.min(o.x,r.x,n.x,s.x)),l=Math.floor(Math.max(o.x,r.x,n.x,s.x)),c=1;for(let o=a-c;o<=l+c;o++)0!==o&&i.push(new e.UnwrappedTileID(o,t));}return i}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,r=this.elevation&&!t.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const s=this.locationCoordinate(this.center),a=this.center.lat,l=1<<i,c=[l*s.x,l*s.y,0],h="globe"===this.projection.name,u=!h,_=e.Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i,u),d=h?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),p=l*e.mercatorZfromAltitude(1,this.center.lat),m=this._camera.position[2]/e.mercatorZfromAltitude(1,this.center.lat),f=[l*d.x,l*d.y,m*(u?1:p)],g=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),v=this.pitch<=60&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace?i:0,x=t.isTerrainDEM&&this._elevation?1e4*this._elevation.exaggeration():this._centerAltitude,y=t.isTerrainDEM?-x:this._elevation?this._elevation.getMinElevationBelowMSL():0,b=this.projection.isReprojectedInTileSpace?Xo(this):1,w=t=>{const i=1/4e4,o=new e.MercatorCoordinate(t.x+i,t.y,t.z),r=new e.MercatorCoordinate(t.x,t.y+i,t.z),n=t.toLngLat(),s=o.toLngLat(),a=r.toLngLat(),l=this.locationCoordinate(n),c=this.locationCoordinate(s),h=this.locationCoordinate(a),u=Math.hypot(c.x-l.x,c.y-l.y),_=Math.hypot(h.x-l.x,h.y-l.y);return Math.sqrt(u*_)*b/i},T=t=>{const i=x,o=y;return {aabb:e.tileAABB(this,l,0,0,0,t,o,i,this.projection),zoom:0,x:0,y:0,minZ:o,maxZ:i,wrap:t,fullyVisible:!1}},E=[];let C=[];const M=i,I=t.reparseOverscaled?o:i,S=e=>e*e,D=S((m-this._centerAltitude)*p),L=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=A(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude));},A=t=>{if(t.zoom<v)return !0;if(t.zoom===M)return !1;if(null!=t.shouldSplit)return t.shouldSplit;const i=t.aabb.distanceX(f),n=t.aabb.distanceY(f);let s=D,l=1;if(h){s=S(t.aabb.distanceZ(f));const i=Math.pow(2,t.zoom),o=e.latFromMercatorY((t.y+1)/i),r=e.latFromMercatorY(t.y/i),n=Math.min(Math.max(a,o),r),c=e.circumferenceAtLatitude(n)/e.circumferenceAtLatitude(a);if(l=n===a?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,c/this._mercatorScaleRatio),this.zoom<=e.GLOBE_ZOOM_THRESHOLD_MIN&&t.zoom===M-1&&c>=.9)return !0}else if(r&&(s=S(t.aabb.distanceZ(f)*p)),this.projection.isReprojectedInTileSpace&&o<=5){const i=Math.pow(2,t.zoom),o=w(new e.MercatorCoordinate((t.x+.5)/i,(t.y+.5)/i));l=o>.85?1:o;}const c=i*i+n*n+s,u=S((1<<M-t.zoom)*g*l*((e,t)=>{if(t*S(.707)<e)return 1;const i=Math.sqrt(t/e);return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)})(Math.max(s,D),c));return c<u};if(this.renderWorldCopies)for(let e=1;e<=3;e++)E.push(T(-e)),E.push(T(e));for(E.push(T(0));E.length>0;){const o=E.pop(),s=o.x,a=o.y;let u=o.fullyVisible;if(!u){const e=o.aabb.intersects(_);if(0===e)continue;u=2===e;}if(o.zoom!==M&&A(o))for(let t=0;t<4;t++){const i=(s<<1)+t%2,c=(a<<1)+(t>>1),_={aabb:n?o.aabb.quadrant(t):e.tileAABB(this,l,o.zoom+1,i,c,o.wrap,o.minZ,o.maxZ,this.projection),zoom:o.zoom+1,x:i,y:c,wrap:o.wrap,fullyVisible:u,tileID:void 0,shouldSplit:void 0,minZ:o.minZ,maxZ:o.maxZ};r&&!h&&(_.tileID=new e.OverscaledTileID(o.zoom+1===M?I:o.zoom+1,o.wrap,o.zoom+1,i,c),L(_)),E.push(_);}else {const r=o.zoom===M?I:o.zoom;if(t.minzoom&&t.minzoom>r)continue;const n=c[0]-(.5+s+(o.wrap<<o.zoom))*(1<<i-o.zoom),l=c[1]-.5-a,h=o.tileID?o.tileID:new e.OverscaledTileID(r,o.wrap,o.zoom,s,a);C.push({tileID:h,distanceSq:n*n+l*l});}}if(this.fogCullDistSq){const i=this.fogCullDistSq,o=this.horizonLineFromTop();C=C.filter((r=>{const n=[0,0,0,1],s=[e.EXTENT,e.EXTENT,0,1],a=this.calculateFogTileMatrix(r.tileID.toUnwrapped());e.transformMat4$1(n,n,a),e.transformMat4$1(s,s,a);const l=e.getAABBPointSquareDist(n,s);if(0===l)return !0;let c=!1;const h=this._elevation;if(h&&l>i&&0!==o){const i=this.calculateProjMatrix(r.tileID.toUnwrapped());let n;t.isTerrainDEM||(n=h.getMinMaxForTile(r.tileID)),n||(n={min:y,max:x});const s=e.furthestTileCorner(this.rotation),a=[s[0]*e.EXTENT,s[1]*e.EXTENT,n.max];e.transformMat4(a,a,i),c=(1-a[1])*this.height*.5<o;}return l<i||c}));}return C.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.clamp(t.lat,-e.MAX_MERCATOR_LATITUDE,e.MAX_MERCATOR_LATITUDE),o=this.projection.project(t.lng,i);return new e.pointGeometry(o.x*this.worldSize,o.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/e.mercatorZfromAltitude(1,this.center.lat)/this.worldSize}setLocationAtPoint(t,i){let o,r;const n=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;o=(i.x-n.x)/e,r=(i.y-n.y)/e;}else {const e=this.pointCoordinate(i),t=this.pointCoordinate(n);o=e.x-t.x,r=e.y-t.y;}const s=this.locationCoordinate(t);this.setLocation(new e.MercatorCoordinate(s.x-o,s.y-r));}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap());}locationPoint(e){return this.projection.locationPoint(this,e)}locationPoint3D(e){return this.projection.locationPoint(this,e,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(t,i){const o=i?e.mercatorZfromAltitude(i,t.lat):void 0,r=this.projection.project(t.lng,t.lat);return new e.MercatorCoordinate(r.x,r.y,o)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,r=[t.x,t.y,0,1],n=[t.x,t.y,1,1];e.transformMat4$1(r,r,this.pixelMatrixInverse),e.transformMat4$1(n,n,this.pixelMatrixInverse);const s=n[3];e.scale$1(r,r,1/r[3]),e.scale$1(n,n,1/s);const a=r[2],l=n[2];return {p0:r,p1:n,t:a===l?0:(o-a)/(l-a)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.transformMat4$1(i,i,this.pixelMatrixInverse),e.transformMat4$1(o,o,this.pixelMatrixInverse),e.scale$1(i,i,1/i[3]),e.scale$1(o,o,1/o[3]),i[2]=e.mercatorZfromAltitude(i[2],this._center.lat)*this.worldSize,o[2]=e.mercatorZfromAltitude(o[2],this._center.lat)*this.worldSize,e.scale$1(i,i,1/this.worldSize),e.scale$1(o,o,1/this.worldSize),new e.Ray([i[0],i[1],i[2]],e.normalize([],e.sub([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:r}=t,n=e.mercatorZfromAltitude(i[2],this._center.lat),s=e.mercatorZfromAltitude(o[2],this._center.lat);return new e.MercatorCoordinate(e.number(i[0],o[0],r)/this.worldSize,e.number(i[1],o[1],r)/this.worldSize,e.number(n,s,r))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(t){if(!this.elevation)return this.pointCoordinate(t);let i=this.projection.pointCoordinate3D(this,t.x,t.y);if(i)return new e.MercatorCoordinate(i[0],i[1],i[2]);let o=0,r=this.horizonLineFromTop();if(t.y>r)return this.pointCoordinate(t);const n=.02*r,s=t.clone();for(let t=0;t<10&&r-o>n;t++){s.y=e.number(o,r,.66);const t=this.projection.pointCoordinate3D(this,s.x,s.y);t?(r=s.y,i=t):o=s.y;}return i?new e.MercatorCoordinate(i[0],i[1],i[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPointOrZero(t,this._centerAltitude):this._centerAltitude,r=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.transformMat4$1(r,r,this.pixelMatrix),r[3]>0?new e.pointGeometry(r[0]/r[3],r[1]/r[3]):new e.pointGeometry(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:t,left:i}=this._edgeInsets,o=this.height-this._edgeInsets.bottom,r=this.width-this._edgeInsets.right,n=this.pointLocation3D(new e.pointGeometry(i,t)),s=this.pointLocation3D(new e.pointGeometry(r,t)),a=this.pointLocation3D(new e.pointGeometry(r,o)),l=this.pointLocation3D(new e.pointGeometry(i,o));let c=Math.min(n.lng,s.lng,a.lng,l.lng),h=Math.max(n.lng,s.lng,a.lng,l.lng),u=Math.min(n.lat,s.lat,a.lat,l.lat),_=Math.max(n.lat,s.lat,a.lat,l.lat);const d=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,m=(t,i,o,r,n)=>{const s=(t+o)/2,a=(i+r)/2,l=new e.pointGeometry(s,a),{lng:f,lat:g}=this.pointLocation3D(l),v=Math.max(0,c-f,u-g,f-h,g-_);c=Math.min(c,f),h=Math.max(h,f),u=Math.min(u,g),_=Math.max(_,g),(n<p||v>d)&&(m(t,i,s,a,n+1),m(s,a,o,r,n+1));};if(m(i,t,r,t,1),m(r,t,r,o,1),m(r,o,i,o,1),m(i,o,i,t,1),"globe"===this.projection.name){const[t,i]=e.polesInViewport(this);t?(_=90,h=180,c=-180):i&&(u=-90,h=180,c=-180);}return new e.LngLatBounds(new e.LngLat(c,u),new e.LngLat(h,_))}_getBoundsRectangular(t,i){const{top:o,left:r}=this._edgeInsets,n=this.height-this._edgeInsets.bottom,s=this.width-this._edgeInsets.right,a=new e.pointGeometry(r,o),l=new e.pointGeometry(s,o),c=new e.pointGeometry(s,n),h=new e.pointGeometry(r,n);let u=this.pointCoordinate(a,t),_=this.pointCoordinate(l,t);const d=this.pointCoordinate(c,i),p=this.pointCoordinate(h,i),m=(e,t)=>(t.y-e.y)/(t.x-e.x);return u.y>1&&_.y>=0?u=new e.MercatorCoordinate((1-p.y)/m(p,u)+p.x,1):u.y<0&&_.y<=1&&(u=new e.MercatorCoordinate(-p.y/m(p,u)+p.x,0)),_.y>1&&u.y>=0?_=new e.MercatorCoordinate((1-d.y)/m(d,_)+d.x,1):_.y<0&&u.y<=1&&(_=new e.MercatorCoordinate(-d.y/m(d,_)+d.x,0)),(new e.LngLatBounds).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(_)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(d))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return "mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))+this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(t){this.maxBounds=t,this.minLat=-e.MAX_MERCATOR_LATITUDE,this.maxLat=e.MAX_MERCATOR_LATITUDE,this.minLng=-180,this.maxLng=180,t&&(this.minLat=t.getSouth(),this.maxLat=t.getNorth(),this.minLng=t.getWest(),this.maxLng=t.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=e.mercatorXfromLng(this.minLng)*this.tileSize,this.worldMaxX=e.mercatorXfromLng(this.maxLng)*this.tileSize,this.worldMinY=e.mercatorYfromLat(this.maxLat)*this.tileSize,this.worldMaxY=e.mercatorYfromLat(this.minLat)*this.tileSize,this._constrain();}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(t){const i=t.key,o=this._distanceTileDataCache;if(o[i])return o[i];const r=t.canonical,n=1/this.height,s=this.cameraWorldSize,a=s/this.zoomScale(r.z),l=(r.x+Math.pow(2,r.z)*t.wrap)*a,c=r.y*a,h=this.point;h.x*=s/this.worldSize,h.y*=s/this.worldSize;const u=this.angle,_=Math.sin(-u),d=-Math.cos(-u);return o[i]={bearing:[_,d],center:[(h.x-l)*n,(h.y-c)*n],scale:a/e.EXTENT*n},o[i]}calculateFogTileMatrix(t){const i=t.key,o=this._fogTileMatrixCache;if(o[i])return o[i];const r=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,t);return e.multiply(r,this.worldToFogMatrix,r),o[i]=new Float32Array(r),o[i]}calculateProjMatrix(t,i=!1){const o=t.key,r=i?this._alignedProjMatrixCache:this._projMatrixCache;if(r[o])return r[o];const n=this.calculatePosMatrix(t,this.worldSize);return e.multiply(n,this.projection.isReprojectedInTileSpace?this.mercatorMatrix:i?this.alignedProjMatrix:this.projMatrix,n),r[o]=new Float32Array(n),r[o]}calculatePixelsToTileUnitsMatrix(t){const i=t.tileID.key,o=this._pixelsToTileUnitsCache;if(o[i])return o[i];const r=function(t,i){const{scale:o}=t.tileTransform,r=o*e.EXTENT/(t.tileSize*Math.pow(2,i.zoom-t.tileID.overscaledZ+t.tileID.canonical.z));return n=new Float32Array(4),l=(s=i.inverseAdjustmentMatrix)[1],c=s[2],h=s[3],_=(a=[r,r])[1],n[0]=s[0]*(u=a[0]),n[1]=l*u,n[2]=c*_,n[3]=h*_,n;var n,s,a,l,c,h,u,_;}(t,this);return o[i]=r,o[i]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const t=1/this.worldSize,i=e.fromScaling([],[t,t,t]);return e.multiply(i,i,this.globeMatrix),i}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const t=this._elevation;this._updateCameraState();const i=e.mercatorZfromAltitude(1,this._center.lat)*this.worldSize,o=this._computeCameraPosition(i),r=this._camera.forward(),n=e.mercatorZfromAltitude(1,this._center.lat);o[2]/=n,r[2]/=n,e.normalize(r,r);const s=t.raycast(o,r,t.exaggeration());if(s){const t=e.scaleAndAdd([],o,r,s),i=new e.MercatorCoordinate(t[0],t[1],e.mercatorZfromAltitude(t[2],e.latFromMercatorY(t[1]))),a=(i.z+e.length([i.x-o[0],i.y-o[1],i.z-o[2]*n]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(a),this._centerAltitude=i.toAltitude(),this._center=this.coordinateLocation(i),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCamera(t=!1){if(!this._elevation)return;const i=this._elevation,o=e.mercatorZfromAltitude(1,this._center.lat)*this.worldSize,r=this._computeCameraPosition(o),n=i.getAtPointOrZero(new e.MercatorCoordinate(...r)),s=this.pixelsPerMeter/this.worldSize*n,a=this._minimumHeightOverTerrain(),l=r[2]-s;if(l<=a)if(l<0||t){const t=this.locationCoordinate(this._center,this._centerAltitude),i=[r[0],r[1],t.z-r[2]],o=e.length(i);i[2]-=(a-l)/this._pixelsPerMercatorPixel;const n=e.length(i);if(0===n)return;e.scale$2(i,i,o/n*this._pixelsPerMercatorPixel),this._camera.position=[r[0],r[1],t.z*this._pixelsPerMercatorPixel-i[2]],this._updateStateFromCamera();}else this._isCameraConstrained=!0;}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const t="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||t){const i=this.center;return i.lat=e.clamp(i.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!t)&&(i.lng=e.clamp(i.lng,this.minLng,this.maxLng)),this.center=i,void(this._constraining=!1)}const i=this._unmodified,{x:o,y:r}=this.point;let n=0,s=o,a=r;const l=this.width/2,c=this.height/2,h=this.worldMinY*this.scale,u=this.worldMaxY*this.scale;if(r-c<h&&(a=h+c),r+c>u&&(a=u-c),u-h<this.height&&(n=Math.max(n,this.height/(u-h)),a=(u+h)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,i=this.worldSize/2-(e+t)/2;s=(o+i+this.worldSize)%this.worldSize-i,s-l<e&&(s=e+l),s+l>t&&(s=t-l),t-e<this.width&&(n=Math.max(n,this.width/(t-e)),s=(t+e)/2);}s===o&&a===r||(this.center=this.unproject(new e.pointGeometry(s,a))),n&&(this.zoom+=this.scaleZoom(n)),this._constrainCamera(),this._unmodified=i,this._constraining=!1;}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=e.mercatorZfromAltitude(1,this.center.lat)/e.mercatorZfromAltitude(1,e.GLOBE_SCALE_MATCH_LATITUDE));const o=qo(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,o),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const r="meters"===this.projection.zAxisUnit?i:1,n=this._camera.getWorldToCamera(this.worldSize,r),s=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);s[8]=2*-t.x/this.width,s[9]=2*t.y/this.height;let a=e.mul([],s,n);if(this.projection.isReprojectedInTileSpace){const t=this.locationCoordinate(this.center),i=e.identity([]);e.translate(i,i,[t.x*this.worldSize,t.y*this.worldSize,0]),e.multiply(i,i,Wo(this)),e.translate(i,i,[-t.x*this.worldSize,-t.y*this.worldSize,0]),e.multiply(a,a,i),this.inverseAdjustmentMatrix=function(e){const t=Wo(e,!0);return v([],[t[0],t[1],t[4],t[5]])}(this);}else this.inverseAdjustmentMatrix=[1,0,0,1];this.mercatorMatrix=e.scale([],a,[this.worldSize,this.worldSize,this.worldSize/r,1]),this.projMatrix=a,this.invProjMatrix=e.invert(new Float64Array(16),this.projMatrix);const l=e.invert([],s);this.frustumCorners=e.FrustumCorners.fromInvProjectionMatrix(l,this.horizonLineFromTop(),this.height);const c=new Float32Array(16);e.identity(c),e.scale(c,c,[1,-1,1]),e.rotateX(c,c,this._pitch),e.rotateZ(c,c,this.angle);const h=e.perspective(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ),u=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;h[8]=2*-t.x/this.width,h[9]=2*(t.y+u)/this.height,this.skyboxMatrix=e.multiply(c,h,c);const _=this.point,d=_.x,p=_.y,m=this.width%2/2,f=this.height%2/2,g=Math.cos(this.angle),x=Math.sin(this.angle),y=d-Math.round(d)+g*m+x*f,b=p-Math.round(p)+g*f+x*m,w=new Float64Array(a);if(e.translate(w,w,[y>.5?y-1:y,b>.5?b-1:b,0]),this.alignedProjMatrix=w,a=e.create(),e.scale(a,a,[this.width/2,-this.height/2,1]),e.translate(a,a,[1,-1,0]),this.labelPlaneMatrix=a,a=e.create(),e.scale(a,a,[1,-1,1]),e.translate(a,a,[-1,-1,0]),e.scale(a,a,[2/this.width,2/this.height,1]),this.glCoordMatrix=a,this.pixelMatrix=e.multiply(new Float64Array(16),this.labelPlaneMatrix,this.projMatrix),this._calcFogMatrices(),this._distanceTileDataCache={},a=e.invert(new Float64Array(16),this.pixelMatrix),!a)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=a,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=e.calculateGlobeMatrix(this);const t=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=e.transformMat4(t,t,n),this.globeRadius=this.worldSize/2/Math.PI-1;}else this.globeMatrix=a;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={};}_calcFogMatrices(){this._fogTileMatrixCache={};const t=this.cameraWorldSizeForFog,i=this.cameraPixelsPerMeter,o=this._camera.position,r=1/this.height/this._pixelsPerMercatorPixel,n=[t,t,i];e.scale$2(n,n,r),e.scale$2(o,o,-1),e.multiply$2(o,o,n);const s=e.create();e.translate(s,s,o),e.scale(s,s,n),this.mercatorFogMatrix=s,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(t,i,r);}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),o=this.point,r=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return [o.x/this.worldSize-i[0]*r,o.y/this.worldSize-i[1]*r,e/this.worldSize*this._centerAltitude-i[2]*r]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition());}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=this._camera.position[2],r=t[2];let n=1;this.projection.wrap&&(this.center=this.center.wrap()),r>0&&(n=Math.min((i-o)/r,1)),this._camera.position=e.scaleAndAdd([],this._camera.position,t,n),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:r}=this._camera.getPitchBearing(),n=e.mercatorZfromAltitude(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,s=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.degToRad(this._maxPitch)),a=Math.max((t[2]-n)/Math.cos(o),s),l=this._zoomFromMercatorZ(a);e.scaleAndAdd(t,t,i,a),this._pitch=e.clamp(o,e.degToRad(this.minPitch),e.degToRad(this.maxPitch)),this.angle=e.wrap(r,-Math.PI,Math.PI),this._setZoom(e.clamp(l,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new e.MercatorCoordinate(t[0],t[1],t[2])),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min((null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom)+4,this._maxZoom);return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}zoomFromMercatorZAdjusted(t){let i=0,o=e.GLOBE_ZOOM_THRESHOLD_MAX,r=0,n=1/0;for(;o-i>1e-6&&o>i;){const e=i+.5*(o-i),s=this.tileSize*Math.pow(2,e),a=this.getCameraToCenterDistance(this.projection,e,s),l=this.scaleZoom(a/(t*this.tileSize)),c=Math.abs(e-l);c<n&&(n=c,r=e),e<l?i=e:o=e;}return r}_terrainEnabled(){return !(!this._elevation||!this.projection.supportsTerrain&&(e.warnOnce("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(t,i){const o=Math.min(t.x,i.x),r=Math.max(t.x,i.x),n=Math.min(t.y,i.y),s=Math.max(t.y,i.y);if(n<this.horizonLineFromTop(!1))return !0;if("mercator"!==this.projection.name)return !1;const a=[new e.pointGeometry(o,n),new e.pointGeometry(r,s),new e.pointGeometry(o,s),new e.pointGeometry(r,n)],l=this.renderWorldCopies?-3:0,c=this.renderWorldCopies?4:1;for(const e of a){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.radToDeg(this.fovAboveCenter)>88||this.anyCornerOffEdge(new e.pointGeometry(0,0),new e.pointGeometry(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.length(e.sub([],this._camera.position,t)),r=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(r)}getCameraPoint(){if("globe"===this.projection.name){const t=function([t,i,o],r){const n=[t,i,o,1];e.transformMat4$1(n,n,r);const s=n[3]=Math.max(n[3],1e-6);return n[0]/=s,n[1]/=s,n[2]/=s,n}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new e.pointGeometry(t[0],t[1])}{const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.pointGeometry(0,t))}}getCameraToCenterDistance(e,t=this.zoom,i=this.worldSize){const o=qo(e,t,this.width,this.height,1024),r=e.pixelSpaceConversion(this.center.lat,i,o);return .5/Math.tan(.5*this._fov)*this.height*r}getWorldToCameraMatrix(){const t=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return "globe"===this.projection.name&&e.multiply(t,t,this.globeMatrix),t}}function Jo(e,t){let i=!1,o=null;const r=()=>{o=null,i&&(e(),o=setTimeout(r,t),i=!1);};return ()=>(i=!0,o||r(),o)}class Qo{constructor(t){this._hashName=t&&encodeURIComponent(t),e.bindAll(["_getCurrentHash","_onHashChange","_updateHash"],this),this._updateHash=Jo(this._updateHashUnthrottled.bind(this),300);}addTo(t){return this._map=t,e.window.addEventListener("hashchange",this._onHashChange,!1),t.on("moveend",this._updateHash),this}remove(){return this._map?(this._map.off("moveend",this._updateHash),e.window.removeEventListener("hashchange",this._onHashChange,!1),clearTimeout(this._updateHash()),this._map=void 0,this):this}getHashString(){const t=this._map;if(!t)return "";const i=er(t);if(this._hashName){const t=this._hashName;let o=!1;const r=e.window.location.hash.slice(1).split("&").map((e=>{const r=e.split("=")[0];return r===t?(o=!0,`${r}=${i}`):e})).filter((e=>e));return o||r.push(`${t}=${i}`),`#${r.join("&")}`}return `#${i}`}_getCurrentHash(){const t=e.window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((e=>e.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t);})),(e&&e[1]||"").split("/")}return t.split("/")}_onHashChange(){const e=this._map;if(!e)return !1;const t=this._getCurrentHash();if(t.length>=3&&!t.some((e=>isNaN(e)))){const i=e.dragRotate.isEnabled()&&e.touchZoomRotate.isEnabled()?+(t[3]||0):e.getBearing();return e.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:i,pitch:+(t[4]||0)}),!0}return !1}_updateHashUnthrottled(){const t=e.window.location.href.replace(/(#.+)?$/,this.getHashString());e.window.history.replaceState(e.window.history.state,null,t);}}function er(e,t){const i=e.getCenter(),o=Math.round(100*e.getZoom())/100,r=Math.ceil((o*Math.LN2+Math.log(512/360/.5))/Math.LN10),n=Math.pow(10,r),s=Math.round(i.lng*n)/n,a=Math.round(i.lat*n)/n,l=e.getBearing(),c=e.getPitch();let h=t?`/${s}/${a}/${o}`:`${o}/${a}/${s}`;return (l||c)&&(h+="/"+Math.round(10*l)/10),c&&(h+=`/${Math.round(c)}`),h}const tr={linearity:.3,easing:e.bezier(0,0,.3,1)},ir=e.extend({deceleration:2500,maxSpeed:1400},tr),or=e.extend({deceleration:20,maxSpeed:1400},tr),rr=e.extend({deceleration:1e3,maxSpeed:360},tr),nr=e.extend({deceleration:1e3,maxSpeed:90},tr);class sr{constructor(e){this._map=e,this.clear();}clear(){this._inertiaBuffer=[];}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:e.exported.now(),settings:t});}_drainInertiaBuffer(){const t=this._inertiaBuffer,i=e.exported.now();for(;t.length>0&&i-t[0].time>160;)t.shift();}_onMoveEnd(t){if(e.exported.prefersReducedMotion)return;if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,pan:new e.pointGeometry(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)i.zoom+=e.zoomDelta||0,i.bearing+=e.bearingDelta||0,i.pitch+=e.pitchDelta||0,e.panDelta&&i.pan._add(e.panDelta),e.around&&(i.around=e.around),e.pinchAround&&(i.pinchAround=e.pinchAround);const o=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(i.pan.mag()){const n=lr(i.pan.mag(),o,e.extend({},ir,t||{}));r.offset=i.pan.mult(n.amount/i.pan.mag()),r.center=this._map.transform.center,ar(r,n);}if(i.zoom){const e=lr(i.zoom,o,or);r.zoom=this._map.transform.zoom+e.amount,ar(r,e);}if(i.bearing){const t=lr(i.bearing,o,rr);r.bearing=this._map.transform.bearing+e.clamp(t.amount,-179,179),ar(r,t);}if(i.pitch){const e=lr(i.pitch,o,nr);r.pitch=this._map.transform.pitch+e.amount,ar(r,e);}if(r.zoom||r.bearing){const e=void 0===i.pinchAround?i.around:i.pinchAround;r.around=e?this._map.unproject(e):this._map.getCenter();}return this.clear(),r.noMoveStart=!0,r}}function ar(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing);}function lr(t,i,o){const{maxSpeed:r,linearity:n,deceleration:s}=o,a=e.clamp(t*n/(i/1e3),-r,r),l=Math.abs(a)/(s*n);return {easing:o.easing,duration:1e3*l,amount:a*(l/2)}}class cr extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,o,r={}){const n=p(i.getCanvasContainer(),o),s=i.unproject(n);super(t,e.extend({point:n,lngLat:s,originalEvent:o},r)),this._defaultPrevented=!1,this.target=i;}}class hr extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,o){const r="touchend"===t?o.changedTouches:o.touches,n=m(i.getCanvasContainer(),r),s=n.map((e=>i.unproject(e))),a=n.reduce(((e,t,i,o)=>e.add(t.div(o.length))),new e.pointGeometry(0,0));super(t,{points:n,point:a,lngLats:s,lngLat:i.unproject(a),originalEvent:o}),this._defaultPrevented=!1;}}class ur extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1;}}class _r{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance;}reset(){this._mousedownPos=void 0;}wheel(e){return this._firePreventable(new ur(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new cr(e.type,this._map,e))}mouseup(e){this._map.fire(new cr(e.type,this._map,e));}preclick(t){const i=e.extend({},t);i.type="preclick",this._map.fire(new cr(i.type,this._map,i));}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||(this.preclick(e),this._map.fire(new cr(e.type,this._map,e)));}dblclick(e){return this._firePreventable(new cr(e.type,this._map,e))}mouseover(e){this._map.fire(new cr(e.type,this._map,e));}mouseout(e){this._map.fire(new cr(e.type,this._map,e));}touchstart(e){return this._firePreventable(new hr(e.type,this._map,e))}touchmove(e){this._map.fire(new hr(e.type,this._map,e));}touchend(e){this._map.fire(new hr(e.type,this._map,e));}touchcancel(e){this._map.fire(new hr(e.type,this._map,e));}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class dr{constructor(e){this._map=e;}reset(){this._delayContextMenu=!1,this._contextMenuEvent=void 0;}mousemove(e){this._map.fire(new cr(e.type,this._map,e));}mousedown(){this._delayContextMenu=!0;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new cr("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._map.fire(new cr(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class pr{constructor(e,t){this._map=e,this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(h(),this._startPos=this._lastPos=t,this._active=!0);}mousemoveWindow(e,t){if(!this._active)return;const i=t,o=this._startPos,r=this._lastPos;if(!o||!r||r.equals(i)||!this._box&&i.dist(o)<this._clickTolerance)return;this._lastPos=i,this._box||(this._box=n("div","mapboxgl-boxzoom",this._container),this._container.classList.add("mapboxgl-crosshair"),this._fireEvent("boxzoomstart",e));const s=Math.min(o.x,i.x),a=Math.max(o.x,i.x),l=Math.min(o.y,i.y),c=Math.max(o.y,i.y);this._map._requestDomTask((()=>{this._box&&(this._box.style.transform=`translate(${s}px,${l}px)`,this._box.style.width=a-s+"px",this._box.style.height=c-l+"px");}));}mouseupWindow(t,i){if(!this._active)return;const o=this._startPos,r=i;if(o&&0===t.button){if(this.reset(),d(),o.x!==r.x||o.y!==r.y)return this._map.fire(new e.Event("boxzoomend",{originalEvent:t})),{cameraAnimation:e=>e.fitScreenCoordinates(o,r,this._map.getBearing(),{linear:!1})};this._fireEvent("boxzoomcancel",t);}}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e));}blur(){this.reset();}reset(){this._active=!1,this._container.classList.remove("mapboxgl-crosshair"),this._box&&(this._box.remove(),this._box=null),u(),delete this._startPos,delete this._lastPos;}_fireEvent(t,i){return this._map.fire(new e.Event(t,{originalEvent:i}))}}function mr(e,t){const i={};for(let o=0;o<e.length;o++)i[e[o].identifier]=t[o];return i}class fr{constructor(e){this.reset(),this.numTouches=e.numTouches;}reset(){this.centroid=void 0,this.startTime=0,this.touches={},this.aborted=!1;}touchstart(t,i,o){(this.centroid||o.length>this.numTouches)&&(this.aborted=!0),this.aborted||(0===this.startTime&&(this.startTime=t.timeStamp),o.length===this.numTouches&&(this.centroid=function(t){const i=new e.pointGeometry(0,0);for(const e of t)i._add(e);return i.div(t.length)}(i),this.touches=mr(o,i)));}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const o=mr(i,t);for(const e in this.touches){const t=this.touches[e],i=o[e];(!i||i.dist(t)>30)&&(this.aborted=!0);}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class gr{constructor(e){this.singleTap=new fr(e),this.numTaps=e.numTaps,this.reset();}reset(){this.lastTime=1/0,this.lastTap=void 0,this.count=0,this.singleTap.reset();}touchstart(e,t,i){this.singleTap.touchstart(e,t,i);}touchmove(e,t,i){this.singleTap.touchmove(e,t,i);}touchend(e,t,i){const o=this.singleTap.touchend(e,t,i);if(o){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(o)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=o,this.count===this.numTaps)return this.reset(),o}}}class vr{constructor(){this._zoomIn=new gr({numTouches:1,numTaps:2}),this._zoomOut=new gr({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i);}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i);}touchend(e,t,i){const o=this._zoomIn.touchend(e,t,i),r=this._zoomOut.touchend(e,t,i);return o?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()+1,around:t.unproject(o)},{originalEvent:e})}):r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()-1,around:t.unproject(r)},{originalEvent:e})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}const xr={0:1,2:2};class yr{constructor(e){this.reset(),this._clickTolerance=e.clickTolerance||1;}blur(){this.reset();}reset(){this._active=!1,this._moved=!1,this._lastPoint=void 0,this._eventButton=void 0;}_correctButton(e,t){return !1}_move(e,t){return {}}mousedown(e,t){if(this._lastPoint)return;const i=f(e);this._correctButton(e,i)&&(this._lastPoint=t,this._eventButton=i);}mousemoveWindow(e,t){const i=this._lastPoint;if(i)if(e.preventDefault(),null!=this._eventButton&&function(e,t){const i=xr[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton))this.reset();else if(this._moved||!(t.dist(i)<this._clickTolerance))return this._moved=!0,this._lastPoint=t,this._move(i,t)}mouseupWindow(e){this._lastPoint&&f(e)===this._eventButton&&(this._moved&&d(),this.reset());}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class br extends yr{mousedown(e,t){super.mousedown(e,t),this._lastPoint&&(this._active=!0);}_correctButton(e,t){return 0===t&&!e.ctrlKey}_move(e,t){return {around:t,panDelta:t.sub(e)}}}class wr extends yr{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=.8*(t.x-e.x);if(i)return this._active=!0,{bearingDelta:i}}contextmenu(e){e.preventDefault();}}class Tr extends yr{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=-.5*(t.y-e.y);if(i)return this._active=!0,{pitchDelta:i}}contextmenu(e){e.preventDefault();}}class Er{constructor(t,i){this._map=t,this._el=t.getCanvasContainer(),this._minTouches=1,this._clickTolerance=i.clickTolerance||1,this.reset(),e.bindAll(["_addTouchPanBlocker","_showTouchPanBlockerAlert"],this);}reset(){this._active=!1,this._touches={},this._sum=new e.pointGeometry(0,0);}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(t,i,o){if(this._active&&!(o.length<this._minTouches)){if(this._map._cooperativeGestures&&!this._map.isMoving()){if(1===o.length&&!e.isFullscreen())return void this._showTouchPanBlockerAlert();"hidden"!==this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="hidden",clearTimeout(this._alertTimer));}return t.cancelable&&t.preventDefault(),this._calculateTransform(t,i,o)}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&i.length<this._minTouches&&this.reset();}touchcancel(){this.reset();}_calculateTransform(t,i,o){o.length>0&&(this._active=!0);const r=mr(o,i),n=new e.pointGeometry(0,0),s=new e.pointGeometry(0,0);let a=0;for(const e in r){const t=r[e],i=this._touches[e];i&&(n._add(t),s._add(t.sub(i)),a++,r[e]=t);}if(this._touches=r,a<this._minTouches||!s.mag())return;const l=s.div(a);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(a),panDelta:l}}enable(){this._enabled=!0,this._map._cooperativeGestures&&(this._addTouchPanBlocker(),this._el.classList.add("mapboxgl-touch-pan-blocker-override","mapboxgl-scrollable-page"));}disable(){this._enabled=!1,this._map._cooperativeGestures&&(clearTimeout(this._alertTimer),this._alertContainer.remove(),this._el.classList.remove("mapboxgl-touch-pan-blocker-override","mapboxgl-scrollable-page")),this.reset();}isEnabled(){return !!this._enabled}isActive(){return !!this._active}_addTouchPanBlocker(){this._map&&!this._alertContainer&&(this._alertContainer=n("div","mapboxgl-touch-pan-blocker",this._map._container),this._alertContainer.textContent=this._map._getUIString("TouchPanBlocker.Message"),this._alertContainer.style.fontSize=`${Math.max(10,Math.min(24,Math.floor(.05*this._el.clientWidth)))}px`);}_showTouchPanBlockerAlert(){this._alertContainer.style.visibility="visible",this._alertContainer.classList.add("mapboxgl-touch-pan-blocker-show"),this._alertContainer.setAttribute("role","alert"),clearTimeout(this._alertTimer),this._alertTimer=setTimeout((()=>{this._alertContainer.classList.remove("mapboxgl-touch-pan-blocker-show"),this._alertContainer.setAttribute("role","null");}),500);}}class Cr{constructor(){this.reset();}reset(){this._active=!1,this._firstTwoTouches=void 0;}_start(e){}_move(e,t,i){return {}}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]));}touchmove(e,t,i){const o=this._firstTwoTouches;if(!o)return;e.preventDefault();const[r,n]=o,s=Mr(i,t,r),a=Mr(i,t,n);if(!s||!a)return;const l=this._aroundCenter?null:s.add(a).div(2);return this._move([s,a],l,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[o,r]=this._firstTwoTouches,n=Mr(i,t,o),s=Mr(i,t,r);n&&s||(this._active&&d(),this.reset());}touchcancel(){this.reset();}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}function Mr(e,t,i){for(let o=0;o<e.length;o++)if(e[o].identifier===i)return t[o]}function Ir(e,t){return Math.log(e/t)/Math.LN2}class Sr extends Cr{reset(){super.reset(),this._distance=0,this._startDistance=0;}_start(e){this._startDistance=this._distance=e[0].dist(e[1]);}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(Ir(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Ir(this._distance,i),pinchAround:t}}}function Dr(e,t){return 180*e.angleWith(t)/Math.PI}class Lr extends Cr{reset(){super.reset(),this._minDiameter=0,this._startVector=void 0,this._vector=void 0;}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1]);}_move(e,t){const i=this._vector;if(this._vector=e[0].sub(e[1]),i&&(this._active||!this._isBelowThreshold(this._vector)))return this._active=!0,{bearingDelta:Dr(this._vector,i),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=this._startVector;if(!i)return !1;const o=Dr(e,i);return Math.abs(o)<t}}function Ar(e){return Math.abs(e.y)>Math.abs(e.x)}class zr extends Cr{constructor(e){super(),this._map=e;}reset(){super.reset(),this._valid=void 0,this._firstMove=void 0,this._lastPoints=void 0;}_start(e){this._lastPoints=e,Ar(e[0].sub(e[1]))&&(this._valid=!1);}_move(t,i,o){const r=this._lastPoints;if(!r)return;const n=t[0].sub(r[0]),s=t[1].sub(r[1]);return this._map._cooperativeGestures&&!e.isFullscreen()&&o.touches.length<3||(this._valid=this.gestureBeginsVertically(n,s,o.timeStamp),!this._valid)?void 0:(this._lastPoints=t,this._active=!0,{pitchDelta:(n.y+s.y)/2*-.5})}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const o=e.mag()>=2,r=t.mag()>=2;if(!o&&!r)return;if(!o||!r)return null==this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const n=e.y>0==t.y>0;return Ar(e)&&Ar(t)&&n}}const Pr={panStep:100,bearingStep:15,pitchStep:10};class Rr{constructor(){const e=Pr;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1;}blur(){this.reset();}reset(){this._active=!1;}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,o=0,r=0,n=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),r=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),r=1);break;case 38:e.shiftKey?o=1:(e.preventDefault(),n=-1);break;case 40:e.shiftKey?o=-1:(e.preventDefault(),n=1);break;default:return}return this._rotationDisabled&&(i=0,o=0),{cameraAnimation:s=>{const a=s.getZoom();s.easeTo({duration:300,easeId:"keyboardHandler",easing:Or,zoom:t?Math.round(a)+t*(e.shiftKey?2:1):a,bearing:s.getBearing()+i*this._bearingStep,pitch:s.getPitch()+o*this._pitchStep,offset:[-r*this._panStep,-n*this._panStep],center:s.getCenter()},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function Or(e){return e*(2-e)}const Br=4.000244140625;class kr{constructor(t,i){this._map=t,this._el=t.getCanvasContainer(),this._handler=i,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222,e.bindAll(["_onTimeout","_addScrollZoomBlocker","_showBlockerAlert"],this);}setZoomRate(e){this._defaultZoomRate=e;}setWheelZoomRate(e){this._wheelZoomRate=e;}isEnabled(){return !!this._enabled}isActive(){return this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around,this._map._cooperativeGestures&&this._addScrollZoomBlocker());}disable(){this.isEnabled()&&(this._enabled=!1,this._map._cooperativeGestures&&(clearTimeout(this._alertTimer),this._alertContainer.remove()));}wheel(t){if(!this.isEnabled())return;if(this._map._cooperativeGestures){if(!(t.ctrlKey||t.metaKey||this.isZooming()||e.isFullscreen()))return void this._showBlockerAlert();"hidden"!==this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="hidden",clearTimeout(this._alertTimer));}let i=t.deltaMode===e.window.WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const o=e.exported.now(),r=o-(this._lastWheelEventTime||0);this._lastWheelEventTime=o,0!==i&&i%Br==0?this._type="wheel":0!==i&&Math.abs(i)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=i,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(r*i)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,i+=this._lastValue)),t.shiftKey&&i&&(i/=4),this._type&&(this._lastWheelEvent=t,this._delta-=i,this._active||this._start(t)),t.preventDefault();}_onTimeout(e){this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e);}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const t=p(this._el,e);this._aroundPoint=this._aroundCenter?this._map.transform.centerPoint:t,this._aroundCoord=this._map.transform.pointCoordinate3D(this._aroundPoint),this._targetZoom=void 0,this._frameId||(this._frameId=!0,this._handler._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._map.transform;"wheel"===this._type&&t.projection.wrap&&(t._center.lng>=180||t._center.lng<=-180)&&(this._prevEase=null,this._easing=null,this._lastWheelEvent=null,this._lastWheelEventTime=0);const i=()=>t._terrainEnabled()&&this._aroundCoord?t.computeZoomRelativeTo(this._aroundCoord):t.zoom;if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>Br?this._wheelZoomRate:this._defaultZoomRate;let o=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==o&&(o=1/o);const r=i(),n=Math.pow(2,r),s="number"==typeof this._targetZoom?t.zoomScale(this._targetZoom):n;this._targetZoom=Math.min(t.maxZoom,Math.max(t.minZoom,t.scaleZoom(s*o))),"wheel"===this._type&&(this._startZoom=r,this._easing=this._smoothOutEasing(200)),this._delta=0;}const o="number"==typeof this._targetZoom?this._targetZoom:i(),r=this._startZoom,n=this._easing;let s,a=!1;if("wheel"===this._type&&r&&n){const t=Math.min((e.exported.now()-this._lastWheelEventTime)/200,1),i=n(t);s=e.number(r,o,i),t<1?this._frameId||(this._frameId=!0):a=!0;}else s=o,a=!0;return this._active=!0,a&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._handler._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout;}),200)),{noInertia:!0,needsRenderFrame:!a,zoomDelta:s-i(),around:this._aroundPoint,aroundCoord:this._aroundCoord,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let i=e.ease;if(this._prevEase){const t=this._prevEase,o=(e.exported.now()-t.start)/t.duration,r=t.easing(o+.01)-t.easing(o),n=.27/Math.sqrt(r*r+1e-4)*.01,s=Math.sqrt(.0729-n*n);i=e.bezier(n,s,.25,1);}return this._prevEase={start:e.exported.now(),duration:t,easing:i},i}blur(){this.reset();}reset(){this._active=!1;}_addScrollZoomBlocker(){this._map&&!this._alertContainer&&(this._alertContainer=n("div","mapboxgl-scroll-zoom-blocker",this._map._container),this._alertContainer.textContent=/(Mac|iPad)/i.test(e.window.navigator.userAgent)?this._map._getUIString("ScrollZoomBlocker.CmdMessage"):this._map._getUIString("ScrollZoomBlocker.CtrlMessage"),this._alertContainer.style.fontSize=`${Math.max(10,Math.min(24,Math.floor(.05*this._el.clientWidth)))}px`);}_showBlockerAlert(){this._alertContainer.style.visibility="visible",this._alertContainer.classList.add("mapboxgl-scroll-zoom-blocker-show"),this._alertContainer.setAttribute("role","alert"),clearTimeout(this._alertTimer),this._alertTimer=setTimeout((()=>{this._alertContainer.classList.remove("mapboxgl-scroll-zoom-blocker-show"),this._alertContainer.setAttribute("role","null");}),200);}}class Fr{constructor(e,t){this._clickZoom=e,this._tapZoom=t;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class Ur{constructor(){this.reset();}reset(){this._active=!1;}blur(){this.reset();}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:i.getZoom()+(e.shiftKey?-1:1),around:i.unproject(t)},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Nr{constructor(){this._tap=new gr({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,this._swipePoint=void 0,this._swipeTouch=0,this._tapTime=0,this._tap.reset();}touchstart(e,t,i){this._swipePoint||(this._tapTime&&e.timeStamp-this._tapTime>500&&this.reset(),this._tapTime?i.length>0&&(this._swipePoint=t[0],this._swipeTouch=i[0].identifier):this._tap.touchstart(e,t,i));}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const o=t[0],r=o.y-this._swipePoint.y;return this._swipePoint=o,e.preventDefault(),this._active=!0,{zoomDelta:r/128}}}else this._tap.touchmove(e,t,i);}touchend(e,t,i){this._tapTime?this._swipePoint&&0===i.length&&this.reset():this._tap.touchend(e,t,i)&&(this._tapTime=e.timeStamp);}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Gr{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i;}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("mapboxgl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("mapboxgl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class jr{constructor(e,t,i){this._pitchWithRotate=e.pitchWithRotate,this._mouseRotate=t,this._mousePitch=i;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class Zr{constructor(e,t,i,o){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=o,this._rotationDisabled=!1,this._enabled=!0;}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("mapboxgl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("mapboxgl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}const Vr=e=>e.zoom||e.drag||e.pitch||e.rotate;class Wr extends e.Event{}class Xr{constructor(){this.constants=[1,1,.01],this.radius=0;}setup(t,i){const o=e.sub([],i,t);this.radius=e.length(o[2]<0?e.div([],o,this.constants):[o[0],o[1],0]);}projectRay(t){e.div(t,t,this.constants),e.normalize(t,t),e.mul$1(t,t,this.constants);const i=e.scale$2([],t,this.radius);if(i[2]>0){const t=e.scale$2([],[0,0,1],e.dot(i,[0,0,1])),o=e.scale$2([],e.normalize([],[i[0],i[1],0]),this.radius),r=e.add([],i,e.scale$2([],e.sub([],e.add([],o,t),i),2));i[0]=r[0],i[1]=r[1];}return i}}function qr(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta}class $r{constructor(t,i){this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new sr(t),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._trackingEllipsoid=new Xr,this._dragOrigin=null,this._eventsInProgress={},this._addDefaultHandlers(i),e.bindAll(["handleEvent","handleWindowEvent"],this);const o=this._el;this._listeners=[[o,"touchstart",{passive:!0}],[o,"touchmove",{passive:!1}],[o,"touchend",void 0],[o,"touchcancel",void 0],[o,"mousedown",void 0],[o,"mousemove",void 0],[o,"mouseup",void 0],[e.window.document,"mousemove",{capture:!0}],[e.window.document,"mouseup",void 0],[o,"mouseover",void 0],[o,"mouseout",void 0],[o,"dblclick",void 0],[o,"click",void 0],[o,"keydown",{capture:!1}],[o,"keyup",void 0],[o,"wheel",{passive:!1}],[o,"contextmenu",void 0],[e.window,"blur",void 0]];for(const[t,i,o]of this._listeners)t.addEventListener(i,t===e.window.document?this.handleWindowEvent:this.handleEvent,o);}destroy(){for(const[t,i,o]of this._listeners)t.removeEventListener(i,t===e.window.document?this.handleWindowEvent:this.handleEvent,o);}_addDefaultHandlers(e){const t=this._map,i=t.getCanvasContainer();this._add("mapEvent",new _r(t,e));const o=t.boxZoom=new pr(t,e);this._add("boxZoom",o);const r=new vr,n=new Ur;t.doubleClickZoom=new Fr(n,r),this._add("tapZoom",r),this._add("clickZoom",n);const s=new Nr;this._add("tapDragZoom",s);const a=t.touchPitch=new zr(t);this._add("touchPitch",a);const l=new wr(e),c=new Tr(e);t.dragRotate=new jr(e,l,c),this._add("mouseRotate",l,["mousePitch"]),this._add("mousePitch",c,["mouseRotate"]);const h=new br(e),u=new Er(t,e);t.dragPan=new Gr(i,h,u),this._add("mousePan",h),this._add("touchPan",u,["touchZoom","touchRotate"]);const _=new Lr,d=new Sr;t.touchZoomRotate=new Zr(i,d,_,s),this._add("touchRotate",_,["touchPan","touchZoom"]),this._add("touchZoom",d,["touchPan","touchRotate"]),this._add("blockableMapEvent",new dr(t));const p=t.scrollZoom=new kr(t,this);this._add("scrollZoom",p,["mousePan"]);const m=t.keyboard=new Rr;this._add("keyboard",m);for(const i of ["boxZoom","doubleClickZoom","tapDragZoom","touchPitch","dragRotate","dragPan","touchZoomRotate","scrollZoom","keyboard"])e.interactive&&e[i]&&t[i].enable(e[i]);}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t;}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[];}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return !!Vr(this._eventsInProgress)||this.isZooming()}_isDragging(){return !!this._eventsInProgress.drag}_blockedByActive(e,t,i){for(const o in e)if(o!==i&&(!t||t.indexOf(o)<0))return !0;return !1}handleWindowEvent(e){this.handleEvent(e,`${e.type}Window`);}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}handleEvent(e,t){this._updatingCamera=!0;const i="renderFrame"===e.type,o=i?void 0:e,r={needsRenderFrame:!1},n={},s={},a=e.touches?this._getMapTouches(e.touches):void 0,l=a?m(this._el,a):i?void 0:p(this._el,e);for(const{handlerName:i,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;this._blockedByActive(s,h,i)?c.reset():c[t||e.type]&&(u=c[t||e.type](e,l,a),this.mergeHandlerResult(r,n,u,i,o),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||c.isActive())&&(s[i]=c);}const c={};for(const e in this._previousActiveHandlers)s[e]||(c[e]=o);this._previousActiveHandlers=s,(Object.keys(c).length||qr(r))&&(this._changes.push([r,n,c]),this._triggerRenderFrame()),(Object.keys(s).length||qr(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:h}=r;h&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],h(this._map));}mergeHandlerResult(t,i,o,r,n){if(!o)return;e.extend(t,o);const s={handlerName:r,originalEvent:o.originalEvent||n};void 0!==o.zoomDelta&&(i.zoom=s),void 0!==o.panDelta&&(i.drag=s),void 0!==o.pitchDelta&&(i.pitch=s),void 0!==o.bearingDelta&&(i.rotate=s);}_applyChanges(){const t={},i={},o={};for(const[r,n,s]of this._changes)r.panDelta&&(t.panDelta=(t.panDelta||new e.pointGeometry(0,0))._add(r.panDelta)),r.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+r.pitchDelta),void 0!==r.around&&(t.around=r.around),void 0!==r.aroundCoord&&(t.aroundCoord=r.aroundCoord),void 0!==r.pinchAround&&(t.pinchAround=r.pinchAround),r.noInertia&&(t.noInertia=r.noInertia),e.extend(i,n),e.extend(o,s);this._updateMapTransform(t,i,o),this._changes=[];}_updateMapTransform(t,i,o){const r=this._map,n=r.transform,s=e=>[e.x,e.y,e.z];if((e=>{const t=this._eventsInProgress.drag;return t&&!this._handlersById[t.handlerName].isActive()})()&&!qr(t)){const e=n.zoom;n.cameraElevationReference="sea",n.recenterOnTerrain(),n.cameraElevationReference="ground",e!==n.zoom&&this._map._update(!0);}if(n._isCameraConstrained&&r._stop(!0),!qr(t))return void this._fireEvents(i,o,!0);let{panDelta:a,zoomDelta:l,bearingDelta:c,pitchDelta:h,around:u,aroundCoord:_,pinchAround:d}=t;n._isCameraConstrained&&(l>0&&(l=0),n._isCameraConstrained=!1),void 0!==d&&(u=d),(l||(e=>i.drag&&!this._eventsInProgress.drag)())&&u&&(this._dragOrigin=s(n.pointCoordinate3D(u)),this._trackingEllipsoid.setup(n._camera.position,this._dragOrigin)),n.cameraElevationReference="sea",r._stop(!0),u=u||r.transform.centerPoint,c&&(n.bearing+=c),h&&(n.pitch+=h),n._updateCameraState();const p=[0,0,0];if(a)if("mercator"===n.projection.name){const e=this._trackingEllipsoid.projectRay(n.screenPointToMercatorRay(u).dir),t=this._trackingEllipsoid.projectRay(n.screenPointToMercatorRay(u.sub(a)).dir);p[0]=t[0]-e[0],p[1]=t[1]-e[1];}else {const t=n.pointCoordinate(u);if("globe"===n.projection.name){a=a.rotate(-n.angle);const i=n._pixelsPerMercatorPixel/n.worldSize;p[0]=-a.x*e.mercatorScale(e.latFromMercatorY(t.y))*i,p[1]=-a.y*e.mercatorScale(n.center.lat)*i;}else {const e=n.pointCoordinate(u.sub(a));t&&e&&(p[0]=e.x-t.x,p[1]=e.y-t.y);}}const m=n.zoom,f=[0,0,0];if(l){const t=s(_||n.pointCoordinate3D(u)),i={dir:e.normalize([],e.sub([],t,n._camera.position))};if(i.dir[2]<0){const o=n.zoomDeltaToMovement(t,l);e.scale$2(f,i.dir,o);}}const g=e.add(p,p,f);n._translateCameraConstrained(g),l&&Math.abs(n.zoom-m)>1e-4&&n.recenterOnTerrain(),n.cameraElevationReference="ground",this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(i,o,!0);}_fireEvents(t,i,o){const r=Vr(this._eventsInProgress),n=Vr(t),s={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(s[`${e}start`]=i),this._eventsInProgress[e]=t[e];}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const e in s)this._fireEvent(e,s[e]);n&&this._fireEvent("move",n.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i);}const a={};let l;for(const e in this._eventsInProgress){const{handlerName:t,originalEvent:o}=this._eventsInProgress[e];this._handlersById[t].isActive()||(delete this._eventsInProgress[e],l=i[t]||o,a[`${e}end`]=l);}for(const e in a)this._fireEvent(e,a[e]);const c=Vr(this._eventsInProgress);if(o&&(r||n)&&!c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;t?(i(t.bearing||this._map.getBearing())&&(t.bearing=0),this._map.easeTo(t,{originalEvent:l})):(this._map.fire(new e.Event("moveend",{originalEvent:l})),i(this._map.getBearing())&&this._map.resetNorth()),this._updatingCamera=!1;}}_fireEvent(t,i){this._map.fire(new e.Event(t,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{this._frameId=void 0,this.handleEvent(new Wr("renderFrame",{timeStamp:e})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}const Hr="map.setFreeCameraOptions(...) and map.getFreeCameraOptions() are not yet supported for non-mercator projections.";class Yr extends e.Evented{constructor(t,i){super(),this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=i.bearingSnap,e.bindAll(["_renderFrameCallback"],this);}getCenter(){return new e.LngLat(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}panBy(t,i,o){return t=e.pointGeometry.convert(t).mult(-1),this.panTo(this.transform.center,e.extend({offset:t},i),o)}panTo(t,i,o){return this.easeTo(e.extend({center:t},i),o)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(t,i,o){return this.easeTo(e.extend({zoom:t},i),o)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(t,i,o){return this.easeTo(e.extend({bearing:t},i),o)}resetNorth(t,i){return this.rotateTo(0,e.extend({duration:1e3},t),i),this}resetNorthPitch(t,i){return this.easeTo(e.extend({bearing:0,pitch:0,duration:1e3},t),i),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}cameraForBounds(t,i){t=e.LngLatBounds.convert(t);const o=i&&i.bearing||0,r=i&&i.pitch||0,n=t.getNorthWest(),s=t.getSouthEast();return this._cameraForBounds(this.transform,n,s,o,r,i)}_extendCameraOptions(t){const i={top:0,bottom:0,right:0,left:0};if("number"==typeof(t=e.extend({padding:i,offset:[0,0],maxZoom:this.transform.maxZoom},t)).padding){const e=t.padding;t.padding={top:e,bottom:e,right:e,left:e};}return t.padding=e.extend(i,t.padding),t}_minimumAABBFrustumDistance(e,t){const i=t.max[0]-t.min[0],o=t.max[1]-t.min[1];return i/o>e.aspect?i/(2*Math.tan(.5*e.fovX)*e.aspect):o/(2*Math.tan(.5*e.fovY)*e.aspect)}_cameraForBoundsOnGlobe(t,i,o,r,n,s){const a=t.clone(),l=this._extendCameraOptions(s);a.bearing=r,a.pitch=n;const c=e.LngLat.convert(i),h=e.LngLat.convert(o),u=.5*(c.lat+h.lat),_=.5*(c.lng+h.lng),d=e.latLngToECEF(u,_),p=e.normalize([],d),m=e.normalize([],e.cross([],p,[0,1,0])),f=e.cross([],m,p),g=[m[0],m[1],m[2],0,f[0],f[1],f[2],0,p[0],p[1],p[2],0,0,0,0,1],v=[d,e.latLngToECEF(c.lat,c.lng),e.latLngToECEF(h.lat,c.lng),e.latLngToECEF(h.lat,h.lng),e.latLngToECEF(c.lat,h.lng),e.latLngToECEF(u,c.lng),e.latLngToECEF(u,h.lng),e.latLngToECEF(c.lat,_),e.latLngToECEF(h.lat,_)];let x=e.Aabb.fromPoints(v.map((t=>[e.dot(m,t),e.dot(f,t),e.dot(p,t)])));const y=e.transformMat4([],x.center,g);0===e.squaredLength(y)&&e.set(y,0,0,1),e.normalize(y,y),e.scale$2(y,y,e.GLOBE_RADIUS),a.center=e.ecefToLatLng(y);const b=a.getWorldToCameraMatrix(),w=e.invert(new Float64Array(16),b);x=e.Aabb.applyTransform(x,e.multiply([],b,g)),e.transformMat4(y,y,b);const T=.5*(x.max[2]-x.min[2]),E=this._minimumAABBFrustumDistance(a,x),C=e.scale$2([],[0,0,1],T),M=e.add(C,y,C),I=E+(0===a.pitch?0:e.distance(y,M)),S=a.globeCenterInViewSpace,D=e.sub([],y,[S[0],S[1],S[2]]);e.normalize(D,D),e.scale$2(D,D,I);const L=e.add([],y,D);e.transformMat4(L,L,w);const A=e.earthRadius/e.GLOBE_RADIUS,z=e.length(L),P=e.mercatorZfromAltitude(Math.max(z*A-e.earthRadius,Number.EPSILON),0),R=Math.min(a.zoomFromMercatorZAdjusted(P),l.maxZoom);return R>.5*(e.GLOBE_ZOOM_THRESHOLD_MIN+e.GLOBE_ZOOM_THRESHOLD_MAX)?(a.setProjection({name:"mercator"}),a.zoom=R,this._cameraForBounds(a,i,o,r,n,s)):{center:a.center,zoom:R,bearing:r,pitch:n}}queryTerrainElevation(t,i){const o=this.transform.elevation;return o?(i=e.extend({},{exaggerated:!0},i),o.getAtPoint(e.MercatorCoordinate.fromLngLat(t),null,i.exaggerated)):null}_cameraForBounds(t,i,o,r,n,s){if("globe"===t.projection.name)return this._cameraForBoundsOnGlobe(t,i,o,r,n,s);const a=t.clone(),l=this._extendCameraOptions(s),c=a.padding;a.bearing=r,a.pitch=n;const h=e.LngLat.convert(i),u=e.LngLat.convert(o),_=new e.LngLat(h.lng,u.lat),d=new e.LngLat(u.lng,h.lat),p=a.project(h),m=a.project(u),f=this.queryTerrainElevation(h),g=this.queryTerrainElevation(u),v=this.queryTerrainElevation(_),x=this.queryTerrainElevation(d),y=[[p.x,p.y,Math.min(f||0,g||0,v||0,x||0)],[m.x,m.y,Math.max(f||0,g||0,v||0,x||0)]];let b=e.Aabb.fromPoints(y);const w=a.getWorldToCameraMatrix(),T=e.invert(new Float64Array(16),w);b=e.Aabb.applyTransform(b,w);const E=e.sub([],b.max,b.min),C=c.left||0,M=c.right||0,I=c.bottom||0,S=c.top||0,{left:D,right:L,top:A,bottom:z}=l.padding,P=.5*(C+M),R=.5*(S+I),O=Math.min(a.scaleZoom(a.scale*Math.min((a.width-(C+M+D+L))/E[0],(a.height-(I+S+z+A))/E[1])),l.maxZoom),B=a.scale/a.zoomScale(O);b=new e.Aabb([b.min[0]-(D+P)*B,b.min[1]-(z+R)*B,b.min[2]],[b.max[0]+(L+P)*B,b.max[1]+(A+R)*B,b.max[2]]);const k=.5*E[2],F=this._minimumAABBFrustumDistance(a,b),U=[0,0,1,0];e.transformMat4$1(U,U,w),e.normalize$2(U,U);const N=e.scale$2([],U,F+k),G=e.add([],b.center,N),j=("number"==typeof l.offset.x&&"number"==typeof l.offset.y?new e.pointGeometry(l.offset.x,l.offset.y):e.pointGeometry.convert(l.offset)).rotate(-e.degToRad(r));b.center[0]-=j.x*B,b.center[1]+=j.y*B,e.transformMat4(b.center,b.center,T),e.transformMat4(G,G,T);const Z=[b.center[0],b.center[1],G[2]*a.pixelsPerMeter];e.scale$2(Z,Z,1/a.worldSize);const V=e.lngFromMercatorX(Z[0]),W=e.latFromMercatorY(Z[1]),X=Math.min(a._zoomFromMercatorZ(Z[2]),l.maxZoom),q=new e.LngLat(V,W);return a.mercatorFromTransition&&X<.5*(e.GLOBE_ZOOM_THRESHOLD_MIN+e.GLOBE_ZOOM_THRESHOLD_MAX)?(a.setProjection({name:"globe"}),a.zoom=X,this._cameraForBounds(a,i,o,r,n,s)):{center:q,zoom:X,bearing:r,pitch:n}}fitBounds(e,t,i){const o=this.cameraForBounds(e,t);return this._fitInternal(o,t,i)}fitScreenCoordinates(t,i,o,r,n){const s=e.pointGeometry.convert(t),a=e.pointGeometry.convert(i),l=new e.pointGeometry(Math.min(s.x,a.x),Math.min(s.y,a.y)),c=new e.pointGeometry(Math.max(s.x,a.x),Math.max(s.y,a.y));if("mercator"===this.transform.projection.name&&this.transform.anyCornerOffEdge(s,a))return this;const h=this.transform.pointLocation3D(l),u=this.transform.pointLocation3D(c),_=this.transform.pointLocation3D(new e.pointGeometry(l.x,c.y)),d=this.transform.pointLocation3D(new e.pointGeometry(c.x,l.y)),p=[Math.min(h.lng,u.lng,_.lng,d.lng),Math.min(h.lat,u.lat,_.lat,d.lat)],m=[Math.max(h.lng,u.lng,_.lng,d.lng),Math.max(h.lat,u.lat,_.lat,d.lat)],f=r&&r.pitch?r.pitch:this.getPitch(),g=this._cameraForBounds(this.transform,p,m,o,f,r);return this._fitInternal(g,r,n)}_fitInternal(t,i,o){return t?(delete(i=e.extend(t,i)).padding,i.linear?this.easeTo(i,o):this.flyTo(i,o)):this}jumpTo(t,i){this.stop();const o=t.preloadOnly?this.transform.clone():this.transform;let r=!1,n=!1,s=!1;return "zoom"in t&&o.zoom!==+t.zoom&&(r=!0,o.zoom=+t.zoom),void 0!==t.center&&(o.center=e.LngLat.convert(t.center)),"bearing"in t&&o.bearing!==+t.bearing&&(n=!0,o.bearing=+t.bearing),"pitch"in t&&o.pitch!==+t.pitch&&(s=!0,o.pitch=+t.pitch),null==t.padding||o.isPaddingEqual(t.padding)||(o.padding=t.padding),t.preloadOnly?(this._preloadTiles(o),this):(this.fire(new e.Event("movestart",i)).fire(new e.Event("move",i)),r&&this.fire(new e.Event("zoomstart",i)).fire(new e.Event("zoom",i)).fire(new e.Event("zoomend",i)),n&&this.fire(new e.Event("rotatestart",i)).fire(new e.Event("rotate",i)).fire(new e.Event("rotateend",i)),s&&this.fire(new e.Event("pitchstart",i)).fire(new e.Event("pitch",i)).fire(new e.Event("pitchend",i)),this.fire(new e.Event("moveend",i)))}getFreeCameraOptions(){return this.transform.projection.supportsFreeCamera||e.warnOnce(Hr),this.transform.getFreeCameraOptions()}setFreeCameraOptions(t,i){const o=this.transform;if(!o.projection.supportsFreeCamera)return e.warnOnce(Hr),this;this.stop();const r=o.zoom,n=o.pitch,s=o.bearing;o.setFreeCameraOptions(t);const a=r!==o.zoom,l=n!==o.pitch,c=s!==o.bearing;return this.fire(new e.Event("movestart",i)).fire(new e.Event("move",i)),a&&this.fire(new e.Event("zoomstart",i)).fire(new e.Event("zoom",i)).fire(new e.Event("zoomend",i)),c&&this.fire(new e.Event("rotatestart",i)).fire(new e.Event("rotate",i)).fire(new e.Event("rotateend",i)),l&&this.fire(new e.Event("pitchstart",i)).fire(new e.Event("pitch",i)).fire(new e.Event("pitchend",i)),this.fire(new e.Event("moveend",i)),this}easeTo(t,i){this._stop(!1,t.easeId),(!1===(t=e.extend({offset:[0,0],duration:500,easing:e.ease},t)).animate||!t.essential&&e.exported.prefersReducedMotion)&&(t.duration=0);const o=this.transform,r=this.getZoom(),n=this.getBearing(),s=this.getPitch(),a=this.getPadding(),l="zoom"in t?+t.zoom:r,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,h="pitch"in t?+t.pitch:s,u="padding"in t?t.padding:o.padding,_=e.pointGeometry.convert(t.offset);let d,p,m;if("globe"===o.projection.name){const i=e.MercatorCoordinate.fromLngLat(o.center),r=_.rotate(-o.angle);i.x+=r.x/o.worldSize,i.y+=r.y/o.worldSize;const n=i.toLngLat(),s=e.LngLat.convert(t.center||n);this._normalizeCenter(s),d=o.centerPoint.add(r),p=new e.pointGeometry(i.x,i.y).mult(o.worldSize),m=new e.pointGeometry(e.mercatorXfromLng(s.lng),e.mercatorYfromLat(s.lat)).mult(o.worldSize).sub(p);}else {d=o.centerPoint.add(_);const i=o.pointLocation(d),r=e.LngLat.convert(t.center||i);this._normalizeCenter(r),p=o.project(i),m=o.project(r).sub(p);}const f=o.zoomScale(l-r);let g,v;t.around&&(g=e.LngLat.convert(t.around),v=o.locationPoint(g));const x=this._zooming||l!==r,y=this._rotating||n!==c,b=this._pitching||h!==s,w=!o.isPaddingEqual(u),T=o=>T=>{if(x&&(o.zoom=e.number(r,l,T)),y&&(o.bearing=e.number(n,c,T)),b&&(o.pitch=e.number(s,h,T)),w&&(o.interpolatePadding(a,u,T),d=o.centerPoint.add(_)),g)o.setLocationAtPoint(g,v);else {const e=o.zoomScale(o.zoom-r),t=l>r?Math.min(2,f):Math.max(.5,f),i=Math.pow(t,1-T),n=o.unproject(p.add(m.mult(T*i)).mult(e));o.setLocationAtPoint(o.renderWorldCopies?n.wrap():n,d);}return t.preloadOnly||this._fireMoveEvents(i),o};if(t.preloadOnly){const e=this._emulate(T,t.duration,o);return this._preloadTiles(e),this}const E={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=x,this._rotating=y,this._pitching=b,this._padding=w,this._easeId=t.easeId,this._prepareEase(i,t.noMoveStart,E),this._ease(T(o),(e=>{o.recenterOnTerrain(),this._afterEase(i,e);}),t),this}_prepareEase(t,i,o={}){this._moving=!0,this.transform.cameraElevationReference="sea",i||o.moving||this.fire(new e.Event("movestart",t)),this._zooming&&!o.zooming&&this.fire(new e.Event("zoomstart",t)),this._rotating&&!o.rotating&&this.fire(new e.Event("rotatestart",t)),this._pitching&&!o.pitching&&this.fire(new e.Event("pitchstart",t));}_fireMoveEvents(t){this.fire(new e.Event("move",t)),this._zooming&&this.fire(new e.Event("zoom",t)),this._rotating&&this.fire(new e.Event("rotate",t)),this._pitching&&this.fire(new e.Event("pitch",t));}_afterEase(t,i){if(this._easeId&&i&&this._easeId===i)return;this._easeId=void 0,this.transform.cameraElevationReference="ground";const o=this._zooming,r=this._rotating,n=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,o&&this.fire(new e.Event("zoomend",t)),r&&this.fire(new e.Event("rotateend",t)),n&&this.fire(new e.Event("pitchend",t)),this.fire(new e.Event("moveend",t));}flyTo(t,i){if(!t.essential&&e.exported.prefersReducedMotion){const o=e.pick(t,["center","zoom","bearing","pitch","around"]);return this.jumpTo(o,i)}this.stop(),t=e.extend({offset:[0,0],speed:1.2,curve:1.42,easing:e.ease},t);const o=this.transform,r=this.getZoom(),n=this.getBearing(),s=this.getPitch(),a=this.getPadding(),l="zoom"in t?e.clamp(+t.zoom,o.minZoom,o.maxZoom):r,c="bearing"in t?this._normalizeBearing(t.bearing,n):n,h="pitch"in t?+t.pitch:s,u="padding"in t?t.padding:o.padding,_=o.zoomScale(l-r),d=e.pointGeometry.convert(t.offset);let p=o.centerPoint.add(d);const m=o.pointLocation(p),f=e.LngLat.convert(t.center||m);this._normalizeCenter(f);const g=o.project(m),v=o.project(f).sub(g);let x=t.curve;const y=Math.max(o.width,o.height),b=y/_,w=v.mag();if("minZoom"in t){const i=e.clamp(Math.min(t.minZoom,r,l),o.minZoom,o.maxZoom),n=y/o.zoomScale(i-r);x=Math.sqrt(n/w*2);}const T=x*x;function E(e){const t=(b*b-y*y+(e?-1:1)*T*T*w*w)/(2*(e?b:y)*T*w);return Math.log(Math.sqrt(t*t+1)-t)}function C(e){return (Math.exp(e)-Math.exp(-e))/2}function M(e){return (Math.exp(e)+Math.exp(-e))/2}const I=E(0);let S=function(e){return M(I)/M(I+x*e)},D=function(e){return y*((M(I)*(C(t=I+x*e)/M(t))-C(I))/T)/w;var t;},L=(E(1)-I)/x;if(Math.abs(w)<1e-6||!isFinite(L)){if(Math.abs(y-b)<1e-6)return this.easeTo(t,i);const e=b<y?-1:1;L=Math.abs(Math.log(b/y))/x,D=function(){return 0},S=function(t){return Math.exp(e*x*t)};}t.duration="duration"in t?+t.duration:1e3*L/("screenSpeed"in t?+t.screenSpeed/x:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0);const A=n!==c,z=h!==s,P=!o.isPaddingEqual(u),R=o=>_=>{const m=_*L,x=1/S(m);o.zoom=1===_?l:r+o.scaleZoom(x),A&&(o.bearing=e.number(n,c,_)),z&&(o.pitch=e.number(s,h,_)),P&&(o.interpolatePadding(a,u,_),p=o.centerPoint.add(d));const y=1===_?f:o.unproject(g.add(v.mult(D(m))).mult(x));return o.setLocationAtPoint(o.renderWorldCopies?y.wrap():y,p),o._updateCameraOnTerrain(),t.preloadOnly||this._fireMoveEvents(i),o};if(t.preloadOnly){const e=this._emulate(R,t.duration,o);return this._preloadTiles(e),this}return this._zooming=!0,this._rotating=A,this._pitching=z,this._padding=P,this._prepareEase(i,!1),this._ease(R(o),(()=>this._afterEase(i)),t),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(e,t){if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),this._easeFrameId=void 0,this._onEaseFrame=void 0),this._onEaseEnd){const e=this._onEaseEnd;this._onEaseEnd=void 0,e.call(this,t);}if(!e){const e=this.handlers;e&&e.stop(!1);}return this}_ease(t,i,o){!1===o.animate||0===o.duration?(t(1),i()):(this._easeStart=e.exported.now(),this._easeOptions=o,this._onEaseFrame=t,this._onEaseEnd=i,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_renderFrameCallback(){const t=Math.min((e.exported.now()-this._easeStart)/this._easeOptions.duration,1),i=this._onEaseFrame;i&&i(this._easeOptions.easing(t)),t<1?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();}_normalizeBearing(t,i){t=e.wrap(t,-180,180);const o=Math.abs(t-i);return Math.abs(t-360-i)<o&&(t-=360),Math.abs(t+360-i)<o&&(t+=360),t}_normalizeCenter(e){const t=this.transform;if(!t.renderWorldCopies||t.maxBounds)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0;}_emulate(e,t,i){const o=Math.ceil(15*t/1e3),r=[],n=e(i.clone());for(let e=0;e<=o;e++){const t=n(e/o);r.push(t.clone());}return r}}class Kr{constructor(t={}){this.options=t,e.bindAll(["_toggleAttribution","_updateEditLink","_updateData","_updateCompact"],this);}getDefaultPosition(){return "bottom-right"}onAdd(e){const t=this.options&&this.options.compact;return this._map=e,this._container=n("div","mapboxgl-ctrl mapboxgl-ctrl-attrib"),this._compactButton=n("button","mapboxgl-ctrl-attrib-button",this._container),n("span","mapboxgl-ctrl-icon",this._compactButton).setAttribute("aria-hidden","true"),this._compactButton.type="button",this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=n("div","mapboxgl-ctrl-attrib-inner",this._container),this._innerContainer.setAttribute("role","list"),t&&this._container.classList.add("mapboxgl-compact"),this._updateAttributions(),this._updateEditLink(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("moveend",this._updateEditLink),void 0===t&&(this._map.on("resize",this._updateCompact),this._updateCompact()),this._container}onRemove(){this._container.remove(),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("moveend",this._updateEditLink),this._map.off("resize",this._updateCompact),this._map=void 0,this._attribHTML=void 0;}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.setAttribute("aria-label",i),e.removeAttribute("title"),e.firstElementChild&&e.firstElementChild.setAttribute("title",i);}_toggleAttribution(){this._container.classList.contains("mapboxgl-compact-show")?(this._container.classList.remove("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-expanded","false")):(this._container.classList.add("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-expanded","true"));}_updateEditLink(){let t=this._editLink;t||(t=this._editLink=this._container.querySelector(".mapbox-improve-map"));const i=[{key:"owner",value:this.styleOwner},{key:"id",value:this.styleId},{key:"access_token",value:this._map._requestManager._customAccessToken||e.config.ACCESS_TOKEN}];if(t){const o=i.reduce(((e,t,o)=>(t.value&&(e+=`${t.key}=${t.value}${o<i.length-1?"&":""}`),e)),"?");t.href=`${e.config.FEEDBACK_URL}/${o}#${er(this._map,!0)}`,t.rel="noopener nofollow",this._setElementTitle(t,"MapFeedback");}}_updateData(e){!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType||(this._updateAttributions(),this._updateEditLink());}_updateAttributions(){if(!this._map.style)return;let e=[];if(this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id;}const t=this._map.style._sourceCaches;for(const i in t){const o=t[i];if(o.used){const t=o.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution);}}e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let o=i+1;o<e.length;o++)if(e[o].indexOf(t)>=0)return !1;return !0})),this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=[...this.options.customAttribution,...e]:e.unshift(this.options.customAttribution));const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("mapboxgl-attrib-empty")):this._container.classList.add("mapboxgl-attrib-empty"),this._editLink=null);}_updateCompact(){this._map.getCanvasContainer().offsetWidth<=640?this._container.classList.add("mapboxgl-compact"):this._container.classList.remove("mapboxgl-compact","mapboxgl-compact-show");}}class Jr{constructor(){e.bindAll(["_updateLogo","_updateCompact"],this);}onAdd(e){this._map=e,this._container=n("div","mapboxgl-ctrl");const t=n("a","mapboxgl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://www.mapbox.com/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="none",this._map.on("sourcedata",this._updateLogo),this._updateLogo(),this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){this._container.remove(),this._map.off("sourcedata",this._updateLogo),this._map.off("resize",this._updateCompact);}getDefaultPosition(){return "bottom-left"}_updateLogo(e){e&&"metadata"!==e.sourceDataType||(this._container.style.display=this._logoRequired()?"block":"none");}_logoRequired(){if(!this._map.style)return !0;const e=this._map.style._sourceCaches;if(0===Object.entries(e).length)return !0;for(const t in e){const i=e[t].getSource();if(i.hasOwnProperty("mapbox_logo")&&!i.mapbox_logo)return !1}return !0}_updateCompact(){const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<250?t.classList.add("mapboxgl-compact"):t.classList.remove("mapboxgl-compact");}}}class Qr{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}function en(t,i,o){if(t=new e.LngLat(t.lng,t.lat),i){const r=new e.LngLat(t.lng-360,t.lat),n=new e.LngLat(t.lng+360,t.lat),s=360*Math.ceil(Math.abs(t.lng-o.center.lng)/360),a=o.locationPoint(t).distSqr(i),l=i.x<0||i.y<0||i.x>o.width||i.y>o.height;o.locationPoint(r).distSqr(i)<a&&(l||Math.abs(r.lng-o.center.lng)<s)?t=r:o.locationPoint(n).distSqr(i)<a&&(l||Math.abs(n.lng-o.center.lng)<s)&&(t=n);}for(;Math.abs(t.lng-o.center.lng)>180;){const e=o.locationPoint(t);if(e.x>=0&&e.y>=0&&e.x<=o.width&&e.y<=o.height)break;t.lng>o.center.lng?t.lng-=360:t.lng+=360;}return t}const tn={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};class on extends e.Evented{constructor(t,i){if(super(),(t instanceof e.window.HTMLElement||i)&&(t=e.extend({element:t},i)),e.bindAll(["_update","_onMove","_onUp","_addDragHandler","_onMapClick","_onKeyPress","_clearFadeTimer"],this),this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&t.pitchAlignment||"auto",this._updateMoving=()=>this._update(!0),this._occludedOpacity=t&&t.occludedOpacity||.2,t&&t.element)this._element=t.element,this._offset=e.pointGeometry.convert(t&&t.offset||[0,0]);else {this._defaultMarker=!0,this._element=n("div");const i=41,o=27,r=s("svg",{display:"block",height:i*this._scale+"px",width:o*this._scale+"px",viewBox:`0 0 ${o} ${i}`},this._element),a=s("radialGradient",{id:"shadowGradient"},s("defs",{},r));s("stop",{offset:"10%","stop-opacity":.4},a),s("stop",{offset:"100%","stop-opacity":.05},a),s("ellipse",{cx:13.5,cy:34.8,rx:10.5,ry:5.25,fill:"url(#shadowGradient)"},r),s("path",{fill:this._color,d:"M27,13.5C27,19.07 20.25,27 14.75,34.5C14.02,35.5 12.98,35.5 12.25,34.5C6.75,27 0,19.22 0,13.5C0,6.04 6.04,0 13.5,0C20.96,0 27,6.04 27,13.5Z"},r),s("path",{opacity:.25,d:"M13.5,0C6.04,0 0,6.04 0,13.5C0,19.22 6.75,27 12.25,34.5C13,35.52 14.02,35.5 14.75,34.5C20.25,27 27,19.07 27,13.5C27,6.04 20.96,0 13.5,0ZM13.5,1C20.42,1 26,6.58 26,13.5C26,15.9 24.5,19.18 22.22,22.74C19.95,26.3 16.71,30.14 13.94,33.91C13.74,34.18 13.61,34.32 13.5,34.44C13.39,34.32 13.26,34.18 13.06,33.91C10.28,30.13 7.41,26.31 5.02,22.77C2.62,19.23 1,15.95 1,13.5C1,6.58 6.58,1 13.5,1Z"},r),s("circle",{fill:"white",cx:13.5,cy:13.5,r:5.5},r),this._offset=e.pointGeometry.convert(t&&t.offset||[0,-14]);}this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label","Map marker"),this._element.classList.add("mapboxgl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault();})),this._element.addEventListener("mousedown",(e=>{e.preventDefault();}));const o=this._element.classList;for(const e in tn)o.remove(`mapboxgl-marker-anchor-${e}`);o.add(`mapboxgl-marker-anchor-${this._anchor}`),this._popup=null;}addTo(e){return e===this._map||(this.remove(),this._map=e,e.getCanvasContainer().appendChild(this._element),e.on("move",this._updateMoving),e.on("moveend",this._update),e.on("remove",this._clearFadeTimer),e._addMarker(this),this.setDraggable(this._draggable),this._update(),e.on("click",this._onMapClick)),this}remove(){const e=this._map;return e&&(e.off("click",this._onMapClick),e.off("move",this._updateMoving),e.off("moveend",this._update),e.off("mousedown",this._addDragHandler),e.off("touchstart",this._addDragHandler),e.off("mouseup",this._onUp),e.off("touchend",this._onUp),e.off("mousemove",this._onMove),e.off("touchmove",this._onMove),e.off("remove",this._clearFadeTimer),e._removeMarker(this),this._map=void 0),this._clearFadeTimer(),this._element.remove(),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.LngLat.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(!0),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeAttribute("role"),this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,o=Math.sqrt(Math.pow(i,2)/2);e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[o,-1*(t-i+o)],"bottom-right":[-o,-1*(t-i+o)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset;}this._popup=e,e._marker=this,this._lngLat&&this._popup.setLngLat(this._lngLat),this._element.setAttribute("role","button"),this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress),this._element.setAttribute("aria-expanded","false");}return this}_onKeyPress(e){const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup();}_onMapClick(e){const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup();}getPopup(){return this._popup}togglePopup(){const e=this._popup;return e?(e.isOpen()?(e.remove(),this._element.setAttribute("aria-expanded","false")):this._map&&(e.addTo(this._map),this._element.setAttribute("aria-expanded","true")),this):this}_behindTerrain(){const e=this._map,t=this._pos;if(!e||!t)return !1;const i=e.unproject(t),o=e.getFreeCameraOptions();if(!o.position)return !1;const r=o.position.toLngLat();return r.distanceTo(i)<.9*r.distanceTo(this._lngLat)}_evaluateOpacity(){const t=this._map;if(!t)return;const i=this._pos;if(!i||i.x<0||i.x>t.transform.width||i.y<0||i.y>t.transform.height)return void this._clearFadeTimer();const o=t.unproject(i);let r;t._showingGlobe()&&e.isLngLatBehindGlobe(t.transform,this._lngLat)?r=0:(r=1-t._queryFogOpacity(o),t.transform._terrainEnabled()&&t.getTerrain()&&this._behindTerrain()&&(r*=this._occludedOpacity)),this._element.style.opacity=`${r}`,this._element.style.pointerEvents=r>0?"auto":"none",this._popup&&this._popup._setOpacity(r),this._fadeTimer=null;}_clearFadeTimer(){this._fadeTimer&&(clearTimeout(this._fadeTimer),this._fadeTimer=null);}_updateDOM(){const e=this._pos;if(!e||!this._map)return;const t=this._offset.mult(this._scale);this._element.style.transform=`\n            translate(${e.x}px,${e.y}px)\n            ${tn[this._anchor]}\n            ${this._calculateXYTransform()} ${this._calculateZTransform()}\n            translate(${t.x}px,${t.y}px)\n        `;}_calculateXYTransform(){const t=this._pos,i=this._map,o=this.getPitchAlignment();if(!i||!t||"map"!==o)return "";if(!i._showingGlobe()){const e=i.getPitch();return e?`rotateX(${e}deg)`:""}const r=e.radToDeg(e.globeTiltAtLngLat(i.transform,this._lngLat)),n=t.sub(e.globeCenterToScreenPoint(i.transform)),s=Math.abs(n.x)+Math.abs(n.y);if(0===s)return "";const a=r/s;return `rotateX(${-n.y*a}deg) rotateY(${n.x*a}deg)`}_calculateZTransform(){const t=this._pos,i=this._map;if(!i||!t)return "";let o=0;const r=this.getRotationAlignment();if("map"===r)if(i._showingGlobe()){const t=i.project(new e.LngLat(this._lngLat.lng,this._lngLat.lat+.001)),r=i.project(new e.LngLat(this._lngLat.lng,this._lngLat.lat-.001)).sub(t);o=e.radToDeg(Math.atan2(r.y,r.x))-90;}else o=-i.getBearing();else if("horizon"===r){const r=e.smoothstep(4,6,i.getZoom()),n=e.globeCenterToScreenPoint(i.transform);n.y+=r*i.transform.height;const s=t.sub(n),a=e.radToDeg(Math.atan2(s.y,s.x));o=(a>90?a-270:a+90)*(1-r);}return o+=this._rotation,o?`rotateZ(${o}deg)`:""}_update(t){e.window.cancelAnimationFrame(this._updateFrameId);const i=this._map;i&&(i.transform.renderWorldCopies&&(this._lngLat=en(this._lngLat,this._pos,i.transform)),this._pos=i.project(this._lngLat),!0===t?this._updateFrameId=e.window.requestAnimationFrame((()=>{this._element&&this._pos&&this._anchor&&(this._pos=this._pos.round(),this._updateDOM());})):this._pos=this._pos.round(),i._requestDomTask((()=>{this._map&&(this._element&&this._pos&&this._anchor&&this._updateDOM(),(i._showingGlobe()||i.getTerrain()||i.getFog())&&!this._fadeTimer&&(this._fadeTimer=setTimeout(this._evaluateOpacity.bind(this),60)));})));}getOffset(){return this._offset}setOffset(t){return this._offset=e.pointGeometry.convert(t),this._update(),this}_onMove(t){const i=this._map;if(!i)return;const o=this._pointerdownPos,r=this._positionDelta;if(o&&r){if(!this._isDragging){const e=this._clickTolerance||i._clickTolerance;if(t.point.dist(o)<e)return;this._isDragging=!0;}this._pos=t.point.sub(r),this._lngLat=i.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new e.Event("dragstart"))),this.fire(new e.Event("drag"));}}_onUp(){this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1;const t=this._map;t&&(t.off("mousemove",this._onMove),t.off("touchmove",this._onMove)),"active"===this._state&&this.fire(new e.Event("dragend")),this._state="inactive";}_addDragHandler(e){const t=this._map,i=this._pos;t&&i&&this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(i),this._pointerdownPos=e.point,this._state="pending",t.on("mousemove",this._onMove),t.on("touchmove",this._onMove),t.once("mouseup",this._onUp),t.once("touchend",this._onUp));}setDraggable(e){this._draggable=!!e;const t=this._map;return t&&(e?(t.on("mousedown",this._addDragHandler),t.on("touchstart",this._addDragHandler)):(t.off("mousedown",this._addDragHandler),t.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return "auto"===this._rotationAlignment||"horizon"===this._rotationAlignment&&this._map&&!this._map._showingGlobe()?"viewport":this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e||"auto",this._update(),this}getPitchAlignment(){return "auto"===this._pitchAlignment?this.getRotationAlignment():this._pitchAlignment}setOccludedOpacity(e){return this._occludedOpacity=e||.2,this._update(),this}getOccludedOpacity(){return this._occludedOpacity}}const rn={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px"},nn=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function sn(t=new e.pointGeometry(0,0),i="bottom"){if("number"==typeof t){const o=Math.round(Math.sqrt(.5*Math.pow(t,2)));switch(i){case"top":return new e.pointGeometry(0,t);case"top-left":return new e.pointGeometry(o,o);case"top-right":return new e.pointGeometry(-o,o);case"bottom":return new e.pointGeometry(0,-t);case"bottom-left":return new e.pointGeometry(o,-o);case"bottom-right":return new e.pointGeometry(-o,-o);case"left":return new e.pointGeometry(t,0);case"right":return new e.pointGeometry(-t,0)}return new e.pointGeometry(0,0)}return t instanceof e.pointGeometry||Array.isArray(t)?e.pointGeometry.convert(t):e.pointGeometry.convert(t[i]||[0,0])}class an{constructor(e){this.jumpTo(e);}getValue(t){if(t<=this._startTime)return this._start;if(t>=this._endTime)return this._end;const i=e.easeCubicInOut((t-this._startTime)/(this._endTime-this._startTime));return this._start*(1-i)+this._end*i}isEasing(e){return e>=this._startTime&&e<=this._endTime}jumpTo(e){this._startTime=-1/0,this._endTime=-1/0,this._start=e,this._end=e;}easeTo(e,t,i){this._start=this.getValue(t),this._end=e,this._startTime=t,this._endTime=t+i;}}const ln={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"Mapbox logo","Map.Title":"Map","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","ScrollZoomBlocker.CtrlMessage":"Use ctrl + scroll to zoom the map","ScrollZoomBlocker.CmdMessage":"Use ⌘ + scroll to zoom the map","TouchPanBlocker.Message":"Use two fingers to move the map"},cn={center:[0,0],zoom:0,bearing:0,pitch:0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:85,interactive:!0,scrollZoom:!0,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,performanceMetricsCollection:!0,bearingSnap:7,clickTolerance:3,pitchWithRotate:!0,hash:!1,attributionControl:!0,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,trackResize:!0,optimizeForTerrain:!0,renderWorldCopies:!0,refreshExpiredTiles:!0,minTileCacheSize:null,maxTileCacheSize:null,localIdeographFontFamily:"sans-serif",localFontFamily:null,transformRequest:null,accessToken:null,fadeDuration:300,crossSourceCollisions:!0},hn={showCompass:!0,showZoom:!0,visualizePitch:!1};class un{constructor(t,i,o=!1){this._clickTolerance=10,this.element=i,this.mouseRotate=new wr({clickTolerance:t.dragRotate._mouseRotate._clickTolerance}),this.map=t,o&&(this.mousePitch=new Tr({clickTolerance:t.dragRotate._mousePitch._clickTolerance})),e.bindAll(["mousedown","mousemove","mouseup","touchstart","touchmove","touchend","reset"],this),i.addEventListener("mousedown",this.mousedown),i.addEventListener("touchstart",this.touchstart,{passive:!1}),i.addEventListener("touchmove",this.touchmove),i.addEventListener("touchend",this.touchend),i.addEventListener("touchcancel",this.reset);}down(e,t){this.mouseRotate.mousedown(e,t),this.mousePitch&&this.mousePitch.mousedown(e,t),h();}move(e,t){const i=this.map,o=this.mouseRotate.mousemoveWindow(e,t),r=o&&o.bearingDelta;if(r&&i.setBearing(i.getBearing()+r),this.mousePitch){const o=this.mousePitch.mousemoveWindow(e,t),r=o&&o.pitchDelta;r&&i.setPitch(i.getPitch()+r);}}off(){const e=this.element;e.removeEventListener("mousedown",this.mousedown),e.removeEventListener("touchstart",this.touchstart,{passive:!1}),e.removeEventListener("touchmove",this.touchmove),e.removeEventListener("touchend",this.touchend),e.removeEventListener("touchcancel",this.reset),this.offTemp();}offTemp(){u(),e.window.removeEventListener("mousemove",this.mousemove),e.window.removeEventListener("mouseup",this.mouseup);}mousedown(t){this.down(e.extend({},t,{ctrlKey:!0,preventDefault:()=>t.preventDefault()}),p(this.element,t)),e.window.addEventListener("mousemove",this.mousemove),e.window.addEventListener("mouseup",this.mouseup);}mousemove(e){this.move(e,p(this.element,e));}mouseup(e){this.mouseRotate.mouseupWindow(e),this.mousePitch&&this.mousePitch.mouseupWindow(e),this.offTemp();}touchstart(e){1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=m(this.element,e.targetTouches)[0],this.down({type:"mousedown",button:0,ctrlKey:!0,preventDefault:()=>e.preventDefault()},this._startPos));}touchmove(e){1!==e.targetTouches.length?this.reset():(this._lastPos=m(this.element,e.targetTouches)[0],this.move({preventDefault:()=>e.preventDefault()},this._lastPos));}touchend(e){0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),this.reset();}reset(){this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp();}}const _n={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0,showUserHeading:!1},dn={maxWidth:100,unit:"metric"};function pn(e,t,i){const o=mn(t),r=o/t,n={kilometer:"km",meter:"m",mile:"mi",foot:"ft","nautical-mile":"nm"}[i];this._map._requestDomTask((()=>{this._container.style.width=e*r+"px",this._container.innerHTML=`${o}&nbsp;${n}`;}));}function mn(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}const fn={version:e.version,supported:i,setRTLTextPlugin:e.setRTLTextPlugin,getRTLTextPluginStatus:e.getRTLTextPluginStatus,Map:class extends Yr{constructor(t){if(e.LivePerformanceUtils.mark(e.PerformanceMarkers.create),null!=(t=e.extend({},cn,t)).minZoom&&null!=t.maxZoom&&t.minZoom>t.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=t.minPitch&&null!=t.maxPitch&&t.minPitch>t.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=t.minPitch&&t.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=t.maxPitch&&t.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(t.antialias&&e.isSafariWithAntialiasingBug(e.window)&&(t.antialias=!1,e.warnOnce("Antialiasing is disabled for this WebGL context to avoid browser bug: https://github.com/mapbox/mapbox-gl-js/issues/11609")),super(new Ko(t.minZoom,t.maxZoom,t.minPitch,t.maxPitch,t.renderWorldCopies),t),this._interactive=t.interactive,this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._failIfMajorPerformanceCaveat=t.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=t.preserveDrawingBuffer,this._antialias=t.antialias,this._useWebGL2=t.useWebGL2,this._trackResize=t.trackResize,this._bearingSnap=t.bearingSnap,this._refreshExpiredTiles=t.refreshExpiredTiles,this._fadeDuration=t.fadeDuration,this._isInitialLoad=!0,this._crossSourceCollisions=t.crossSourceCollisions,this._collectResourceTiming=t.collectResourceTiming,this._optimizeForTerrain=t.optimizeForTerrain,this._language=this._parseLanguage(t.language),this._worldview=t.worldview,this._renderTaskQueue=new Qr,this._domRenderTaskQueue=new Qr,this._controls=[],this._markers=[],this._popups=[],this._mapId=e.uniqueId(),this._locale=e.extend({},ln,t.locale),this._clickTolerance=t.clickTolerance,this._cooperativeGestures=t.cooperativeGestures,this._performanceMetricsCollection=t.performanceMetricsCollection,this._containerWidth=0,this._containerHeight=0,this._averageElevationLastSampledAt=-1/0,this._averageElevationExaggeration=0,this._averageElevation=new an(0),this._interactionRange=[1/0,-1/0],this._visibilityHidden=0,this._useExplicitProjection=!1,this._requestManager=new e.RequestManager(t.transformRequest,t.accessToken,t.testMode),this._silenceAuthErrors=!!t.testMode,"string"==typeof t.container){if(this._container=e.window.document.getElementById(t.container),!this._container)throw new Error(`Container '${t.container}' not found.`)}else {if(!(t.container instanceof e.window.HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=t.container;}if(this._container.childNodes.length>0&&e.warnOnce("The map container element should be empty, otherwise the map's interactivity will be negatively impacted. If you want to display a message when WebGL is not supported, use the Mapbox GL Supported plugin instead."),t.maxBounds&&this.setMaxBounds(t.maxBounds),e.bindAll(["_onWindowOnline","_onWindowResize","_onVisibilityChange","_onMapScroll","_contextLost","_contextRestored"],this),this._setupContainer(),this._setupPainter(),void 0===this.painter)throw new Error("Failed to initialize WebGL.");this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),void 0!==e.window&&(e.window.addEventListener("online",this._onWindowOnline,!1),e.window.addEventListener("resize",this._onWindowResize,!1),e.window.addEventListener("orientationchange",this._onWindowResize,!1),e.window.addEventListener("webkitfullscreenchange",this._onWindowResize,!1),e.window.addEventListener("visibilitychange",this._onVisibilityChange,!1)),this.handlers=new $r(this,t),this._localFontFamily=t.localFontFamily,this._localIdeographFontFamily=t.localIdeographFontFamily,t.style&&this.setStyle(t.style,{localFontFamily:this._localFontFamily,localIdeographFontFamily:this._localIdeographFontFamily}),t.projection&&this.setProjection(t.projection),this._hash=t.hash&&new Qo("string"==typeof t.hash&&t.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:t.center,zoom:t.zoom,bearing:t.bearing,pitch:t.pitch}),t.bounds&&(this.resize(),this.fitBounds(t.bounds,e.extend({},t.fitBoundsOptions,{duration:0})))),this.resize(),t.attributionControl&&this.addControl(new Kr({customAttribution:t.customAttribution})),this._logoControl=new Jr,this.addControl(this._logoControl,t.logoPosition),this.on("style.load",(()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet);})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new e.Event(`${t.dataType}data`,t));})),this.on("dataloading",(t=>{this.fire(new e.Event(`${t.dataType}dataloading`,t));}));}_getMapId(){return this._mapId}addControl(t,i){if(void 0===i&&(i=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new e.ErrorEvent(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const o=t.onAdd(this);this._controls.push(t);const r=this._controlPositions[i];return -1!==i.indexOf("bottom")?r.insertBefore(o,r.firstChild):r.appendChild(o),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new e.ErrorEvent(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(t);return i>-1&&this._controls.splice(i,1),t.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}resize(t){if(this._updateContainerDimensions(),this._containerWidth===this.transform.width&&this._containerHeight===this.transform.height)return this;this._resizeCanvas(this._containerWidth,this._containerHeight),this.transform.resize(this._containerWidth,this._containerHeight),this.painter.resize(Math.ceil(this._containerWidth),Math.ceil(this._containerHeight));const i=!this._moving;return i&&this.fire(new e.Event("movestart",t)).fire(new e.Event("move",t)),this.fire(new e.Event("resize",t)),i&&this.fire(new e.Event("moveend",t)),this}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()||null}setMaxBounds(t){return this.transform.setMaxBounds(e.LngLatBounds.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.minZoom=t,this._update(),this.getZoom()<t?this.setZoom(t):this.fire(new e.Event("zoomstart")).fire(new e.Event("zoom")).fire(new e.Event("zoomend")),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.maxZoom=t,this._update(),this.getZoom()>t?this.setZoom(t):this.fire(new e.Event("zoomstart")).fire(new e.Event("zoom")).fire(new e.Event("zoomend")),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.minPitch=t,this._update(),this.getPitch()<t?this.setPitch(t):this.fire(new e.Event("pitchstart")).fire(new e.Event("pitch")).fire(new e.Event("pitchend")),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?85:t)>85)throw new Error("maxPitch must be less than or equal to 85");if(t>=this.transform.minPitch)return this.transform.maxPitch=t,this._update(),this.getPitch()>t?this.setPitch(t):this.fire(new e.Event("pitchstart")).fire(new e.Event("pitch")).fire(new e.Event("pitchend")),this;throw new Error("maxPitch must be greater than or equal to minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.renderWorldCopies=e,this.transform.renderWorldCopies||this._forceMarkerAndPopupUpdate(!0),this._update()}getLanguage(){return this._language}_parseLanguage(t){return "auto"===t?e.window.navigator.language:Array.isArray(t)?0===t.length?void 0:t.map((t=>"auto"===t?e.window.navigator.language:t)):t}setLanguage(e){const t=this._parseLanguage(e);if(!this.style||t===this._language)return this;this._language=t,this.style._reloadSources();for(const e of this._controls)e._setLanguage&&e._setLanguage(this._language);return this}getWorldview(){return this._worldview}setWorldview(e){return this.style&&e!==this._worldview?(this._worldview=e,this.style._reloadSources(),this):this}getProjection(){return this.transform.mercatorFromTransition?{name:"globe",center:[0,0]}:this.transform.getProjection()}_showingGlobe(){return "globe"===this.transform.projection.name}setProjection(e){return this._lazyInitEmptyStyle(),e?"string"==typeof e&&(e={name:e}):e=null,this._useExplicitProjection=!!e,this._prioritizeAndUpdateProjection(e,this.style.stylesheet?this.style.stylesheet.projection:null)}_updateProjectionTransition(){if("globe"!==this.getProjection().name)return;const t=this.transform,i=t.projection.name;let o;"globe"===i&&t.zoom>=e.GLOBE_ZOOM_THRESHOLD_MAX?(t.setMercatorFromTransition(),o=!0):"mercator"===i&&t.zoom<e.GLOBE_ZOOM_THRESHOLD_MAX&&(t.setProjection({name:"globe"}),o=!0),o&&(this.style.applyProjectionUpdate(),this.style._forceSymbolLayerUpdate());}_prioritizeAndUpdateProjection(e,t){return this._updateProjection(e||t||{name:"mercator"})}_updateProjection(t){let i;if(i="globe"===t.name&&this.transform.zoom>=e.GLOBE_ZOOM_THRESHOLD_MAX?this.transform.setMercatorFromTransition():this.transform.setProjection(t),this.style.applyProjectionUpdate(),i){this.painter.clearBackgroundTiles();for(const e in this.style._sourceCaches)this.style._sourceCaches[e].clearTiles();this._update(!0),this._forceMarkerAndPopupUpdate(!0);}return this}project(t){return this.transform.locationPoint3D(e.LngLat.convert(t))}unproject(t){return this.transform.pointLocation3D(e.pointGeometry.convert(t))}isMoving(){return this._moving||this.handlers&&this.handlers.isMoving()||!1}isZooming(){return this._zooming||this.handlers&&this.handlers.isZooming()||!1}isRotating(){return this._rotating||this.handlers&&this.handlers.isRotating()||!1}_isDragging(){return this.handlers&&this.handlers._isDragging()||!1}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let o=!1;const r=r=>{const n=t.filter((e=>this.getLayer(e))),s=n.length?this.queryRenderedFeatures(r.point,{layers:n}):[];s.length?o||(o=!0,i.call(this,new cr(e,this,r.originalEvent,{features:s}))):o=!1;},n=()=>{o=!1;};return {layers:new Set(t),listener:i,delegates:{mousemove:r,mouseout:n}}}if("mouseleave"===e||"mouseout"===e){let o=!1;const r=r=>{const n=t.filter((e=>this.getLayer(e)));(n.length?this.queryRenderedFeatures(r.point,{layers:n}):[]).length?o=!0:o&&(o=!1,i.call(this,new cr(e,this,r.originalEvent)));},n=t=>{o&&(o=!1,i.call(this,new cr(e,this,t.originalEvent)));};return {layers:new Set(t),listener:i,delegates:{mousemove:r,mouseout:n}}}{const o=e=>{const o=t.filter((e=>this.getLayer(e))),r=o.length?this.queryRenderedFeatures(e.point,{layers:o}):[];r.length&&(e.features=r,i.call(this,e),delete e.features);};return {layers:new Set(t),listener:i,delegates:{[e]:o}}}}on(e,t,i){if(void 0===i)return super.on(e,t);Array.isArray(t)||(t=[t]);const o=this._createDelegatedListener(e,t,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(o);for(const e in o.delegates)this.on(e,o.delegates[e]);return this}once(e,t,i){if(void 0===i)return super.once(e,t);Array.isArray(t)||(t=[t]);const o=this._createDelegatedListener(e,t,i);for(const e in o.delegates)this.once(e,o.delegates[e]);return this}off(e,t,i){if(void 0===i)return super.off(e,t);t=new Set(Array.isArray(t)?t:[t]);const o=(e,t)=>{if(e.size!==t.size)return !1;for(const i of e)if(!t.has(i))return !1;return !0},r=this._delegatedListeners?this._delegatedListeners[e]:void 0;return r&&(e=>{for(let r=0;r<e.length;r++){const n=e[r];if(n.listener===i&&o(n.layers,t)){for(const e in n.delegates)this.off(e,n.delegates[e]);return e.splice(r,1),this}}})(r),this}queryRenderedFeatures(t,i){return this.style?(void 0!==i||void 0===t||t instanceof e.pointGeometry||Array.isArray(t)||(i=t,t=void 0),this.style.queryRenderedFeatures(t=t||[[0,0],[this.transform.width,this.transform.height]],i=i||{},this.transform)):[]}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}setStyle(t,i){return !1!==(i=e.extend({},{localIdeographFontFamily:this._localIdeographFontFamily,localFontFamily:this._localFontFamily},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&i.localFontFamily===this._localFontFamily&&this.style&&t?(this._diffStyle(t,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._localFontFamily=i.localFontFamily,this._updateStyle(t,i))}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){return this.style&&(this.style.setEventedParent(null),this.style._remove(),this.style=void 0),e&&(this.style=new Qt(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e):this.style.loadJSON(e)),this._updateTerrain(),this}_lazyInitEmptyStyle(){this.style||(this.style=new Qt(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(t,i){if("string"==typeof t){const o=this._requestManager.normalizeStyleURL(t),r=this._requestManager.transformRequest(o,e.ResourceType.Style);e.getJSON(r,((t,o)=>{t?this.fire(new e.ErrorEvent(t)):o&&this._updateDiff(o,i);}));}else "object"==typeof t&&this._updateDiff(t,i);}_updateDiff(t,i){try{this.style.setState(t)&&this._update(!0);}catch(o){e.warnOnce(`Unable to perform style diff: ${o.message||o.error||o}.  Rebuilding the style from scratch.`),this._updateStyle(t,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():(e.warnOnce("There is no style added to the map."),!1)}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(e){return !!this.style&&this.style._isSourceCacheLoaded(e)}areTilesLoaded(){const e=this.style&&this.style._sourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}addSourceType(e,t,i){this._lazyInitEmptyStyle(),this.style.addSourceType(e,t,i);}removeSource(e){return this.style.removeSource(e),this._updateTerrain(),this._update(!0)}getSource(e){return this.style.getSource(e)}addImage(t,i,{pixelRatio:o=1,sdf:r=!1,stretchX:n,stretchY:s,content:a}={}){if(this._lazyInitEmptyStyle(),i instanceof e.window.HTMLImageElement||e.window.ImageBitmap&&i instanceof e.window.ImageBitmap){const{width:l,height:c,data:h}=e.exported.getImageData(i);this.style.addImage(t,{data:new e.RGBAImage({width:l,height:c},h),pixelRatio:o,stretchX:n,stretchY:s,content:a,sdf:r,version:0});}else if(void 0===i.width||void 0===i.height)this.fire(new e.ErrorEvent(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));else {const{width:l,height:c}=i,h=i;this.style.addImage(t,{data:new e.RGBAImage({width:l,height:c},new Uint8Array(h.data)),pixelRatio:o,stretchX:n,stretchY:s,content:a,sdf:r,version:0,userImage:h}),h.onAdd&&h.onAdd(this,t);}}updateImage(t,i){const o=this.style.getImage(t);if(!o)return void this.fire(new e.ErrorEvent(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=i instanceof e.window.HTMLImageElement||e.window.ImageBitmap&&i instanceof e.window.ImageBitmap?e.exported.getImageData(i):i,{width:n,height:s}=r;void 0!==n&&void 0!==s?n===o.data.width&&s===o.data.height?(o.data.replace(r.data,!(i instanceof e.window.HTMLImageElement||e.window.ImageBitmap&&i instanceof e.window.ImageBitmap)),this.style.updateImage(t,o)):this.fire(new e.ErrorEvent(new Error(`The width and height of the updated image (${n}, ${s})\n                must be that same as the previous version of the image\n                (${o.data.width}, ${o.data.height})`))):this.fire(new e.ErrorEvent(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new e.ErrorEvent(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e);}loadImage(t,i){e.getImage(this._requestManager.transformRequest(t,e.ResourceType.Image),((t,o)=>{i(t,o instanceof e.window.HTMLImageElement?e.exported.getImageData(o):o);}));}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,o={}){return this.style.setPaintProperty(e,t,i,o),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,o={}){return this.style.setLayoutProperty(e,t,i,o),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setTerrain(e){return this._lazyInitEmptyStyle(),!e&&this.transform.projection.requiresDraping?this.style.setTerrainForDraping():this.style.setTerrain(e),this._averageElevationLastSampledAt=-1/0,this._update(!0)}getTerrain(){return this.style?this.style.getTerrain():null}setFog(e){return this._lazyInitEmptyStyle(),this.style.setFog(e),this._update(!0)}getFog(){return this.style?this.style.getFog():null}_queryFogOpacity(t){return this.style&&this.style.fog?this.style.fog.getOpacityAtLatLng(e.LngLat.convert(t),this.transform):0}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}_updateContainerDimensions(){if(!this._container)return;const t=this._container.getBoundingClientRect().width||400,i=this._container.getBoundingClientRect().height||300;let o,r,n,s=this._container;for(;s&&(!r||!n);){const t=e.window.getComputedStyle(s).transform;t&&"none"!==t&&(o=t.match(/matrix.*\((.+)\)/)[1].split(", "),o[0]&&"0"!==o[0]&&"1"!==o[0]&&(r=o[0]),o[3]&&"0"!==o[3]&&"1"!==o[3]&&(n=o[3])),s=s.parentElement;}this._containerWidth=r?Math.abs(t/r):t,this._containerHeight=n?Math.abs(i/n):i;}_detectMissingCSS(){"rgb(250, 128, 114)"!==e.window.getComputedStyle(this._missingCSSCanary).getPropertyValue("background-color")&&e.warnOnce("This page appears to be missing CSS declarations for Mapbox GL JS, which may cause the map to display incorrectly. Please ensure your page includes mapbox-gl.css, as described in https://www.mapbox.com/mapbox-gl-js/api/.");}_setupContainer(){const e=this._container;e.classList.add("mapboxgl-map"),(this._missingCSSCanary=n("div","mapboxgl-canary",e)).style.visibility="hidden",this._detectMissingCSS();const t=this._canvasContainer=n("div","mapboxgl-canvas-container",e);this._interactive&&t.classList.add("mapboxgl-interactive"),this._canvas=n("canvas","mapboxgl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex","0"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region"),this._updateContainerDimensions(),this._resizeCanvas(this._containerWidth,this._containerHeight);const i=this._controlContainer=n("div","mapboxgl-control-container",e),o=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{o[e]=n("div",`mapboxgl-ctrl-${e}`,i);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(t,i){const o=e.exported.devicePixelRatio||1;this._canvas.width=o*Math.ceil(t),this._canvas.height=o*Math.ceil(i),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${i}px`;}_addMarker(e){this._markers.push(e);}_removeMarker(e){const t=this._markers.indexOf(e);-1!==t&&this._markers.splice(t,1);}_addPopup(e){this._popups.push(e);}_removePopup(e){const t=this._popups.indexOf(e);-1!==t&&this._popups.splice(t,1);}_setupPainter(){const t=e.extend({},i.webGLContextAttributes,{failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1}),o=this._useWebGL2&&this._canvas.getContext("webgl2",t),r=o||this._canvas.getContext("webgl",t)||this._canvas.getContext("experimental-webgl",t);r?(this._useWebGL2&&!o&&e.warnOnce("Failed to create WebGL 2 context. Using WebGL 1."),e.storeAuthState(r,!0),this.painter=new Fo(r,this.transform,!!o),this.on("data",(e=>{"source"===e.dataType&&this.painter.setTileLoadedFlag(!0);})),e.exported$1.testSupport(r)):this.fire(new e.ErrorEvent(new Error("Failed to initialize WebGL")));}_contextLost(t){t.preventDefault(),this._frame&&(this._frame.cancel(),this._frame=null),this.fire(new e.Event("webglcontextlost",{originalEvent:t}));}_contextRestored(t){this._setupPainter(),this.resize(),this._update(),this.fire(new e.Event("webglcontextrestored",{originalEvent:t}));}_onMapScroll(e){if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e);}_requestDomTask(e){!this.loaded()||this.loaded()&&!this.isMoving()?e():this._domRenderTaskQueue.add(e);}_render(t){let i;const o=this.painter.context.extTimerQuery,r=e.exported.now();if(this.listens("gpu-timing-frame")&&(i=o.createQueryEXT(),o.beginQueryEXT(o.TIME_ELAPSED_EXT,i)),this.painter.context.setDirty(),this.painter.setBaseState(),(this.isMoving()||this.isRotating()||this.isZooming())&&(this._interactionRange[0]=Math.min(this._interactionRange[0],e.window.performance.now()),this._interactionRange[1]=Math.max(this._interactionRange[1],e.window.performance.now())),this._renderTaskQueue.run(t),this._domRenderTaskQueue.run(t),this._removed)return;this._updateProjectionTransition();const n=this._isInitialLoad?0:this._fadeDuration;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,i=this.transform.pitch,o=e.exported.now(),r=new e.EvaluationParameters(t,{now:o,fadeDuration:n,pitch:i,transition:this.style.getTransition()});this.style.update(r);}this.style&&this.style.fog&&this.style.fog.hasTransition()&&(this.style._markersNeedUpdate=!0,this._sourcesDirty=!0);let s=!1;if(this.style&&this._sourcesDirty?(this._sourcesDirty=!1,this.painter._updateFog(this.style),this._updateTerrain(),s=this._updateAverageElevation(r),this.style._updateSources(this.transform),this._forceMarkerAndPopupUpdate()):s=this._updateAverageElevation(r),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,n,this._crossSourceCollisions),this.style&&this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showTerrainWireframe:this.showTerrainWireframe,showOverdrawInspector:this._showOverdrawInspector,showQueryGeometry:!!this._showQueryGeometry,showTileAABBs:this.showTileAABBs,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:n,isInitialLoad:this._isInitialLoad,showPadding:this.showPadding,gpuTiming:!!this.listens("gpu-timing-layer"),gpuTimingDeferredRender:!!this.listens("gpu-timing-deferred-render"),speedIndexTiming:this.speedIndexTiming}),this.fire(new e.Event("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,this.fire(new e.Event("load"))),this.style&&this.style.hasTransitions()&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles(),i){const t=e.exported.now()-r;o.endQueryEXT(o.TIME_ELAPSED_EXT,i),setTimeout((()=>{const n=o.getQueryObjectEXT(i,o.QUERY_RESULT_EXT)/1e6;o.deleteQueryEXT(i),this.fire(new e.Event("gpu-timing-frame",{cpuTime:t,gpuTime:n})),e.window.performance.mark("frame-gpu",{startTime:r,detail:{gpuTime:n}});}),50);}if(this.listens("gpu-timing-layer")){const t=this.painter.collectGpuTimers();setTimeout((()=>{const i=this.painter.queryGpuTimers(t);this.fire(new e.Event("gpu-timing-layer",{layerTimes:i}));}),50);}if(this.listens("gpu-timing-deferred-render")){const t=this.painter.collectDeferredRenderGpuQueries();setTimeout((()=>{const i=this.painter.queryGpuTimeDeferredRender(t);this.fire(new e.Event("gpu-timing-deferred-render",{gpuTime:i}));}),50);}const a=this._sourcesDirty||this._styleDirty||this._placementDirty||s;if(a||this._repaint)this.triggerRepaint();else {const t=!this.isMoving()&&this.loaded();if(t&&(s=this._updateAverageElevation(r,!0)),s)this.triggerRepaint();else if(this._triggerFrame(!1),t&&(this.fire(new e.Event("idle")),this._isInitialLoad=!1,this.speedIndexTiming)){const t=this._calculateSpeedIndex();this.fire(new e.Event("speedindexcompleted",{speedIndex:t})),this.speedIndexTiming=!1;}}!this._loaded||this._fullyLoaded||a||(this._fullyLoaded=!0,e.LivePerformanceUtils.mark(e.PerformanceMarkers.fullLoad),this._performanceMetricsCollection&&e.postPerformanceEvent(this._requestManager._customAccessToken,{width:this.painter.width,height:this.painter.height,interactionRange:this._interactionRange,visibilityHidden:this._visibilityHidden,terrainEnabled:!!this.painter.style.getTerrain(),fogEnabled:!!this.painter.style.getFog(),projection:this.getProjection().name,zoom:this.transform.zoom,renderer:this.painter.context.renderer,vendor:this.painter.context.vendor}),this._authenticate());}_forceMarkerAndPopupUpdate(e){for(const t of this._markers)e&&!this.getRenderWorldCopies()&&(t._lngLat=t._lngLat.wrap()),t._update();for(const t of this._popups)!e||this.getRenderWorldCopies()||t._trackPointer||(t._lngLat=t._lngLat.wrap()),t._update();}_updateAverageElevation(e,t=!1){const i=e=>(this.transform.averageElevation=e,this._update(!1),!0);if(!this.painter.averageElevationNeedsEasing())return 0!==this.transform.averageElevation&&i(0);if((t||e-this._averageElevationLastSampledAt>500)&&!this._averageElevation.isEasing(e)){const t=this.transform.averageElevation;let o=this.transform.sampleAverageElevation(),r=!1;this.transform.elevation&&(r=this.transform.elevation.exaggeration()!==this._averageElevationExaggeration,this._averageElevationExaggeration=this.transform.elevation.exaggeration()),isNaN(o)?o=0:this._averageElevationLastSampledAt=e;const n=Math.abs(t-o);if(n>1){if(this._isInitialLoad||r)return this._averageElevation.jumpTo(o),i(o);this._averageElevation.easeTo(o,e,300);}else if(n>1e-4)return this._averageElevation.jumpTo(o),i(o)}return !!this._averageElevation.isEasing(e)&&i(this._averageElevation.getValue(e))}_authenticate(){e.getMapSessionAPI(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(t=>{if(t&&(t.message===e.AUTH_ERR_MSG||401===t.status)){const t=this.painter.context.gl;e.storeAuthState(t,!1),this._logoControl instanceof Jr&&this._logoControl._updateLogo(),t&&t.clear(t.DEPTH_BUFFER_BIT|t.COLOR_BUFFER_BIT|t.STENCIL_BUFFER_BIT),this._silenceAuthErrors||this.fire(new e.ErrorEvent(new Error("A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/")));}})),e.postMapLoadEvent(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(()=>{}));}_updateTerrain(){const e=this._isDragging();this.painter.updateTerrain(this.style,e);}_calculateSpeedIndex(){const e=this.painter.canvasCopy(),t=this.painter.getCanvasCopiesAndTimestamps();t.timeStamps.push(performance.now());const i=this.painter.context.gl,o=i.createFramebuffer();function r(e){i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,e,0);const t=new Uint8Array(i.drawingBufferWidth*i.drawingBufferHeight*4);return i.readPixels(0,0,i.drawingBufferWidth,i.drawingBufferHeight,i.RGBA,i.UNSIGNED_BYTE,t),t}return i.bindFramebuffer(i.FRAMEBUFFER,o),this._canvasPixelComparison(r(e),t.canvasCopies.map(r),t.timeStamps)}_canvasPixelComparison(e,t,i){let o=i[1]-i[0];const r=e.length/4;for(let n=0;n<t.length;n++){const s=t[n];let a=0;for(let t=0;t<s.length;t+=4)s[t]===e[t]&&s[t+1]===e[t+1]&&s[t+2]===e[t+2]&&s[t+3]===e[t+3]&&(a+=1);o+=(i[n+2]-i[n+1])*(1-a/r);}return o}remove(){this._hash&&this._hash.remove();for(const e of this._controls)e.onRemove(this);this._controls=[],this._frame&&(this._frame.cancel(),this._frame=null),this._renderTaskQueue.clear(),this._domRenderTaskQueue.clear(),this.style&&this.style.destroy(),this.painter.destroy(),this.handlers&&this.handlers.destroy(),this.handlers=void 0,this.setStyle(null),void 0!==e.window&&(e.window.removeEventListener("resize",this._onWindowResize,!1),e.window.removeEventListener("orientationchange",this._onWindowResize,!1),e.window.removeEventListener("webkitfullscreenchange",this._onWindowResize,!1),e.window.removeEventListener("online",this._onWindowOnline,!1),e.window.removeEventListener("visibilitychange",this._onVisibilityChange,!1));const t=this.painter.context.gl.getExtension("WEBGL_lose_context");t&&t.loseContext(),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvasContainer.remove(),this._controlContainer.remove(),this._missingCSSCanary.remove(),this._canvas=void 0,this._canvasContainer=void 0,this._controlContainer=void 0,this._missingCSSCanary=void 0,this._container.classList.remove("mapboxgl-map"),this._container.removeEventListener("scroll",this._onMapScroll,!1),e.removeAuthState(this.painter.context.gl),this._removed=!0,this.fire(new e.Event("remove"));}triggerRepaint(){this._triggerFrame(!0);}_triggerFrame(t){this._renderNextFrame=this._renderNextFrame||t,this.style&&!this._frame&&(this._frame=e.exported.frame((e=>{const t=!!this._renderNextFrame;this._frame=null,this._renderNextFrame=null,t&&this._render(e);})));}_preloadTiles(t){const i=this.style?Object.values(this.style._sourceCaches):[];return e.asyncAll(i,((e,i)=>e._preloadTiles(t,i)),(()=>{this.triggerRepaint();})),this}_onWindowOnline(){this._update();}_onWindowResize(e){this._trackResize&&this.resize({originalEvent:e})._update();}_onVisibilityChange(){"hidden"===e.window.document.visibilityState&&this._visibilityHidden++;}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(e){this._showTileBoundaries!==e&&(this._showTileBoundaries=e,this._update());}get showTerrainWireframe(){return !!this._showTerrainWireframe}set showTerrainWireframe(e){this._showTerrainWireframe!==e&&(this._showTerrainWireframe=e,this._update());}get speedIndexTiming(){return !!this._speedIndexTiming}set speedIndexTiming(e){this._speedIndexTiming!==e&&(this._speedIndexTiming=e,this._update());}get showPadding(){return !!this._showPadding}set showPadding(e){this._showPadding!==e&&(this._showPadding=e,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(e){this._showCollisionBoxes!==e&&(this._showCollisionBoxes=e,e?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(e){this._showOverdrawInspector!==e&&(this._showOverdrawInspector=e,this._update());}get repaint(){return !!this._repaint}set repaint(e){this._repaint!==e&&(this._repaint=e,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(e){this._vertices=e,this._update();}get showTileAABBs(){return !!this._showTileAABBs}set showTileAABBs(e){this._showTileAABBs!==e&&(this._showTileAABBs=e,e&&this._update());}_setCacheLimits(t,i){e.setCacheLimits(t,i);}get version(){return e.version}},NavigationControl:class{constructor(t){this.options=e.extend({},hn,t),this._container=n("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this.options.showZoom&&(e.bindAll(["_setButtonTitle","_updateZoomButtons"],this),this._zoomInButton=this._createButton("mapboxgl-ctrl-zoom-in",(e=>{this._map&&this._map.zoomIn({},{originalEvent:e});})),n("span","mapboxgl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("mapboxgl-ctrl-zoom-out",(e=>{this._map&&this._map.zoomOut({},{originalEvent:e});})),n("span","mapboxgl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(e.bindAll(["_rotateCompassArrow"],this),this._compass=this._createButton("mapboxgl-ctrl-compass",(e=>{const t=this._map;t&&(this.options.visualizePitch?t.resetNorthPitch({},{originalEvent:e}):t.resetNorth({},{originalEvent:e}));})),this._compassIcon=n("span","mapboxgl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"));}_updateZoomButtons(){const e=this._map;if(!e)return;const t=e.getZoom(),i=t===e.getMaxZoom(),o=t===e.getMinZoom();this._zoomInButton.disabled=i,this._zoomOutButton.disabled=o,this._zoomInButton.setAttribute("aria-disabled",i.toString()),this._zoomOutButton.setAttribute("aria-disabled",o.toString());}_rotateCompassArrow(){const e=this._map;if(!e)return;const t=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(e.transform.pitch*(Math.PI/180)),.5)}) rotateX(${e.transform.pitch}deg) rotateZ(${e.transform.angle*(180/Math.PI)}deg)`:`rotate(${e.transform.angle*(180/Math.PI)}deg)`;e._requestDomTask((()=>{this._compassIcon&&(this._compassIcon.style.transform=t);}));}onAdd(e){return this._map=e,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),e.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&e.on("pitch",this._rotateCompassArrow),e.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new un(e,this._compass,this.options.visualizePitch)),this._container}onRemove(){const e=this._map;e&&(this._container.remove(),this.options.showZoom&&e.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&e.off("pitch",this._rotateCompassArrow),e.off("rotate",this._rotateCompassArrow),this._handler&&this._handler.off(),this._handler=void 0),this._map=void 0);}_createButton(e,t){const i=n("button",e,this._container);return i.type="button",i.addEventListener("click",t),i}_setButtonTitle(e,t){if(!this._map)return;const i=this._map._getUIString(`NavigationControl.${t}`);e.setAttribute("aria-label",i),e.firstElementChild&&e.firstElementChild.setAttribute("title",i);}},GeolocateControl:class extends e.Evented{constructor(t){super(),this.options=e.extend({geolocation:e.window.navigator.geolocation},_n,t),e.bindAll(["_onSuccess","_onError","_onZoom","_finish","_setupUI","_updateCamera","_updateMarker","_updateMarkerRotation","_onDeviceOrientation"],this),this._updateMarkerRotationThrottled=Jo(this._updateMarkerRotation,20),this._numberOfWatches=0;}onAdd(e){return this._map=e,this._container=n("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkGeolocationSupport(this._setupUI),this._container}onRemove(){void 0!==this._geolocationWatchID&&(this.options.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),this._container.remove(),this._map.off("zoom",this._onZoom),this._map=void 0,this._numberOfWatches=0,this._noTimeout=!1;}_checkGeolocationSupport(t){const i=(e=!!this.options.geolocation)=>{this._supportsGeolocation=e,t(e);};void 0!==this._supportsGeolocation?t(this._supportsGeolocation):void 0!==e.window.navigator.permissions?e.window.navigator.permissions.query({name:"geolocation"}).then((e=>i("denied"!==e.state))).catch((()=>i())):i();}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return !!t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");}}_onSuccess(t){if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new e.Event("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("mapboxgl-user-location-dot-stale"),this.fire(new e.Event("geolocate",t)),this._finish();}}_updateCamera(t){const i=new e.LngLat(t.coords.longitude,t.coords.latitude),o=t.coords.accuracy,r=this._map.getBearing(),n=e.extend({bearing:r},this.options.fitBoundsOptions);this._map.fitBounds(i.toBounds(o),n,{geolocateSource:!0});}_updateMarker(t){if(t){const i=new e.LngLat(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();}_updateCircleRadius(){const t=this._map.transform,i=e.mercatorZfromAltitude(1,t._center.lat)*t.worldSize,o=Math.ceil(2*this._accuracy*i);this._circleElement.style.width=`${o}px`,this._circleElement.style.height=`${o}px`;}_onZoom(){this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}_updateMarkerRotation(){this._userLocationDotMarker&&"number"==typeof this._heading?(this._userLocationDotMarker.setRotation(this._heading),this._dotElement.classList.add("mapboxgl-user-location-show-heading")):(this._dotElement.classList.remove("mapboxgl-user-location-show-heading"),this._userLocationDotMarker.setRotation(0));}_onError(t){if(this._map){if(this.options.trackUserLocation)if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.setAttribute("aria-label",e),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",e),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===t.code&&this._noTimeout)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("mapboxgl-user-location-dot-stale"),this.fire(new e.Event("error",t)),this._finish();}}_finish(){this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;}_setupUI(t){if(void 0!==this._map){if(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=n("button","mapboxgl-ctrl-geolocate",this._container),n("span","mapboxgl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",!1===t){e.warnOnce("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.setAttribute("aria-label",t),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",t);}else {const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.setAttribute("aria-label",e),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",e);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=n("div","mapboxgl-user-location"),this._dotElement.appendChild(n("div","mapboxgl-user-location-dot")),this._dotElement.appendChild(n("div","mapboxgl-user-location-heading")),this._userLocationDotMarker=new on({element:this._dotElement,rotationAlignment:"map",pitchAlignment:"map"}),this._circleElement=n("div","mapboxgl-user-location-accuracy-circle"),this._accuracyCircleMarker=new on({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",this.trigger.bind(this)),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this.fire(new e.Event("trackuserlocationend")));}));}}_onDeviceOrientation(e){this._userLocationDotMarker&&(e.webkitCompassHeading?this._heading=e.webkitCompassHeading:!0===e.absolute&&(this._heading=-1*e.alpha),this._updateMarkerRotationThrottled());}trigger(){if(!this._setup)return e.warnOnce("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new e.Event("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":this._numberOfWatches--,this._noTimeout=!1,this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this.fire(new e.Event("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new e.Event("trackuserlocationstart"));}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"BACKGROUND":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");break;case"BACKGROUND_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error");}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),this._numberOfWatches++,this._numberOfWatches>1?(e={maximumAge:6e5,timeout:0},this._noTimeout=!0):(e=this.options.positionOptions,this._noTimeout=!1),this._geolocationWatchID=this.options.geolocation.watchPosition(this._onSuccess,this._onError,e),this.options.showUserHeading&&this._addDeviceOrientationListener();}}else this.options.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_addDeviceOrientationListener(){const t=()=>{e.window.addEventListener("ondeviceorientationabsolute"in e.window?"deviceorientationabsolute":"deviceorientation",this._onDeviceOrientation);};void 0!==e.window.DeviceMotionEvent&&"function"==typeof e.window.DeviceMotionEvent.requestPermission?DeviceOrientationEvent.requestPermission().then((e=>{"granted"===e&&t();})).catch(console.error):t();}_clearWatch(){this.options.geolocation.clearWatch(this._geolocationWatchID),e.window.removeEventListener("deviceorientation",this._onDeviceOrientation),e.window.removeEventListener("deviceorientationabsolute",this._onDeviceOrientation),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},AttributionControl:Kr,ScaleControl:class{constructor(t){this.options=e.extend({},dn,t),function(){try{return new Intl.NumberFormat("en",{style:"unit",unitDisplay:"narrow",unit:"meter"}),!0}catch(e){return !1}}()||(this._setScale=pn.bind(this)),e.bindAll(["_update","_setScale","setUnit"],this);}getDefaultPosition(){return "bottom-left"}_update(){const e=this.options.maxWidth||100,t=this._map,i=t._containerHeight/2,o=t._containerWidth/2-e/2,r=t.unproject([o,i]),n=t.unproject([o+e,i]),s=r.distanceTo(n);if("imperial"===this.options.unit){const t=3.2808*s;t>5280?this._setScale(e,t/5280,"mile"):this._setScale(e,t,"foot");}else "nautical"===this.options.unit?this._setScale(e,s/1852,"nautical-mile"):s>=1e3?this._setScale(e,s/1e3,"kilometer"):this._setScale(e,s,"meter");}_setScale(e,t,i){const o=mn(t),r=o/t;this._map._requestDomTask((()=>{this._container.style.width=e*r+"px",this._container.innerHTML="nautical-mile"!==i?new Intl.NumberFormat(this._language,{style:"unit",unitDisplay:"narrow",unit:i}).format(o):`${o}&nbsp;nm`;}));}onAdd(e){return this._map=e,this._language=e.getLanguage(),this._container=n("div","mapboxgl-ctrl mapboxgl-ctrl-scale",e.getContainer()),this._container.dir="auto",this._map.on("move",this._update),this._update(),this._container}onRemove(){this._container.remove(),this._map.off("move",this._update),this._map=void 0;}_setLanguage(e){this._language=e,this._update();}setUnit(e){this.options.unit=e,this._update();}},FullscreenControl:class{constructor(t){this._fullscreen=!1,t&&t.container&&(t.container instanceof e.window.HTMLElement?this._container=t.container:e.warnOnce("Full screen control 'container' must be a DOM element.")),e.bindAll(["_onClickFullscreen","_changeIcon"],this),"onfullscreenchange"in e.window.document?this._fullscreenchange="fullscreenchange":"onwebkitfullscreenchange"in e.window.document&&(this._fullscreenchange="webkitfullscreenchange");}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=n("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkFullscreenSupport()?this._setupUI():(this._controlContainer.style.display="none",e.warnOnce("This device does not support fullscreen mode.")),this._controlContainer}onRemove(){this._controlContainer.remove(),this._map=null,e.window.document.removeEventListener(this._fullscreenchange,this._changeIcon);}_checkFullscreenSupport(){return !(!e.window.document.fullscreenEnabled&&!e.window.document.webkitFullscreenEnabled)}_setupUI(){const t=this._fullscreenButton=n("button","mapboxgl-ctrl-fullscreen",this._controlContainer);n("span","mapboxgl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),e.window.document.addEventListener(this._fullscreenchange,this._changeIcon);}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.firstElementChild&&this._fullscreenButton.firstElementChild.setAttribute("title",e);}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_changeIcon(){(e.window.document.fullscreenElement||e.window.document.webkitFullscreenElement)===this._container!==this._fullscreen&&(this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("mapboxgl-ctrl-shrink"),this._fullscreenButton.classList.toggle("mapboxgl-ctrl-fullscreen"),this._updateTitle());}_onClickFullscreen(){this._isFullscreen()?e.window.document.exitFullscreen?e.window.document.exitFullscreen():e.window.document.webkitCancelFullScreen&&e.window.document.webkitCancelFullScreen():this._container.requestFullscreen?this._container.requestFullscreen():this._container.webkitRequestFullscreen&&this._container.webkitRequestFullscreen();}},Popup:class extends e.Evented{constructor(t){super(),this.options=e.extend(Object.create(rn),t),e.bindAll(["_update","_onClose","remove","_onMouseEvent"],this),this._classList=new Set(t&&t.className?t.className.trim().split(/\s+/):[]);}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&t.on("preclick",this._onClose),this.options.closeOnMove&&t.on("move",this._onClose),t.on("remove",this.remove),this._update(),t._addPopup(this),this._focusFirstElement(),this._trackPointer?(t.on("mousemove",this._onMouseEvent),t.on("mouseup",this._onMouseEvent),t._canvasContainer.classList.add("mapboxgl-track-pointer")):t.on("move",this._update),this.fire(new e.Event("open")),this}isOpen(){return !!this._map}remove(){this._content&&this._content.remove(),this._container&&(this._container.remove(),this._container=void 0);const t=this._map;return t&&(t.off("move",this._update),t.off("move",this._onClose),t.off("preclick",this._onClose),t.off("click",this._onClose),t.off("remove",this.remove),t.off("mousemove",this._onMouseEvent),t.off("mouseup",this._onMouseEvent),t.off("drag",this._onMouseEvent),t._canvasContainer&&t._canvasContainer.classList.remove("mapboxgl-track-pointer"),t._removePopup(this),this._map=void 0),this.fire(new e.Event("close")),this}getLngLat(){return this._lngLat}setLngLat(t){this._lngLat=e.LngLat.convert(t),this._pos=null,this._trackPointer=!1,this._update();const i=this._map;return i&&(i.on("move",this._update),i.off("mousemove",this._onMouseEvent),i._canvasContainer.classList.remove("mapboxgl-track-pointer")),this}trackPointer(){this._trackPointer=!0,this._pos=null,this._update();const e=this._map;return e&&(e.off("move",this._update),e.on("mousemove",this._onMouseEvent),e.on("drag",this._onMouseEvent),e._canvasContainer.classList.add("mapboxgl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(e.window.document.createTextNode(t))}setHTML(t){const i=e.window.document.createDocumentFragment(),o=e.window.document.createElement("body");let r;for(o.innerHTML=t;r=o.firstChild,r;)i.appendChild(r);return this.setDOMContent(i)}getMaxWidth(){return this._container&&this._container.style.maxWidth}setMaxWidth(e){return this.options.maxWidth=e,this._update(),this}setDOMContent(e){let t=this._content;if(t)for(;t.hasChildNodes();)t.firstChild&&t.removeChild(t.firstChild);else t=this._content=n("div","mapboxgl-popup-content",this._container||void 0);if(t.appendChild(e),this.options.closeButton){const e=this._closeButton=n("button","mapboxgl-popup-close-button",t);e.type="button",e.setAttribute("aria-label","Close popup"),e.setAttribute("aria-hidden","true"),e.innerHTML="&#215;",e.addEventListener("click",this._onClose);}return this._update(),this._focusFirstElement(),this}addClassName(e){return this._classList.add(e),this._updateClassList(),this}removeClassName(e){return this._classList.delete(e),this._updateClassList(),this}setOffset(e){return this.options.offset=e,this._update(),this}toggleClassName(e){let t;return this._classList.delete(e)?t=!1:(this._classList.add(e),t=!0),this._updateClassList(),t}_onMouseEvent(e){this._update(e.point);}_getAnchor(e){if(this.options.anchor)return this.options.anchor;const t=this._map,i=this._container,o=this._pos;if(!t||!i||!o)return "bottom";const r=i.offsetWidth,n=i.offsetHeight,s=o.x<r/2,a=o.x>t.transform.width-r/2;if(o.y+e<n)return s?"top-left":a?"top-right":"top";if(o.y>t.transform.height-n){if(s)return "bottom-left";if(a)return "bottom-right"}return s?"left":a?"right":"bottom"}_updateClassList(){const e=this._container;if(!e)return;const t=[...this._classList];t.push("mapboxgl-popup"),this._anchor&&t.push(`mapboxgl-popup-anchor-${this._anchor}`),this._trackPointer&&t.push("mapboxgl-popup-track-pointer"),e.className=t.join(" ");}_update(t){const i=this._map,o=this._content;if(!i||!this._lngLat&&!this._trackPointer||!o)return;let r=this._container;if(r||(r=this._container=n("div","mapboxgl-popup",i.getContainer()),this._tip=n("div","mapboxgl-popup-tip",r),r.appendChild(o)),this.options.maxWidth&&r.style.maxWidth!==this.options.maxWidth&&(r.style.maxWidth=this.options.maxWidth),i.transform.renderWorldCopies&&!this._trackPointer&&(this._lngLat=en(this._lngLat,this._pos,i.transform)),!this._trackPointer||t){const e=this._pos=this._trackPointer&&t?t:i.project(this._lngLat),o=sn(this.options.offset),r=this._anchor=this._getAnchor(o.y),n=sn(this.options.offset,r),s=e.add(n).round();i._requestDomTask((()=>{this._container&&r&&(this._container.style.transform=`${tn[r]} translate(${s.x}px,${s.y}px)`);}));}if(!this._marker&&i._showingGlobe()){const t=e.isLngLatBehindGlobe(i.transform,this._lngLat)?0:1;this._setOpacity(t);}this._updateClassList();}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const e=this._container.querySelector(nn);e&&e.focus();}_onClose(){this.remove();}_setOpacity(e){this._container&&(this._container.style.opacity=`${e}`),this._content&&(this._content.style.pointerEvents=e?"auto":"none");}},Marker:on,Style:Qt,LngLat:e.LngLat,LngLatBounds:e.LngLatBounds,Point:e.pointGeometry,MercatorCoordinate:e.MercatorCoordinate,FreeCameraOptions:Zo,Evented:e.Evented,config:e.config,prewarm:function(){je().acquire(Ue);},clearPrewarmedResources:function(){const e=Ge;e&&(e.isPreloaded()&&1===e.numActive()?(e.release(Ue),Ge=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},get accessToken(){return e.config.ACCESS_TOKEN},set accessToken(t){e.config.ACCESS_TOKEN=t;},get baseApiUrl(){return e.config.API_URL},set baseApiUrl(t){e.config.API_URL=t;},get workerCount(){return Ne.workerCount},set workerCount(e){Ne.workerCount=e;},get maxParallelImageRequests(){return e.config.MAX_PARALLEL_IMAGE_REQUESTS},set maxParallelImageRequests(t){e.config.MAX_PARALLEL_IMAGE_REQUESTS=t;},clearStorage(t){e.clearTileCache(t);},workerUrl:"",workerClass:null,setNow:e.exported.setNow,restoreNow:e.exported.restoreNow};return fn}));
    
    //
    
    var mapboxgl$1 = mapboxgl;
    
    return mapboxgl$1;
    
    }));
    //# sourceMappingURL=mapbox-gl.js.map